/*************************************************************************
 *
 *  $RCSfile: animationbasenode.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/21 17:02:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SLIDESHOW_ANIMATIONBASENODE_HXX
#define _SLIDESHOW_ANIMATIONBASENODE_HXX

#include <basecontainernode.hxx>
#include <activitiesfactory.hxx>
#include <shapeattributelayer.hxx>
#include <shapeattributelayerholder.hxx>
#include <attributableshape.hxx>
#include <shapesubset.hxx>

#ifndef _COM_SUN_STAR_ANIMATIONS_XANIMATE_HPP_
#include <com/sun/star/animations/XAnimate.hpp>
#endif


namespace presentation
{
    namespace internal
    {
        /** Common base class for all leaf animation nodes.

        This class basically holds the target shape
        */
        class AnimationBaseNode : public BaseNode
        {
        public:
            AnimationBaseNode( const ::com::sun::star::uno::Reference< 
                               		::com::sun::star::animations::XAnimationNode >&	xNode, 
                               const BaseContainerNodeSharedPtr&					rParent,
                               const NodeContext& 									rContext );

            virtual bool init();
            virtual void dispose();
            virtual bool resolve();
            virtual bool activate();
            virtual void deactivate();
            virtual void end();
            virtual void notifyDeactivating( const AnimationNodeSharedPtr& rNotifier );
            virtual bool hasPendingAnimation() const;

#if defined(VERBOSE) && defined(DBG_UTIL)
            virtual void showState() const;
#endif
        protected:

            /** Animation-specific end().

	            This is also called from deactivate, for subsetted
	            shapes. Actually force-ends the underlying animation
	            activity.
            */
            void endAnimation();

            /** Create parameter struct for ActivitiesFactory
             */
            ActivitiesFactory::CommonParameters fillCommonParameters() const;

            /** Create AnimationActivity from common XAnimate parameters
             */
            AnimationActivitySharedPtr createActivity() const;

            /// Returns true, if this node animates a subset of a shape
            bool isSubsettedShape() const;

            /** Returns true, if this is a subset animation, and
                the subset is autogenerated (e.g. from an
                iteration)
            */
            bool isDependentSubsettedShape() const;

            /** This method enables a subset shape
             */
            void enableShapeSubset();

            /** This method removes subset shapes

	            Subset shapes may be only temporarily added to a
                slide. When the animation active duration ends,
                and they are generated from iterated effects, they
                are removed again for redraw
                performance. Furthermore, they are revoked from
                the original shape, such that it displays the full
                content again.
            */
            void disableShapeSubset();
                
            AttributableShapeSharedPtr getShape() const;

            // inline accessors
            // ----------------

            const ::com::sun::star::uno::Reference< 
            	::com::sun::star::animations::XAnimate >& getXAnimateNode() const { return mxAnimateNode; }
            const ShapeAttributeLayerHolder&			  getAttributeLayerHolder() const { return maAttributeLayerHolder; }
            const AnimationActivitySharedPtr&			  getActivity() const { return mpActivity; }
            AnimationActivitySharedPtr&					  getActivity() { return mpActivity; }

        private:
            ::com::sun::star::uno::Reference< 
            	::com::sun::star::animations::XAnimate > 	mxAnimateNode;
            ShapeAttributeLayerHolder						maAttributeLayerHolder;
            AnimationActivitySharedPtr						mpActivity;

            /// When valid, this node has a plain target shape
            AttributableShapeSharedPtr						mpShape;
            /// When valid, this is a subsetted target shape 
            ShapeSubsetSharedPtr							mpShapeSubset;
            bool											mbIsIndependentSubset;
        };
    }
}

#endif /* _SLIDESHOW_ANIMATIONBASENODE_HXX */
