/*************************************************************************
 *
 *  $RCSfile: viewshape.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 19:01:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// must be first
#include <canvas/debug.hxx>

#ifndef  _USE_MATH_DEFINES
#define  _USE_MATH_DEFINES  // needed by Visual C++ for math constants
#endif
#include <math.h>           // M_PI definition 

#include <viewshape.hxx>
#include <tools.hxx>

#ifndef _RTL_LOGFILE_HXX_
#include <rtl/logfile.hxx>
#endif
#ifndef INCLUDED_RTL_MATH_HXX
#include <rtl/math.hxx>
#endif

#ifndef _DRAFTS_COM_SUN_STAR_RENDERING_PANOSELETTERFORM_HPP_
#include <drafts/com/sun/star/rendering/PanoseLetterForm.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_FONTSLANT_HPP_
#include <com/sun/star/awt/FontSlant.hpp>
#endif

#ifndef _BGFX_POLYGON_B2DPOLYGONTOOLS_HXX
#include <basegfx/polygon/b2dpolygontools.hxx>
#endif
#ifndef _BGFX_NUMERIC_FTOOLS_HXX
#include <basegfx/numeric/ftools.hxx>
#endif
#ifndef _BGFX_MATRIX_B2DHOMMATRIX_HXX
#include <basegfx/matrix/b2dhommatrix.hxx>
#endif

#ifndef _CANVAS_VERBOSETRACE_HXX
#include <canvas/verbosetrace.hxx>
#endif
#ifndef _CANVAS_CANVASTOOLS_HXX
#include <canvas/canvastools.hxx>
#endif
#ifndef _CPPCANVAS_VCLFACTORY_HXX
#include <cppcanvas/vclfactory.hxx>
#endif
#ifndef _CPPCANVAS_BASEGFXFACTORY_HXX
#include <cppcanvas/basegfxfactory.hxx>
#endif

using namespace ::drafts::com::sun::star;
using namespace ::com::sun::star;


namespace presentation
{
    namespace internal
    {
        
        // TODO(F2): Provide sensible setup for mtf-related attributes (fill mode, 
        // char rotation etc.). Do that via mtf argument at this object
        
        bool ViewShape::prefetch( const ::cppcanvas::CanvasSharedPtr&	rDestinationCanvas,
                                  const GDIMetaFileSharedPtr&			rMtf,
                                  const ShapeAttributeLayerSharedPtr&	rAttr ) const
        {
            RTL_LOGFILE_CONTEXT( aLog, "::presentation::internal::ViewShape::prefetch()" );
            ENSURE_AND_RETURN( rMtf.get() != NULL,
                               "ViewShape::prefetch(): no valid metafile!" );

            if( rMtf != mpLastMtf ||
                rDestinationCanvas != mpLastCanvas )
            {
                // buffered renderer invalid, re-create
                ::cppcanvas::Renderer::Parameters aParms;

                // also invalidate alpha compositing bitmap. Do NOT
                // invalidate, if we're incidentally rendering INTO
                // it.
                if( rDestinationCanvas != mpLastBitmapCanvas )
                {
                    mpLastBitmap.reset();
                    mpLastBitmapCanvas.reset();
                }

                // fill attribute override parameter struct.  For
                // every valid attribute, the corresponding struct
                // member is filled, which in the metafile renderer
                // forces rendering with the set attribute.
                if( rAttr.get() )
                {
                    if( rAttr->isFillColorValid() )
                    {
                        // convert RGBColor to RGBA32 integer. Note
                        // that getIntegerColor() also truncates
                        // out-of-range values appropriately
                        aParms.maFillColor = 
                            rAttr->getFillColor().getIntegerColor();
                    }
                    if( rAttr->isLineColorValid() )
                    {
                        // convert RGBColor to RGBA32 integer. Note
                        // that getIntegerColor() also truncates
                        // out-of-range values appropriately
                        aParms.maLineColor = 
                            rAttr->getLineColor().getIntegerColor();
                    }
                    if( rAttr->isCharColorValid() )
                    {
                        // convert RGBColor to RGBA32 integer. Note
                        // that getIntegerColor() also truncates
                        // out-of-range values appropriately
                        aParms.maTextColor = 
                            rAttr->getCharColor().getIntegerColor();
                    }
                    if( rAttr->isFontFamilyValid() )
                    {
                        aParms.maFontName = 
                            rAttr->getFontFamily();
                    }
                    if( rAttr->isCharScaleValid() )
                    {
                        ::basegfx::B2DHomMatrix aMatrix;

                        // enlarge text by given scale factor. Do that
                        // with the middle of the shape as the center
                        // of scaling.
                        aMatrix.translate( -0.5, -0.5 );
                        aMatrix.scale( rAttr->getCharScale(),
                                       rAttr->getCharScale() );
                        aMatrix.translate( 0.5, 0.5 );

                        aParms.maTextTransformation = aMatrix;
                    }
                    if( rAttr->isCharWeightValid() )
                    {
                        aParms.maFontWeight = 
                            static_cast< sal_Int8 >(
                                ::basegfx::fround( 
                                    ::std::max( 0.0,
                                                ::std::min( 11.0, 
                                                            rAttr->getCharWeight() / 20.0 ) ) ) );
                    }
                    if( rAttr->isCharPostureValid() )
                    {
                        aParms.maFontLetterForm = 
                            rAttr->getCharPosture() == awt::FontSlant_NONE ?
                            rendering::PanoseLetterForm::ANYTHING :
                            rendering::PanoseLetterForm::OBLIQUE_CONTACT;
                    }
                    if( rAttr->isUnderlineModeValid() )
                    {
                        aParms.maFontUnderline = 
                            rAttr->getUnderlineMode();
                    }
                }

                mpRenderer = ::cppcanvas::VCLFactory::getInstance().createRenderer( rDestinationCanvas, 
                                                                                    *rMtf.get(),
                                                                                    aParms );

                mpLastMtf    = rMtf;
                mpLastCanvas = rDestinationCanvas;
            }

            return mpRenderer.get() != NULL;
        }

        bool ViewShape::draw( const ::cppcanvas::CanvasSharedPtr&		rDestinationCanvas,
                              const GDIMetaFileSharedPtr&				rMtf,
                              const ShapeAttributeLayerSharedPtr&		rAttr,
                              const ::basegfx::B2DHomMatrix&			rTransform,
                              const ::basegfx::B2DPolyPolygon&			rClip,
                              const DocTreeNode::VectorOfDocTreeNodes&	rSubsets ) const
        {
            RTL_LOGFILE_CONTEXT( aLog, "::presentation::internal::ViewShape::draw()" );

            if( !prefetch( rDestinationCanvas, rMtf, rAttr ) )
                return false;

            ENSURE_AND_RETURN( mpRenderer.get(), "ViewShape::draw(): Invalid renderer" );

            mpRenderer->setTransformation( rTransform );

            if( rClip.count() )
            {
                // setup clip
                mpRenderer->setClip( 
                    ::cppcanvas::BaseGfxFactory::getInstance().createPolyPolygon( 
                        rDestinationCanvas,
                        rClip ) );
            }
            else
            {
                // clear clip
                mpRenderer->setClip( ::cppcanvas::PolyPolygonSharedPtr() );
            }

            if( rSubsets.empty() )
            {
                return mpRenderer->draw();
            }
            else
            {
                // render subsets of whole metafile
                // --------------------------------

                DocTreeNode::VectorOfDocTreeNodes::const_iterator 		aIter( rSubsets.begin() );
                const DocTreeNode::VectorOfDocTreeNodes::const_iterator	aEnd ( rSubsets.end() );
                while( aIter != aEnd )
                {
                    if( !mpRenderer->drawSubset( aIter->getStartIndex(),
                                                 aIter->getEndIndex() ) )
                        return false;

                    ++aIter;
                }

                return true;
            }
        }

        bool ViewShape::renderSprite( const GDIMetaFileSharedPtr&				rMtf,
                                      const ::basegfx::B2DRectangle&			rOrigBounds, 
                                      const ::basegfx::B2DRectangle&			rBounds,
                                      int										nUpdateFlags,
                                      const ShapeAttributeLayerSharedPtr&		pAttr,
                                      const DocTreeNode::VectorOfDocTreeNodes&	rSubsets,
                                      bool 										bIsVisible ) const
        {
            RTL_LOGFILE_CONTEXT( aLog, "::presentation::internal::ViewShape::renderSprite()" );

            // TODO(P1): For multiple views, it might pay off to reorg Shape and ViewShape, 
            // in that all the common setup steps here are refactored to Shape (would then
            // have to be performed only _once_ per Shape paint).

            ENSURE_AND_RETURN( mpSprite.get(), "ViewShape::renderSprite(): No sprite" );

            VERBOSE_TRACE( "ViewShape::renderSprite(): Rendering sprite 0x%X",
                           mpSprite.get() );

            if( !bIsVisible )
            {
                // shape is invisible, no need to update anything.
                mpSprite->hide();

                return true;
            }

            bool bRedrawRequired( mbForceUpdate || (nUpdateFlags & FORCE) );

            // always show the sprite (might have been hidden before)
            mpSprite->show();

            if( mbForceUpdate || (nUpdateFlags & (POSITION|TRANSFORMATION)) )
            {
                mpSprite->move( rBounds.getMinimum() );
            }
            if( mbForceUpdate || (nUpdateFlags & ALPHA) )
            {
                mpSprite->setAlpha( (pAttr.get() && pAttr->isAlphaValid()) ? 
                                    // clamp alpha to valid range
                                    ::std::max( 0.0, 
                                                ::std::min( 1.0, pAttr->getAlpha() ) ): 
                                    1.0 );
            }
            if( mbForceUpdate || (nUpdateFlags & CLIP) )
            {
                if( pAttr.get() && pAttr->isClipValid() ) 
                    mpSprite->clip( pAttr->getClip() );
                else
                    mpSprite->clip( ::basegfx::B2DPolyPolygon() );
            }
            if( mbForceUpdate || (nUpdateFlags & TRANSFORMATION) )
            {                
                // TODO(P2): implement sprite transformation by
                // XSprite::setTransformation()
                bRedrawRequired = true;
            }
            if( mbForceUpdate || (nUpdateFlags & CONTENT) )
            {                
                bRedrawRequired = true;

                // TODO(P1): maybe provide some appearance change methods at 
                // the Renderer interface

                // clear the last canvas; forces the renderer to be regenerated 
                // below, for the different attributes to take effect
                mpLastCanvas.reset();
            }

            mbForceUpdate = false;

            if( !bRedrawRequired )
                return true;

            // shape needs repaint - setup all that's needed
            ::basegfx::B2DHomMatrix aTransform( getShapeTransformation( rOrigBounds, rBounds, pAttr, false) );

            if( pAttr.get() )
            {
                // calculate extra size requirements, due to shear or rotations
                // This is only necessary when attributes are given
                // ------------------------------------------------------------

                const ::basegfx::B2DSize aSize( rBounds.getRange() );

                // calc size of transformed unit rectangle
                const ::basegfx::B2DSize aTransformedSize( 
                    getShapeUpdateArea( rBounds,
                                        aTransform,
                                        pAttr ).getRange() );
                
                // subtract from regular bounds to determine the extra
                // size needed. Ignore transformed size that is smaller
                // than the original shape.
                const ::basegfx::B2DSize aAdditionalSize(
                    ::std::max( 0.0,
                                aTransformedSize.getX() - aSize.getX() ),
                    ::std::max( 0.0,
                                aTransformedSize.getY() - aSize.getY() ) );

                // resize the sprite (scale might have changed), add
                // additionalSize to make room for rotation/shear
                const ::basegfx::B2DSize& rSpriteSize( 
                    mpViewLayer->getCanvas()->getTransformation() * 
                    ::basegfx::B2DSize( aSize + 
                                        aAdditionalSize ) );

                mpSprite->resize( rSpriteSize );
                
                if( !aAdditionalSize.equalZero() )
                {
                    // translation is solely performed via Sprite::move(). 
                    // Because of that, if we enlarged the sprite size, the 
                    // content will move the corresponding amount to the right
                    // and bottom. Correct that.
                    mpSprite->move( rBounds.getMinimum() - 0.5*aAdditionalSize );

                    // center shape in the middle of the enlarged output area
                    aTransform.translate( aAdditionalSize.getX() * .5,
                                          aAdditionalSize.getY() * .5 );
                }
            }

            return draw( mpSprite->getContentCanvas(),
                         rMtf, 
                         pAttr, 
                         aTransform,
                         ::basegfx::B2DPolyPolygon(), // clipping is done via Sprite::clip()
                         rSubsets );
        }

        bool ViewShape::render( const ::cppcanvas::CanvasSharedPtr&			rDestinationCanvas,
                                const GDIMetaFileSharedPtr&					rMtf,
                                const ::basegfx::B2DRectangle&				rOrigBounds, 
                                const ::basegfx::B2DRectangle&				rBounds,
                                int											nUpdateFlags,
                                const ShapeAttributeLayerSharedPtr&			pAttr,
                                const DocTreeNode::VectorOfDocTreeNodes&	rSubsets,
                                bool 										bIsVisible ) const
        {
            RTL_LOGFILE_CONTEXT( aLog, "::presentation::internal::ViewShape::render()" );

            // TODO(P1): For multiple views, it might pay off to reorg Shape and ViewShape, 
            // in that all the common setup steps here are refactored to Shape (would then
            // have to be performed only _once_ per Shape paint).

            if( !bIsVisible )
            {
                VERBOSE_TRACE( "ViewShape::render(): skipping shape %X", this );

                // shape is invisible, no need to update anything.
                return true;
            }

            // since we have no sprite here, _any_ update request 
            // translates into a required redraw.
            bool bRedrawRequired( mbForceUpdate || nUpdateFlags != 0 );

            if( (nUpdateFlags & CONTENT) )
            {                
                // TODO(P1): maybe provide some appearance change methods at 
                // the Renderer interface
                
                // clear the last canvas; forces the renderer to be regenerated 
                // below, for the different attributes to take effect
                mpLastCanvas.reset();
            }

            mbForceUpdate = false;

            if( !bRedrawRequired )
                return true;

            VERBOSE_TRACE( "ViewShape::render(): rendering shape %X at position (%f,%f)", 
                           this, 
                           rBounds.getMinX(),
                           rBounds.getMinY() );


            // shape needs repaint - setup all that's needed
            // ---------------------------------------------

            ::basegfx::B2DPolyPolygon aClip;

            if( pAttr.get() )
            {
                // setup clip poly
                if( pAttr->isClipValid() )
                    aClip = pAttr->getClip();
                                
                if( pAttr->isAlphaValid() )
                {
                    const double nAlpha( pAttr->getAlpha() );

                    if( !::basegfx::fTools::equalZero( nAlpha ) &&
                        !::rtl::math::approxEqual(nAlpha, 1.0) )
                    {
                        // get shape transformation _without_ page output position
                        const ::basegfx::B2DHomMatrix aTransform( getShapeTransformation( rOrigBounds, 
                                                                                          rBounds, 
                                                                                          pAttr, 
                                                                                          false ) );

                        // render with global alpha - have to prepare
                        // a bitmap, and render that with modulated
                        // alpha
                        // -------------------------------------------

                        // determine output rect in device pixel
                        const ::basegfx::B2DHomMatrix aCanvasTransform( 
                            rDestinationCanvas->getTransformation() );
                        ::basegfx::B2DRectangle aTmpRect;
                        ::canvas::tools::calcTransformedRectBounds( aTmpRect, 
                                                                    rBounds, 
                                                                    aCanvasTransform );

                        const ::basegfx::B2ISize aBmpSize( 
                            ::basegfx::fround( aTmpRect.getWidth() ),
                            ::basegfx::fround( aTmpRect.getHeight() ) );

                        if( !mpLastBitmapCanvas.get() ||
                            mpLastBitmapCanvas->getSize() != aBmpSize )
                        {
                            // create a bitmap of appropriate size
                            mpLastBitmap = 
                                ::cppcanvas::BaseGfxFactory::getInstance().createAlphaBitmap( 
                                    rDestinationCanvas, 
                                    aBmpSize );

                            ENSURE_AND_THROW(mpLastBitmap.get(),
                                             "ViewShape::render(): Could not create intermediate bitmap");

                            mpLastBitmapCanvas = mpLastBitmap->getBitmapCanvas();

                            // setup bitmap canvas transformation -
                            // which happens to be destination canvas
                            // transformation without any
                            // translational components.

                            // generate linear part of canvas view
                            // transformation (linear means: without
                            // translational components)
                            ::basegfx::B2DHomMatrix aLinearTransform( aCanvasTransform );
                            aLinearTransform.set( 0, 2, 0.0 );
                            aLinearTransform.set( 1, 2, 0.0 );
            
                            // apply linear part of canvas view
                            // transformation to bitmap canvas
                            mpLastBitmapCanvas->setTransformation( aLinearTransform );
                        }
                            
                        // TODO(P1): If no update flags, or only
                        // alpha_update is set, we can save us the
                        // rendering into the bitmap

                        // render into this bitmap
                        if( !draw( mpLastBitmapCanvas,
                                   rMtf, 
                                   pAttr, 
                                   aTransform,
                                   aClip,
                                   rSubsets ) )
                        {
                            return false;
                        }

                        // render bitmap to screen, with given global
                        // alpha. Since the bitmap already contains
                        // pixel-equivalent output, we have to use the
                        // inverse view transformation, adjusted with
                        // the final shape output position.
                        ::basegfx::B2DHomMatrix aBitmapTransform( aCanvasTransform );
                        OSL_ENSURE( aBitmapTransform.isInvertible(),
                                    "ViewShape::render(): View transformation is singular!" );

                        aBitmapTransform.invert();

                        ::basegfx::B2DHomMatrix aTranslation;
                        aTranslation.translate( aTmpRect.getMinX(),
                                                aTmpRect.getMinY() );

                        aBitmapTransform = aBitmapTransform * aTranslation;
                        mpLastBitmap->setTransformation( aBitmapTransform );

                        // finally, render bitmap alpha-modulated
                        mpLastBitmap->drawAlphaModulated( nAlpha );

                        return true;
                    }
                }
            }

            // retrieve shape transformation, _with_ shape translation
            // to actual page position.
            const ::basegfx::B2DHomMatrix aTransform( getShapeTransformation( rOrigBounds, 
                                                                              rBounds, 
                                                                              pAttr, 
                                                                              true) );

            return draw( rDestinationCanvas,
                         rMtf, 
                         pAttr, 
                         aTransform,
                         aClip,
                         rSubsets );
        }

        ViewShape::ViewShape( const ViewLayerSharedPtr& rViewLayer ) :
            mpViewLayer( rViewLayer ),
            mpRenderer(),
            mpLastMtf(),
            mpLastCanvas(),
            mpLastBitmap(),
            mpLastBitmapCanvas(),
            mpSprite(),
            mbAnimationMode( false ),
            mbForceUpdate( true )
        {
            ENSURE_AND_THROW( mpViewLayer.get(), "ViewShape::ViewShape(): Invalid View" );
            ENSURE_AND_THROW( mpViewLayer->getCanvas().get(), "ViewShape::ViewShape(): Invalid ViewLayer canvas" );
        }

        ViewShape::~ViewShape()
        {
        }

        ViewLayerSharedPtr ViewShape::getViewLayer() const
        {
            return mpViewLayer;
        }

        ::basegfx::B2DRectangle ViewShape::getActualBounds( const GDIMetaFileSharedPtr&		 	 		rMtf,
                                                            const ShapeAttributeLayerSharedPtr&  		pAttr,
                                                            const DocTreeNode::VectorOfDocTreeNodes&	rSubsets ) const
        {
            // TODO(P2): cppcanvas code was lost, re-implement mtf
            // bound rect calculation. For the time being, this is a
            // fake here.
            return ::basegfx::B2DRectangle(0.0, 0.0, 1.0, 1.0);

//             if( rSubset.isEmpty() ||
//                 !prefetch( mpViewLayer->getCanvas(), 
//                            rMtf, 
//                            pAttr ) )
//             {
//                 // either subset contains the whole shape. Or we
//                 // cannot prefetch, be defensive then and assume full
//                 // shape size
//                 return ::basegfx::B2DRectangle(0.0, 0.0, 1.0, 1.0);
//             }

//             ENSURE_AND_THROW( mpRenderer.get(), 
//                               "ViewShape::getActualBounds(): Invalid renderer" );

//             // retrieve bounds for subset of whole metafile
//             // --------------------------------------------
//             if( bInvertedSubset )
//             {
//                 ::basegfx::B2DRange aTotalBounds;

//                 // get part before subset range 
//                 if( rSubset.getStartIndex() > 0 )
//                     aTotalBounds = mpRenderer->getSubsetArea( 0, 
//                                                               rSubset.getStartIndex() );

//                 // get part behind subset range
//                 if( rSubset.getEndIndex() < nNumDocTreeItems )
//                     aTotalBounds.expand( mpRenderer->getSubsetArea( rSubset.getEndIndex(), 
//                                                                     nNumDocTreeItems ) );
                    
//                 return aTotalBounds;
//             }
//             else
//             {
//                 return mpRenderer->getSubsetArea( rSubset.getStartIndex(), 
//                                                   rSubset.getEndIndex() );
//             }
        }

        ::basegfx::B2DSize ViewShape::getAntialiasingBorder() const
        {
            const ::basegfx::B2DHomMatrix& rViewTransform( 
                mpViewLayer->getCanvas()->getTransformation() ); 
            
            // TODO(F1): As a quick shortcut (did not want to invert
            // whole matrix here), taking only scale components of
            // view transformation matrix. This will be wrong when
            // e.g. shearing is involved.
            const double nXBorder( ::cppcanvas::Canvas::ANTIALIASING_EXTRA_SIZE / rViewTransform.get(0,0) );
            const double nYBorder( ::cppcanvas::Canvas::ANTIALIASING_EXTRA_SIZE / rViewTransform.get(1,1) );

            return ::basegfx::B2DSize( nXBorder,
                                       nYBorder );
        }

        bool ViewShape::enterAnimationMode()
        {
            mbForceUpdate   = true;
            mbAnimationMode = true;

            return true;
        }

        void ViewShape::leaveAnimationMode()
        {
            mpSprite.reset();
            mbAnimationMode = false;
            mbForceUpdate   = true;
        }

        bool ViewShape::isBackgroundDetached() const
        {
            return mbAnimationMode;
        }

        bool ViewShape::update( const GDIMetaFileSharedPtr&	rMtf,
                                const RenderArgs&			rArgs,
                                int							nUpdateFlags,
                                bool						bIsVisible ) const
        {
            RTL_LOGFILE_CONTEXT( aLog, "::presentation::internal::ViewShape::update()" );
            ENSURE_AND_RETURN( mpViewLayer->getCanvas().get(), "ViewShape::update(): Invalid layer canvas" );

            // try to create sprite, when animated
            if( isBackgroundDetached() && !mpSprite.get() )
            {
                const ::basegfx::B2DSize& rSpriteSize( 
                    mpViewLayer->getCanvas()->getTransformation() * ::basegfx::B2DSize( rArgs.mrBounds.getRange() ) );

                mpSprite.reset( new AnimatedSprite( mpViewLayer, rSpriteSize ) );
            }

            // Shall we render to a sprite, or to a plain canvas?
            if( mpSprite.get() != NULL )
                return renderSprite( rMtf, 
                                     rArgs.mrOrigBounds, 
                                     rArgs.mrBounds, 
                                     nUpdateFlags, 
                                     rArgs.mrAttr, 
                                     rArgs.mrSubsets, 
                                     bIsVisible );
            else
                return render( mpViewLayer->getCanvas(), 
                               rMtf, 
                               rArgs.mrOrigBounds, 
                               rArgs.mrBounds, 
                               nUpdateFlags, 
                               rArgs.mrAttr, 
                               rArgs.mrSubsets, 
                               bIsVisible );
        }

    }
}
