/*************************************************************************
 *
 *  $RCSfile: drawshape.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 19:15:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SLIDESHOW_DRAWSHAPE_HXX
#define _SLIDESHOW_DRAWSHAPE_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif

#include <set>
#include <vector>

#include <activity.hxx>
#include <intrinsicanimation.hxx>
#include <attributableshape.hxx>
#include <slideshowexceptions.hxx>
#include <viewshape.hxx>


class Graphic;

namespace presentation
{
    namespace internal
    {
        class DrawShape;

        typedef ::boost::shared_ptr< DrawShape > DrawShapeSharedPtr;

        /** This class is the representation of a draw document's
            XShape, and implements the Shape, AnimatableShape, and
            AttributableShape interfaces.

            @attention this class is to be treated 'final', i.e. one
            should not derive from it.
         */
        class DrawShape : 
            public AttributableShape, 
            public IntrinsicAnimation
        {
        public:
            /** Create a shape for the given XShape

            	@param xShape
                The XShape to represent.

                @param xContainingPage
                The page that contains this shape. Needed for proper
                import (currently, the UnoGraphicExporter needs this
                information).

                @param nPrio
                Externally-determined shape priority (used e.g. for
                paint ordering). This number _must be_ unique!
             */
            DrawShape( const ::com::sun::star::uno::Reference< 
                       		::com::sun::star::drawing::XShape >& 	xShape,
                       const ::com::sun::star::uno::Reference< 
                       	 	::com::sun::star::drawing::XDrawPage >&	xContainingPage,
                       double										nPrio	); // throw ImportFailedException;

            /** Create a shape for the given XShape and graphic content

            	@param xShape
                The XShape to represent.

                @param xContainingPage
                The page that contains this shape. Needed for proper
                import (currently, the UnoGraphicExporter needs this
                information).

                @param nPrio
                Externally-determined shape priority (used e.g. for
                paint ordering). This number _must be_ unique!

                @param rGraphic
                Graphic to display in the shape's bound rect. If this
                Graphic contains animatable content, the created
                DrawShape will return true on hasIntrinsicAnimation().
             */
            DrawShape( const ::com::sun::star::uno::Reference< 
                       		::com::sun::star::drawing::XShape >& 	xShape,
                       const ::com::sun::star::uno::Reference< 
                       	 	::com::sun::star::drawing::XDrawPage >&	xContainingPage,
                       double										nPrio,
                       const Graphic&								rGraphic ); // throw ImportFailedException;

            virtual ~DrawShape();

            virtual ::com::sun::star::uno::Reference< 
                ::com::sun::star::drawing::XShape > getXShape() const;

            // View layer methods
            //------------------------------------------------------------------

            virtual void addViewLayer( const ViewLayerSharedPtr& 	rNewLayer,
                                       bool							bRedrawLayer );
            virtual bool removeViewLayer( const ViewLayerSharedPtr& rNewLayer );

            // attribute methods
            //------------------------------------------------------------------

            virtual ShapeAttributeLayerSharedPtr createAttributeLayer();
            virtual bool revokeAttributeLayer( const ShapeAttributeLayerSharedPtr& rLayer );
            virtual void setVisibility( bool bVisible );
            virtual ::basegfx::B2DRectangle getPosSize() const;
            virtual ::basegfx::B2DRectangle getUpdateArea() const;
            virtual bool isVisible() const;
            virtual double getPriority() const;


            // animation methods
            //------------------------------------------------------------------

            virtual void enterAnimationMode();
            virtual void leaveAnimationMode();
            virtual bool isBackgroundDetached() const;
            virtual bool hasIntrinsicAnimation() const;


            // render methods
            //------------------------------------------------------------------

            virtual bool update() const;
            virtual bool render() const;
            virtual bool isUpdateNecessary() const;

            // Sub item specialities
            //------------------------------------------------------------------

            virtual sal_Int32 getNumberOfTreeNodes() const; // throw ImportFailedException;
            virtual DocTreeNode getFormattingDocTreeNode( sal_Int32 nIndex ) const; // throw ImportFailedException;
            virtual DocTreeNode getLogicalDocTreeNode( sal_Int32 nIndex ) const; // throw ImportFailedException;
            virtual DocTreeNode getEffectiveSubset() const;
            virtual AttributableShapeSharedPtr querySubset( const DocTreeNode& rTreeNode ) const;
            virtual bool createSubset( AttributableShapeSharedPtr& 	o_rSubset, 
                                       const DocTreeNode& 			rTreeNode );
            virtual bool revokeSubset( const AttributableShapeSharedPtr& rShape );


            // IntrinsicAnimation methods
            //------------------------------------------------------------------

            /** Start shape intrinsic animation
                
            	Since the IntrinsicAnimation interface is at the same
            	object, the rShape parameter seems a bit redundant. In
            	fact, it's not, because a DrawShape can hardly
            	generate a valid shared_ptr on itself.
             */
            virtual bool startIntrinsicAnimation( const SlideShowContext& rContext,
                                                  const ShapeSharedPtr&	  rShape );
            virtual bool endIntrinsicAnimation();

            /** Display next frame of an intrinsic animation.

            	Used by IntrinsicAnimationActivity, to show the next
            	animation frame.
             */
            bool setIntrinsicAnimationFrame( ::std::size_t nCurrFrame );


        private:
            // default: disabled copy/assignment
            DrawShape(const DrawShape&);
            DrawShape& operator=( const DrawShape& );

            /** Private copy constructor

				Used to create subsetted shapes
             */
            DrawShape( const DrawShape&, const DocTreeNode& rTreeNode, double nPrio );

            GDIMetaFileSharedPtr loadMtf( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >&  	xShape, 
                                          const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >&	xContainingPage,
                                          bool 																		    	bWithComments ) const; // throw ImportFailedException;

            int  getUpdateFlags() const;
            bool implRender( int nUpdateFlags ) const;
            void updateStateIds() const;
            void initDocTrees() const;
            void endLineFormat( DocTreeNode& 	rCurrShapeFormatTree,
                                DocTreeNode& 	rCurrLine,
                                sal_Int32		nCurrIndex				) const;
            
            void endShapeFormat( DocTreeNode& 	rCurrShapeFormatTree,
                                 DocTreeNode& 	rCurrLine,
                                 sal_Int32		nCurrIndex			) const;

            void endCharCellLogic( DocTreeNode& 	rCurrWord,
                                   DocTreeNode& 	rCurrCharCell,
                                   sal_Int32		nCurrIndex		) const;

            void endWordLogic( DocTreeNode& 	rCurrSentence,
                               DocTreeNode& 	rCurrWord,
                               DocTreeNode& 	rCurrCharCell,
                               sal_Int32		nCurrIndex		) const;

            void endSentenceLogic( DocTreeNode& 	rCurrPara,
                                   DocTreeNode& 	rCurrSentence,
                                   DocTreeNode& 	rCurrWord,
                                   DocTreeNode& 	rCurrCharCell,
                                   sal_Int32		nCurrIndex		) const;

            void endParaLogic( DocTreeNode& 	rCurrShapeLogicTree,
                               DocTreeNode& 	rCurrPara,
                               DocTreeNode& 	rCurrSentence,
                               DocTreeNode& 	rCurrWord,
                               DocTreeNode& 	rCurrCharCell,
                               sal_Int32		nCurrIndex			) const;

            void endShapeLogic( DocTreeNode& 	rCurrShapeLogicTree,
                                DocTreeNode& 	rCurrPara,
                                DocTreeNode& 	rCurrSentence,
                                DocTreeNode& 	rCurrWord,
                                DocTreeNode& 	rCurrCharCell,
                                sal_Int32		nCurrIndex			) const;

            struct SubsetEntry;
            void updateSubsetBounds( const SubsetEntry& rSubsetEntry );
            void updateSubsets();

            /// The associated XShape
            ::com::sun::star::uno::Reference< 
                	::com::sun::star::drawing::XShape > 							mxShape;
            ::com::sun::star::uno::Reference< 
                	::com::sun::star::drawing::XDrawPage >							mxPage;

            /** A vector of metafile actually representing the Shape.

            	If this shape is not animated, only a single entry is
            	available.
             */
            mutable VectorOfMtfAnimationFrames										maAnimationFrames;
            ::std::size_t															mnCurrFrame;
            mutable ActivitySharedPtr												mpIntrinsicAnimationActivity;

            /// Metafile of currently active frame (static for shapes w/o intrinsic animation)
            mutable GDIMetaFileSharedPtr											mpCurrMtf;

            // The attributes of this Shape
            const double															mnPriority;
            ::basegfx::B2DRectangle													maBounds; // always needed for rendering.
            																				  // for subset shapes, this member 
            																				  // might change when views are
            																				  // added, as minimal bounds are
            																				  // calculated

            // Pointer to modifiable shape attributes
            ShapeAttributeLayerSharedPtr											mpAttributeLayer; // only created lazily

            // The attribute states, to detect attribute changes,
            // without buffering and querying each single attribute
            mutable State::StateId 													mnAttributeTransformationState;
            mutable State::StateId 													mnAttributeClipState;
            mutable State::StateId 													mnAttributeAlphaState;
            mutable State::StateId 													mnAttributePositionState;
            mutable State::StateId 													mnAttributeContentState;

            /// the list of active view shapes (one for each registered view layer)
            typedef ::std::vector< ViewShapeSharedPtr > ViewShapeVector;
            ViewShapeVector															maViewShapes;

            /** Entry for subset shape

            	This struct contains data for every subset shape
            	generated for this one. Note that for a given
            	start/end action index combination, only one subset
            	instance is generated (and reused for subsequent
            	queries).
             */
            struct SubsetEntry
            {
                DrawShapeSharedPtr	mpShape;
                sal_Int32			mnStartActionIndex;
                sal_Int32			mnEndActionIndex;

                /// Number of times this subset was queried, and not yet revoked
                int					mnSubsetQueriedCount;

                inline sal_Int32 getHashValue() const
                {
                    // TODO(Q3): That's a hack. We assume that start
                    // index will always be less than 65535 (if this
                    // assumption is violated, hash map performance
                    // will degrade severely)
                    return mnStartActionIndex*SAL_MAX_INT16 + mnEndActionIndex;
                }

                /// The shape set is ordered according to this method
                inline bool operator<(const SubsetEntry& rOther) const
                {
                    return getHashValue() < rOther.getHashValue();
                }
                
            };

            typedef ::std::set< SubsetEntry > ShapeSet;
            /// the list of subset shapes spawned from this one. 
            ShapeSet																maSubsetShapes;
            /// caches minimal subset index from maSubsetShapes
            sal_Int32																mnMinSubsetActionIndex;
            /// caches maximal subset index from maSubsetShapes
            sal_Int32																mnMaxSubsetActionIndex;

            /// Whether this shape is currently in animation mode (value != 0)
            int																		mnIsAnimatedCount;

            // cached general sub item info (lazy initialised)
            mutable DocTreeNode::VectorOfDocTreeNodes								maFormattedDocTree;
            mutable DocTreeNode::VectorOfDocTreeNodes								maLogicalDocTree;
            mutable sal_Int32														mnNumDocTreeItems;

            /// Subset of the metafile to show
            const DocTreeNode														maSubset;

            /// Current number of subsets to render (calculated from maSubset and mnMin/MaxSubsetActionIndex
            mutable DocTreeNode::VectorOfDocTreeNodes								maCurrentSubsets;
            
            /// Whether shape is visible (without attribute layers)
            bool																	mbIsVisible;

            /// Whether the doc tree has been initialized successfully, or not
            mutable bool															mbDocTreeInitialized;

            /// Whether the mpMtf has verbose text comments, or not
            mutable bool															mbMtfHasComments;

            /// Whether redraw is necessary, regardless of state ids
            mutable bool 															mbForceUpdate;
        };

        typedef ::boost::shared_ptr< DrawShape > DrawShapeSharedPtr;

    }
}

#endif /* _SLIDESHOW_DRAWSHAPE_HXX */
