/*************************************************************************
 *
 *  $RCSfile: gdimtftools.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 19:16:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SLIDESHOW_GDIMTFTOOLS_HXX
#define _SLIDESHOW_GDIMTFTOOLS_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <vector>


class GDIMetaFile;
class Graphic;

namespace com { namespace sun { namespace star { namespace drawing 
{
    class XShape;
    class XDrawPage;
} } } }


// -----------------------------------------------------------------------------

namespace presentation
{
    namespace internal
    {
        typedef ::boost::shared_ptr< GDIMetaFile > GDIMetaFileSharedPtr;


        /** Retrieve a meta file for the given shape

			@param xShape
            XShape to retrieve a metafile for.
        
            @param xContainingPage
            The page that contains this shape. Needed for proper
            import (currently, the UnoGraphicExporter needs this
            information).

            @param o_rMtf
            Metafile to extract shape content into

            @param bVerboseComments
            When true, annotate text actions with verbose comments,
            denoting logical and physical text entities.
         */
        bool getMetaFile( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& 		xShape, 
                          const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >&	xContainingPage,
                          GDIMetaFile& 							                                    		o_rMtf,
                          bool									                                    		bVerboseComments );

        /** Retrieve a meta file for the page background

        	@param xPage
            XDrawPage to retrieve a metafile for.

            @param xContainingPage
            The containing page of the content - if xPage is a
            masterpage, xContainingPage must be the draw page that
            uses the master page as its background.

            @param o_rMtf
            Metafile to extract shape content into

            @param bVerboseComments
            When true, annotate text actions with verbose comments,
            denoting logical and physical text entities.
         */
        bool getBackgroundMetaFile( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >& 	xPage, 
                                    const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >& 	xContainingPage, 
                                    GDIMetaFile& 							                                			o_rMtf,
                                    bool									                                			bVerboseComments );

        /** Remove all text actions from the given metafile.
         */
        void removeTextActions( GDIMetaFile& io_rMtf );

        struct MtfAnimationFrame
        {
            MtfAnimationFrame( const GDIMetaFileSharedPtr& rMtf,
                               double					   nDuration ) :
                mpMtf( rMtf ),
                mnDuration( nDuration )
            {
            }

            /// Enables STL algos to be used for duration extraction
            double getDuration() const
            {
                return mnDuration;
            }

            GDIMetaFileSharedPtr	mpMtf;
            double					mnDuration;
        };
        
        typedef ::std::vector< MtfAnimationFrame > VectorOfMtfAnimationFrames;

        /** Extract a vector of animation frames from given Graphic.

        	@param o_rFrames
            Resulting vector of animated metafiles

            @param rGraphic
            Input graphic object, to extract animations from
         */
        bool getAnimationFromGraphic( VectorOfMtfAnimationFrames& o_rFrames,
                                      const Graphic&			  rGraphic );
    }
}

#endif
