/*************************************************************************
 *
 *  $RCSfile: svmedit.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2004/09/17 13:40:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVEDIT_HXX
#define _SVEDIT_HXX


#ifndef _SV_WINTYPES_HXX
#include <vcl/wintypes.hxx>
#endif
#ifndef _EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

class ImpSvMEdit;
class Timer;
class ExtTextEngine;
class ExtTextView;

class MultiLineEdit : public Edit
{
private:
	ImpSvMEdit*		pImpSvMEdit;

	XubString		aSaveValue;
	Link			aModifyHdlLink;

	Timer*			pUpdateDataTimer;
	Link			aUpdateDataHdlLink;

protected:

	DECL_LINK( 		ImpUpdateDataHdl, Timer* );
	void 			StateChanged( StateChangedType nType );
	void 			DataChanged( const DataChangedEvent& rDCEvt );
	long 			PreNotify( NotifyEvent& rNEvt );
	long 			Notify( NotifyEvent& rNEvt );
	void 			ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground );
	WinBits 		ImplInitStyle( WinBits nStyle );

	ExtTextEngine*	GetTextEngine() const;
	ExtTextView*	GetTextView() const;
	ScrollBar*		GetHScrollBar() const;
	ScrollBar*		GetVScrollBar() const;

public:
					MultiLineEdit( Window* pParent, WinBits nWinStyle = WB_LEFT | WB_BORDER );
					MultiLineEdit( Window* pParent, const ResId& rResId );
					~MultiLineEdit();


	virtual void	Modify();
	virtual void	UpdateData();

	void			SetModifyFlag();
	void			ClearModifyFlag();
	BOOL			IsModified() const;

	void			EnableUpdateData( ULONG nTimeout = EDIT_UPDATEDATA_TIMEOUT );
	void			DisableUpdateData() { delete pUpdateDataTimer; pUpdateDataTimer = NULL; }
	ULONG			IsUpdateDataEnabled() const;

	void			SetReadOnly( BOOL bReadOnly = TRUE );
	BOOL			IsReadOnly() const;

	void			EnableFocusSelectionHide( BOOL bHide );
	BOOL			IsFocusSelectionHideEnabled() const;

	void			SetMaxTextLen( ULONG nMaxLen = 0 );
	ULONG			GetMaxTextLen() const;

	void			SetSelection( const Selection& rSelection );
	Selection		GetSelection() const;

	void			ReplaceSelected( const XubString& rStr );
	void			DeleteSelected();
	XubString		GetSelected() const;
	XubString		GetSelected( LineEnd aSeparator ) const;

	void			Cut();
	void			Copy();
	void			Paste();

	void			SetText( const String& rStr );
	String			GetText() const;
	String			GetText( LineEnd aSeparator ) const;
	String			GetTextLines() const;
	String			GetTextLines( LineEnd aSeparator ) const;

    void            SetRightToLeft( BOOL bRightToLeft );
    BOOL            IsRightToLeft() const;

	void			SaveValue() 						{ aSaveValue = GetText(); }
	const XubString&	GetSavedValue() const 				{ return aSaveValue; }

	void			SetModifyHdl( const Link& rLink ) 	{ aModifyHdlLink = rLink; }
	const Link&		GetModifyHdl() const 				{ return aModifyHdlLink; }

	void			SetUpdateDataHdl( const Link& rLink ) { aUpdateDataHdlLink = rLink; }
	const Link&		GetUpdateDataHdl() const { return aUpdateDataHdlLink; }

	virtual void	Resize();
	virtual void	GetFocus();

	Size			CalcMinimumSize() const;
	Size			CalcAdjustedSize( const Size& rPrefSize ) const;
	Size			CalcSize( USHORT nColumns, USHORT nLines ) const;
	void			GetMaxVisColumnsAndLines( USHORT& rnCols, USHORT& rnLines ) const;

	void 			Draw( OutputDevice* pDev, const Point& rPos, const Size& rSize, ULONG nFlags );

   	void			SetLeftMargin( USHORT n );
	USHORT			GetLeftMargin() const;

    virtual
    ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindowPeer >
    GetComponentInterface(BOOL bCreate = TRUE);

    void            DisableSelectionOnFocus();
};

inline ULONG MultiLineEdit::IsUpdateDataEnabled() const
{
	return pUpdateDataTimer ? pUpdateDataTimer->GetTimeout() : 0;
}


#endif
