/*************************************************************************
 *
 *  $RCSfile: accessiblebrowseboxcell.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2004/03/31 15:14:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SVTOOLS_ACCESSIBLE_BROWSE_BOX_CELL_HXX
#include "accessiblebrowseboxcell.hxx"
#endif
#ifndef _SVTOOLS_ACCESSIBLETABLEPROVIDER_HXX
#include "accessibletableprovider.hxx"
#endif

// .................................................................................
namespace svt
{
// .................................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::awt;
	using namespace ::com::sun::star::accessibility;

	// =============================================================================
	// = AccessibleBrowseBoxCell
	// =============================================================================
	DBG_NAME( svt_AccessibleBrowseBoxCell )
	// -----------------------------------------------------------------------------
	AccessibleBrowseBoxCell::AccessibleBrowseBoxCell(
			const Reference< XAccessible >& _rxParent, IAccessibleTableProvider& _rBrowseBox,
			const Reference< XWindow >& _xFocusWindow,
			sal_Int32 _nRowPos, sal_uInt16 _nColPos )
		:AccessibleBrowseBoxBase( _rxParent, _rBrowseBox, _xFocusWindow, BBTYPE_TABLECELL )
		,m_nRowPos( _nRowPos )
		,m_nColPos( _nColPos )
	{
		DBG_CTOR( svt_AccessibleBrowseBoxCell, NULL );
		// set accessible name here, because for that we need the position of the cell
		// and so the base class isn't capable of doing this
		sal_Int32 nPos = _nRowPos * _rBrowseBox.GetColumnCount() + _nColPos;
		::rtl::OUString aAccName = _rBrowseBox.GetAccessibleName( BBTYPE_TABLECELL, nPos );
		implSetName( aAccName );
	}

	// -----------------------------------------------------------------------------
	AccessibleBrowseBoxCell::~AccessibleBrowseBoxCell()
	{
		DBG_DTOR( svt_AccessibleBrowseBoxCell, NULL );
	}

	// -----------------------------------------------------------------------------
	void SAL_CALL AccessibleBrowseBoxCell::grabFocus() throw ( RuntimeException )
	{
		SolarMethodGuard aGuard( *this );
		mpBrowseBox->GoToCell( m_nRowPos, m_nColPos );
	}
	// -----------------------------------------------------------------------------
	::Rectangle AccessibleBrowseBoxCell::implGetBoundingBox()
	{
		return mpBrowseBox->GetFieldRectPixelAbs( m_nRowPos, m_nColPos, FALSE, FALSE );
	}

	// -----------------------------------------------------------------------------
	::Rectangle AccessibleBrowseBoxCell::implGetBoundingBoxOnScreen()
	{
		return mpBrowseBox->GetFieldRectPixelAbs( m_nRowPos, m_nColPos, FALSE );
	}

// .................................................................................
}	// namespace svt
// .................................................................................


