/*************************************************************************
 *
 *  $RCSfile: lingucfg.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: hr $ $Date: 2004/11/26 23:01:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
#include <com/sun/star/lang/Locale.hpp>
#endif

#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SVTOOLS_LINGUCFG_HXX_
#include <lingucfg.hxx>
#endif
#ifndef _SVTOOLS_LINGUPROPS_HXX_
#include <linguprops.hxx>
#endif

using namespace rtl;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;

#define A2OU(x)        ::rtl::OUString::createFromAscii( x )

///////////////////////////////////////////////////////////////////////////


static Locale lcl_CreateLocale( LanguageType eLang )
{
	String aLangStr, aCtryStr;
	if ( eLang != LANGUAGE_NONE )
		ConvertLanguageToIsoNames( eLang, aLangStr, aCtryStr );

	return Locale( aLangStr, aCtryStr, OUString() );
}


static INT16 lcl_LocaleToLanguage( const Locale& rLocale )
{
	//	empty Locale -> LANGUAGE_NONE
	if ( rLocale.Language.getLength() == 0 )
		return LANGUAGE_NONE;

	//	Variant of Locale is ignored
	return ConvertIsoNamesToLanguage( rLocale.Language, rLocale.Country );
}


static BOOL lcl_SetLocale( INT16 &rLanguage, const Any &rVal )
{
	BOOL bSucc = FALSE;

	Locale	aNew;
	if (rVal >>= aNew)	// conversion successful?
	{
		INT16 nNew = lcl_LocaleToLanguage( aNew );
		if (nNew != rLanguage)
		{
			rLanguage = nNew;
			bSucc = TRUE;
		}
	}

	return bSucc;
}


static inline INT16 lcl_CfgLocaleStrToLanguage( const OUString &rCfgLocaleStr )
{
	INT16 nRes = LANGUAGE_NONE;
    if (0 != rCfgLocaleStr.getLength())
        nRes = ConvertIsoStringToLanguage( rCfgLocaleStr );
    return nRes;
}


static inline const OUString lcl_LanguageToCfgLocaleStr( INT16 nLanguage )
{
    OUString aRes;
    if (LANGUAGE_NONE != nLanguage)
        aRes = ConvertLanguageToIsoString( nLanguage );
    return aRes;
}


static void lcl_CfgAnyToLanguage( const Any &rVal, INT16& rLanguage )
{
	OUString aTmp;
    if ((rVal >>= aTmp)  &&  0 != aTmp.getLength())
       rLanguage = ConvertIsoStringToLanguage( aTmp );
}


//////////////////////////////////////////////////////////////////////

SvtLinguOptions::SvtLinguOptions()
{
    nDefaultLanguage = LANGUAGE_NONE;

	nDefaultLanguage_CJK = LANGUAGE_NONE;
	nDefaultLanguage_CTL = LANGUAGE_NONE;

	// general options
	bIsGermanPreReform		= FALSE;
	bIsUseDictionaryList	=
	bIsIgnoreControlCharacters	= TRUE;

	// spelling options
	bIsSpellCapitalization	=
	bIsSpellSpecial			= TRUE;
	bIsSpellAuto			=
	bIsSpellInAllLanguages	=
	bIsSpellHideMarkings	=
	bIsSpellReverse			=
	bIsSpellWithDigits		=
	bIsSpellUpperCase		= FALSE;

    // text conversion options
    bIsIgnorePostPositionalWord     = TRUE;
    bIsAutoCloseDialog              = 
    bIsShowEntriesRecentlyUsedFirst = 
    bIsAutoReplaceUniqueEntries     = FALSE;
    bIsDirectionToSimplified        = TRUE;
    bIsUseCharacterVariants         =
    bIsTranslateCommonTerms         =
    bIsReverseMapping               = FALSE;

    bROIsDirectionToSimplified      =
    bROIsUseCharacterVariants       =
    bROIsTranslateCommonTerms       =
    bROIsReverseMapping             = FALSE;

	// hyphenation options
	bIsHyphSpecial			= TRUE;
	bIsHyphAuto				= FALSE;
	nHyphMinLeading			=
	nHyphMinTrailing		= 2;
	nHyphMinWordLength		= 0;
}


//////////////////////////////////////////////////////////////////////

#define NUM_PROPS   29

Sequence< OUString > SvtLinguConfigItem::GetPropertyNames()
{
    static const char * aPropNames[NUM_PROPS + 1] =
	{
		"General/DefaultLocale",						//  0
		"General/DictionaryList/ActiveDictionaries",	//  1
		"General/DictionaryList/IsUseDictionaryList",	//  2
		"General/IsIgnoreControlCharacters",			//  3
		"General/IsGermanPreReform",                    //  4
		"General/DefaultLocale_CJK",					//  5
		"General/DefaultLocale_CTL",					//  6

		"SpellChecking/IsSpellUpperCase",				//  7
		"SpellChecking/IsSpellWithDigits",				//  8
		"SpellChecking/IsSpellCapitalization",			//  9
		"SpellChecking/IsSpellAuto",					// 10
		"SpellChecking/IsSpellSpecial",					// 11
		"SpellChecking/IsSpellInAllLocales",			// 12
		"SpellChecking/IsHideMarkings",					// 13
		"SpellChecking/IsReverseDirection",				// 14

		"Hyphenation/MinLeading",                       // 15
		"Hyphenation/MinTrailing",                      // 16
		"Hyphenation/MinWordLength",                    // 17
		"Hyphenation/IsHyphSpecial",                    // 18
		"Hyphenation/IsHyphAuto",	                    // 19

        "TextConversion/ActiveConversionDictionaries",  // 20
        "TextConversion/IsIgnorePostPositionalWord",    // 21
        "TextConversion/IsAutoCloseDialog",             // 22
        "TextConversion/IsShowEntriesRecentlyUsedFirst",// 23
        "TextConversion/IsAutoReplaceUniqueEntries",    // 24
        "TextConversion/IsDirectionToSimplified",       // 25
        "TextConversion/IsUseCharacterVariants",        // 26
        "TextConversion/IsTranslateCommonTerms",        // 27
        "TextConversion/IsReverseMapping",              // 28

		0
	};

	const char** ppPropName = aPropNames;

    Sequence< OUString > aNames( NUM_PROPS );
	OUString *pNames = aNames.getArray();
	for( INT32 i = 0; *ppPropName;  ++i, ++ppPropName )
	{
		pNames[i] = A2OU( *ppPropName );
	}
	//aNames.realloc( i );
	return aNames;
}


//////////////////////////////////////////////////////////////////////

static struct NamesToHdl
{
	char   *pPropName;
	INT32	nHdl;
} aNamesToHdl[] =
{
	{UPN_IS_GERMAN_PRE_REFORM,           UPH_IS_GERMAN_PRE_REFORM},
	{UPN_IS_USE_DICTIONARY_LIST,         UPH_IS_USE_DICTIONARY_LIST},
	{UPN_IS_IGNORE_CONTROL_CHARACTERS,   UPH_IS_IGNORE_CONTROL_CHARACTERS},
	{UPN_IS_SPELL_UPPER_CASE,            UPH_IS_SPELL_UPPER_CASE},
	{UPN_IS_SPELL_WITH_DIGITS,           UPH_IS_SPELL_WITH_DIGITS},
	{UPN_IS_SPELL_CAPITALIZATION,        UPH_IS_SPELL_CAPITALIZATION},
	{UPN_HYPH_MIN_LEADING,               UPH_HYPH_MIN_LEADING},
	{UPN_HYPH_MIN_TRAILING,              UPH_HYPH_MIN_TRAILING},
	{UPN_HYPH_MIN_WORD_LENGTH,           UPH_HYPH_MIN_WORD_LENGTH},
	{UPN_DEFAULT_LANGUAGE,               UPH_DEFAULT_LANGUAGE},
	{UPN_DEFAULT_LOCALE,                 UPH_DEFAULT_LOCALE},
	{UPN_DEFAULT_LOCALE_CJK,             UPH_DEFAULT_LOCALE_CJK},
	{UPN_DEFAULT_LOCALE_CTL,             UPH_DEFAULT_LOCALE_CTL},
	{UPN_IS_HYPH_AUTO,                   UPH_IS_HYPH_AUTO},
	{UPN_IS_HYPH_SPECIAL,                UPH_IS_HYPH_SPECIAL},
	{UPN_IS_SPELL_AUTO,                  UPH_IS_SPELL_AUTO},
	{UPN_IS_SPELL_HIDE,                  UPH_IS_SPELL_HIDE},
	{UPN_IS_SPELL_IN_ALL_LANGUAGES,      UPH_IS_SPELL_IN_ALL_LANGUAGES},
	{UPN_IS_SPELL_SPECIAL,               UPH_IS_SPELL_SPECIAL},
	{UPN_IS_WRAP_REVERSE,                UPH_IS_WRAP_REVERSE},
	{UPN_ACTIVE_DICTIONARIES,            UPH_ACTIVE_DICTIONARIES},
	{UPN_ACTIVE_CONVERSION_DICTIONARIES, UPH_ACTIVE_CONVERSION_DICTIONARIES},
	{UPN_IS_IGNORE_POST_POSITIONAL_WORD,         UPH_IS_IGNORE_POST_POSITIONAL_WORD},
	{UPN_IS_AUTO_CLOSE_DIALOG,                   UPH_IS_AUTO_CLOSE_DIALOG},
	{UPN_IS_SHOW_ENTRIES_RECENTLY_USED_FIRST,    UPH_IS_SHOW_ENTRIES_RECENTLY_USED_FIRST},
	{UPN_IS_AUTO_REPLACE_UNIQUE_ENTRIES,         UPH_IS_AUTO_REPLACE_UNIQUE_ENTRIES},
    {UPN_IS_DIRECTION_TO_SIMPLIFIED,             UPH_IS_DIRECTION_TO_SIMPLIFIED},
    {UPN_IS_USE_CHARACTER_VARIANTS,              UPH_IS_USE_CHARACTER_VARIANTS},
    {UPN_IS_TRANSLATE_COMMON_TERMS,              UPH_IS_TRANSLATE_COMMON_TERMS},
    {UPN_IS_REVERSE_MAPPING,                     UPH_IS_REVERSE_MAPPING},
	{NULL,                               -1}
};


SvtLinguConfig::SvtLinguConfig()
{
    pOpt = new SvtLinguOptions;
	LoadConfig();
	bIsModified	= FALSE;
}


SvtLinguConfig::~SvtLinguConfig()
{
	SaveConfig();
    delete pOpt;
}


void SvtLinguConfig::SetModified( BOOL bVal )
{
    if ((bIsModified = bVal))
        SaveConfig();
}


BOOL SvtLinguConfig::GetHdlByName( INT32 &rnHdl, const OUString &rPropertyName )
{
	NamesToHdl *pEntry = &aNamesToHdl[0];
	while (pEntry && pEntry->pPropName != NULL)
	{
		if (0 == rPropertyName.compareToAscii( pEntry->pPropName ))
		{
			rnHdl = pEntry->nHdl;
			break;
		}
		++pEntry;
	}
	return pEntry && pEntry->pPropName != NULL;
}


Any	SvtLinguConfig::GetProperty( const OUString &rPropertyName ) const
{
	INT32 nHdl;
	return GetHdlByName( nHdl, rPropertyName ) ? GetProperty( nHdl ) : Any();
}


Any	SvtLinguConfig::GetProperty( INT32 nPropertyHandle ) const
{
	Any aRes;

	const INT16 *pnVal = 0;
	const BOOL  *pbVal = 0;

    const SvtLinguOptions &rOpt = *((const SvtLinguConfig *) this)->pOpt;
	switch (nPropertyHandle)
	{
		case UPH_IS_GERMAN_PRE_REFORM :		pbVal = &rOpt.bIsGermanPreReform;	break;
		case UPH_IS_USE_DICTIONARY_LIST :	pbVal = &rOpt.bIsUseDictionaryList;	break;
		case UPH_IS_IGNORE_CONTROL_CHARACTERS :	pbVal = &rOpt.bIsIgnoreControlCharacters;	break;
		case UPH_IS_HYPH_AUTO : 			pbVal = &rOpt.bIsHyphAuto;	break;
		case UPH_IS_HYPH_SPECIAL : 			pbVal = &rOpt.bIsHyphSpecial;	break;
		case UPH_IS_SPELL_AUTO : 			pbVal = &rOpt.bIsSpellAuto;	break;
		case UPH_IS_SPELL_HIDE : 			pbVal = &rOpt.bIsSpellHideMarkings;	break;
		case UPH_IS_SPELL_IN_ALL_LANGUAGES :pbVal = &rOpt.bIsSpellInAllLanguages;	break;
		case UPH_IS_SPELL_SPECIAL : 		pbVal = &rOpt.bIsSpellSpecial;	break;
		case UPH_IS_WRAP_REVERSE : 			pbVal = &rOpt.bIsSpellReverse;	break;
		case UPH_DEFAULT_LANGUAGE :			pnVal = &rOpt.nDefaultLanguage;	break;
		case UPH_IS_SPELL_CAPITALIZATION :	pbVal = &rOpt.bIsSpellCapitalization;		break;
		case UPH_IS_SPELL_WITH_DIGITS :		pbVal = &rOpt.bIsSpellWithDigits;	break;
		case UPH_IS_SPELL_UPPER_CASE :		pbVal = &rOpt.bIsSpellUpperCase;		break;
		case UPH_HYPH_MIN_LEADING :			pnVal = &rOpt.nHyphMinLeading;		break;
		case UPH_HYPH_MIN_TRAILING :		pnVal = &rOpt.nHyphMinTrailing;	break;
		case UPH_HYPH_MIN_WORD_LENGTH :		pnVal = &rOpt.nHyphMinWordLength;	break;
		case UPH_ACTIVE_DICTIONARIES :
		{
			aRes <<= rOpt.aActiveDics;
			break;
		}
        case UPH_ACTIVE_CONVERSION_DICTIONARIES :
        {
            aRes <<= rOpt.aActiveConvDics;
            break;
        }
		case UPH_DEFAULT_LOCALE :
		{
			Locale aLocale( lcl_CreateLocale( rOpt.nDefaultLanguage ) );
			aRes.setValue( &aLocale, ::getCppuType((Locale*)0 ));
			break;
		}
		case UPH_DEFAULT_LOCALE_CJK :
		{
			Locale aLocale( lcl_CreateLocale( rOpt.nDefaultLanguage_CJK ) );
			aRes.setValue( &aLocale, ::getCppuType((Locale*)0 ));
			break;
		}
		case UPH_DEFAULT_LOCALE_CTL :
		{
			Locale aLocale( lcl_CreateLocale( rOpt.nDefaultLanguage_CTL ) );
			aRes.setValue( &aLocale, ::getCppuType((Locale*)0 ));
			break;
		}
        case UPH_IS_IGNORE_POST_POSITIONAL_WORD :       pbVal = &rOpt.bIsIgnorePostPositionalWord; break;
        case UPH_IS_AUTO_CLOSE_DIALOG :                 pbVal = &rOpt.bIsAutoCloseDialog; break;
        case UPH_IS_SHOW_ENTRIES_RECENTLY_USED_FIRST :  pbVal = &rOpt.bIsShowEntriesRecentlyUsedFirst; break;
        case UPH_IS_AUTO_REPLACE_UNIQUE_ENTRIES :       pbVal = &rOpt.bIsAutoReplaceUniqueEntries; break;

        case UPH_IS_DIRECTION_TO_SIMPLIFIED:            pbVal = &rOpt.bIsDirectionToSimplified; break;
        case UPH_IS_USE_CHARACTER_VARIANTS :            pbVal = &rOpt.bIsUseCharacterVariants; break;
        case UPH_IS_TRANSLATE_COMMON_TERMS :            pbVal = &rOpt.bIsTranslateCommonTerms; break;
        case UPH_IS_REVERSE_MAPPING :                   pbVal = &rOpt.bIsReverseMapping; break;
		default :
			DBG_ERROR( "unexpected property handle" );
	}

	if (pbVal)
		aRes <<= *pbVal;
	if (pnVal)
		aRes <<= *pnVal;

	return aRes;
}


BOOL SvtLinguConfig::SetProperty( const OUString &rPropertyName, const Any &rValue )
{
	BOOL bSucc = FALSE;
	INT32 nHdl;
	if (GetHdlByName( nHdl, rPropertyName ))
		bSucc = SetProperty( nHdl, rValue );
	return bSucc;
}


BOOL SvtLinguConfig::SetProperty( INT32 nPropertyHandle, const Any &rValue )
{
	BOOL bSucc = FALSE;
	if (!rValue.hasValue())
		return bSucc;

	BOOL bMod = FALSE;

	INT16 *pnVal = 0;
	BOOL  *pbVal = 0;

	switch (nPropertyHandle)
	{
        case UPH_IS_GERMAN_PRE_REFORM :     pbVal = &pOpt->bIsGermanPreReform;  break;
        case UPH_IS_USE_DICTIONARY_LIST :   pbVal = &pOpt->bIsUseDictionaryList;    break;
        case UPH_IS_IGNORE_CONTROL_CHARACTERS : pbVal = &pOpt->bIsIgnoreControlCharacters;  break;
        case UPH_IS_HYPH_AUTO :             pbVal = &pOpt->bIsHyphAuto; break;
        case UPH_IS_HYPH_SPECIAL :          pbVal = &pOpt->bIsHyphSpecial;  break;
        case UPH_IS_SPELL_AUTO :            pbVal = &pOpt->bIsSpellAuto;    break;
        case UPH_IS_SPELL_HIDE :            pbVal = &pOpt->bIsSpellHideMarkings;    break;
        case UPH_IS_SPELL_IN_ALL_LANGUAGES :pbVal = &pOpt->bIsSpellInAllLanguages;  break;
        case UPH_IS_SPELL_SPECIAL :         pbVal = &pOpt->bIsSpellSpecial; break;
        case UPH_IS_WRAP_REVERSE :          pbVal = &pOpt->bIsSpellReverse; break;
        case UPH_DEFAULT_LANGUAGE :         pnVal = &pOpt->nDefaultLanguage;    break;
        case UPH_IS_SPELL_CAPITALIZATION :  pbVal = &pOpt->bIsSpellCapitalization;      break;
        case UPH_IS_SPELL_WITH_DIGITS :     pbVal = &pOpt->bIsSpellWithDigits;  break;
        case UPH_IS_SPELL_UPPER_CASE :      pbVal = &pOpt->bIsSpellUpperCase;       break;
        case UPH_HYPH_MIN_LEADING :         pnVal = &pOpt->nHyphMinLeading;     break;
        case UPH_HYPH_MIN_TRAILING :        pnVal = &pOpt->nHyphMinTrailing;    break;
        case UPH_HYPH_MIN_WORD_LENGTH :     pnVal = &pOpt->nHyphMinWordLength;  break;
		case UPH_ACTIVE_DICTIONARIES :
		{
            rValue >>= pOpt->aActiveDics;
			bMod = TRUE;
			break;
		}
        case UPH_ACTIVE_CONVERSION_DICTIONARIES :
        {
            rValue >>= pOpt->aActiveConvDics;
            bMod = TRUE;
            break;
        }
		case UPH_DEFAULT_LOCALE :
		{
            bSucc = lcl_SetLocale( pOpt->nDefaultLanguage, rValue );
			bMod = bSucc;
			break;
		}
		case UPH_DEFAULT_LOCALE_CJK :
		{
            bSucc = lcl_SetLocale( pOpt->nDefaultLanguage_CJK, rValue );
			bMod = bSucc;
			break;
		}
		case UPH_DEFAULT_LOCALE_CTL :
		{
            bSucc = lcl_SetLocale( pOpt->nDefaultLanguage_CTL, rValue );
			bMod = bSucc;
			break;
		}
        case UPH_IS_IGNORE_POST_POSITIONAL_WORD :       pbVal = &pOpt->bIsIgnorePostPositionalWord; break;
        case UPH_IS_AUTO_CLOSE_DIALOG :                 pbVal = &pOpt->bIsAutoCloseDialog; break;
        case UPH_IS_SHOW_ENTRIES_RECENTLY_USED_FIRST :  pbVal = &pOpt->bIsShowEntriesRecentlyUsedFirst; break;
        case UPH_IS_AUTO_REPLACE_UNIQUE_ENTRIES :       pbVal = &pOpt->bIsAutoReplaceUniqueEntries; break;

        case UPH_IS_DIRECTION_TO_SIMPLIFIED :           pbVal = &pOpt->bIsDirectionToSimplified; break;
        case UPH_IS_USE_CHARACTER_VARIANTS :            pbVal = &pOpt->bIsUseCharacterVariants; break;
        case UPH_IS_TRANSLATE_COMMON_TERMS :            pbVal = &pOpt->bIsTranslateCommonTerms; break;
        case UPH_IS_REVERSE_MAPPING :                   pbVal = &pOpt->bIsReverseMapping; break;
		default :
			DBG_ERROR( "unexpected property handle" );
	}

	if (pbVal)
	{
		BOOL bNew;
		if (rValue >>= bNew)
		{
			if (bNew != *pbVal)
			{
				*pbVal = bNew;
				bMod = TRUE;
			}
			bSucc = TRUE;
		}
	}
	if (pnVal)
	{
		INT16 nNew;
		if (rValue >>= nNew)
		{
			if (nNew != *pnVal)
			{
				*pnVal = nNew;
				bMod = TRUE;
			}
			bSucc = TRUE;
		}
	}

	if (bMod)
		SetModified( TRUE );

	return bSucc;
}


BOOL SvtLinguConfig::GetOptions( SvtLinguOptions &rOptions ) const
{
    rOptions = *pOpt;
	return TRUE;
}


BOOL SvtLinguConfig::SetOptions( const SvtLinguOptions &rOptions )
{
    *pOpt = rOptions;
	SetModified( TRUE );
	return TRUE;
}


static const char* aRootName = "Office.Linguistic";

BOOL SvtLinguConfig::LoadConfig()
{
	BOOL bRes = FALSE;

	SvtLinguConfigItem aCfg( String::CreateFromAscii( aRootName ));
	Sequence< OUString > aNames = aCfg.GetPropertyNames();
	INT32 nProps = aNames.getLength();

	const Sequence< Any > aValues = aCfg.GetProperties( aNames );
    const Sequence< sal_Bool > aROStates = aCfg.GetReadOnlyStates( aNames );

    if (nProps  &&  aValues.getLength() == nProps &&  aROStates.getLength() == nProps)
	{
		const Any *pValue = aValues.getConstArray();
        const sal_Bool *pROStates = aROStates.getConstArray();
		for (INT32 i = 0;  i < nProps;  ++i)
		{
			const Any &rVal = pValue[i];
			switch ( i )
			{
                case  0: { pOpt->bRODefaultLanguage = pROStates[i]; lcl_CfgAnyToLanguage( rVal, pOpt->nDefaultLanguage ); } break;
                case  1: { pOpt->bROActiveDics = pROStates[i]; rVal >>= pOpt->aActiveDics;   } break;
                case  2: { pOpt->bROIsUseDictionaryList = pROStates[i]; rVal >>= pOpt->bIsUseDictionaryList;  } break;
                case  3: { pOpt->bROIsIgnoreControlCharacters = pROStates[i]; rVal >>= pOpt->bIsIgnoreControlCharacters;    } break;
                case  4: { pOpt->bROIsGermanPreReform = pROStates[i]; rVal >>= pOpt->bIsGermanPreReform;    } break;
                case  5: { pOpt->bRODefaultLanguage_CJK = pROStates[i]; lcl_CfgAnyToLanguage( rVal, pOpt->nDefaultLanguage_CJK );    } break;
                case  6: { pOpt->bRODefaultLanguage_CTL = pROStates[i]; lcl_CfgAnyToLanguage( rVal, pOpt->nDefaultLanguage_CTL );    } break;

                case  7: { pOpt->bROIsSpellUpperCase = pROStates[i]; rVal >>= pOpt->bIsSpellUpperCase; } break;
                case  8: { pOpt->bROIsSpellWithDigits = pROStates[i]; rVal >>= pOpt->bIsSpellWithDigits;    } break;
                case  9: { pOpt->bROIsSpellCapitalization = pROStates[i]; rVal >>= pOpt->bIsSpellCapitalization;    } break;
                case 10: { pOpt->bROIsSpellAuto = pROStates[i]; rVal >>= pOpt->bIsSpellAuto;  } break;
                case 11: { pOpt->bROIsSpellSpecial = pROStates[i]; rVal >>= pOpt->bIsSpellSpecial;   } break;
                case 12: { pOpt->bROIsSpellInAllLanguages = pROStates[i]; rVal >>= pOpt->bIsSpellInAllLanguages;    } break;
                case 13: { pOpt->bROIsSpellHideMarkings = pROStates[i]; rVal >>= pOpt->bIsSpellHideMarkings;  } break;
                case 14: { pOpt->bROIsSpellReverse = pROStates[i]; rVal >>= pOpt->bIsSpellReverse;   } break;

                case 15: { pOpt->bROHyphMinLeading = pROStates[i]; rVal >>= pOpt->nHyphMinLeading;   } break;
                case 16: { pOpt->bROHyphMinTrailing = pROStates[i]; rVal >>= pOpt->nHyphMinTrailing;  } break;
                case 17: { pOpt->bROHyphMinWordLength = pROStates[i]; rVal >>= pOpt->nHyphMinWordLength;    } break;
                case 18: { pOpt->bROIsHyphSpecial = pROStates[i]; rVal >>= pOpt->bIsHyphSpecial;    } break;
                case 19: { pOpt->bROIsHyphAuto = pROStates[i]; rVal >>= pOpt->bIsHyphAuto;   } break;

                case 20: { pOpt->bROActiveConvDics = pROStates[i]; rVal >>= pOpt->aActiveConvDics;   } break;

                case 21: { pOpt->bROIsIgnorePostPositionalWord = pROStates[i]; rVal >>= pOpt->bIsIgnorePostPositionalWord;  } break;
                case 22: { pOpt->bROIsAutoCloseDialog = pROStates[i]; rVal >>= pOpt->bIsAutoCloseDialog;  } break;
                case 23: { pOpt->bROIsShowEntriesRecentlyUsedFirst = pROStates[i]; rVal >>= pOpt->bIsShowEntriesRecentlyUsedFirst;  } break;
                case 24: { pOpt->bROIsAutoReplaceUniqueEntries = pROStates[i]; rVal >>= pOpt->bIsAutoReplaceUniqueEntries;  } break;

                case 25: { pOpt->bROIsDirectionToSimplified = pROStates[i];
                            if( ! (rVal >>= pOpt->bIsDirectionToSimplified) )
                            {
                                //default is locale dependent:
                                if(  pOpt->nDefaultLanguage_CJK == LANGUAGE_CHINESE_HONGKONG
                                  || pOpt->nDefaultLanguage_CJK == LANGUAGE_CHINESE_MACAU
                                  || pOpt->nDefaultLanguage_CJK == LANGUAGE_CHINESE_TRADITIONAL )
                                {
                                    pOpt->bIsDirectionToSimplified = FALSE;
                                }
                                else
                                {
                                    pOpt->bIsDirectionToSimplified = TRUE;
                                }
                            }
                         } break;
                case 26: { pOpt->bROIsUseCharacterVariants = pROStates[i]; rVal >>= pOpt->bIsUseCharacterVariants;  } break;
                case 27: { pOpt->bROIsTranslateCommonTerms = pROStates[i]; rVal >>= pOpt->bIsTranslateCommonTerms;  } break;
                case 28: { pOpt->bROIsReverseMapping = pROStates[i]; rVal >>= pOpt->bIsReverseMapping;  } break;

				default:
					DBG_ERROR( "unexpected case" );
			}
		}

		bRes = TRUE;
	}
	DBG_ASSERT( bRes, "LoadConfig failed" );

	return bRes;
}


BOOL SvtLinguConfig::SaveConfig()
{
	if( !IsModified() )
		return TRUE;

	BOOL bRet = FALSE;
	const Type &rBOOL  	  = ::getBooleanCppuType();
	const Type &rINT16 	  = ::getCppuType( (INT16 *) NULL );

	SvtLinguConfigItem aCfg( String::CreateFromAscii( aRootName ));
	const Sequence< OUString > aNames = aCfg.GetPropertyNames();
    INT32 nProps = aNames.getLength();
    Sequence< Any > aValues( nProps );
	Any *pValue = aValues.getArray();

    if (nProps  &&  aValues.getLength() == nProps)
	{
        OUString aTmp( lcl_LanguageToCfgLocaleStr( pOpt->nDefaultLanguage ) );
		*pValue++ = makeAny( aTmp );                               		//   0
        *pValue++ = makeAny( pOpt->aActiveDics );                        //   1
        pValue++->setValue( &pOpt->bIsUseDictionaryList, rBOOL );        //   2
        pValue++->setValue( &pOpt->bIsIgnoreControlCharacters, rBOOL );  //   3
        pValue++->setValue( &pOpt->bIsGermanPreReform, rBOOL );          //   4
        aTmp = lcl_LanguageToCfgLocaleStr( pOpt->nDefaultLanguage_CJK );
		*pValue++ = makeAny( aTmp );                                    //   5
        aTmp = lcl_LanguageToCfgLocaleStr( pOpt->nDefaultLanguage_CTL );
		*pValue++ = makeAny( aTmp );                                    //   6

        pValue++->setValue( &pOpt->bIsSpellUpperCase, rBOOL );          //   7
        pValue++->setValue( &pOpt->bIsSpellWithDigits, rBOOL );         //   8
        pValue++->setValue( &pOpt->bIsSpellCapitalization, rBOOL );     //   9
        pValue++->setValue( &pOpt->bIsSpellAuto, rBOOL );               //  10
        pValue++->setValue( &pOpt->bIsSpellSpecial, rBOOL );                //  11
        pValue++->setValue( &pOpt->bIsSpellInAllLanguages, rBOOL );     //  12
        pValue++->setValue( &pOpt->bIsSpellHideMarkings, rBOOL );       //  13
        pValue++->setValue( &pOpt->bIsSpellReverse, rBOOL );                //  14

        pValue++->setValue( &pOpt->nHyphMinLeading, rINT16 );           //  15
        pValue++->setValue( &pOpt->nHyphMinTrailing, rINT16 );          //  16
        pValue++->setValue( &pOpt->nHyphMinWordLength, rINT16 );            //  17
        pValue++->setValue( &pOpt->bIsHyphSpecial, rBOOL );             //  18
        pValue++->setValue( &pOpt->bIsHyphAuto, rBOOL );                    //  19

        *pValue++ = makeAny( pOpt->aActiveConvDics );                    //   20

        pValue++->setValue( &pOpt->bIsIgnorePostPositionalWord, rBOOL ); //  21
        pValue++->setValue( &pOpt->bIsAutoCloseDialog, rBOOL );          //  22
        pValue++->setValue( &pOpt->bIsShowEntriesRecentlyUsedFirst, rBOOL ); //  23
        pValue++->setValue( &pOpt->bIsAutoReplaceUniqueEntries, rBOOL ); //  24

        pValue++->setValue( &pOpt->bIsDirectionToSimplified, rBOOL ); //  25
        pValue++->setValue( &pOpt->bIsUseCharacterVariants, rBOOL ); //  26
        pValue++->setValue( &pOpt->bIsTranslateCommonTerms, rBOOL ); //  27
        pValue++->setValue( &pOpt->bIsReverseMapping, rBOOL ); //  28

        bRet |= aCfg.PutProperties( aNames, aValues );
	}

	if (bRet)
		SetModified( FALSE );

	return bRet;
}

BOOL SvtLinguConfig::IsReadOnly( const rtl::OUString &rPropertyName ) const
{
    BOOL bReadOnly = FALSE;
    INT32 nHdl;
    if (GetHdlByName( nHdl, rPropertyName ))
        bReadOnly = IsReadOnly( nHdl );
    return bReadOnly;
}

BOOL SvtLinguConfig::IsReadOnly( INT32 nPropertyHandle ) const
{
    BOOL bReadOnly = FALSE;
    switch(nPropertyHandle)
    {
        case UPH_IS_GERMAN_PRE_REFORM           : bReadOnly = pOpt->bROIsGermanPreReform        ; break;
        case UPH_IS_USE_DICTIONARY_LIST         : bReadOnly = pOpt->bROIsUseDictionaryList      ; break;
        case UPH_IS_IGNORE_CONTROL_CHARACTERS   : bReadOnly = pOpt->bROIsIgnoreControlCharacters; break;
        case UPH_IS_HYPH_AUTO                   : bReadOnly = pOpt->bROIsHyphAuto               ; break;
        case UPH_IS_HYPH_SPECIAL                : bReadOnly = pOpt->bROIsHyphSpecial            ; break;
        case UPH_IS_SPELL_AUTO                  : bReadOnly = pOpt->bROIsSpellAuto              ; break;
        case UPH_IS_SPELL_HIDE                  : bReadOnly = pOpt->bROIsSpellHideMarkings      ; break;
        case UPH_IS_SPELL_IN_ALL_LANGUAGES      : bReadOnly = pOpt->bROIsSpellInAllLanguages    ; break;
        case UPH_IS_SPELL_SPECIAL               : bReadOnly = pOpt->bROIsSpellSpecial           ; break;
        case UPH_IS_WRAP_REVERSE                : bReadOnly = pOpt->bROIsSpellReverse           ; break;
        case UPH_DEFAULT_LANGUAGE               : bReadOnly = pOpt->bRODefaultLanguage          ; break;
        case UPH_IS_SPELL_CAPITALIZATION        : bReadOnly = pOpt->bROIsSpellCapitalization    ; break;
        case UPH_IS_SPELL_WITH_DIGITS           : bReadOnly = pOpt->bROIsSpellWithDigits        ; break;
        case UPH_IS_SPELL_UPPER_CASE            : bReadOnly = pOpt->bROIsSpellUpperCase         ; break;
        case UPH_HYPH_MIN_LEADING               : bReadOnly = pOpt->bROHyphMinLeading           ; break;
        case UPH_HYPH_MIN_TRAILING              : bReadOnly = pOpt->bROHyphMinTrailing          ; break;
        case UPH_HYPH_MIN_WORD_LENGTH           : bReadOnly = pOpt->bROHyphMinWordLength        ; break;
        case UPH_ACTIVE_DICTIONARIES            : bReadOnly = pOpt->bROActiveDics               ; break;
        case UPH_ACTIVE_CONVERSION_DICTIONARIES : bReadOnly = pOpt->bROActiveConvDics           ; break;
        case UPH_DEFAULT_LOCALE                 : bReadOnly = pOpt->bRODefaultLanguage          ; break;
        case UPH_DEFAULT_LOCALE_CJK             : bReadOnly = pOpt->bRODefaultLanguage_CJK      ; break;
        case UPH_DEFAULT_LOCALE_CTL             : bReadOnly = pOpt->bRODefaultLanguage_CTL      ; break;
        case UPH_IS_IGNORE_POST_POSITIONAL_WORD :       bReadOnly = pOpt->bROIsIgnorePostPositionalWord; break;
        case UPH_IS_AUTO_CLOSE_DIALOG :                 bReadOnly = pOpt->bROIsAutoCloseDialog; break;
        case UPH_IS_SHOW_ENTRIES_RECENTLY_USED_FIRST :  bReadOnly = pOpt->bROIsShowEntriesRecentlyUsedFirst; break;
        case UPH_IS_AUTO_REPLACE_UNIQUE_ENTRIES :       bReadOnly = pOpt->bROIsAutoReplaceUniqueEntries; break;
        case UPH_IS_DIRECTION_TO_SIMPLIFIED : bReadOnly = pOpt->bROIsDirectionToSimplified; break;
        case UPH_IS_USE_CHARACTER_VARIANTS : bReadOnly = pOpt->bROIsUseCharacterVariants; break;
        case UPH_IS_TRANSLATE_COMMON_TERMS : bReadOnly = pOpt->bROIsTranslateCommonTerms; break;
        case UPH_IS_REVERSE_MAPPING :        bReadOnly = pOpt->bROIsReverseMapping; break;
        default :
            DBG_ERROR( "unexpected property handle" );
    }
    return bReadOnly;
}

//////////////////////////////////////////////////////////////////////

