/*************************************************************************
 *
 *  $RCSfile: brooker.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2004/06/16 10:28:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define ENABLE_BYTESTRING_STREAM_OPERATORS
#include "brooker.hxx"
#if OSL_DEBUG_LEVEL > 1
#include <stdio.h>
#endif
class TypedCommunicationLinkList : public CommunicationLinkList
{
	BroadcastCategory mnCategory;
public:

	virtual ~TypedCommunicationLinkList() {};

	TypedCommunicationLinkList( BroadcastCategory nCategory );
	virtual BOOL operator < (const TypedCommunicationLinkList &rPar);
	virtual BOOL operator == (const TypedCommunicationLinkList &rPar);
};

TypedCommunicationLinkList::TypedCommunicationLinkList( BroadcastCategory nCategory )
: mnCategory( nCategory )
{}

BOOL TypedCommunicationLinkList::operator < (const TypedCommunicationLinkList &rPar)
{
	return mnCategory < rPar.mnCategory;
}

BOOL TypedCommunicationLinkList::operator == (const TypedCommunicationLinkList &rPar)
{
	return mnCategory == rPar.mnCategory;
}



SV_IMPL_OP_PTRARR_SORT( ClientLists, TypedCommunicationLinkList* )



InformationBrooker::InformationBrooker()
{
	mpClientLists = new ClientLists();

	mpManager = new CommunicationManagerServerViaSocket( GetBroadcastPort(), CM_UNLIMITED_CONNECTIONS, TRUE );
	mpManager->SetConnectionOpenedHdl( LINK( this, InformationBrooker, ManagerOpen ) );
	mpManager->SetConnectionClosedHdl( LINK( this, InformationBrooker, ManagerClose ) );
	mpManager->SetDataReceivedHdl( LINK( this, InformationBrooker, ManagerData ) );
	mpManager->StartCommunication();
}

InformationBrooker::~InformationBrooker()
{
	ImplDisconnectAll();
	delete mpManager;
}

void InformationBrooker::ImplDisconnectAll()
{
	Broadcast( "Disconnecting all Listeners due to Shutdown of Brooker", BCST_CAT_ALL, BCST_CLIENT_BROOKER );
}

void InformationBrooker::Broadcast( ByteString aMsg, BroadcastCategory nCategory, ClientID aCI, BroadcastFilterFlag nFlags )
{
	// Callback for new Messages
	BroadcastMessage aBCMsg( aMsg, nCategory, aCI );
	if ( !FilterMessage( aBCMsg, nFlags ) )
		return;		// Allow to skip message if desired
	MessageArrived( aBCMsg );

	TypedCommunicationLinkList *pLinkList = new TypedCommunicationLinkList( nCategory );

	USHORT nPos;
	// Liste suchen
	if ( mpClientLists->Seek_Entry( pLinkList, &nPos ) )
	{
		delete pLinkList;
		pLinkList = mpClientLists->GetObject( nPos );

		SvStream *pData = NULL;

		for ( USHORT i = 0; i < pLinkList->Count(); i++ )
		{
			CommunicationLink *pCL = pLinkList->GetObject(i);
			if ( !pData )
			{			// wir gehen mal davon aus, da alle Links die selbe Art von Stream benutzen
				pData = pCL->GetBestCommunicationStream();
				*pData << BCST_CMD_BROADCAST;
				*pData << nCategory;
				*pData << ByteString( aBCMsg );
				*pData << aCI;
			}
			pCL->TransferDataStream( pData, CM_PROTOCOL_BROADCASTER );
		}
	}
	else
		delete pLinkList;
}

IMPL_LINK( InformationBrooker, ManagerOpen, CommunicationLink*, pCL )
{
	OpenConnection( pCL );
	// rcksenden der ClientID
	SvStream *pData = pCL->GetBestCommunicationStream();
	*pData << BCST_CMD_CLIENT_ID;
	*pData << (ClientID)pCL;
	pCL->TransferDataStream( pData, CM_PROTOCOL_BROADCASTER );
	delete pData;

	return 0;
}

void InformationBrooker::ImplRemoveLink( TypedCommunicationLinkList *pLinkList, CommunicationLink* pCL )
{
	USHORT nPos;
	if ( pLinkList->Seek_Entry( pCL, &nPos ) )
		pLinkList->Remove( nPos );

	if ( pLinkList->Count() == 0 )
	{	// Liste ist leer, also Entfernen
		if ( mpClientLists->Seek_Entry( pLinkList, &nPos ) )
			mpClientLists->Remove( nPos );
	}
}

void InformationBrooker::ImplHandleListeningLink( BroadcastCommand aCmd, BroadcastCategory nType, CommunicationLink* pCL )
{
	TypedCommunicationLinkList *pLinkList = new TypedCommunicationLinkList( nType );

	USHORT nPos;
	BOOL bFound;
	// Liste suchen
	bFound = mpClientLists->Seek_Entry( pLinkList, &nPos );
	if ( bFound )
	{
		delete pLinkList;
		pLinkList = mpClientLists->GetObject( nPos );
	}

	if ( aCmd == BCST_CMD_ADD_CATEGORY )
	{
		if ( !bFound )		// Wir brauchen eine Liste, also aufbewahren
			mpClientLists->C40_PTR_INSERT( TypedCommunicationLinkList, pLinkList );

		// Link einfgen
		if ( !pLinkList->Seek_Entry( pCL, &nPos ) )
			pLinkList->C40_PTR_INSERT( CommunicationLink, pCL );
	}
	else
	{
		if ( !bFound )
		{	// Die TempListe von oben wegschmeissen
			delete pLinkList;
			pLinkList = NULL;
		}
		else
		{	// Link eventuell entfernen
			ImplRemoveLink( pLinkList, pCL );
		}
	}
}

IMPL_LINK( InformationBrooker, ManagerClose, CommunicationLink*, pCL )
{
	CloseConnection( pCL );
	for ( short i = mpClientLists->Count()-1 ; i >= 0; i-- )
	{
		ImplRemoveLink( mpClientLists->GetObject(i), pCL );
	}

	return 0;
}

IMPL_LINK( InformationBrooker, ManagerData, CommunicationLink*, pCL )
{
	DBG_ASSERT( pCL->GetProtocol() == CM_PROTOCOL_BROADCASTER, "Protocol is not CM_PROTOCOL_BROADCASTER" )

	SvStream *pData = pCL->GetServiceData();
	if ( ! pData )  // Impossible, but it happens
	{
#if OSL_DEBUG_LEVEL > 1
	   printf("%s:%lu: Data NULL pointer\n",pCL->GetCommunicationPartner( CM_FQDN ).GetBuffer(), (ULONG)(pCL) );fflush(stdout);
#endif
	   return 0;
	}

	BroadcastCommand aCmd;
	*pData >> aCmd;
	switch ( aCmd )
	{
		case BCST_CMD_ADD_CATEGORY:
		case BCST_CMD_REMOVE_CATEGORY:
			{
				BroadcastCategory nType;
				*pData >> nType;
				ImplHandleListeningLink( aCmd, nType, pCL );
				if ( BCST_CMD_ADD_CATEGORY == aCmd )
					ImplHandleListeningLink( BCST_CMD_ADD_CATEGORY, BCST_CAT_ALL, pCL );
			}
			break;
		case BCST_CMD_BROADCAST:
			{
				BroadcastCategory nType;
				ByteString aMsg;
				BroadcastFilterFlag nFlags;
				*pData >> nType;
				*pData >> aMsg;
				if ( !pData->IsEof() )	// Wegen nachtrglicher Erweiterung der Message
					*pData >> nFlags;
				else
					nFlags = BCST_FILTER_NOFILTER;
				Broadcast( aMsg, nType, (ClientID)pCL, nFlags );
			}
			break;

	default:
		{
			if ( !ExtraCommand( pData ) )
			{
				DBG_ERROR("Unknown request in InformationBrooker");
			}
		}
	}

	ReceiveData( pCL );		// Data is lost at this point!!

	return 0;
}


BOOL InformationBrooker::ExtraCommand( SvStream *pData )
{
	for ( ULONG i = 0; i < aExtraCommandLnkList.Count(); i++ )
	{
		pData->Seek( 0 );
		if ( aExtraCommandLnkList.GetObject( i )->Call( pData ) )
			return TRUE;
	}
	return FALSE;
}

void InformationBrooker::RemoveExtraCommandHdl( Link aLink )
{
	for ( ULONG i = 0; i < aExtraCommandLnkList.Count(); i++ )
		if ( *aExtraCommandLnkList.GetObject( i ) == aLink ) {
			delete aExtraCommandLnkList.GetObject( i );
			aExtraCommandLnkList.Remove( i );
			return;
		}
}

void InformationBrooker::MessageArrived( const BroadcastMessage &aMsg )
{
	for ( ULONG i = 0; i < aMessageArrivedLnkList.Count(); i++ )
		aMessageArrivedLnkList.GetObject( i )->Call( (void*)&aMsg );
}

void InformationBrooker::RemoveMessageArrivedHdl( Link aLink )
{
	for ( ULONG i = 0; i < aMessageArrivedLnkList.Count(); i++ )
		if ( *aMessageArrivedLnkList.GetObject( i ) == aLink ) {
			delete aMessageArrivedLnkList.GetObject( i );
			aMessageArrivedLnkList.Remove( i );
			return;
		}
}

BOOL InformationBrooker::FilterMessage( BroadcastMessage &aMsg, BroadcastFilterFlag &nFilterFlags )
{
	BOOL bOK = TRUE;
	FilterMessagePack aPack( aMsg, nFilterFlags );
	for ( ULONG i = 0; i < aFilterMessageLnkList.Count(); i++ )
		bOK &= aFilterMessageLnkList.GetObject( i )->Call( (void*)&aPack );
	return bOK;
}

void InformationBrooker::RemoveFilterMessageHdl( Link aLink )
{
	for ( ULONG i = 0; i < aFilterMessageLnkList.Count(); i++ )
		if ( *aFilterMessageLnkList.GetObject( i ) == aLink ) {
			delete aFilterMessageLnkList.GetObject( i );
			aFilterMessageLnkList.Remove( i );
			return;
		}
}

