/*************************************************************************
 *
 *  $RCSfile: basicmixer.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2003/11/24 16:28:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SDR_MIXER_BASICMIXER_HXX
#define _SDR_MIXER_BASICMIXER_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _SV_GEN_HXX
#include <tools/gen.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////
// predeclarations

namespace sdr
{
	namespace contact
	{
		class DisplayInfo;
		class ViewObjectContact;
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace mixer
	{
		class BasicMixer
		{
		protected:
			// setup associated object for paint at given state
			virtual void SetupObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo) = 0;

			// restore associated object to original state
			virtual void RestoreObject(sdr::contact::DisplayInfo& rDisplayInfo) = 0;

		public:
			// basic constructor.
			BasicMixer();

			// destructor
			virtual ~BasicMixer();

			// paint method. This will call SetupObject(fMixerState), then the paint at the
			// associated ViewCOntact, and then RestoreObject().
			virtual sal_Bool PaintObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo, 
				Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC);
		};
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// #test# color change mixer
// predeclarations

class SdrObject;

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace mixer
	{
		class ColorChangeMixer : public BasicMixer
		{
			// The animated object
			SdrObject&								mrObject;

			// #test# color change mixer
			sal_uInt32								mnOrigColor;

		protected:
			// internal access to SdrObject
			SdrObject& GetSdrObject() const
			{
				return mrObject;
			}

			// setup associated object for paint at given state
			virtual void SetupObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo);

			// restore associated object to original state
			virtual void RestoreObject(sdr::contact::DisplayInfo& rDisplayInfo);

		public:
			// basic constructor.
			ColorChangeMixer(SdrObject& rObject);

			// destructor
			virtual ~ColorChangeMixer();
		};
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_MIXER_BASICMIXER_HXX

// eof
