/*************************************************************************
 *
 *  $RCSfile: dlight3d.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: pjunck $ $Date: 2004/11/03 10:37:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//BFS01#ifndef _SVDIO_HXX
//BFS01#include "svdio.hxx"
//BFS01#endif

//BFS01#ifndef _E3D_GLOBL3D_HXX
//BFS01#include "globl3d.hxx"
//BFS01#endif

//BFS01#ifndef _E3D_POLYOB3D_HXX
//BFS01#include "polyob3d.hxx"
//BFS01#endif

#ifndef _E3D_DLIGHT3D_HXX
#include "dlight3d.hxx"
#endif

//BFS01#ifndef _SVDPAGE_HXX
//BFS01#include "svdpage.hxx"
//BFS01#endif

//BFS01TYPEINIT1(E3dDistantLight, E3dLight);

/*************************************************************************
|*
|* E3dDistantLight-Konstruktor
|*
\************************************************************************/

//BFS01E3dDistantLight::E3dDistantLight(const Vector3D& rPos, const Vector3D& rDir,
//BFS01								 const Color& rColor, double fLightIntensity) :
//BFS01	E3dLight(rPos, rColor, fLightIntensity)
//BFS01{
//BFS01	SetDirection(rDir);
//BFS01	CreateLightObj();
//BFS01}

/*************************************************************************
|*
|* E3dDistantLight-Destruktor
|*
\************************************************************************/

//BFS01E3dDistantLight::~E3dDistantLight()
//BFS01{
//BFS01}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

//BFS01UINT16 E3dDistantLight::GetObjIdentifier() const
//BFS01{
//BFS01	return E3D_DISTLIGHT_ID;
//BFS01}

/*************************************************************************
|*
|* Richtung ZUR Lichtquelle setzen
|*
\************************************************************************/

//BFS01void E3dDistantLight::SetDirection(const Vector3D& rNewDir)
//BFS01{
//BFS01	if ( aDirection != rNewDir )
//BFS01	{
//BFS01		aDirection = rNewDir;
//BFS01		aDirection.Normalize();
//BFS01		CreateLightObj();
//BFS01		StructureChanged(this);
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Lichtstaerke an uebergeben Punkt bestimmen und die akkumulierte
|* Punktfarbe berechnen
|*
\************************************************************************/

//BFS01FASTBOOL E3dDistantLight::CalcLighting(Color& rNewColor,
//BFS01										const Vector3D& rPnt,
//BFS01										const Vector3D& rPntNormal,
//BFS01										const Color& rPntColor)
//BFS01{
//BFS01	double fR = 0, fG = 0, fB = 0;
//BFS01
//BFS01	if ( IsOn() )
//BFS01	{
//BFS01		double fLight = rPntNormal.Scalar(aDirection);
//BFS01
//BFS01		if ( fLight > 0 )
//BFS01		{
//BFS01			fR = fLight * GetRed();
//BFS01			fG = fLight * GetGreen();
//BFS01			fB = fLight * GetBlue();
//BFS01		}
//BFS01	}
//BFS01	return ImpCalcLighting(rNewColor, rPntColor, fR, fG, fB);
//BFS01}

/*************************************************************************
|*
|* Darstellung des Lichtobjekts in der Szene ein-/ausschalten
|*
\************************************************************************/

//BFS01void E3dDistantLight::CreateLightObj()
//BFS01{
//BFS01	pSub->Clear();
//BFS01
//BFS01	if ( IsLightObjVisible() )
//BFS01	{
//BFS01		Insert3DObj(new E3dPolyObj(GetPosition() + aDirection, GetPosition()));
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* sichern
|*
\************************************************************************/

//BFS01void E3dDistantLight::WriteData(SvStream& rOut) const
//BFS01{
//BFS01#ifndef SVX_LIGHT
//BFS01	E3dLight::WriteData(rOut);
//BFS01
//BFS01#ifdef E3D_STREAMING
//BFS01	SdrDownCompat aCompat(rOut, STREAM_WRITE);
//BFS01#ifdef DBG_UTIL
//BFS01	aCompat.SetID("E3dDistantLight");
//BFS01#endif
//BFS01
//BFS01	rOut << aDirection;
//BFS01#endif
//BFS01#endif	// #ifndef SVX_LIGHT
//BFS01}

/*************************************************************************
|*
|* laden
|*
\************************************************************************/

//BFS01void E3dDistantLight::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
//BFS01{
//BFS01	if (ImpCheckSubRecords (rHead, rIn))
//BFS01	{
//BFS01		E3dLight::ReadData(rHead, rIn);
//BFS01
//BFS01		SdrDownCompat aCompat(rIn, STREAM_READ);
//BFS01#ifdef DBG_UTIL
//BFS01		aCompat.SetID("E3dDistantLight");
//BFS01#endif
//BFS01
//BFS01		rIn >> aDirection;
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

//BFS01void E3dDistantLight::operator=(const SdrObject& rObj)
//BFS01{
//BFS01	E3dLight::operator=(rObj);
//BFS01
//BFS01	const E3dDistantLight& r3DObj = (const E3dDistantLight&)rObj;
//BFS01	aDirection = r3DObj.aDirection;
//BFS01}

// eof
