/*************************************************************************
 *
 *  $RCSfile: polyob3d.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: pjunck $ $Date: 2004/11/03 10:41:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//BFS01#include <stdio.h>

//BFS01#include "svdstr.hrc"
//BFS01#include "svdglob.hxx"

//BFS01#ifndef _INC_FLOAT
//BFS01#include <float.h>
//BFS01#endif

//BFS01#ifndef _SVDOPATH_HXX //autogen
//BFS01#include "svdopath.hxx"
//BFS01#endif

//BFS01#ifndef _SVDITER_HXX //autogen
//BFS01#include "svditer.hxx"
//BFS01#endif

//BFS01#ifndef _SVDPAGE_HXX
//BFS01#include "svdpage.hxx"
//BFS01#endif

//BFS01#ifndef _XATTR_HXX
//BFS01#include "xattr.hxx"
//BFS01#endif

//BFS01#ifndef _SVDHDL_HXX
//BFS01#include "svdhdl.hxx"
//BFS01#endif

//BFS01#ifndef _SVDIO_HXX
//BFS01#include "svdio.hxx"
//BFS01#endif

//BFS01#ifndef _B3D_BASE3D_HXX
//BFS01#include <goodies/base3d.hxx>
//BFS01#endif

// FG: wegen der DEBUG-Ausgabe in Dateien (temporaer)
//BFS01#ifndef _INC_STDIO
//BFS01#include <stdio.h>
//BFS01#endif

//BFS01#ifndef _E3D_GLOBL3D_HXX
//BFS01#include "globl3d.hxx"
//BFS01#endif

#ifndef _E3D_POLYOB3D_HXX
#include "polyob3d.hxx"
#endif

//BFS01#ifndef _E3D_POLYSC3D_HXX
//BFS01#include "polysc3d.hxx"
//BFS01#endif

//BFS01TYPEINIT1(E3dPolyObj, E3dObject);

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

//BFS01E3dPolyObj::E3dPolyObj(const PolyPolygon3D& rPolyPoly3D, FASTBOOL bDblSided,
//BFS01	FASTBOOL bLight) :
//BFS01	bDoubleSided(bDblSided),
//BFS01	bBackSideVisible(FALSE),
//BFS01	bLighted(bLight),
//BFS01	bOwnAttrs(sal_False),
//BFS01	bOwnStyle(sal_False),
//BFS01	nObjectnumber (-1)  // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
//BFS01{
//BFS01	SetPolyPolygon3D(rPolyPoly3D);
//BFS01}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

//BFS01E3dPolyObj::E3dPolyObj(const PolyPolygon3D& rPolyPoly3D,
//BFS01	const PolyPolygon3D& rPolyNormals3D, FASTBOOL bDblSided,
//BFS01	FASTBOOL bLight) :
//BFS01	bDoubleSided(bDblSided),
//BFS01	bBackSideVisible(FALSE),
//BFS01	bLighted(bLight),
//BFS01	bOwnAttrs (sal_False),
//BFS01	bOwnStyle (sal_False),
//BFS01	nObjectnumber (-1)  // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
//BFS01{
//BFS01	SetPolyPolygon3D(rPolyPoly3D);
//BFS01	SetPolyNormals3D(rPolyNormals3D);
//BFS01}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

//BFS01E3dPolyObj::E3dPolyObj(const PolyPolygon3D& rPolyPoly3D,
//BFS01	const PolyPolygon3D& rPolyNormals3D,
//BFS01	const PolyPolygon3D& rPolyTexture3D,
//BFS01	FASTBOOL bDblSided,
//BFS01	FASTBOOL bLight) :
//BFS01	bDoubleSided(bDblSided),
//BFS01	bBackSideVisible(FALSE),
//BFS01	bLighted(bLight),
//BFS01	bOwnAttrs (sal_False),
//BFS01	bOwnStyle (sal_False),
//BFS01	nObjectnumber (-1)  // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
//BFS01{
//BFS01	SetPolyPolygon3D(rPolyPoly3D);
//BFS01	SetPolyNormals3D(rPolyNormals3D);
//BFS01	SetPolyTexture3D(rPolyTexture3D);
//BFS01}

/*************************************************************************
|*
|* Linien-Konstruktor
|*
\************************************************************************/

//BFS01E3dPolyObj::E3dPolyObj(const Vector3D& rP1, const Vector3D& rP2) :
//BFS01	aPolyPoly3D(1),
//BFS01	bDoubleSided(TRUE),
//BFS01	bBackSideVisible(FALSE),
//BFS01	bLighted(FALSE),
//BFS01	bOwnAttrs (sal_False),
//BFS01	bOwnStyle (sal_False),
//BFS01	nObjectnumber (-1)    // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
//BFS01{
//BFS01	Polygon3D aPoly3D(2);
//BFS01	aPoly3D[0] = rP1;
//BFS01	aPoly3D[1] = rP2;
//BFS01	aPolyPoly3D.Insert(aPoly3D);
//BFS01	aLocalBoundVol.Union(rP1);
//BFS01	aLocalBoundVol.Union(rP2);
//BFS01	RecalcBoundVolume();
//BFS01}

/*************************************************************************
|*
|* Leer-Konstruktor
|*
\************************************************************************/

//BFS01E3dPolyObj::E3dPolyObj() :
//BFS01	bDoubleSided(FALSE),
//BFS01	bBackSideVisible(FALSE),
//BFS01	bLighted(FALSE),
//BFS01	bOwnAttrs (sal_False),
//BFS01	bOwnStyle (sal_False),
//BFS01	nObjectnumber (-1)    // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
//BFS01{
//BFS01}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

//BFS01E3dPolyObj::~E3dPolyObj()
//BFS01{
//BFS01}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

//BFS01UINT16 E3dPolyObj::GetObjIdentifier() const
//BFS01{
//BFS01	return E3D_POLYOBJ_ID;
//BFS01}

/*************************************************************************
|*
|* Polygon setzen
|*
\************************************************************************/

//BFS01void E3dPolyObj::SetPolyPolygon3D(const PolyPolygon3D& rNewPolyPoly3D)
//BFS01{
//BFS01	if ( aPolyPoly3D != rNewPolyPoly3D )
//BFS01	{
//BFS01		// Neues PolyPolygon; kopieren
//BFS01		aPolyPoly3D = rNewPolyPoly3D;
//BFS01
//BFS01		// Normale berechnen und BoundVol fuellen
//BFS01		aLocalBoundVol = Volume3D();
//BFS01		aNormal = aPolyPoly3D.GetNormal();
//BFS01
//BFS01		// Teilpolygone einbeziehen
//BFS01		for ( USHORT nPoly = 0; nPoly < aPolyPoly3D.Count(); nPoly++ )
//BFS01			for ( USHORT i = 0; i < aPolyPoly3D[nPoly].GetPointCount(); i++ )
//BFS01				aLocalBoundVol.Union(aPolyPoly3D[nPoly][i]);
//BFS01
//BFS01		bBoundVolValid = FALSE;
//BFS01		StructureChanged(this);
//BFS01	}
//BFS01}

//BFS01void E3dPolyObj::SetPolyNormals3D(const PolyPolygon3D& rNewPolyNormals3D)
//BFS01{
//BFS01	if ( aPolyNormals3D != rNewPolyNormals3D )
//BFS01	{
//BFS01		// Neue Normalen; kopieren
//BFS01		aPolyNormals3D = rNewPolyNormals3D;
//BFS01	}
//BFS01}

//BFS01void E3dPolyObj::SetPolyTexture3D(const PolyPolygon3D& rNewPolyTexture3D)
//BFS01{
//BFS01	if ( aPolyTexture3D != rNewPolyTexture3D )
//BFS01	{
//BFS01		// Neue Texturkoordinaten; kopieren
//BFS01		aPolyTexture3D = rNewPolyTexture3D;
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Get the name of the object (singular)
|*
\************************************************************************/

//BFS01void E3dPolyObj::TakeObjNameSingul(XubString& rName) const
//BFS01{
//BFS01	rName=ImpGetResStr(STR_ObjNameSingulPoly3d);
//BFS01
//BFS01	String aName( GetName() );
//BFS01	if(aName.Len())
//BFS01	{
//BFS01		rName += sal_Unicode(' ');
//BFS01		rName += sal_Unicode('\'');
//BFS01		rName += aName;
//BFS01		rName += sal_Unicode('\'');
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Get the name of the object (plural)
|*
\************************************************************************/

//BFS01void E3dPolyObj::TakeObjNamePlural(XubString& rName) const
//BFS01{
//BFS01	rName=ImpGetResStr(STR_ObjNamePluralPoly3d);
//BFS01}

/*************************************************************************
|*
|* Get BoundRect of Object
|*
\************************************************************************/

//BFS01const Rectangle& E3dPolyObj::GetCurrentBoundRect() const
//BFS01{
//BFS01	return E3dObject::GetCurrentBoundRect();
//BFS01}

/*************************************************************************
|*
|* sichern
|*
\************************************************************************/

//BFS01void E3dPolyObj::WriteData31(SvStream& rOut) const
//BFS01{
//BFS01#ifndef SVX_LIGHT
//BFS01	E3dObject::WriteData(rOut);
//BFS01
//BFS01	SdrDownCompat aCompat(rOut, STREAM_WRITE);
//BFS01#ifdef DBG_UTIL
//BFS01	aCompat.SetID("E3dPolyObj");
//BFS01#endif
//BFS01
//BFS01	rOut << aPolyPoly3D;
//BFS01	rOut << aNormal;
//BFS01	rOut << BOOL(bDoubleSided);
//BFS01	rOut << BOOL(bBackSideVisible);
//BFS01	rOut << BOOL(bLighted);
//BFS01
//BFS01	rOut << (UINT32) bOwnAttrs;
//BFS01	rOut << (UINT32) bOwnStyle;
//BFS01#endif
//BFS01}

/*************************************************************************
|*
|* sichern: zur 356 wurde das Fileformat freigegeben 11.2.1997 FG
|*
/*************************************************************************/

//BFS01void E3dPolyObj::WriteData(SvStream& rOut) const
//BFS01{
//BFS01#ifndef SVX_LIGHT
//BFS01	if (rOut.GetVersion() < 3560) // FG: Zu dieser Version erfolgte die Umstellung
//BFS01	{
//BFS01		WriteData31(rOut);
//BFS01	}
//BFS01	else
//BFS01	{
//BFS01		SdrDownCompat aCompat(rOut, STREAM_WRITE);
//BFS01#ifdef DBG_UTIL
//BFS01		aCompat.SetID("E3dPolyObj");
//BFS01#endif
//BFS01		{
//BFS01			SdrDownCompat aCompat (rOut, STREAM_WRITE);
//BFS01#ifdef DBG_UTIL
//BFS01			aCompat.SetID("PolyPolygon3D");
//BFS01#endif
//BFS01			rOut << aPolyPoly3D;
//BFS01		}
//BFS01		{
//BFS01			SdrDownCompat aCompat (rOut, STREAM_WRITE);
//BFS01#ifdef DBG_UTIL
//BFS01			aCompat.SetID("PolyPolygon3D");
//BFS01#endif
//BFS01			rOut << aNormal;
//BFS01		}
//BFS01		rOut << BOOL(bDoubleSided);
//BFS01		rOut << BOOL(bBackSideVisible);
//BFS01		rOut << BOOL(bLighted);
//BFS01
//BFS01		rOut << (UINT32) bOwnAttrs;
//BFS01		rOut << (UINT32) bOwnStyle;
//BFS01		rOut << (UINT32) nObjectnumber;
//BFS01			// Falls das Objekt eigene Attribute hat, wird es rausgeschrieben
//BFS01
//BFS01		if (OwnAttrs() || OwnStyle())
//BFS01		{
//BFS01			E3dObject::WriteData(rOut);
//BFS01		}
//BFS01
//BFS01		// Neue PolyPolygone schreiben fuer Normalen und Textur
//BFS01		if(aPolyNormals3D.Count())
//BFS01		{
//BFS01#ifdef DBG_UTIL
//BFS01			aCompat.SetID("PolyPolygon3D Normals");
//BFS01#endif
//BFS01			rOut << aPolyNormals3D;
//BFS01		}
//BFS01		if(aPolyTexture3D.Count())
//BFS01		{
//BFS01#ifdef DBG_UTIL
//BFS01			aCompat.SetID("PolyPolygon3D Texturkoordinaten");
//BFS01#endif
//BFS01			rOut << aPolyTexture3D;
//BFS01		}
//BFS01	}
//BFS01#endif	// #ifndef SVX_LIGHT
//BFS01}

/*************************************************************************
|*
|* laden
|*
\************************************************************************/

//BFS01void E3dPolyObj::ReadData31(const SdrObjIOHeader& rHead, SvStream& rIn)
//BFS01{
//BFS01	if (ImpCheckSubRecords (rHead, rIn))
//BFS01	{
//BFS01		E3dObject::ReadData(rHead, rIn);
//BFS01		SdrDownCompat aCompat(rIn, STREAM_READ);
//BFS01#ifdef DBG_UTIL
//BFS01		aCompat.SetID("E3dPolyObj");
//BFS01#endif
//BFS01
//BFS01		BOOL   bTmp;
//BFS01		UINT32 nTmp;
//BFS01
//BFS01		// wieviele Bytes werden fuer das Polygon gelesen ?
//BFS01		long nFilePositionBefore = rIn.Tell ();
//BFS01		rIn >> aPolyPoly3D;
//BFS01		long nFilePositionAfter  = rIn.Tell ();
//BFS01
//BFS01		// wenn anschliessend noch mehr Member gestreamt werden, so muss (!!!!) die
//BFS01		// folgende Anzahl der Bytes angepasst werden, ansonsten geht das Lesen wieder
//BFS01		// daneben !
//BFS01		// Diese Werte werden weiter unten eingelesen.
//BFS01		long nBytesToRead        = sizeof (aNormal) + sizeof (bTmp) * 3 + sizeof (nTmp) * 2;
//BFS01
//BFS01		// wieviele Bytes wuerden denn nun gelesen werden ?
//BFS01		// es kommen noch 4 Bytes hinzu, die vom SdrDownCompat fuer die Laenge belegt werden
//BFS01		long nWouldRead          = nFilePositionAfter - nFilePositionBefore + nBytesToRead + 4;
//BFS01
//BFS01		// und um wieviele liegen wir daneben ?
//BFS01		long nBytesWrong         = nWouldRead - aCompat.GetSubRecordSize();
//BFS01
//BFS01		// hoffentlich alles ok, sonst korrigiere die Fileposition
//BFS01		if (nBytesWrong)
//BFS01		{
//BFS01			rIn.Seek (nFilePositionAfter - nBytesWrong);
//BFS01		}
//BFS01
//BFS01		// so, jetzt kann der Rest unbeschadet gelesen werden.
//BFS01		// aus den hier gelesenen Werten muss die Groesse nBytesToRead bestimmt werden.
//BFS01		rIn >> aNormal;
//BFS01		rIn >> bTmp; bDoubleSided = bTmp;
//BFS01		rIn >> bTmp; bBackSideVisible = bTmp;
//BFS01		rIn >> bTmp; bLighted = bTmp;
//BFS01
//BFS01		// Temporaer: Anzahl der Dreiecke aus der Triangulation
//BFS01		rIn >> nTmp; bOwnAttrs = (sal_Bool) nTmp;
//BFS01
//BFS01		if (aCompat.GetBytesLeft () == sizeof (UINT32)) 
//BFS01		{
//BFS01			rIn >> nTmp; 
//BFS01		}
//BFS01		
//BFS01		bOwnStyle = (sal_Bool) nTmp;
//BFS01
//BFS01		SetPolyPolygon3D(aPolyPoly3D);
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* laden
|*
\************************************************************************/

//BFS01void E3dPolyObj::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
//BFS01{
//BFS01	if ( rIn.GetError() != SVSTREAM_OK )
//BFS01		return;
//BFS01
//BFS01	if ((rHead.GetVersion() < 13) || (rIn.GetVersion() < 3560))
//BFS01	{
//BFS01		ReadData31(rHead, rIn);
//BFS01	}
//BFS01	else
//BFS01	{
//BFS01		BOOL   bTmp;
//BFS01		UINT32 nTmp;
//BFS01
//BFS01		SdrDownCompat aCompat(rIn, STREAM_READ);
//BFS01#ifdef DBG_UTIL
//BFS01		aCompat.SetID("E3dPolyObj");
//BFS01#endif
//BFS01
//BFS01		{
//BFS01			SdrDownCompat aCompatPolyPolygon (rIn, STREAM_READ);
//BFS01#ifdef DBG_UTIL
//BFS01			aCompatPolyPolygon.SetID("PolyPolygon3D");
//BFS01#endif
//BFS01			rIn >> aPolyPoly3D;
//BFS01		}
//BFS01		{
//BFS01			SdrDownCompat aCompatPolyPolygon (rIn, STREAM_READ);
//BFS01#ifdef DBG_UTIL
//BFS01			aCompatPolyPolygon.SetID("PolyPolygon3D");
//BFS01#endif
//BFS01			rIn >> aNormal;
//BFS01		}
//BFS01
//BFS01		rIn >> bTmp; bDoubleSided = bTmp;
//BFS01		rIn >> bTmp; bBackSideVisible = bTmp;
//BFS01		rIn >> bTmp; bLighted = bTmp;
//BFS01
//BFS01		// Temporaer: Anzahl der Dreiecke aus der Triangulation
//BFS01		rIn >> nTmp; bOwnAttrs = (BOOL) nTmp;
//BFS01		rIn >> nTmp; bOwnStyle = (BOOL) nTmp;
//BFS01		rIn >> nObjectnumber;
//BFS01
//BFS01		// Nur falls das Objekt eigene Attribute oder einen eigenen
//BFS01		// Stil besitzt wird es gelesen.
//BFS01
//BFS01		if (OwnAttrs() || OwnStyle())
//BFS01		{
//BFS01		  E3dObject::ReadData(rHead, rIn);
//BFS01		}
//BFS01		else
//BFS01		{
//BFS01				// FG: Achtung fuer jedes 3d-Objekt muss eine Subliste existieren, auch wenn
//BFS01				//     sie keinen Eintrag hat, viele Programmstellen (GetBoundRect) fragen nicht
//BFS01				//     ab ob dieser Pointer NULL ist.
//BFS01			pSub = new E3dObjList(NULL, NULL);
//BFS01			pSub->SetOwnerObj(this);
//BFS01			pSub->SetListKind(SDROBJLIST_GROUPOBJ);
//BFS01		}
//BFS01
//BFS01		if(aCompat.GetBytesLeft())
//BFS01		{
//BFS01			// Normalen lesen
//BFS01			rIn >> aPolyNormals3D;
//BFS01			SetPolyNormals3D(aPolyNormals3D);
//BFS01		}
//BFS01
//BFS01		if(aCompat.GetBytesLeft())
//BFS01		{
//BFS01			// Texturen lesen
//BFS01			rIn >> aPolyTexture3D;
//BFS01			SetPolyTexture3D(aPolyTexture3D);
//BFS01		}
//BFS01
//BFS01		SetPolyPolygon3D(aPolyPoly3D);
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Wireframe erzeugen
|*
\************************************************************************/

//BFS01void E3dPolyObj::CreateWireframe(Polygon3D& rWirePoly, const Matrix4D* pTf/*BFS01,	E3dDragDetail eDetail*/)
//BFS01{
//BFS01	// Keine Aktion, da solche Objekte nur noch Hilfsobjekte beim
//BFS01	// Laden/Speichern von 4.0 Format sind.
//BFS01}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

//BFS01void E3dPolyObj::operator=(const SdrObject& rObj)
//BFS01{
//BFS01	E3dObject::operator=(rObj);
//BFS01
//BFS01	const E3dPolyObj& r3DObj = (const E3dPolyObj&) rObj;
//BFS01
//BFS01	aPolyPoly3D		 = r3DObj.aPolyPoly3D;
//BFS01	aPolyNormals3D	 = r3DObj.aPolyNormals3D;
//BFS01	aPolyTexture3D	 = r3DObj.aPolyTexture3D;
//BFS01	aNormal			 = r3DObj.aNormal;
//BFS01
//BFS01	bDoubleSided	 = r3DObj.bDoubleSided;
//BFS01	bBackSideVisible = r3DObj.bBackSideVisible;
//BFS01	bLighted		 = r3DObj.bLighted;
//BFS01	bOwnAttrs        = r3DObj.bOwnAttrs;
//BFS01	bOwnStyle        = r3DObj.bOwnStyle;
//BFS01
//BFS01	nObjectnumber    = r3DObj.nObjectnumber;
//BFS01}

/*************************************************************************
|*
|* Wandle das Objekt in ein Polygon.
|* Es ist nur ein Displayobjekt vorhanden, welches ein (!) Polygon darstellt
|*
\************************************************************************/

//BFS01SdrObject *E3dPolyObj::DoConvertToPolyObj(BOOL bBezier) const
//BFS01{
//BFS01	return NULL;
//BFS01}

/*************************************************************************
|*
|* erstelle neues GeoData-Objekt
|*
\************************************************************************/

//BFS01SdrObjGeoData *E3dPolyObj::NewGeoData() const
//BFS01{
//BFS01	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
//BFS01	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");
//BFS01
//BFS01	if (GetParentObj()->ISA (E3dObject))
//BFS01		return GetParentObj()->E3dObject::NewGeoData ();
//BFS01	else
//BFS01		return E3dObject::NewGeoData ();
//BFS01}

/*************************************************************************
|*
|* uebergebe aktuelle werte an das GeoData-Objekt
|*
\************************************************************************/

//BFS01void E3dPolyObj::SaveGeoData(SdrObjGeoData& rGeo) const
//BFS01{
//BFS01	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
//BFS01	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");
//BFS01
//BFS01	if (GetParentObj()->ISA (E3dObject))
//BFS01		GetParentObj()->E3dObject::SaveGeoData (rGeo);
//BFS01	else
//BFS01		E3dObject::SaveGeoData (rGeo);
//BFS01}

/*************************************************************************
|*
|* uebernehme werte aus dem GeoData-Objekt
|*
\************************************************************************/

//BFS01void E3dPolyObj::RestGeoData(const SdrObjGeoData& rGeo)
//BFS01{
//BFS01	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
//BFS01	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");
//BFS01
//BFS01	if (GetParentObj()->ISA (E3dObject))
//BFS01		GetParentObj()->E3dObject::RestGeoData (rGeo);
//BFS01	else
//BFS01		E3dObject::RestGeoData (rGeo);
//BFS01}

/*************************************************************************
|*
|* Page neu setzen. Normalerweise geht die Page an das Oberobjekt, wenn
|* dieses Objekt von einer Factory erzeugt wurde, existiert noch kein
|* Parent, also wird die Page selbst gesetzt.
|*
\************************************************************************/

//BFS01void E3dPolyObj::SetPage(SdrPage* pNewPage)
//BFS01{
//BFS01	if (GetParentObj())
//BFS01	{
//BFS01		DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");
//BFS01
//BFS01		if (GetParentObj()->ISA (E3dObject))
//BFS01			GetParentObj()->E3dObject::SetPage (pNewPage);
//BFS01		SdrAttrObj::SetPage(pNewPage);
//BFS01	}
//BFS01	else
//BFS01	{
//BFS01		pPage = pNewPage;
//BFS01		if (pPage)
//BFS01			pModel = pPage->GetModel ();
//BFS01	}
//BFS01}

/*************************************************************************
|*
|* Layer setzen
|*
\************************************************************************/

//BFS01void E3dPolyObj::SetModel(SdrModel* pNewModel)
//BFS01{
//BFS01	SdrAttrObj::SetModel(pNewModel);
//BFS01}

/*************************************************************************
|*
|* Layer abfragen. Da alle Unterobjekte auf demselben Layer liegen
|* gibt es keinerlei Probleme
|*
\************************************************************************/

//BFS01SdrLayerID E3dPolyObj::GetLayer() const
//BFS01{
//BFS01	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
//BFS01	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");
//BFS01
//BFS01	if (GetParentObj()->ISA (E3dObject))
//BFS01		return GetParentObj()->E3dObject::GetLayer ();
//BFS01	else
//BFS01		return SdrLayerID(nLayerID);
//BFS01}

/*************************************************************************
|*
|* Layer setzen
|*
\************************************************************************/

//BFS01void E3dPolyObj::NbcSetLayer(SdrLayerID nLayer)
//BFS01{
//BFS01	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
//BFS01	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");
//BFS01
//BFS01	if (GetParentObj()->ISA (E3dObject))
//BFS01		GetParentObj()->SdrAttrObj::NbcSetLayer (nLayer);
//BFS01	SdrAttrObj::NbcSetLayer(nLayer);
//BFS01}

/*************************************************************************
|*
|* Bestimme die Anzahl der Punkte
|*
\************************************************************************/

//BFS01USHORT E3dPolyObj::GetPointCount () const
//BFS01{
//BFS01	USHORT nResult = 0;
//BFS01
//BFS01	for (long nPoly = 0;
//BFS01			  nPoly < aPolyPoly3D.Count();
//BFS01			  nPoly ++)
//BFS01		nResult += (USHORT) (aPolyPoly3D[(USHORT)nPoly].GetPointCount());
//BFS01
//BFS01	return nResult;
//BFS01}


