/*************************************************************************
 *
 *  $RCSfile: conctrl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 15:38:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop


#ifndef _SVDVIEW_HXX //autogen
#include <svx/svdview.hxx>
#endif
#ifndef _SVDOBJ_HXX //autogen
#include <svx/svdobj.hxx>
#endif


#include "view.hxx"
#include "edtwin.hxx"
#include "wrtsh.hxx"
#include "drawbase.hxx"
#include "conctrl.hxx"

extern BOOL bNoInterrupt;		// in mainwn.cxx

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/


ConstControl::ConstControl(SwWrtShell* pWrtShell, SwEditWin* pEditWin, SwView* pSwView) :
	SwDrawBase(pWrtShell, pEditWin, pSwView)
{
	bInsCtrl = TRUE;
}

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/


BOOL ConstControl::MouseButtonDown(const MouseEvent& rMEvt)
{
	BOOL bReturn = FALSE;

	SdrView *pSdrView = pSh->GetDrawView();

	pSdrView->SetOrtho(rMEvt.IsShift());
	pSdrView->SetAngleSnapEnabled(rMEvt.IsShift());

	if (rMEvt.IsMod2())
	{
		pSdrView->SetCreate1stPointAsCenter(TRUE);
		pSdrView->SetResizeAtCenter(TRUE);
	}
	else
	{
		pSdrView->SetCreate1stPointAsCenter(FALSE);
		pSdrView->SetResizeAtCenter(FALSE);
	}

	SdrViewEvent aVEvt;
	SdrHitKind eHit = pSdrView->PickAnything(rMEvt, SDRMOUSEBUTTONDOWN, aVEvt);

	// Nur neues Objekt, wenn nicht im Basismode (bzw reinem Selektionsmode)
	if (rMEvt.IsLeft() && !pWin->IsDrawAction() &&
		(eHit == SDRHIT_UNMARKEDOBJECT || eHit == SDRHIT_NONE || pSh->IsDrawCreate()))
	{
		bNoInterrupt = TRUE;
		pWin->CaptureMouse();

		pWin->SetPointer(Pointer(POINTER_CROSS));

		aStartPos = pWin->PixelToLogic(rMEvt.GetPosPixel());
		bReturn = pSh->BeginCreate(pWin->GetDrawMode(), VCSbxInventor, aStartPos);

		if (bReturn)
			pWin->SetDrawAction(TRUE);
	}
	else
		bReturn = SwDrawBase::MouseButtonDown(rMEvt);

	return (bReturn);
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/


void ConstControl::Activate(const USHORT nSlotId)
{
	switch (nSlotId)
	{
		case SVX_SNAP_PUSHBUTTON:
			pWin->SetDrawMode(OBJ_PUSHBUTTON);
			break;
		case SVX_SNAP_RADIOBUTTON:
			pWin->SetDrawMode(OBJ_RADIOBUTTON);
			break;
		case SVX_SNAP_CHECKBOX:
			pWin->SetDrawMode(OBJ_CHECKBOX);
			break;
		case SVX_SNAP_SPINBUTTON:
			pWin->SetDrawMode(OBJ_SPINBUTTON);
			break;
		case SVX_SNAP_FIXEDTEXT:
			pWin->SetDrawMode(OBJ_FIXEDTEXT);
			break;
		case SVX_SNAP_GROUPBOX:
			pWin->SetDrawMode(OBJ_GROUPBOX);
			break;
		case SVX_SNAP_LISTBOX:
			pWin->SetDrawMode(OBJ_LISTBOX);
			break;
		case SVX_SNAP_COMBOBOX:
			pWin->SetDrawMode(OBJ_COMBOBOX);
			break;
		case SVX_SNAP_EDIT:
			pWin->SetDrawMode(OBJ_EDIT);
			break;
		case SVX_SNAP_HSCROLLBAR:
			pWin->SetDrawMode(OBJ_HSCROLLBAR);
			break;
		case SVX_SNAP_VSCROLLBAR:
			pWin->SetDrawMode(OBJ_VSCROLLBAR);
			break;
		case SVX_SNAP_PREVIEW:
			pWin->SetDrawMode(OBJ_DLG_PREVIEW);
			break;
		case SVX_SNAP_URLBUTTON:
			pWin->SetDrawMode(OBJ_URLBUTTON);
			break;
		default:
			pWin->SetDrawMode(OBJ_NONE);
			break;
	}

	SwDrawBase::Activate(nSlotId);

	pSh->GetDrawView()->SetCurrentObj(OBJ_NONE);

	SetDrawPointer();
}


