/*************************************************************************
 *
 *  $RCSfile: dtconv.c,v $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <fcntl.h>
#include <unistd.h>

#include <errno.h>
#include <string.h>

#include <locale.h>

#include <langinfo.h>

#if !defined(CODESET)
#define CODESET _NL_CTYPE_CODESET_NAME
#endif

#include<iconv.h>



/*
#include<limits.h>
*/


/*
 * For state-dependent encodings, changes the state of the conversion
 * descriptor to initial shift state.  Also, outputs the byte sequence
 * to change the state to initial state.
 * This code is assuming the iconv call for initializing the state
 * won't fail due to lack of space in the output buffer.
 */
#define INIT_SHIFT_STATE(cd, fptr, ileft, tptr, oleft) \
    { \
        fptr = NULL; \
        ileft = 0; \
        tptr = to; \
        oleft = BUFSIZ; \
        (void) iconv(cd, &fptr, &ileft, &tptr, &oleft); \
        (void) fwrite(to, 1, BUFSIZ - oleft, stdout); \
    }


int main(int argc, char * argv[])
{
    const char *locale = "";
    const char *codeset;
    const char from_code[] = "utf-8";
    
    extern char *optarg;
    extern int optind, optopt;
    int errflg = 0;
    int c;
    
    iconv_t cd;
    char from[BUFSIZ], to[BUFSIZ];
    char *tptr;
    const char *fptr;
    size_t ileft, oleft, num, ret;
    
    while ((c = getopt(argc, argv, ":l:")) != -1) {
        switch(c){
        case 'l':
            locale = optarg;
            break;
        case ':':
            fprintf(stderr, "dtconv: option -%c requires an operand\n", optopt);
            errflg++;
            break;
        case '?':
            fprintf(stderr, "dtconv: unrecognized option: -%c\n", optopt);
            errflg++;
            break;
        }
    }
        
    if (optind + 1 < argc) {
        fprintf(stderr, "dtconv: too many source files specified\n");
        errflg++;
    }

    /* input file specified - assigning file stream to stdin */
    if (optind < argc) {
        int fd = open(argv[optind], O_RDONLY);
        if (fd > 0) {
            dup2(fd, 0);
            close(fd);
        } else {
            fprintf(stderr, "dtconv: %s: %s\n", strerror(errno), argv[optind]);
            errflg++;
        }
    }

    if (errflg > 0) {
        fprintf(stderr, "Usage: dtconv [-l locale] [file]\n");
        exit(2);
    }
    
    /* 
     * locale points either to an empty string (which causes setlocale to 
     * evaluate the corresponding environment variables) or to the operand
     * of the -l option. The category of interest for nl_langinfo(CODESET)
     * is LC_CTYPE.
     */
    
    if (NULL == setlocale(LC_CTYPE, locale)) {
        fprintf(stderr, "dtconv: could not change locale to %s.\n", locale);
        exit(2);
    }
    
    codeset = nl_langinfo(CODESET);
    
    if ('\0' == *codeset) {
        fprintf(stderr, "dtconv: could not determine codeset for locale %s.\n", locale);
        exit(2);
    }
    
    /*
     * if the requested codeset equals from_code, just pass the data from 
     * stdin to stdout.
     */
    if (0 == strcasecmp(codeset, from_code)) {
        while ((num = fread(from, 1, BUFSIZ, stdin)) > 0) {
            fwrite(from, 1, num, stdout);
        }
        exit(0);
    }
    
    cd = iconv_open(codeset, from_code);
    if ((iconv_t) -1 == cd) {
        fprintf(stderr, "dtconv: conversion from %s to %s failed: %s.\n", 
            from_code, codeset, strerror(errno));
        exit(2);
    }

    ileft = 0;
    while ((ileft +=
        (num = fread(from + ileft, 1, BUFSIZ - ileft, stdin))) > 0) {

        if (num == 0) {
             /*
              * Input buffer still contains incomplete character
              * or sequence.  However, no more input character.
              */

             /*
              * Initializes the conversion descriptor and outputs
              * the sequence to change the state to initial state.
              */
             INIT_SHIFT_STATE(cd, fptr, ileft, tptr, oleft);
             (void) iconv_close(cd);

             (void) fprintf(stderr, "dtconv: conversion error.\n");
             exit(2);
        }

        fptr = from;
        for (;;) {        
            tptr = to;
            oleft = BUFSIZ;

            if ((size_t)-1 != iconv(cd, &fptr, &ileft, &tptr, &oleft)) {
                /*
                 * iconv succeeded
                 */

                /*
                 * Outputs converted characters
                 */
                (void) fwrite(to, 1, BUFSIZ - oleft, stdout);
                break;
            }
            
            /*
            * iconv failed
            */
            if (errno == EINVAL) {
                /*
                 * Incomplete character or shift sequence
                 */

                 /*
                  * Outputs converted characters
                  */
                (void) fwrite(to, 1, BUFSIZ - oleft, stdout);
                
                 /*
                  * Copies remaining characters in input buffer
                  * to the top of the input buffer.
                  */
                (void) memmove(from, fptr, ileft);
                
                /*
                 * Tries to fill input buffer from stdin
                 */
                break;
            } else if (errno == E2BIG) {
                /*
                 * Lack of space in output buffer
                 */

                /*
                 * Outputs converted characters
                 */
                (void) fwrite(to, 1, BUFSIZ - oleft, stdout);
                
                /*
                 * Tries to convert remaining characters in
                 * input buffer with emptied output buffer
                 */
                continue;
            } else if (errno == EILSEQ) {
                 /*
                  * Illegal character or shift sequence
                  */

                 /*
                  * Outputs converted characters
                  */
                 (void) fwrite(to, 1, BUFSIZ - oleft, stdout);
                 /*
                  * Initializes the conversion descriptor and
                  * outputs the sequence to change the state to
                  * initial state.
                  */
                 INIT_SHIFT_STATE(cd, fptr, ileft, tptr, oleft);
                 (void) iconv_close(cd);

                 (void) fprintf(stderr, "dtconv: illegal character or sequence\n");
                 return (2);
             } else if (errno == EBADF) {
                 /*
                  * Invalid conversion descriptor.
                  * Actually, this shouldn't happen here.
                  */
                 (void) fprintf(stderr, "dtconv: conversion error\n");
                 return (2);
             } else {
                 /*
                  * This errno is not defined
                  */
                 (void) fprintf(stderr, "dtconv: iconv error\n");
                 return (2);
             }
         }
    }
            
    /*
     * Initializes the conversion descriptor and outputs
     * the sequence to change the state to initial state.
     */
    INIT_SHIFT_STATE(cd, fptr, ileft, tptr, oleft);

    iconv_close(cd);
    exit(0);
}


