#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJ=..$/..

PRJNAME=sysui
TARGET=cde

TARGETTYPE=CUI
LIBTARGET=NO
NO_DEFAULT_STL=TRUE
LIBSALCPPRT=$(0)

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk

# --- Product Version Information ----------------------------------

.INCLUDE :  ../productversion.mk

# --- Files --------------------------------------------------------

.IF "$(OS)"=="SOLARIS"

OBJFILES = $(OBJ)$/dtconv.obj

APP1TARGET=dtconv
APP1OBJS=$(OBJ)$/dtconv.obj
APP1LIBS=
APP1STDLIBS=-ldl

# menu launcher files
LAUNCHERDIR = $(MISC)$/$(TARGET)/$(BASEDIR:f)/share/cde
LAUNCHERLIST = writer calc draw impress math base printeradmin
LAUNCHERDEPN = $(foreach,i,$(LAUNCHERLIST) $(i:+".fp") $(i:+".dt"))

LAUNCHERFLAGFILE = $(MISC)$/$(TARGET)launcher.flag

PKGNAME = `sed -n -e 's/PKG=//p' pkginfo`
PKGFLAGFILE = $(MISC)$/$(TARGET)pkg.flag

PKGFILES = \
	$(MISC)$/$(TARGET)$/pkginfo
    
PKGDATESTRING = `date -u '+%Y.%m.%d'`
.IF "$(CPU)"=="S"
PKGARCH=sparc
.ELSE
PKGARCH=i386
.ENDIF

SCRIPTFILES = $(BIN)/dtintegrate
ULFDIR = $(COMMONMISC)$/desktopshare

.ENDIF # "$(OS)"=="SOLARIS"

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk

.IF "$(OS)"=="SOLARIS"
ALLTAR : $(PKGFLAGFILE)

$(LAUNCHERFLAGFILE): $(LAUNCHERDEPN) ../productversion.mk brand.pl translate.pl makefile.mk $(ULFDIR)/launcher_comment.ulf $(ULFDIR)/launcher_name.ulf
	@$(MKDIRHIER) $(LAUNCHERDIR)/types
	-@$(RM) -rf $(LAUNCHERDIR)/types/*
	@echo Patching CDE frontpanel templates ..
	@$(PERL) brand.pl -p "$(LONGPRODUCTNAME)" -u $(UNIXFILENAME) $(LAUNCHERDEPN) $(LAUNCHERDIR)/types/C
	@echo Translating CDE frontpanel templates ..
	@$(PERL) translate.pl -p "$(LONGPRODUCTNAME)" -d $(LAUNCHERDIR)/types -k "fp,LABEL,PUSH_ACTION" -k "dt,LABEL,EXEC_STRING" $(ULFDIR)/launcher_name.ulf
	@$(PERL) translate.pl -p "$(LONGPRODUCTNAME)" -d $(LAUNCHERDIR)/types -k "fp,HELP_STRING,PUSH_ACTION" -k "dt,DESCRIPTION,EXEC_STRING" $(ULFDIR)/launcher_comment.ulf 
	@ln -s zh_CN $(LAUNCHERDIR)/types/zh
	@touch $@

%.stripped : $$(@:db)
	@cp $(@:db) $@
	@strip $@

$(SCRIPTFILES) : $$(@:f:+".sh") makefile.mk pkginfo
	@cat $(@:f:+".sh") | tr -d "\015" | sed -e "s/%LAUNCHERLIST/$(LAUNCHERLIST)/" -e "s/%UNIXFILENAME/$(UNIXFILENAME)/" -e "s/%PACKAGENAME/$(PKGNAME)/" > $@

$(PKGFILES) : $$(@:f) makefile.mk
	@cat $(@:f) | tr -d "\015" > $@

# FIXME: need to add vendor information ..
# FIXME: should use epm here ..
$(PKGFLAGFILE): $(LAUNCHERFLAGFILE) pkginfo $(BIN)/$(APP1TARGET).stripped $(SCRIPTFILES) $(PKGFILES) prototype 
	@cat prototype | tr -d "\015" > $(MISC)$/$(TARGET)/prototype
	@pkgproto $(MISC)/$(TARGET)/$(BASEDIR:f)= | awk '{ printf "%s %s %s 0%d%d root bin\n",$$1, $$2, $$3, $$4/100, $$4%10*11 }' >> $(MISC)$/$(TARGET)/prototype
	@echo "f none share/cde/$(APP1TARGET)=$(BIN)/$(APP1TARGET).stripped 755 root bin" >> $(MISC)$/$(TARGET)/prototype
	@echo "f none share/cde/dtintegrate=$(BIN)/dtintegrate 755 root bin" >> $(MISC)$/$(TARGET)/prototype
	@pkgmk -o -r . -f $(MISC)$/$(TARGET)/prototype BASEDIR=$(BASEDIR) ARCH=$(PKGARCH) VERSION=$(PKGVERSION),REV=$(PKGREV).$(PKGDATESTRING)
	@tar -cf - -C /var/spool/pkg $(PKGNAME) | gzip > $(BIN)/$(PKGNAME).tar.gz
        @rm -rf /var/spool/pkg/$(PKGNAME)
	@touch $@
	
.ENDIF # "$(OS)"=="SOLARIS"
