:
eval 'exec perl -wS $0 ${1+"$@"}'
    if 0;

#*************************************************************************
#
#   $RCSfile: translate.pl,v $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************


#*********************************************************************
#
# main
#

$productname = "OpenOffice.org";
$workdir = ".";
my(@keys);

while ($_ = $ARGV[0], /^-/) {
    shift;
    last if /^--$/;
    if (/^-p/) {
        $productname = $ARGV[0];
        shift;
    }
    if (/^-d/) {
        $workdir = $ARGV[0];
        shift;
    }
    if (/^-k/) {
        push @keys,$ARGV[0];
        shift;
    }  
}

# open input file
unless (open(INFILE, $ARGV[0])) {
    print STDERR "Can't open $ARGV[0] file: $!\n";
    return;
}
    
while (<INFILE>) {
    $line = $_;
    
    # new section reached
    if ( "[" eq substr($line, 0, 1) ) {
        $section = substr($line, 1, index($line,"]")-1);
        $section=~s/-/./g;
        
    } else {
        # split locale = "value" into 2 strings
        ($locale, $value) = split(' = ', $line);
        
        # check if line is valid 
        if ( $locale ne $line ) {
        
            # use just anything inside the ""
            $value = substr($value, index($value, "\"") + 1, rindex($value, "\"") - 1);
            $value =~ s/%PRODUCTNAME/$productname/g; 

            # replace en-US with en
            $locale=~s/en-US/en/;
            
            # replace '-' with '_' in locale strings
            $locale=~s/-/_/g;

            foreach $i (@keys) {
                ($extension,$key,$anchor) = split /,/, $i;
            
                # the target file might already exist from a previous run
                # of translate.pl. If so, use this file as input file. Use
                # the corresponding source file otherwise.
                $outfile="$workdir/$locale/$section.$extension";
                unless ( open(SOURCE, "$outfile" ) || open(SOURCE, "$workdir/C/$section.$extension")) {
                    next;
                }
            
                # open output file - since the file might already exist and
                # be used as input file, append ".tmp" suffix.
                mkdir "$workdir/$locale", 0777;
                unless (open(OUTFILE, "> $outfile.tmp")) {
                    print STDERR "Can't create output file $outfile.tmp: $!\n";
                    close SOURCE;
                    return;
                }
            
                while (<SOURCE>) {
                    # remove possible windows line-ends
                    chomp;
                
                    # ignore lines containing $key
                    if (/$key/) {
                        next;
                    }
                
                    # insert new line before $anchor in fp files
                    if (/$anchor/) {
                        printf OUTFILE "    %-16s%s\n", $key, $value;
                    }
                
                    # finally write the current line to output file
                    print OUTFILE "$_\n";
                }
            
                close SOURCE;
                close OUTFILE;
            
                unless (rename "$outfile.tmp", $outfile) {
                    print STDERR "Can't create output file $outfile: $!\n";
                    unlink "$outfile.tmp";
                }
            }
        }
    }
}

close(INFILE);
