/*************************************************************************
 *
 *  $RCSfile: versionhelper.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2003/07/29 13:02:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef AUTOREGISTER_HXX
#define AUTOREGISTER_HXX

#include <stdio.h>
#include <vector>
#include <ostream>
#include <iostream>

#include <rtl/ustring.hxx>
#include <rtl/string.hxx>

#include "dynamicregister.hxx"

// -----------------------------------------------------------------------------
// ---------------------------------- Version ----------------------------------
// -----------------------------------------------------------------------------
// extern "C" const struct VersionInfo *GetVersionInfo();

// this is a Hack, but at the moment, no change to handle this behaviour better.
struct VersionInfo
{
	const char*	pTime;
	const char*	pDate;
	const char*	pUpd;
	const char*	pMinor;
	const char*	pBuild;
	const char*	pInpath;
};
typedef const struct VersionInfo* (*FktGetVersionInfoPtr)();

// -----------------------------------------------------------------------------
class VersionHelper : public DynamicLibraryHelper
{
	const VersionInfo *m_pInfo;

public:
    VersionHelper(rtl::OUString const& _sDLLName, GetOpt & _aOptions);
//	void print(std::ostream& _aStream);
    void printall(FILE*);

    rtl::OString getTime() const;
    rtl::OString getDate() const;
    rtl::OString getUpd() const;
    rtl::OString getMinor() const;
    rtl::OString getBuild() const;
    rtl::OString getInpath() const;

    bool isOk() const;
};

/** insertion operator for easy output */
// std::ostream &operator <<( std::ostream &stream, 
//                           VersionHelper &version );


#endif

