/*************************************************************************
 *
 *  $RCSfile: intnlang.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2004/02/04 13:46:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define private public

// propagate methods to I18N, see intn.hxx
#define I18N_CHARACTERCLASSIFICATION_USES_CLASS_INTERNATIONAL

#ifndef _IMPSTRG_HXX
#include <impstrg.hxx>
#endif

#ifndef _INTNTAB_HXX
#include <intntab.hxx>
#endif

#ifndef _DEBUG_HXX
#include <debug.hxx>
#endif

// -----------------------------------------------------------------------

DBG_NAMEEX( International );

// -----------------------------------------------------------------------

// ----------------
// - IntnCharInfo -
// ----------------

struct IntnCharInfo
{
	USHORT			nLowerChar;
	USHORT			nUpperChar;
	BYTE			nType;
	BYTE			nBaseType;
	BYTE			nSubType;
};

// -----------------------------------------------------------------------

typedef StringCompare (*IntnCompareCharProc)( USHORT nPrevChar1, USHORT nPrevChar2,
											  USHORT& rUniChar1, USHORT& rUniChar2,
											  USHORT& rNextChar1, USHORT& rNextChar2,
											  StringCompare& rLigaSort );

// -----------------------------------------------------------------------

#define I_LOA					(INTN_CHAR_ALPHA | INTN_CHAR_LOWER)
#define I_UPA					(INTN_CHAR_ALPHA | INTN_CHAR_UPPER)
#define I_NUM					(INTN_CHAR_NUMERIC)
#define I_NAN					(INTN_CHAR_NOTALPHANUMERIC)

#define I_BT_CONTROL			1
#define I_BT_SPACE				2
#define I_BT_UNDERSCORE 		3
#define I_BT_SYMBOL 			4
#define I_BT_PUNKTATIONMARK 	5
#define I_BT_BRACKET			6
#define I_BT_QUOTATION			7
#define I_BT_HYPHEN 			8
#define I_BT_APOSTROPHE 		9
#define I_BT_0					30
#define I_BT_1					31
#define I_BT_2					32
#define I_BT_3					33
#define I_BT_4					34
#define I_BT_5					35
#define I_BT_6					36
#define I_BT_7					37
#define I_BT_8					38
#define I_BT_9					39
#define I_BT_A					50
#define I_BT_B					51
#define I_BT_C					52
#define I_BT_D					53
#define I_BT_E					54
#define I_BT_F					55
#define I_BT_G					56
#define I_BT_H					57
#define I_BT_I					58
#define I_BT_J					59
#define I_BT_K					60
#define I_BT_L					61
#define I_BT_M					62
#define I_BT_N					63
#define I_BT_O					64
#define I_BT_P					65
#define I_BT_Q					66
#define I_BT_R					67
#define I_BT_S					68
#define I_BT_T					69
#define I_BT_U					70
#define I_BT_V					71
#define I_BT_W					72
#define I_BT_X					73
#define I_BT_Y					74
#define I_BT_Z					75
#define I_BT_ETH				90
#define I_BT_THORN				91
#define I_BT_ENG				92
#define I_BT_KRA				93
#define I_BT_CYR_A				94
#define I_BT_CYR_BE 			95
#define I_BT_CYR_VE 			96
#define I_BT_CYR_GE 			97
#define I_BT_CYR_HARD_GHE       98
#define I_BT_CYR_DE 			99
#define I_BT_CYR_GJE            100
#define I_BT_CYR_DJE            101
#define I_BT_CYR_IE 			102
#define I_BT_CYR_IO             103
#define I_BT_CYR_UKR_IE         104
#define I_BT_CYR_IE_GRAVE		105					
#define I_BT_CYR_ZHE			106
#define I_BT_CYR_ZE 			107
#define I_BT_CYR_DZE            108
#define I_BT_CYR_BEL_I          109
#define I_BT_CYR_YI             110 
#define I_BT_CYR_II 			111
#define I_BT_CYR_SHORT_II		112
#define I_BT_CYR_I_GRAVE        113
#define I_BT_CYR_JE             114 
#define I_BT_CYR_KA 			115
#define I_BT_CYR_KJE            116 
#define I_BT_CYR_EL 			117
#define I_BT_CYR_LJE            118
#define I_BT_CYR_EM 			119
#define I_BT_CYR_EN 			120
#define I_BT_CYR_NJE            121
#define I_BT_CYR_O			    122
#define I_BT_CYR_PE 			123
#define I_BT_CYR_ER 			124
#define I_BT_CYR_ES 			125
#define I_BT_CYR_TE 			126
#define I_BT_CYR_TSHE           127
#define I_BT_CYR_U			    128
#define I_BT_CYR_SHORT_U        129 
#define I_BT_CYR_EF 			130
#define I_BT_CYR_KHA			131
#define I_BT_CYR_TSE			132
#define I_BT_CYR_CHE			133
#define I_BT_CYR_DZHE           134
#define I_BT_CYR_SHA			135
#define I_BT_CYR_SHCHA			136
#define I_BT_CYR_HARD_SIGN		137
#define I_BT_CYR_YERI			138
#define I_BT_CYR_SOFT_SIGN		139
#define I_BT_CYR_REVERSED_E 	140
#define I_BT_CYR_IU 			141
#define I_BT_CYR_IA 			142
#define I_BT_GREEK_ALPHA		143
#define I_BT_GREEK_BETA 		144
#define I_BT_GREEK_GAMMA		145
#define I_BT_GREEK_DELTA		146
#define I_BT_GREEK_EPSILON		147
#define I_BT_GREEK_ZETA 		148
#define I_BT_GREEK_ETA			149
#define I_BT_GREEK_THETA		150
#define I_BT_GREEK_IOTA 		151
#define I_BT_GREEK_KAPPA		152
#define I_BT_GREEK_LAMBDA		153
#define I_BT_GREEK_MU			154
#define I_BT_GREEK_NU			155
#define I_BT_GREEK_XI			156
#define I_BT_GREEK_OMICRON		157
#define I_BT_GREEK_PI			158
#define I_BT_GREEK_RHO			159
#define I_BT_GREEK_SIGMA		160
#define I_BT_GREEK_TAU			161
#define I_BT_GREEK_UPSILON		162
#define I_BT_GREEK_PHI			163
#define I_BT_GREEK_CHI			164
#define I_BT_GREEK_PSI			165
#define I_BT_GREEK_OMEGA		166

#define I_ST_NORMAL 			0x00
#define I_ST_ACUTE				0x01
#define I_ST_GRAVE				0x02
#define I_ST_CIRCUMFLEX 		0x03
#define I_ST_DIAERESIS			0x04
#define I_ST_CEDILLA			0x05
#define I_ST_RING				0x06
#define I_ST_TILDE				0x07
#define I_ST_MACRON 			0x08
#define I_ST_BREVE				0x09
#define I_ST_DOT				0x0A
#define I_ST_DOTLESS			0x0B
#define I_ST_MIDDLEDOT			0x0C
#define I_ST_OGONEK 			0x0D
#define I_ST_HACEK				0x0E
#define I_ST_SLASH				0x0F
#define I_ST_BAR				0x10
#define I_ST_APOSTROPHE 		0x11
#define I_ST_DOUBLEACUTE		0x12
#define I_ST_LIGATURE			0x13
#define I_ST_TONE				0x14

#define I_MAX_UNICHAR			0x017F
#define I_SYM_UNICHAR			((I_MAX_UNICHAR)+1)

static IntnCharInfo aImplCharInfoTab[I_MAX_UNICHAR+2] =
{
{ 0x0000, 0x0000, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0000 / NULL								  // ASCII
{ 0x0001, 0x0001, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0001 / START OF HEADING
{ 0x0002, 0x0002, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0002 / START OF TEXT
{ 0x0003, 0x0003, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0003 / END OF TEXT
{ 0x0004, 0x0004, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0004 / END OF TRANSMISION
{ 0x0005, 0x0005, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0005 / ENQUIRY
{ 0x0006, 0x0006, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0006 / ACKNOWLEDGE
{ 0x0007, 0x0007, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0007 / BELL
{ 0x0008, 0x0008, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0008 / BACKPSACE
{ 0x0009, 0x0009, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0009 / HORIZONTAL TABULATION
{ 0x000A, 0x000A, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x000A / LINE FEED
{ 0x000B, 0x000B, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x000B / VERTICAL TABULATION
{ 0x000C, 0x000C, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x000C / FORM FEED
{ 0x000D, 0x000D, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x000D / CARRIAGE RETURN
{ 0x000E, 0x000E, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x000E / SHIFT OUT
{ 0x000F, 0x000F, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x000F / SHIFT IN
{ 0x0010, 0x0010, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0010 / DATA LINK ESCAPE
{ 0x0011, 0x0011, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0011 / DEVICE CONTROL ONE
{ 0x0012, 0x0012, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0012 / DEVICE CONTROL TWO
{ 0x0013, 0x0013, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0013 / DEVICE CONTROL THREE
{ 0x0014, 0x0014, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0014 / DEVICE CONTROL FOUR
{ 0x0015, 0x0015, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0015 / NEGATIVE ACKNOWLEDGE
{ 0x0016, 0x0016, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0016 / SYNCHRONOUS IDLE
{ 0x0017, 0x0017, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0017 / END OF TRANSMISION BLOCK
{ 0x0018, 0x0018, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0018 / CANCEL
{ 0x0019, 0x0019, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0019 / END OF MEDIUM
{ 0x001A, 0x001A, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x001A / SUBSTITUTE
{ 0x001B, 0x001B, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x001B / ESCAPE
{ 0x001C, 0x001C, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x001C / FILE SEPARATOR
{ 0x001D, 0x001D, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x001D / GROUP SEPARATOR
{ 0x001E, 0x001E, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x001E / RECORD SEPARATOR
{ 0x001F, 0x001F, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x001F / UNIT SEPARATOR
{ 0x0020, 0x0020, I_NAN, I_BT_SPACE,		  I_ST_NORMAL		},	// 0x0020 / SPACE
{ 0x0021, 0x0021, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0021 / EXCLAMATION
{ 0x0022, 0x0022, I_NAN, I_BT_QUOTATION,	  I_ST_NORMAL		},	// 0x0022 / QUOTATION MARK
{ 0x0023, 0x0023, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x0023 / NUMBER SIGN
{ 0x0024, 0x0024, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x0024 / DOLLAR SIGN
{ 0x0025, 0x0025, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x0025 / PERCENT SIGN
{ 0x0026, 0x0026, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x0026 / AMPERSAND
{ 0x0027, 0x0027, I_NAN, I_BT_APOSTROPHE,	  I_ST_NORMAL		},	// 0x0027 / APOSTOPHE-QUOTE
{ 0x0028, 0x0028, I_NAN, I_BT_BRACKET,		  I_ST_NORMAL		},	// 0x0028 / OPENING PARENTHESIS
{ 0x0029, 0x0029, I_NAN, I_BT_BRACKET,		  I_ST_NORMAL		},	// 0x0029 / CLOSING PARENTHESIS
{ 0x002A, 0x002A, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x002A / ASTERISK
{ 0x002B, 0x002B, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x002B / PLUS SIGN
{ 0x002C, 0x002C, I_NAN, I_BT_PUNKTATIONMARK, I_ST_NORMAL		},	// 0x002C / COMMA
{ 0x002D, 0x002D, I_NAN, I_BT_HYPHEN,		  I_ST_NORMAL		},	// 0x002D / HYPHEN MINUS
{ 0x002E, 0x002E, I_NAN, I_BT_PUNKTATIONMARK, I_ST_NORMAL		},	// 0x002E / PERIOD
{ 0x002F, 0x002F, I_NAN, I_BT_PUNKTATIONMARK, I_ST_NORMAL		},	// 0x002F / SLASH
{ 0x0030, 0x0030, I_NUM, I_BT_0,			  I_ST_NORMAL		},	// 0x0030 / DIGIT ZERO
{ 0x0031, 0x0031, I_NUM, I_BT_1,			  I_ST_NORMAL		},	// 0x0031 / DIGIT ONE
{ 0x0032, 0x0032, I_NUM, I_BT_2,			  I_ST_NORMAL		},	// 0x0032 / DIGIT TWO
{ 0x0033, 0x0033, I_NUM, I_BT_3,			  I_ST_NORMAL		},	// 0x0033 / DIGIT THREE
{ 0x0034, 0x0034, I_NUM, I_BT_4,			  I_ST_NORMAL		},	// 0x0034 / DIGIT FOUR
{ 0x0035, 0x0035, I_NUM, I_BT_5,			  I_ST_NORMAL		},	// 0x0035 / DIGIT FIVE
{ 0x0036, 0x0036, I_NUM, I_BT_6,			  I_ST_NORMAL		},	// 0x0036 / DIGIT SIX
{ 0x0037, 0x0037, I_NUM, I_BT_7,			  I_ST_NORMAL		},	// 0x0037 / DIGIT SEVEN
{ 0x0038, 0x0038, I_NUM, I_BT_8,			  I_ST_NORMAL		},	// 0x0038 / DIGIT EIGHT
{ 0x0039, 0x0039, I_NUM, I_BT_9,			  I_ST_NORMAL		},	// 0x0039 / DIGIT NINE
{ 0x003A, 0x003A, I_NAN, I_BT_PUNKTATIONMARK, I_ST_NORMAL		},	// 0x003A / COLON
{ 0x003B, 0x003B, I_NAN, I_BT_PUNKTATIONMARK, I_ST_NORMAL		},	// 0x003B / SEMICOLON
{ 0x003C, 0x003C, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x003C / LESS-THAN SIGN
{ 0x003D, 0x003D, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x003D / EQUALS SIGN
{ 0x003E, 0x003E, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x003E / GREATER-THAN SIGN
{ 0x003F, 0x003F, I_NAN, I_BT_PUNKTATIONMARK, I_ST_NORMAL		},	// 0x003F / QUESTION MARK
{ 0x0040, 0x0040, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x0040 / COMMERIAL AT
{ 0x0061, 0x0041, I_UPA, I_BT_A,			  I_ST_NORMAL		},	// 0x0041 / LATIN CAPITAL LETTER A
{ 0x0062, 0x0042, I_UPA, I_BT_B,			  I_ST_NORMAL		},	// 0x0042 / LATIN CAPITAL LETTER B
{ 0x0063, 0x0043, I_UPA, I_BT_C,			  I_ST_NORMAL		},	// 0x0043 / LATIN CAPITAL LETTER C
{ 0x0064, 0x0044, I_UPA, I_BT_D,			  I_ST_NORMAL		},	// 0x0044 / LATIN CAPITAL LETTER D
{ 0x0065, 0x0045, I_UPA, I_BT_E,			  I_ST_NORMAL		},	// 0x0045 / LATIN CAPITAL LETTER E
{ 0x0066, 0x0046, I_UPA, I_BT_F,			  I_ST_NORMAL		},	// 0x0046 / LATIN CAPITAL LETTER F
{ 0x0067, 0x0047, I_UPA, I_BT_G,			  I_ST_NORMAL		},	// 0x0047 / LATIN CAPITAL LETTER G
{ 0x0068, 0x0048, I_UPA, I_BT_H,			  I_ST_NORMAL		},	// 0x0048 / LATIN CAPITAL LETTER H
{ 0x0069, 0x0049, I_UPA, I_BT_I,			  I_ST_NORMAL		},	// 0x0049 / LATIN CAPITAL LETTER I
{ 0x006A, 0x004A, I_UPA, I_BT_J,			  I_ST_NORMAL		},	// 0x004A / LATIN CAPITAL LETTER J
{ 0x006B, 0x004B, I_UPA, I_BT_K,			  I_ST_NORMAL		},	// 0x004B / LATIN CAPITAL LETTER K
{ 0x006C, 0x004C, I_UPA, I_BT_L,			  I_ST_NORMAL		},	// 0x004C / LATIN CAPITAL LETTER L
{ 0x006D, 0x004D, I_UPA, I_BT_M,			  I_ST_NORMAL		},	// 0x004D / LATIN CAPITAL LETTER M
{ 0x006E, 0x004E, I_UPA, I_BT_N,			  I_ST_NORMAL		},	// 0x004E / LATIN CAPITAL LETTER N
{ 0x006F, 0x004F, I_UPA, I_BT_O,			  I_ST_NORMAL		},	// 0x004F / LATIN CAPITAL LETTER O
{ 0x0070, 0x0050, I_UPA, I_BT_P,			  I_ST_NORMAL		},	// 0x0050 / LATIN CAPITAL LETTER P
{ 0x0071, 0x0051, I_UPA, I_BT_Q,			  I_ST_NORMAL		},	// 0x0051 / LATIN CAPITAL LETTER Q
{ 0x0072, 0x0052, I_UPA, I_BT_R,			  I_ST_NORMAL		},	// 0x0052 / LATIN CAPITAL LETTER R
{ 0x0073, 0x0053, I_UPA, I_BT_S,			  I_ST_NORMAL		},	// 0x0053 / LATIN CAPITAL LETTER S
{ 0x0074, 0x0054, I_UPA, I_BT_T,			  I_ST_NORMAL		},	// 0x0054 / LATIN CAPITAL LETTER T
{ 0x0075, 0x0055, I_UPA, I_BT_U,			  I_ST_NORMAL		},	// 0x0055 / LATIN CAPITAL LETTER U
{ 0x0076, 0x0056, I_UPA, I_BT_V,			  I_ST_NORMAL		},	// 0x0056 / LATIN CAPITAL LETTER V
{ 0x0077, 0x0057, I_UPA, I_BT_W,			  I_ST_NORMAL		},	// 0x0057 / LATIN CAPITAL LETTER W
{ 0x0078, 0x0058, I_UPA, I_BT_X,			  I_ST_NORMAL		},	// 0x0058 / LATIN CAPITAL LETTER X
{ 0x0079, 0x0059, I_UPA, I_BT_Y,			  I_ST_NORMAL		},	// 0x0059 / LATIN CAPITAL LETTER Y
{ 0x007A, 0x005A, I_UPA, I_BT_Z,			  I_ST_NORMAL		},	// 0x005A / LATIN CAPITAL LETTER Z
{ 0x005B, 0x005B, I_NAN, I_BT_BRACKET,		  I_ST_NORMAL		},	// 0x005B / OPENING SQUARE BRACKET
{ 0x005C, 0x005C, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x005C / BACKSLASH
{ 0x005D, 0x005D, I_NAN, I_BT_BRACKET,		  I_ST_NORMAL		},	// 0x005D / CLOSING SQUARE BRACKET
{ 0x005E, 0x005E, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x005E / SPACING CIRCUMFLEX
{ 0x005F, 0x005F, I_NAN, I_BT_UNDERSCORE,	  I_ST_NORMAL		},	// 0x005F / SPACING UNDERSCORE
{ 0x0060, 0x0060, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x0060 / SPACING GRAVE
{ 0x0061, 0x0041, I_LOA, I_BT_A,			  I_ST_NORMAL		},	// 0x0061 / LATIN SMALL LETTER A
{ 0x0062, 0x0042, I_LOA, I_BT_B,			  I_ST_NORMAL		},	// 0x0062 / LATIN SMALL LETTER B
{ 0x0063, 0x0043, I_LOA, I_BT_C,			  I_ST_NORMAL		},	// 0x0063 / LATIN SMALL LETTER C
{ 0x0064, 0x0044, I_LOA, I_BT_D,			  I_ST_NORMAL		},	// 0x0064 / LATIN SMALL LETTER D
{ 0x0065, 0x0045, I_LOA, I_BT_E,			  I_ST_NORMAL		},	// 0x0065 / LATIN SMALL LETTER E
{ 0x0066, 0x0046, I_LOA, I_BT_F,			  I_ST_NORMAL		},	// 0x0066 / LATIN SMALL LETTER F
{ 0x0067, 0x0047, I_LOA, I_BT_G,			  I_ST_NORMAL		},	// 0x0067 / LATIN SMALL LETTER G
{ 0x0068, 0x0048, I_LOA, I_BT_H,			  I_ST_NORMAL		},	// 0x0068 / LATIN SMALL LETTER H
{ 0x0069, 0x0049, I_LOA, I_BT_I,			  I_ST_NORMAL		},	// 0x0069 / LATIN SMALL LETTER I
{ 0x006A, 0x004A, I_LOA, I_BT_J,			  I_ST_NORMAL		},	// 0x006A / LATIN SMALL LETTER J
{ 0x006B, 0x004B, I_LOA, I_BT_K,			  I_ST_NORMAL		},	// 0x006B / LATIN SMALL LETTER K
{ 0x006C, 0x004C, I_LOA, I_BT_L,			  I_ST_NORMAL		},	// 0x006C / LATIN SMALL LETTER L
{ 0x006D, 0x004D, I_LOA, I_BT_M,			  I_ST_NORMAL		},	// 0x006D / LATIN SMALL LETTER M
{ 0x006E, 0x004E, I_LOA, I_BT_N,			  I_ST_NORMAL		},	// 0x006E / LATIN SMALL LETTER N
{ 0x006F, 0x004F, I_LOA, I_BT_O,			  I_ST_NORMAL		},	// 0x006F / LATIN SMALL LETTER O
{ 0x0070, 0x0050, I_LOA, I_BT_P,			  I_ST_NORMAL		},	// 0x0070 / LATIN SMALL LETTER P
{ 0x0071, 0x0051, I_LOA, I_BT_Q,			  I_ST_NORMAL		},	// 0x0071 / LATIN SMALL LETTER Q
{ 0x0072, 0x0052, I_LOA, I_BT_R,			  I_ST_NORMAL		},	// 0x0072 / LATIN SMALL LETTER R
{ 0x0073, 0x0053, I_LOA, I_BT_S,			  I_ST_NORMAL		},	// 0x0073 / LATIN SMALL LETTER S
{ 0x0074, 0x0054, I_LOA, I_BT_T,			  I_ST_NORMAL		},	// 0x0074 / LATIN SMALL LETTER T
{ 0x0075, 0x0055, I_LOA, I_BT_U,			  I_ST_NORMAL		},	// 0x0075 / LATIN SMALL LETTER U
{ 0x0076, 0x0056, I_LOA, I_BT_V,			  I_ST_NORMAL		},	// 0x0076 / LATIN SMALL LETTER V
{ 0x0077, 0x0057, I_LOA, I_BT_W,			  I_ST_NORMAL		},	// 0x0077 / LATIN SMALL LETTER W
{ 0x0078, 0x0058, I_LOA, I_BT_X,			  I_ST_NORMAL		},	// 0x0078 / LATIN SMALL LETTER X
{ 0x0079, 0x0059, I_LOA, I_BT_Y,			  I_ST_NORMAL		},	// 0x0079 / LATIN SMALL LETTER Y
{ 0x007A, 0x005A, I_LOA, I_BT_Z,			  I_ST_NORMAL		},	// 0x007A / LATIN SMALL LETTER Z
{ 0x007B, 0x007B, I_NAN, I_BT_BRACKET,		  I_ST_NORMAL		},	// 0x007B / OPENING CURLY BRACKET
{ 0x007C, 0x007C, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x007C / VERTICAL BAR
{ 0x007D, 0x007D, I_NAN, I_BT_BRACKET,		  I_ST_NORMAL		},	// 0x007D / CLOSING CURLY BRACKET
{ 0x007E, 0x007E, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x007E / TILDE
{ 0x007F, 0x007F, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x007F / DELETE
{ 0x0080, 0x0080, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0080 / CTRL								  // LATIN 1
{ 0x0081, 0x0081, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0081 / CTRL
{ 0x0082, 0x0082, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0082 / CTRL
{ 0x0083, 0x0083, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0083 / CTRL
{ 0x0084, 0x0084, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0084 / CTRL
{ 0x0085, 0x0085, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0085 / CTRL
{ 0x0086, 0x0086, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0086 / CTRL
{ 0x0087, 0x0087, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0087 / CTRL
{ 0x0088, 0x0088, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0088 / CTRL
{ 0x0089, 0x0089, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0089 / CTRL
{ 0x008A, 0x008A, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x008A / CTRL
{ 0x008B, 0x008B, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x008B / CTRL
{ 0x008C, 0x008C, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x008C / CTRL
{ 0x008D, 0x008D, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x008D / CTRL
{ 0x008E, 0x008E, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x008E / CTRL
{ 0x008F, 0x008F, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x008F / CTRL
{ 0x0090, 0x0090, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0090 / CTRL
{ 0x0091, 0x0091, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0091 / CTRL
{ 0x0092, 0x0092, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0092 / CTRL
{ 0x0093, 0x0093, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0093 / CTRL
{ 0x0094, 0x0094, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0094 / CTRL
{ 0x0095, 0x0095, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0095 / CTRL
{ 0x0096, 0x0096, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0096 / CTRL
{ 0x0097, 0x0097, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0097 / CTRL
{ 0x0098, 0x0098, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0098 / CTRL
{ 0x0099, 0x0099, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0099 / CTRL
{ 0x009A, 0x009A, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x009A / CTRL
{ 0x009B, 0x009B, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x009B / CTRL
{ 0x009C, 0x009C, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x009C / CTRL
{ 0x009D, 0x009D, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x009D / CTRL
{ 0x009E, 0x009E, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x009E / CTRL
{ 0x009F, 0x009F, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x009F / CTRL
{ 0x00A0, 0x00A0, I_NAN, I_BT_SPACE,		  I_ST_NORMAL		},	// 0x00A0 / NON BREAKING SPACE
{ 0x00A1, 0x00A1, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00A1 / INVERTED EXCLAMATION MARK
{ 0x00A2, 0x00A2, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00A2 / CENT SIGN
{ 0x00A3, 0x00A3, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00A3 / POUND SIGN
{ 0x00A4, 0x00A4, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00A4 / CURRENCY SIGN
{ 0x00A5, 0x00A5, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00A5 / YEN SIGN
{ 0x00A6, 0x00A6, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00A6 / BROKEN VERTICAL BAR
{ 0x00A7, 0x00A7, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00A7 / SECTION SIGN
{ 0x00A8, 0x00A8, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00A8 / SPACING DIAERESIS
{ 0x00A9, 0x00A9, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00A9 / COPYRIGHT SIGN
{ 0x00AA, 0x00AA, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00AA / FEMININE ORDINAL INDICATOR
{ 0x00AB, 0x00AB, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00AB / LEFT POINTING GUILLEMET
{ 0x00AC, 0x00AC, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00AC / NOT SIGN
{ 0x00AD, 0x00AD, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x00AD / SOFT HYPHEN
{ 0x00AE, 0x00AE, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00AE / REGISTERED TRADE MARK
{ 0x00AF, 0x00AF, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00AF / SPACING MACRON
{ 0x00B0, 0x00B0, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B0 / DEGREE SIGN
{ 0x00B1, 0x00B1, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B1 / PLUS-OR-MINUS SIGN
{ 0x00B2, 0x00B2, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B2 / SUPERSCRIPT DIGIT TWO
{ 0x00B3, 0x00B3, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B3 / SUPERSCRIPT DIGIT THREE
{ 0x00B4, 0x00B4, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B4 / SPACING ACUTE
{ 0x00B5, 0x00B5, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B5 / MICRO SIGN
{ 0x00B6, 0x00B6, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B6 / PARAGRAPH SIGN
{ 0x00B7, 0x00B7, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B7 / MIDDLE DOT
{ 0x00B8, 0x00B8, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B8 / SPACING CEDILLA
{ 0x00B9, 0x00B9, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00B9 / SUPERSCRIPT DIGIT ONE
{ 0x00BA, 0x00BA, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00BA / MASCULINE ORDINAL INDICATOR
{ 0x00BB, 0x00BB, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00BB / RIGHT POINTING GUILLEMET
{ 0x00BC, 0x00BC, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00BC / FRACTION ONE QUARTER
{ 0x00BD, 0x00BD, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00BD / FRACTION ONE HALF
{ 0x00BE, 0x00BE, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00BE / FRACTION THREE QUARTER
{ 0x00BF, 0x00BF, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00BF / INVERTED QUESTION MARK
{ 0x00E0, 0x00C0, I_UPA, I_BT_A,			  I_ST_GRAVE		},	// 0x00C0 / LATIN CAPITAL LETTER A GRAVE
{ 0x00E1, 0x00C1, I_UPA, I_BT_A,			  I_ST_ACUTE		},	// 0x00C1 / LATIN CAPITAL LETTER A ACUTE
{ 0x00E2, 0x00C2, I_UPA, I_BT_A,			  I_ST_CIRCUMFLEX	},	// 0x00C2 / LATIN CAPITAL LETTER A CIRCUMFLEX
{ 0x00E3, 0x00C3, I_UPA, I_BT_A,			  I_ST_TILDE		},	// 0x00C3 / LATIN CAPITAL LETTER A TILDE
{ 0x00E4, 0x00C4, I_UPA, I_BT_A,			  I_ST_DIAERESIS	},	// 0x00C4 / LATIN CAPITAL LETTER A DIAERESIS
{ 0x00E5, 0x00C5, I_UPA, I_BT_A,			  I_ST_RING 		},	// 0x00C5 / LATIN CAPITAL LETTER A RING
{ 0x00E6, 0x00C6, I_UPA, I_BT_A,			  I_ST_LIGATURE 	},	// 0x00C6 / LATIN CAPITAL LETTER A E
{ 0x00E7, 0x00C7, I_UPA, I_BT_C,			  I_ST_CEDILLA		},	// 0x00C7 / LATIN CAPITAL LETTER C CEDILLA
{ 0x00E8, 0x00C8, I_UPA, I_BT_E,			  I_ST_GRAVE		},	// 0x00C8 / LATIN CAPITAL LETTER E GRAVE
{ 0x00E9, 0x00C9, I_UPA, I_BT_E,			  I_ST_ACUTE		},	// 0x00C9 / LATIN CAPITAL LETTER E ACUTE
{ 0x00EA, 0x00CA, I_UPA, I_BT_E,			  I_ST_CIRCUMFLEX	},	// 0x00CA / LATIN CAPITAL LETTER E CIRCUMFLEX
{ 0x00EB, 0x00CB, I_UPA, I_BT_E,			  I_ST_DIAERESIS	},	// 0x00CB / LATIN CAPITAL LETTER E DIAERESIS
{ 0x00EC, 0x00CC, I_UPA, I_BT_I,			  I_ST_GRAVE		},	// 0x00CC / LATIN CAPITAL LETTER I GRAVE
{ 0x00ED, 0x00CD, I_UPA, I_BT_I,			  I_ST_ACUTE		},	// 0x00CD / LATIN CAPITAL LETTER I ACUTE
{ 0x00EE, 0x00CE, I_UPA, I_BT_I,			  I_ST_CIRCUMFLEX	},	// 0x00CE / LATIN CAPITAL LETTER I CIRCUMFLEX
{ 0x00EF, 0x00CF, I_UPA, I_BT_I,			  I_ST_DIAERESIS	},	// 0x00CF / LATIN CAPITAL LETTER I DIAERESIS
{ 0x00F0, 0x00D0, I_UPA, I_BT_ETH,			  I_ST_NORMAL		},	// 0x00D0 / LATIN CAPITAL LETTER ETH
{ 0x00F1, 0x00D1, I_UPA, I_BT_N,			  I_ST_TILDE		},	// 0x00D1 / LATIN CAPITAL LETTER N TILDE
{ 0x00F2, 0x00D2, I_UPA, I_BT_O,			  I_ST_GRAVE		},	// 0x00D2 / LATIN CAPITAL LETTER O GRAVE
{ 0x00F3, 0x00D3, I_UPA, I_BT_O,			  I_ST_ACUTE		},	// 0x00D3 / LATIN CAPITAL LETTER O ACUTE
{ 0x00F4, 0x00D4, I_UPA, I_BT_O,			  I_ST_CIRCUMFLEX	},	// 0x00D4 / LATIN CAPITAL LETTER O CIRCUMFLEX
{ 0x00F5, 0x00D5, I_UPA, I_BT_O,			  I_ST_TILDE		},	// 0x00D5 / LATIN CAPITAL LETTER O TILDE
{ 0x00F6, 0x00D6, I_UPA, I_BT_O,			  I_ST_DIAERESIS	},	// 0x00D6 / LATIN CAPITAL LETTER O DIAERESIS
{ 0x00D7, 0x00D7, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00D7 / MULTIPLIKATION SIGN
{ 0x00F8, 0x00D8, I_UPA, I_BT_O,			  I_ST_SLASH		},	// 0x00D8 / LATIN CAPITAL LETTER O SLASH
{ 0x00F9, 0x00D9, I_UPA, I_BT_U,			  I_ST_GRAVE		},	// 0x00D9 / LATIN CAPITAL LETTER U GRAVE
{ 0x00FA, 0x00DA, I_UPA, I_BT_U,			  I_ST_ACUTE		},	// 0x00DA / LATIN CAPITAL LETTER U ACUTE
{ 0x00FB, 0x00DB, I_UPA, I_BT_U,			  I_ST_CIRCUMFLEX	},	// 0x00DB / LATIN CAPITAL LETTER U CIRCUMFLEX
{ 0x00FC, 0x00DC, I_UPA, I_BT_U,			  I_ST_DIAERESIS	},	// 0x00DC / LATIN CAPITAL LETTER U DIAERESIS
{ 0x00FD, 0x00DD, I_UPA, I_BT_Y,			  I_ST_ACUTE		},	// 0x00DD / LATIN CAPITAL LETTER Y ACUTE
{ 0x00FE, 0x00DE, I_UPA, I_BT_THORN,		  I_ST_NORMAL		},	// 0x00DE / LATIN CAPITAL LETTER THORN
{ 0x00DF, 0x00DF, I_LOA, I_BT_S,			  I_ST_LIGATURE 	},	// 0x00DF / LATIN SMALL LETTER SHARP S
{ 0x00E0, 0x00C0, I_LOA, I_BT_A,			  I_ST_GRAVE		},	// 0x00E0 / LATIN SMALL LETTER A GRAVE
{ 0x00E1, 0x00C1, I_LOA, I_BT_A,			  I_ST_ACUTE		},	// 0x00E1 / LATIN SMALL LETTER A ACUTE
{ 0x00E2, 0x00C2, I_LOA, I_BT_A,			  I_ST_CIRCUMFLEX	},	// 0x00E2 / LATIN SMALL LETTER A CIRCUMFLEX
{ 0x00E3, 0x00C3, I_LOA, I_BT_A,			  I_ST_TILDE		},	// 0x00E3 / LATIN SMALL LETTER A TILDE
{ 0x00E4, 0x00C4, I_LOA, I_BT_A,			  I_ST_DIAERESIS	},	// 0x00E4 / LATIN SMALL LETTER A DIAERESIS
{ 0x00E5, 0x00C5, I_LOA, I_BT_A,			  I_ST_RING 		},	// 0x00E5 / LATIN SMALL LETTER A RING
{ 0x00E6, 0x00C6, I_LOA, I_BT_A,			  I_ST_LIGATURE 	},	// 0x00E6 / LATIN SMALL LETTER A E
{ 0x00E7, 0x00C7, I_LOA, I_BT_C,			  I_ST_CEDILLA		},	// 0x00E7 / LATIN SMALL LETTER C CEDILLA
{ 0x00E8, 0x00C8, I_LOA, I_BT_E,			  I_ST_GRAVE		},	// 0x00E8 / LATIN SMALL LETTER E GRAVE
{ 0x00E9, 0x00C9, I_LOA, I_BT_E,			  I_ST_ACUTE		},	// 0x00E9 / LATIN SMALL LETTER E ACUTE
{ 0x00EA, 0x00CA, I_LOA, I_BT_E,			  I_ST_CIRCUMFLEX	},	// 0x00EA / LATIN SMALL LETTER E CIRCUMFLEX
{ 0x00EB, 0x00CB, I_LOA, I_BT_E,			  I_ST_DIAERESIS	},	// 0x00EB / LATIN SMALL LETTER E DIAERESIS
{ 0x00EC, 0x00CC, I_LOA, I_BT_I,			  I_ST_GRAVE		},	// 0x00EC / LATIN SMALL LETTER I GRAVE
{ 0x00ED, 0x00CD, I_LOA, I_BT_I,			  I_ST_ACUTE		},	// 0x00ED / LATIN SMALL LETTER I ACUTE
{ 0x00EE, 0x00CE, I_LOA, I_BT_I,			  I_ST_CIRCUMFLEX	},	// 0x00EE / LATIN SMALL LETTER I CIRCUMFLEX
{ 0x00EF, 0x00CF, I_LOA, I_BT_I,			  I_ST_DIAERESIS	},	// 0x00EF / LATIN SMALL LETTER I DIAERESIS
{ 0x00F0, 0x00D0, I_LOA, I_BT_ETH,			  I_ST_NORMAL		},	// 0x00F0 / LATIN SMALL LETTER ETH
{ 0x00F1, 0x00D1, I_LOA, I_BT_N,			  I_ST_TILDE		},	// 0x00F1 / LATIN SMALL LETTER N TILDE
{ 0x00F2, 0x00D2, I_LOA, I_BT_O,			  I_ST_GRAVE		},	// 0x00F2 / LATIN SMALL LETTER O GRAVE
{ 0x00F3, 0x00D3, I_LOA, I_BT_O,			  I_ST_ACUTE		},	// 0x00F3 / LATIN SMALL LETTER O ACUTE
{ 0x00F4, 0x00D4, I_LOA, I_BT_O,			  I_ST_CIRCUMFLEX	},	// 0x00F4 / LATIN SMALL LETTER O CIRCUMFLEX
{ 0x00F5, 0x00D5, I_LOA, I_BT_O,			  I_ST_TILDE		},	// 0x00F5 / LATIN SMALL LETTER O TILDE
{ 0x00F6, 0x00D6, I_LOA, I_BT_O,			  I_ST_DIAERESIS	},	// 0x00F6 / LATIN SMALL LETTER O DIAERESIS
{ 0x00F7, 0x00F7, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		},	// 0x00F7 / DIVISION SIGN
{ 0x00F8, 0x00D8, I_LOA, I_BT_O,			  I_ST_SLASH		},	// 0x00F8 / LATIN SMALL LETTER O SLASH
{ 0x00F9, 0x00D9, I_LOA, I_BT_U,			  I_ST_GRAVE		},	// 0x00F9 / LATIN SMALL LETTER U GRAVE
{ 0x00FA, 0x00DA, I_LOA, I_BT_U,			  I_ST_ACUTE		},	// 0x00FA / LATIN SMALL LETTER U ACUTE
{ 0x00FB, 0x00DB, I_LOA, I_BT_U,			  I_ST_CIRCUMFLEX	},	// 0x00FB / LATIN SMALL LETTER U CIRCUMFLEX
{ 0x00FC, 0x00DC, I_LOA, I_BT_U,			  I_ST_DIAERESIS	},	// 0x00FC / LATIN SMALL LETTER U DIAERESIS
{ 0x00FD, 0x00DD, I_LOA, I_BT_Y,			  I_ST_ACUTE		},	// 0x00FD / LATIN SMALL LETTER Y ACUTE
{ 0x00FE, 0x00DE, I_LOA, I_BT_THORN,		  I_ST_NORMAL		},	// 0x00FE / LATIN SMALL LETTER THORN
{ 0x00FF, 0x0178, I_LOA, I_BT_Y,			  I_ST_DIAERESIS	},	// 0x00FF / LATIN SMALL LETTER Y DIAERESIS
{ 0x0101, 0x0100, I_UPA, I_BT_A,			  I_ST_MACRON		},	// 0x0100 / LATIN CAPITAL LETTER A MACRON		  // EUROPEAN LATIN
{ 0x0101, 0x0100, I_LOA, I_BT_A,			  I_ST_MACRON		},	// 0x0101 / LATIN SMALL LETTER A MACRON
{ 0x0103, 0x0102, I_UPA, I_BT_A,			  I_ST_BREVE		},	// 0x0102 / LATIN CAPITAL LETTER A BREVE
{ 0x0103, 0x0102, I_LOA, I_BT_A,			  I_ST_BREVE		},	// 0x0103 / LATIN SMALL LETTER A BREVE
{ 0x0105, 0x0104, I_UPA, I_BT_A,			  I_ST_OGONEK		},	// 0x0104 / LATIN CAPITAL LETTER A OGONEK
{ 0x0105, 0x0104, I_LOA, I_BT_A,			  I_ST_OGONEK		},	// 0x0105 / LATIN SMALL LETTER A OGONEK
{ 0x0107, 0x0106, I_UPA, I_BT_C,			  I_ST_ACUTE		},	// 0x0106 / LATIN CAPITAL LETTER C ACUTE
{ 0x0107, 0x0106, I_LOA, I_BT_C,			  I_ST_ACUTE		},	// 0x0107 / LATIN SMALL LETTER C ACUTE
{ 0x0109, 0x0108, I_UPA, I_BT_C,			  I_ST_CIRCUMFLEX	},	// 0x0108 / LATIN CAPITEL LETTER C CIRCUMFLEX
{ 0x0109, 0x0108, I_LOA, I_BT_C,			  I_ST_CIRCUMFLEX	},	// 0x0109 / LATIN SMALL LETTER C CIRCUMFLEX
{ 0x010B, 0x010A, I_UPA, I_BT_C,			  I_ST_DOT			},	// 0x010A / LATIN CAPITEL LETTER C DOT
{ 0x010B, 0x010A, I_LOA, I_BT_C,			  I_ST_DOT			},	// 0x010B / LATIN SMALL LETTER C DOT
{ 0x010D, 0x010C, I_UPA, I_BT_C,			  I_ST_HACEK		},	// 0x010C / LATIN CAPITEL LETTER C HACEK
{ 0x010D, 0x010C, I_LOA, I_BT_C,			  I_ST_HACEK		},	// 0x010D / LATIN SMALL LETTER C HACEK
{ 0x010F, 0x010E, I_UPA, I_BT_D,			  I_ST_HACEK		},	// 0x010E / LATIN CAPITEL LETTER D HACEK
{ 0x010F, 0x010E, I_LOA, I_BT_D,			  I_ST_HACEK		},	// 0x010F / LATIN SMALL LETTER D HACEK
{ 0x0111, 0x0110, I_UPA, I_BT_D,			  I_ST_BAR			},	// 0x0110 / LATIN CAPITEL LETTER D BAR
{ 0x0111, 0x0110, I_LOA, I_BT_D,			  I_ST_BAR			},	// 0x0111 / LATIN SMALL LETTER D BAR
{ 0x0113, 0x0112, I_UPA, I_BT_E,			  I_ST_MACRON		},	// 0x0112 / LATIN CAPITAL LETTER E MACRON
{ 0x0113, 0x0112, I_LOA, I_BT_E,			  I_ST_MACRON		},	// 0x0113 / LATIN SMALL LETTER E MACRON
{ 0x0115, 0x0114, I_UPA, I_BT_E,			  I_ST_BREVE		},	// 0x0114 / LATIN CAPITEL LETTER E BREVE
{ 0x0115, 0x0114, I_LOA, I_BT_E,			  I_ST_BREVE		},	// 0x0115 / LATIN SMALL LETTER E BREVE
{ 0x0117, 0x0116, I_UPA, I_BT_E,			  I_ST_DOT			},	// 0x0116 / LATIN CAPITEL LETTER E DOT
{ 0x0117, 0x0116, I_LOA, I_BT_E,			  I_ST_DOT			},	// 0x0117 / LATIN SMALL LETTER E DOT
{ 0x0119, 0x0118, I_UPA, I_BT_E,			  I_ST_OGONEK		},	// 0x0118 / LATIN CAPITEL LETTER E OGONEK
{ 0x0119, 0x0118, I_LOA, I_BT_E,			  I_ST_OGONEK		},	// 0x0119 / LATIN SMALL LETTER E OGONEK
{ 0x011B, 0x011A, I_UPA, I_BT_E,			  I_ST_HACEK		},	// 0x011A / LATIN CAPITEL LETTER E HACEK
{ 0x011B, 0x011A, I_LOA, I_BT_E,			  I_ST_HACEK		},	// 0x011B / LATIN SMALL LETTER E HACEK
{ 0x011D, 0x011C, I_UPA, I_BT_G,			  I_ST_CIRCUMFLEX	},	// 0x011C / LATIN CAPITEL LETTER G CIRCUMFLEX
{ 0x011D, 0x011C, I_LOA, I_BT_G,			  I_ST_CIRCUMFLEX	},	// 0x011D / LATIN SMALL LETTER G CIRCUMFLEX
{ 0x011F, 0x011E, I_UPA, I_BT_G,			  I_ST_BREVE		},	// 0x011E / LATIN CAPITEL LETTER G BREVE
{ 0x011F, 0x011E, I_LOA, I_BT_G,			  I_ST_BREVE		},	// 0x011F / LATIN SMALL LETTER G BREVE
{ 0x0121, 0x0120, I_UPA, I_BT_G,			  I_ST_DOT			},	// 0x0120 / LATIN CAPITEL LETTER G DOT
{ 0x0121, 0x0120, I_LOA, I_BT_G,			  I_ST_DOT			},	// 0x0121 / LATIN SMALL LETTER G DOT
{ 0x0123, 0x0122, I_UPA, I_BT_G,			  I_ST_CEDILLA		},	// 0x0122 / LATIN CAPITEL LETTER G CEDILLA
{ 0x0123, 0x0122, I_LOA, I_BT_G,			  I_ST_CEDILLA		},	// 0x0123 / LATIN SMALL LETTER G CEDILLA
{ 0x0125, 0x0124, I_UPA, I_BT_H,			  I_ST_CIRCUMFLEX	},	// 0x0124 / LATIN CAPITEL LETTER H CIRCUMFLEX
{ 0x0125, 0x0124, I_LOA, I_BT_H,			  I_ST_CIRCUMFLEX	},	// 0x0125 / LATIN SMALL LETTER H CIRCUMFLEX
{ 0x0127, 0x0126, I_UPA, I_BT_H,			  I_ST_BAR			},	// 0x0126 / LATIN CAPITEL LETTER H BAR
{ 0x0127, 0x0126, I_LOA, I_BT_H,			  I_ST_BAR			},	// 0x0127 / LATIN SMALL LETTER H BAR
{ 0x0129, 0x0128, I_UPA, I_BT_I,			  I_ST_TILDE		},	// 0x0128 / LATIN CAPITEL LETTER I TILDE
{ 0x0129, 0x0128, I_LOA, I_BT_I,			  I_ST_TILDE		},	// 0x0129 / LATIN SMALL LETTER I TILDE
{ 0x012B, 0x012A, I_UPA, I_BT_I,			  I_ST_MACRON		},	// 0x012A / LATIN CAPITEL LETTER I MACRON
{ 0x012B, 0x012A, I_LOA, I_BT_I,			  I_ST_MACRON		},	// 0x012B / LATIN SMALL LETTER I MACRON
{ 0x012D, 0x012C, I_UPA, I_BT_I,			  I_ST_BREVE		},	// 0x012C / LATIN CAPITEL LETTER I BREVE
{ 0x012D, 0x012C, I_LOA, I_BT_I,			  I_ST_BREVE		},	// 0x012D / LATIN SMALL LETTER I BREVE
{ 0x012F, 0x012E, I_UPA, I_BT_I,			  I_ST_OGONEK		},	// 0x012E / LATIN CAPITEL LETTER I OGONEK
{ 0x012F, 0x012E, I_LOA, I_BT_I,			  I_ST_OGONEK		},	// 0x012F / LATIN SMALL LETTER I OGONEK
{ 0x0130, 0x0069, I_UPA, I_BT_I,			  I_ST_DOT			},	// 0x0130 / LATIN CAPITEL LETTER I DOT
{ 0x0131, 0x0049, I_LOA, I_BT_I,			  I_ST_DOTLESS		},	// 0x0131 / LATIN SMALL LETTER DOTLESS I
{ 0x0133, 0x0132, I_UPA, I_BT_I,			  I_ST_LIGATURE 	},	// 0x0132 / LATIN CAPITAL LETTER IJ
{ 0x0133, 0x0132, I_LOA, I_BT_I,			  I_ST_LIGATURE 	},	// 0x0133 / LATIN SMALL LETTER IJ
{ 0x0135, 0x0134, I_UPA, I_BT_J,			  I_ST_CIRCUMFLEX	},	// 0x0134 / LATIN CAPITEL LETTER J CIRCUMFLEX
{ 0x0135, 0x0134, I_LOA, I_BT_J,			  I_ST_CIRCUMFLEX	},	// 0x0135 / LATIN SMALL LETTER J CIRCUMFLEX
{ 0x0137, 0x0136, I_UPA, I_BT_K,			  I_ST_CEDILLA		},	// 0x0136 / LATIN CAPITEL LETTER K CEDILLA
{ 0x0137, 0x0136, I_LOA, I_BT_K,			  I_ST_CEDILLA		},	// 0x0137 / LATIN SMALL LETTER K CEDILLA
{ 0x0138, 0x0138, I_LOA, I_BT_KRA,			  I_ST_NORMAL		},	// 0x0138 / LATIN SMALL LETTER KRA
{ 0x013A, 0x0139, I_UPA, I_BT_L,			  I_ST_ACUTE		},	// 0x0139 / LATIN CAPTIEL LETTER L ACUTE
{ 0x013A, 0x0139, I_LOA, I_BT_L,			  I_ST_ACUTE		},	// 0x013A / LATIN SMALL LETTER L ACUTE
{ 0x013C, 0x013B, I_UPA, I_BT_L,			  I_ST_CEDILLA		},	// 0x013B / LATIN CAPITEL LETTER L CEDILLA
{ 0x013C, 0x013B, I_LOA, I_BT_L,			  I_ST_CEDILLA		},	// 0x013C / LATIN SMALL LETTER L CEDILLA
{ 0x013E, 0x013D, I_UPA, I_BT_L,			  I_ST_HACEK		},	// 0x013D / LATIN CAPITEL LETTER L HACEK
{ 0x013E, 0x013D, I_LOA, I_BT_L,			  I_ST_HACEK		},	// 0x013E / LATIN SMALL LETTER L HACEK
{ 0x0140, 0x013F, I_UPA, I_BT_L,			  I_ST_MIDDLEDOT	},	// 0x013F / LATIN CAPITEL LETTER L WITH MIDDLE DOT
{ 0x0140, 0x013F, I_LOA, I_BT_L,			  I_ST_MIDDLEDOT	},	// 0x0140 / LATIN SMALL LETTER L WITH MIDDLE DOT
{ 0x0142, 0x0141, I_UPA, I_BT_L,			  I_ST_SLASH		},	// 0x0141 / LATIN CAPITEL LETTER L SLASH
{ 0x0142, 0x0141, I_LOA, I_BT_L,			  I_ST_SLASH		},	// 0x0142 / LATIN SMALL LETTER L SLASH
{ 0x0144, 0x0143, I_UPA, I_BT_N,			  I_ST_ACUTE		},	// 0x0143 / LATIN CAPITEL LETTER N ACUTE
{ 0x0144, 0x0143, I_LOA, I_BT_N,			  I_ST_ACUTE		},	// 0x0144 / LATIN SMALL LETTER N ACUTE
{ 0x0146, 0x0145, I_UPA, I_BT_N,			  I_ST_CEDILLA		},	// 0x0145 / LATIN CAPITEL LETTER N CEDILLA
{ 0x0146, 0x0145, I_LOA, I_BT_N,			  I_ST_CEDILLA		},	// 0x0146 / LATIN SMALL LETTER N CEDILLA
{ 0x0148, 0x0147, I_UPA, I_BT_N,			  I_ST_HACEK		},	// 0x0147 / LATIN CAPITEL LETTER N HACEK
{ 0x0148, 0x0147, I_LOA, I_BT_N,			  I_ST_HACEK		},	// 0x0148 / LATIN SMALL LETTER N HACEK
{ 0x0149, 0x0149, I_LOA, I_BT_N,			  I_ST_APOSTROPHE	},	// 0x0149 / LATIN SMALL LETTER APOSTROPHE N
{ 0x014B, 0x014A, I_UPA, I_BT_ENG,			  I_ST_NORMAL		},	// 0x014A / LATIN CAPITEL LETTER ENG
{ 0x014B, 0x014A, I_LOA, I_BT_ENG,			  I_ST_NORMAL		},	// 0x014B / LATIN SMALL LETTER ENG
{ 0x014D, 0x014C, I_UPA, I_BT_O,			  I_ST_MACRON		},	// 0x014C / LATIN CAPITEL LETTER O MACRON
{ 0x014D, 0x014C, I_LOA, I_BT_O,			  I_ST_MACRON		},	// 0x014D / LATIN SMALL LETTER O MACRON
{ 0x014F, 0x014E, I_UPA, I_BT_O,			  I_ST_BREVE		},	// 0x014E / LATIN CAPITEL LETTER O BREVE
{ 0x014F, 0x014E, I_LOA, I_BT_O,			  I_ST_BREVE		},	// 0x014F / LATIN SMALL LETTER O BREVE
{ 0x0151, 0x0150, I_UPA, I_BT_O,			  I_ST_DOUBLEACUTE	},	// 0x0150 / LATIN CAPITEL LETTER O DOUBLE ACUTE
{ 0x0151, 0x0150, I_LOA, I_BT_O,			  I_ST_DOUBLEACUTE	},	// 0x0151 / LATIN SMALL LETTER O DOUBLE ACUTE
{ 0x0153, 0x0152, I_UPA, I_BT_O,			  I_ST_LIGATURE 	},	// 0x0152 / LATIN CAPITEL LETTER O E
{ 0x0153, 0x0152, I_LOA, I_BT_O,			  I_ST_LIGATURE 	},	// 0x0153 / LATIN SMALL LETTER O E
{ 0x0155, 0x0154, I_UPA, I_BT_R,			  I_ST_ACUTE		},	// 0x0154 / LATIN CAPITEL LETTER R ACUTE
{ 0x0155, 0x0154, I_LOA, I_BT_R,			  I_ST_ACUTE		},	// 0x0155 / LATIN SMALL LETTER R ACUTE
{ 0x0157, 0x0156, I_UPA, I_BT_R,			  I_ST_CEDILLA		},	// 0x0156 / LATIN CAPITEL LETTER R CEDILLA
{ 0x0157, 0x0156, I_LOA, I_BT_R,			  I_ST_CEDILLA		},	// 0x0157 / LATIN SMALL LETTER R CEDILLA
{ 0x0159, 0x0158, I_UPA, I_BT_R,			  I_ST_HACEK		},	// 0x0158 / LATIN CAPITEL LETTER R HACEK
{ 0x0159, 0x0158, I_LOA, I_BT_R,			  I_ST_HACEK		},	// 0x0159 / LATIN SMALL LETTER R HACEK
{ 0x015B, 0x015A, I_UPA, I_BT_S,			  I_ST_ACUTE		},	// 0x015A / LATIN CAPITEL LETTER S ACUTE
{ 0x015B, 0x015A, I_LOA, I_BT_S,			  I_ST_ACUTE		},	// 0x015B / LATIN SMALL LETTER S ACUTE
{ 0x015D, 0x015C, I_UPA, I_BT_S,			  I_ST_CIRCUMFLEX	},	// 0x015C / LATIN CAPITEL LETTER S CIRCUMFLEX
{ 0x015D, 0x015C, I_LOA, I_BT_S,			  I_ST_CIRCUMFLEX	},	// 0x015D / LATIN SMALL LETTER S CIRCUMFLEX
{ 0x015F, 0x015E, I_UPA, I_BT_S,			  I_ST_CEDILLA		},	// 0x015E / LATIN CAPITEL LETTER S CEDILLA
{ 0x015F, 0x015E, I_LOA, I_BT_S,			  I_ST_CEDILLA		},	// 0x015F / LATIN SMALL LETTER S CEDILLA
{ 0x0161, 0x0160, I_UPA, I_BT_S,			  I_ST_HACEK		},	// 0x0160 / LATIN CAPITEL LETTER S HACEK
{ 0x0161, 0x0160, I_LOA, I_BT_S,			  I_ST_HACEK		},	// 0x0161 / LATIN SMALL LETTER S HACEK
{ 0x0163, 0x0162, I_UPA, I_BT_T,			  I_ST_CEDILLA		},	// 0x0162 / LATIN CAPITEL LETTER T CEDILLA
{ 0x0163, 0x0162, I_LOA, I_BT_T,			  I_ST_CEDILLA		},	// 0x0163 / LATIN SMALL LETTER T CEDILLA
{ 0x0165, 0x0164, I_UPA, I_BT_T,			  I_ST_HACEK		},	// 0x0164 / LATIN CAPITEL LETTER T HACEK
{ 0x0165, 0x0164, I_LOA, I_BT_T,			  I_ST_HACEK		},	// 0x0165 / LATIN SMALL LETTER T HACEK
{ 0x0167, 0x0166, I_UPA, I_BT_T,			  I_ST_BAR			},	// 0x0166 / LATIN CAPITEL LETTER T BAR
{ 0x0167, 0x0166, I_LOA, I_BT_T,			  I_ST_BAR			},	// 0x0167 / LATIN SMALL LETTER T BAR
{ 0x0169, 0x0168, I_UPA, I_BT_U,			  I_ST_TILDE		},	// 0x0168 / LATIN CAPITEL LETTER U TILDE
{ 0x0169, 0x0168, I_LOA, I_BT_U,			  I_ST_TILDE		},	// 0x0169 / LATIN SMALL LETTER U TILDE
{ 0x016B, 0x016A, I_UPA, I_BT_U,			  I_ST_MACRON		},	// 0x016A / LATIN CAPITEL LETTER U MACRON
{ 0x016B, 0x016A, I_LOA, I_BT_U,			  I_ST_MACRON		},	// 0x016B / LATIN SMALL LETTER U MACRON
{ 0x016D, 0x016C, I_UPA, I_BT_U,			  I_ST_BREVE		},	// 0x016C / LATIN CAPITEL LETTER U BREVE
{ 0x016D, 0x016C, I_LOA, I_BT_U,			  I_ST_BREVE		},	// 0x016D / LATIN SMALL LETTER U BREVE
{ 0x016F, 0x016E, I_UPA, I_BT_U,			  I_ST_RING 		},	// 0x016E / LATIN CAPITEL LETTER U RING
{ 0x016F, 0x016E, I_LOA, I_BT_U,			  I_ST_RING 		},	// 0x016F / LATIN SMALL LETTER U RING
{ 0x0171, 0x0170, I_UPA, I_BT_U,			  I_ST_DOUBLEACUTE	},	// 0x0170 / LATIN CAPITEL LETTER U DOUBLE ACUTE
{ 0x0171, 0x0170, I_LOA, I_BT_U,			  I_ST_DOUBLEACUTE	},	// 0x0171 / LATIN SMALL LETTER U DOUBLE ACUTE
{ 0x0173, 0x0172, I_UPA, I_BT_U,			  I_ST_OGONEK		},	// 0x0172 / LATIN CAPITEL LETTER U OGONEK
{ 0x0173, 0x0172, I_LOA, I_BT_U,			  I_ST_OGONEK		},	// 0x0173 / LATIN SMALL LETTER U OGONEK
{ 0x0175, 0x0174, I_UPA, I_BT_W,			  I_ST_CIRCUMFLEX	},	// 0x0174 / LATIN CAPITEL LETTER W CIRCUMFLEX
{ 0x0175, 0x0174, I_LOA, I_BT_W,			  I_ST_CIRCUMFLEX	},	// 0x0175 / LATIN SMALL LETTER W CIRCUMFLEX
{ 0x0177, 0x0176, I_UPA, I_BT_Y,			  I_ST_CIRCUMFLEX	},	// 0x0176 / LATIN CAPITEL LETTER Y CIRCUMFLEX
{ 0x0177, 0x0176, I_LOA, I_BT_Y,			  I_ST_CIRCUMFLEX	},	// 0x0177 / LATIN SMALL LETTER Y CIRCUMFLEX
{ 0x00FF, 0x0178, I_UPA, I_BT_Y,			  I_ST_DIAERESIS	},	// 0x0178 / LATIN CAPITEL LETTER Y DIAERESIS
{ 0x017A, 0x0179, I_UPA, I_BT_Z,			  I_ST_ACUTE		},	// 0x0179 / LATIN CAPITEL LETTER Z ACUTE
{ 0x017A, 0x0179, I_LOA, I_BT_Z,			  I_ST_ACUTE		},	// 0x017A / LATIN SMALL LETTER Z ACUTE
{ 0x017C, 0x017B, I_UPA, I_BT_Z,			  I_ST_DOT			},	// 0x017B / LATIN CAPITEL LETTER Z DOT
{ 0x017C, 0x017B, I_LOA, I_BT_Z,			  I_ST_DOT			},	// 0x017C / LATIN SMALL LETTER Z DOT
{ 0x017E, 0x017D, I_UPA, I_BT_Z,			  I_ST_HACEK		},	// 0x017D / LATIN CAPITEL LETTER Z HACEK
{ 0x017E, 0x017D, I_LOA, I_BT_Z,			  I_ST_HACEK		},	// 0x017E / LATIN SMALL LETTER Z HACEK
{ 0x017F, 0x017F, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x017F /
{ 0x0180, 0x0180, I_NAN, I_BT_SYMBOL,		  I_ST_NORMAL		}	// 0x0180 / Only for I_SYM_WCHAR and must be at the end of the table
};

#define I_GREEK_START		(0x0386)
#define I_GREEK_END 		(0x03CE)

static IntnCharInfo aImplGreekCharInfoTab[(I_GREEK_END-I_GREEK_START)+1] =
{
{ 0x03AC, 0x0386, I_UPA, I_BT_GREEK_ALPHA,	  I_ST_TONE 		},	// 0x0386 / GREEK CAPITAL LETTER ALPHA TONOS
{ 0x0387, 0x0387, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x0387 /
{ 0x03AD, 0x0388, I_UPA, I_BT_GREEK_EPSILON,  I_ST_TONE 		},	// 0x0388 / GREEK CAPITAL LETTER EPSILON TONOS
{ 0x03AE, 0x0389, I_UPA, I_BT_GREEK_ETA,	  I_ST_TONE 		},	// 0x0389 / GREEK CAPITAL LETTER ETA TONOS
{ 0x03AF, 0x038A, I_UPA, I_BT_GREEK_IOTA,	  I_ST_TONE 		},	// 0x038A / GREEK CAPITAL LETTER IOTA TONOS
{ 0x038B, 0x038B, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x038B /
{ 0x03CC, 0x038C, I_UPA, I_BT_GREEK_OMICRON,  I_ST_TONE 		},	// 0x038C / GREEK CAPITAL LETTER OMICRON TONOS
{ 0x038D, 0x038D, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x038D /
{ 0x03CD, 0x038E, I_UPA, I_BT_GREEK_UPSILON,  I_ST_TONE 		},	// 0x038E / GREEK CAPITAL LETTER UPSILON TONOS
{ 0x03CE, 0x038F, I_UPA, I_BT_GREEK_OMEGA,	  I_ST_TONE 		},	// 0x038F / GREEK CAPITAL LETTER OMEGA TONOS
{ 0x0390, 0x0390, I_LOA, I_BT_GREEK_IOTA,	  I_ST_DIAERESIS	},	// 0x0390 / GREEK SMALL LETTER IOTA DIARESIS TONOS
{ 0x03B1, 0x0391, I_UPA, I_BT_GREEK_ALPHA,	  I_ST_NORMAL		},	// 0x0391 / GREEK CAPITAL LETTER ALPHA
{ 0x03B2, 0x0392, I_UPA, I_BT_GREEK_BETA,	  I_ST_NORMAL		},	// 0x0392 / GREEK CAPITAL LETTER BETA
{ 0x03B3, 0x0393, I_UPA, I_BT_GREEK_GAMMA,	  I_ST_NORMAL		},	// 0x0393 / GREEK CAPITAL LETTER GAMMA
{ 0x03B4, 0x0394, I_UPA, I_BT_GREEK_DELTA,	  I_ST_NORMAL		},	// 0x0394 / GREEK CAPITAL LETTER DELTA
{ 0x03B5, 0x0395, I_UPA, I_BT_GREEK_EPSILON,  I_ST_NORMAL		},	// 0x0395 / GREEK CAPITAL LETTER EPSILON
{ 0x03B6, 0x0396, I_UPA, I_BT_GREEK_ZETA,	  I_ST_NORMAL		},	// 0x0396 / GREEK CAPITAL LETTER ZETA
{ 0x03B7, 0x0397, I_UPA, I_BT_GREEK_ETA,	  I_ST_NORMAL		},	// 0x0397 / GREEK CAPITAL LETTER ETA
{ 0x03B8, 0x0398, I_UPA, I_BT_GREEK_THETA,	  I_ST_NORMAL		},	// 0x0398 / GREEK CAPITAL LETTER THETA
{ 0x03B9, 0x0399, I_UPA, I_BT_GREEK_IOTA,	  I_ST_NORMAL		},	// 0x0399 / GREEK CAPITAL LETTER IOTA
{ 0x03BA, 0x039A, I_UPA, I_BT_GREEK_KAPPA,	  I_ST_NORMAL		},	// 0x039A / GREEK CAPITAL LETTER KAPPA
{ 0x03BB, 0x039B, I_UPA, I_BT_GREEK_LAMBDA,   I_ST_NORMAL		},	// 0x039B / GREEK CAPITAL LETTER LAMBDA
{ 0x03BC, 0x039C, I_UPA, I_BT_GREEK_MU, 	  I_ST_NORMAL		},	// 0x039C / GREEK CAPITAL LETTER MU
{ 0x03BD, 0x039D, I_UPA, I_BT_GREEK_NU, 	  I_ST_NORMAL		},	// 0x039D / GREEK CAPITAL LETTER NU
{ 0x03BE, 0x039E, I_UPA, I_BT_GREEK_XI, 	  I_ST_NORMAL		},	// 0x039E / GREEK CAPITAL LETTER XI
{ 0x03BF, 0x039F, I_UPA, I_BT_GREEK_OMICRON,  I_ST_NORMAL		},	// 0x039F / GREEK CAPITAL LETTER OMICRON
{ 0x03C0, 0x03A0, I_UPA, I_BT_GREEK_PI, 	  I_ST_NORMAL		},	// 0x03A0 / GREEK CAPITAL LETTER PI
{ 0x03C1, 0x03A1, I_UPA, I_BT_GREEK_RHO,	  I_ST_NORMAL		},	// 0x03A1 / GREEK CAPITAL LETTER RHO
{ 0x03A2, 0x03A2, I_NAN, I_BT_CONTROL,		  I_ST_NORMAL		},	// 0x03A2 /
{ 0x03C3, 0x03A3, I_UPA, I_BT_GREEK_SIGMA,	  I_ST_NORMAL		},	// 0x03A3 / GREEK CAPITAL LETTER SIGMA
{ 0x03C4, 0x03A4, I_UPA, I_BT_GREEK_TAU,	  I_ST_NORMAL		},	// 0x03A4 / GREEK CAPITAL LETTER TAU
{ 0x03C5, 0x03A5, I_UPA, I_BT_GREEK_UPSILON,  I_ST_NORMAL		},	// 0x03A5 / GREEK CAPITAL LETTER UPSILON
{ 0x03C6, 0x03A6, I_UPA, I_BT_GREEK_PHI,	  I_ST_NORMAL		},	// 0x03A6 / GREEK CAPITAL LETTER PHI
{ 0x03C7, 0x03A7, I_UPA, I_BT_GREEK_CHI,	  I_ST_NORMAL		},	// 0x03A7 / GREEK CAPITAL LETTER CHI
{ 0x03C8, 0x03A8, I_UPA, I_BT_GREEK_PSI,	  I_ST_NORMAL		},	// 0x03A8 / GREEK CAPITAL LETTER PSI
{ 0x03C9, 0x03A9, I_UPA, I_BT_GREEK_OMEGA,	  I_ST_NORMAL		},	// 0x03A9 / GREEK CAPITAL LETTER OMEGA
{ 0x03CA, 0x03AA, I_UPA, I_BT_GREEK_IOTA,	  I_ST_DIAERESIS	},	// 0x03AA / GREEK CAPITAL LETTER IOTA DIARESIS
{ 0x03CB, 0x03AB, I_UPA, I_BT_GREEK_UPSILON,  I_ST_DIAERESIS	},	// 0x03AB / GREEK CAPITAL LETTER UPSILON DIARESIS
{ 0x03AC, 0x0386, I_LOA, I_BT_GREEK_ALPHA,	  I_ST_TONE 		},	// 0x03AC / GREEK SMALL LETTER ALPHA TONOS
{ 0x03AD, 0x0388, I_LOA, I_BT_GREEK_EPSILON,  I_ST_TONE 		},	// 0x03AD / GREEK SMALL LETTER EPSILON TONOS
{ 0x03AE, 0x0389, I_LOA, I_BT_GREEK_ETA,	  I_ST_TONE 		},	// 0x03AE / GREEK SMALL LETTER ETA TONOS
{ 0x03AF, 0x038A, I_LOA, I_BT_GREEK_IOTA,	  I_ST_TONE 		},	// 0x03AF / GREEK SMALL LETTER IOTA TONOS
{ 0x03B0, 0x03B0, I_LOA, I_BT_GREEK_UPSILON,  I_ST_DIAERESIS	},	// 0x03B0 / GREEK SMALL LETTER UPSILON DIARESIS TONOS
{ 0x03B1, 0x0391, I_LOA, I_BT_GREEK_ALPHA,	  I_ST_NORMAL		},	// 0x03B1 / GREEK SMALL LETTER ALPHA
{ 0x03B2, 0x0392, I_LOA, I_BT_GREEK_BETA,	  I_ST_NORMAL		},	// 0x03B2 / GREEK SMALL LETTER BETA
{ 0x03B3, 0x0393, I_LOA, I_BT_GREEK_GAMMA,	  I_ST_NORMAL		},	// 0x03B3 / GREEK SMALL LETTER GAMMA
{ 0x03B4, 0x0394, I_LOA, I_BT_GREEK_DELTA,	  I_ST_NORMAL		},	// 0x03B4 / GREEK SMALL LETTER DELTA
{ 0x03B5, 0x0395, I_LOA, I_BT_GREEK_EPSILON,  I_ST_NORMAL		},	// 0x03B5 / GREEK SMALL LETTER EPSILON
{ 0x03B6, 0x0396, I_LOA, I_BT_GREEK_ZETA,	  I_ST_NORMAL		},	// 0x03B6 / GREEK SMALL LETTER ZETA
{ 0x03B7, 0x0397, I_LOA, I_BT_GREEK_ETA,	  I_ST_NORMAL		},	// 0x03B7 / GREEK SMALL LETTER ETA
{ 0x03B8, 0x0398, I_LOA, I_BT_GREEK_THETA,	  I_ST_NORMAL		},	// 0x03B8 / GREEK SMALL LETTER THETA
{ 0x03B9, 0x0399, I_LOA, I_BT_GREEK_IOTA,	  I_ST_NORMAL		},	// 0x03B9 / GREEK SMALL LETTER IOTA
{ 0x03BA, 0x039A, I_LOA, I_BT_GREEK_KAPPA,	  I_ST_NORMAL		},	// 0x03BA / GREEK SMALL LETTER KAPPA
{ 0x03BB, 0x039B, I_LOA, I_BT_GREEK_LAMBDA,   I_ST_NORMAL		},	// 0x03BB / GREEK SMALL LETTER LAMBDA
{ 0x03BC, 0x039C, I_LOA, I_BT_GREEK_MU, 	  I_ST_NORMAL		},	// 0x03BC / GREEK SMALL LETTER MU
{ 0x03BD, 0x039D, I_LOA, I_BT_GREEK_NU, 	  I_ST_NORMAL		},	// 0x03BD / GREEK SMALL LETTER NU
{ 0x03BE, 0x039E, I_LOA, I_BT_GREEK_XI, 	  I_ST_NORMAL		},	// 0x03BE / GREEK SMALL LETTER XI
{ 0x03BF, 0x039F, I_LOA, I_BT_GREEK_OMICRON,  I_ST_NORMAL		},	// 0x03BF / GREEK SMALL LETTER OMICRON
{ 0x03C0, 0x03A0, I_LOA, I_BT_GREEK_PI, 	  I_ST_NORMAL		},	// 0x03C0 / GREEK SMALL LETTER PI
{ 0x03C1, 0x03A1, I_LOA, I_BT_GREEK_RHO,	  I_ST_NORMAL		},	// 0x03C1 / GREEK SMALL LETTER RHO
{ 0x03C2, 0x03A3, I_LOA, I_BT_GREEK_SIGMA,	  I_ST_NORMAL		},	// 0x03C2 / GREEK SMALL LETTER FINAL SIGMA
{ 0x03C3, 0x03A3, I_LOA, I_BT_GREEK_SIGMA,	  I_ST_NORMAL		},	// 0x03C3 / GREEK SMALL LETTER SIGMA
{ 0x03C4, 0x03A4, I_LOA, I_BT_GREEK_TAU,	  I_ST_NORMAL		},	// 0x03C4 / GREEK SMALL LETTER TAU
{ 0x03C5, 0x03A5, I_LOA, I_BT_GREEK_UPSILON,  I_ST_NORMAL		},	// 0x03C5 / GREEK SMALL LETTER UPSILON
{ 0x03C6, 0x03A6, I_LOA, I_BT_GREEK_PHI,	  I_ST_NORMAL		},	// 0x03C6 / GREEK SMALL LETTER PHI
{ 0x03C7, 0x03A7, I_LOA, I_BT_GREEK_CHI,	  I_ST_NORMAL		},	// 0x03C7 / GREEK SMALL LETTER CHI
{ 0x03C8, 0x03A8, I_LOA, I_BT_GREEK_PSI,	  I_ST_NORMAL		},	// 0x03C8 / GREEK SMALL LETTER PSI
{ 0x03C9, 0x03A9, I_LOA, I_BT_GREEK_OMEGA,	  I_ST_NORMAL		},	// 0x03C9 / GREEK SMALL LETTER OMEGA
{ 0x03CA, 0x03AA, I_LOA, I_BT_GREEK_IOTA,	  I_ST_DIAERESIS	},	// 0x03CA / GREEK SMALL LETTER IOTA DIARESIS
{ 0x03CB, 0x03AB, I_LOA, I_BT_GREEK_UPSILON,  I_ST_DIAERESIS	},	// 0x03CB / GREEK SMALL LETTER UPSILON DIARESIS
{ 0x03CC, 0x038C, I_LOA, I_BT_GREEK_OMICRON,  I_ST_TONE 		},	// 0x03CC / GREEK SMALL LETTER OMICRON TONOS
{ 0x03CD, 0x038E, I_LOA, I_BT_GREEK_UPSILON,  I_ST_TONE 		},	// 0x03CD / GREEK SMALL LETTER UPSILON TONOS
{ 0x03CE, 0x038F, I_LOA, I_BT_GREEK_OMEGA,	  I_ST_TONE 		}	// 0x03CE / GREEK SMALL LETTER OMEGA TONOS
};

#define I_CYR_START 		(0x0400)
#define I_CYR_END			(0x045F)

static IntnCharInfo aImplCyrillicCharInfoTab[(I_CYR_END-I_CYR_START)+1] =
{
{ 0x0450, 0x0400, I_UPA, I_BT_CYR_IE_GRAVE,	  I_ST_NORMAL		},	
{ 0x0451, 0x0401, I_UPA, I_BT_CYR_IO,   	  I_ST_NORMAL		},	
{ 0x0452, 0x0402, I_UPA, I_BT_CYR_DJE,   	  I_ST_NORMAL		},	
{ 0x0453, 0x0403, I_UPA, I_BT_CYR_GJE,   	  I_ST_NORMAL		},	
{ 0x0454, 0x0404, I_UPA, I_BT_CYR_UKR_IE,  	  I_ST_NORMAL		},	
{ 0x0455, 0x0405, I_UPA, I_BT_CYR_DZE,   	  I_ST_NORMAL		},	
{ 0x0456, 0x0406, I_UPA, I_BT_CYR_BEL_I,   	  I_ST_NORMAL		},	
{ 0x0457, 0x0407, I_UPA, I_BT_CYR_YI,   	  I_ST_NORMAL		},	
{ 0x0458, 0x0408, I_UPA, I_BT_CYR_JE,   	  I_ST_NORMAL		},	
{ 0x0459, 0x0409, I_UPA, I_BT_CYR_LJE,   	  I_ST_NORMAL		},	
{ 0x045A, 0x040A, I_UPA, I_BT_CYR_NJE,   	  I_ST_NORMAL		},	
{ 0x045B, 0x040B, I_UPA, I_BT_CYR_TSHE,   	  I_ST_NORMAL		},	
{ 0x045C, 0x040C, I_UPA, I_BT_CYR_KJE,   	  I_ST_NORMAL		},	
{ 0x045D, 0x040D, I_UPA, I_BT_CYR_I_GRAVE,    I_ST_NORMAL		},	
{ 0x045E, 0x040E, I_UPA, I_BT_CYR_SHORT_U,    I_ST_NORMAL		},	
{ 0x045F, 0x040F, I_UPA, I_BT_CYR_DZHE,   	  I_ST_NORMAL		},	
{ 0x0430, 0x0410, I_UPA, I_BT_CYR_A,		  I_ST_NORMAL		},	// 0x0410 / CYRILLIC CAPITAL LETTER A
{ 0x0431, 0x0411, I_UPA, I_BT_CYR_BE,		  I_ST_NORMAL		},	// 0x0411 / CYRILLIC CAPITAL LETTER BE
{ 0x0432, 0x0412, I_UPA, I_BT_CYR_VE,		  I_ST_NORMAL		},	// 0x0412 / CYRILLIC CAPITAL LETTER VE
{ 0x0433, 0x0413, I_UPA, I_BT_CYR_GE,		  I_ST_NORMAL		},	// 0x0413 / CYRILLIC CAPITAL LETTER GE
{ 0x0434, 0x0414, I_UPA, I_BT_CYR_DE,		  I_ST_NORMAL		},	// 0x0414 / CYRILLIC CAPITAL LETTER DE
{ 0x0435, 0x0415, I_UPA, I_BT_CYR_IE,		  I_ST_NORMAL		},	// 0x0415 / CYRILLIC CAPITAL LETTER IE
{ 0x0436, 0x0416, I_UPA, I_BT_CYR_ZHE,		  I_ST_NORMAL		},	// 0x0416 / CYRILLIC CAPITAL LETTER ZHE
{ 0x0437, 0x0417, I_UPA, I_BT_CYR_ZE,		  I_ST_NORMAL		},	// 0x0417 / CYRILLIC CAPITAL LETTER ZE
{ 0x0438, 0x0418, I_UPA, I_BT_CYR_II,		  I_ST_NORMAL		},	// 0x0418 / CYRILLIC CAPITAL LETTER II
{ 0x0439, 0x0419, I_UPA, I_BT_CYR_SHORT_II,   I_ST_NORMAL		},	// 0x0419 / CYRILLIC CAPITAL LETTER SHORT II
{ 0x043A, 0x041A, I_UPA, I_BT_CYR_KA,		  I_ST_NORMAL		},	// 0x041A / CYRILLIC CAPITAL LETTER KA
{ 0x043B, 0x041B, I_UPA, I_BT_CYR_EL,		  I_ST_NORMAL		},	// 0x041B / CYRILLIC CAPITAL LETTER EL
{ 0x043C, 0x041C, I_UPA, I_BT_CYR_EM,		  I_ST_NORMAL		},	// 0x041C / CYRILLIC CAPITAL LETTER EM
{ 0x043D, 0x041D, I_UPA, I_BT_CYR_EN,		  I_ST_NORMAL		},	// 0x041D / CYRILLIC CAPITAL LETTER EN
{ 0x043E, 0x041E, I_UPA, I_BT_CYR_O,		  I_ST_NORMAL		},	// 0x041E / CYRILLIC CAPITAL LETTER O
{ 0x043F, 0x041F, I_UPA, I_BT_CYR_PE,		  I_ST_NORMAL		},	// 0x041F / CYRILLIC CAPITAL LETTER PE
{ 0x0440, 0x0420, I_UPA, I_BT_CYR_ER,		  I_ST_NORMAL		},	// 0x0420 / CYRILLIC CAPITAL LETTER ER
{ 0x0441, 0x0421, I_UPA, I_BT_CYR_ES,		  I_ST_NORMAL		},	// 0x0421 / CYRILLIC CAPITAL LETTER ES
{ 0x0442, 0x0422, I_UPA, I_BT_CYR_TE,		  I_ST_NORMAL		},	// 0x0422 / CYRILLIC CAPITAL LETTER TE
{ 0x0443, 0x0423, I_UPA, I_BT_CYR_U,		  I_ST_NORMAL		},	// 0x0423 / CYRILLIC CAPITAL LETTER U
{ 0x0444, 0x0424, I_UPA, I_BT_CYR_EF,		  I_ST_NORMAL		},	// 0x0424 / CYRILLIC CAPITAL LETTER EF
{ 0x0445, 0x0425, I_UPA, I_BT_CYR_KHA,		  I_ST_NORMAL		},	// 0x0425 / CYRILLIC CAPITAL LETTER KHA
{ 0x0446, 0x0426, I_UPA, I_BT_CYR_TSE,		  I_ST_NORMAL		},	// 0x0426 / CYRILLIC CAPITAL LETTER TSE
{ 0x0447, 0x0427, I_UPA, I_BT_CYR_CHE,		  I_ST_NORMAL		},	// 0x0427 / CYRILLIC CAPITAL LETTER CHE
{ 0x0448, 0x0428, I_UPA, I_BT_CYR_SHA,		  I_ST_NORMAL		},	// 0x0428 / CYRILLIC CAPITAL LETTER SHA
{ 0x0449, 0x0429, I_UPA, I_BT_CYR_SHCHA,	  I_ST_NORMAL		},	// 0x0429 / CYRILLIC CAPITAL LETTER SHCHA
{ 0x044A, 0x042A, I_UPA, I_BT_CYR_HARD_SIGN,  I_ST_NORMAL		},	// 0x042A / CYRILLIC CAPITAL LETTER HARD SIGN
{ 0x044B, 0x042B, I_UPA, I_BT_CYR_YERI, 	  I_ST_NORMAL		},	// 0x042B / CYRILLIC CAPITAL LETTER YERI
{ 0x044C, 0x042C, I_UPA, I_BT_CYR_SOFT_SIGN,  I_ST_NORMAL		},	// 0x042C / CYRILLIC CAPITAL LETTER SOFT SIGN
{ 0x044D, 0x042D, I_UPA, I_BT_CYR_REVERSED_E, I_ST_NORMAL		},	// 0x042D / CYRILLIC CAPITAL LETTER REVERSED E
{ 0x044E, 0x042E, I_UPA, I_BT_CYR_IU,		  I_ST_NORMAL		},	// 0x042E / CYRILLIC CAPITAL LETTER IU
{ 0x044F, 0x042F, I_UPA, I_BT_CYR_IA,		  I_ST_NORMAL		},	// 0x042F / CYRILLIC CAPITAL LETTER IA
{ 0x0430, 0x0410, I_LOA, I_BT_CYR_A,		  I_ST_NORMAL		},	// 0x0430 / CYRILLIC SMALL LETTER A
{ 0x0431, 0x0411, I_LOA, I_BT_CYR_BE,		  I_ST_NORMAL		},	// 0x0431 / CYRILLIC SMALL LETTER BE
{ 0x0432, 0x0412, I_LOA, I_BT_CYR_VE,		  I_ST_NORMAL		},	// 0x0432 / CYRILLIC SMALL LETTER VE
{ 0x0433, 0x0413, I_LOA, I_BT_CYR_GE,		  I_ST_NORMAL		},	// 0x0433 / CYRILLIC SMALL LETTER GE
{ 0x0434, 0x0414, I_LOA, I_BT_CYR_DE,		  I_ST_NORMAL		},	// 0x0434 / CYRILLIC SMALL LETTER DE
{ 0x0435, 0x0415, I_LOA, I_BT_CYR_IE,		  I_ST_NORMAL		},	// 0x0435 / CYRILLIC SMALL LETTER IE
{ 0x0436, 0x0416, I_LOA, I_BT_CYR_ZHE,		  I_ST_NORMAL		},	// 0x0436 / CYRILLIC SMALL LETTER ZHE
{ 0x0437, 0x0417, I_LOA, I_BT_CYR_ZE,		  I_ST_NORMAL		},	// 0x0437 / CYRILLIC SMALL LETTER ZE
{ 0x0438, 0x0418, I_LOA, I_BT_CYR_II,		  I_ST_NORMAL		},	// 0x0438 / CYRILLIC SMALL LETTER II
{ 0x0439, 0x0419, I_LOA, I_BT_CYR_SHORT_II,   I_ST_NORMAL		},	// 0x0439 / CYRILLIC SMALL LETTER SHORT II
{ 0x043A, 0x041A, I_LOA, I_BT_CYR_KA,		  I_ST_NORMAL		},	// 0x043A / CYRILLIC SMALL LETTER KA
{ 0x043B, 0x041B, I_LOA, I_BT_CYR_EL,		  I_ST_NORMAL		},	// 0x043B / CYRILLIC SMALL LETTER EL
{ 0x043C, 0x041C, I_LOA, I_BT_CYR_EM,		  I_ST_NORMAL		},	// 0x043C / CYRILLIC SMALL LETTER EM
{ 0x043D, 0x041D, I_LOA, I_BT_CYR_EN,		  I_ST_NORMAL		},	// 0x043D / CYRILLIC SMALL LETTER EN
{ 0x043E, 0x041E, I_LOA, I_BT_CYR_O,		  I_ST_NORMAL		},	// 0x043E / CYRILLIC SMALL LETTER O
{ 0x043F, 0x041F, I_LOA, I_BT_CYR_PE,		  I_ST_NORMAL		},	// 0x043F / CYRILLIC SMALL LETTER PE
{ 0x0440, 0x0420, I_LOA, I_BT_CYR_ER,		  I_ST_NORMAL		},	// 0x0440 / CYRILLIC SMALL LETTER ER
{ 0x0441, 0x0421, I_LOA, I_BT_CYR_ES,		  I_ST_NORMAL		},	// 0x0441 / CYRILLIC SMALL LETTER ES
{ 0x0442, 0x0422, I_LOA, I_BT_CYR_TE,		  I_ST_NORMAL		},	// 0x0442 / CYRILLIC SMALL LETTER TE
{ 0x0443, 0x0423, I_LOA, I_BT_CYR_U,		  I_ST_NORMAL		},	// 0x0443 / CYRILLIC SMALL LETTER U
{ 0x0444, 0x0424, I_LOA, I_BT_CYR_EF,		  I_ST_NORMAL		},	// 0x0444 / CYRILLIC SMALL LETTER EF
{ 0x0445, 0x0425, I_LOA, I_BT_CYR_KHA,		  I_ST_NORMAL		},	// 0x0445 / CYRILLIC SMALL LETTER KHA
{ 0x0446, 0x0426, I_LOA, I_BT_CYR_TSE,		  I_ST_NORMAL		},	// 0x0446 / CYRILLIC SMALL LETTER TSE
{ 0x0447, 0x0427, I_LOA, I_BT_CYR_CHE,		  I_ST_NORMAL		},	// 0x0447 / CYRILLIC SMALL LETTER CHE
{ 0x0448, 0x0428, I_LOA, I_BT_CYR_SHA,		  I_ST_NORMAL		},	// 0x0448 / CYRILLIC SMALL LETTER SHA
{ 0x0449, 0x0429, I_LOA, I_BT_CYR_SHCHA,	  I_ST_NORMAL		},	// 0x0449 / CYRILLIC SMALL LETTER SHCHA
{ 0x044A, 0x042A, I_LOA, I_BT_CYR_HARD_SIGN,  I_ST_NORMAL		},	// 0x044A / CYRILLIC SMALL LETTER HARD SIGN
{ 0x044B, 0x042B, I_LOA, I_BT_CYR_YERI, 	  I_ST_NORMAL		},	// 0x044B / CYRILLIC SMALL LETTER YERI
{ 0x044C, 0x042C, I_LOA, I_BT_CYR_SOFT_SIGN,  I_ST_NORMAL		},	// 0x044C / CYRILLIC SMALL LETTER SOFT SIGN
{ 0x044D, 0x042D, I_LOA, I_BT_CYR_REVERSED_E, I_ST_NORMAL		},	// 0x044D / CYRILLIC SMALL LETTER REVERSED E
{ 0x044E, 0x042E, I_LOA, I_BT_CYR_IU,		  I_ST_NORMAL		},	// 0x044E / CYRILLIC SMALL LETTER IU
{ 0x044F, 0x042F, I_LOA, I_BT_CYR_IA,		  I_ST_NORMAL		},	// 0x044F / CYRILLIC SMALL LETTER IA
{ 0x0450, 0x0400, I_LOA, I_BT_CYR_IE_GRAVE,	  I_ST_NORMAL		},
{ 0x0451, 0x0401, I_LOA, I_BT_CYR_IO,   	  I_ST_NORMAL		},
{ 0x0452, 0x0402, I_LOA, I_BT_CYR_DJE,   	  I_ST_NORMAL		},
{ 0x0453, 0x0403, I_LOA, I_BT_CYR_GJE,   	  I_ST_NORMAL		},
{ 0x0454, 0x0404, I_LOA, I_BT_CYR_UKR_IE,     I_ST_NORMAL		},
{ 0x0455, 0x0405, I_LOA, I_BT_CYR_DZE,   	  I_ST_NORMAL		},
{ 0x0456, 0x0406, I_LOA, I_BT_CYR_BEL_I,   	  I_ST_NORMAL		},
{ 0x0457, 0x0407, I_LOA, I_BT_CYR_YI,   	  I_ST_NORMAL		},
{ 0x0458, 0x0408, I_LOA, I_BT_CYR_JE,   	  I_ST_NORMAL		},
{ 0x0459, 0x0409, I_LOA, I_BT_CYR_LJE,   	  I_ST_NORMAL		},
{ 0x045A, 0x040A, I_LOA, I_BT_CYR_NJE,   	  I_ST_NORMAL		},
{ 0x045B, 0x040B, I_LOA, I_BT_CYR_TSHE,   	  I_ST_NORMAL		},
{ 0x045C, 0x040C, I_LOA, I_BT_CYR_KJE,   	  I_ST_NORMAL		},
{ 0x045D, 0x040D, I_LOA, I_BT_CYR_I_GRAVE,    I_ST_NORMAL		},
{ 0x045E, 0x040E, I_LOA, I_BT_CYR_SHORT_U,    I_ST_NORMAL		},
{ 0x045F, 0x040F, I_LOA, I_BT_CYR_DZHE,   	  I_ST_NORMAL		}
};

#define I_CYR_EXT_START 		(0x0490)
#define I_CYR_EXT_END			(0x0491)


static IntnCharInfo aImplCyrillicExtCharInfoTab[(I_CYR_EXT_END-I_CYR_EXT_START)+1] =
{
{ 0x0491, 0x0490, I_UPA, I_BT_CYR_HARD_GHE,	  I_ST_NORMAL		},	
{ 0x0491, 0x0490, I_LOA, I_BT_CYR_HARD_GHE,   I_ST_NORMAL		}	
};

// -----------------------------------------------------------------------

static IntnCharInfo* _ImplGetCharInfo( USHORT n )
{
	if ( (n >= I_CYR_START) && (n <= I_CYR_END) )
		return aImplCyrillicCharInfoTab+(n-I_CYR_START);
	if ( (n >= I_CYR_EXT_START) && (n <= I_CYR_EXT_END) )
		return aImplCyrillicExtCharInfoTab+(n-I_CYR_EXT_START);
	else if ( (n >= I_GREEK_START) && (n <= I_GREEK_END) )
		return aImplGreekCharInfoTab+(n-I_GREEK_START);
	else
		return aImplCharInfoTab+I_SYM_UNICHAR;
}

inline IntnCharInfo* ImplGetCharInfo( USHORT n )
{
	if ( n < I_MAX_UNICHAR )
		return aImplCharInfoTab+n;
	else
		return _ImplGetCharInfo( n );
}

// -----------------------------------------------------------------------

inline BYTE ImplIntnTestIgnoreChar( BYTE nBaseType )
{
	if ( nBaseType >= I_BT_0 )
		return 0;
	else if ( (nBaseType == I_BT_HYPHEN) ||
			  (nBaseType == I_BT_APOSTROPHE) ||
			  (nBaseType == I_BT_CONTROL) ||
			  (nBaseType == I_BT_QUOTATION) ||
			  (nBaseType == I_BT_SPACE) )
		return nBaseType;
	else
		return 0;
}

// -----------------------------------------------------------------------

static void ImplIntnExpandLigature( USHORT& rUniChar, USHORT& rNextChar )
{
	switch ( rUniChar )
	{
		// AE
		case 0x00C6:
			rUniChar  = 0x0041;
			rNextChar = 0x0045;
			break;

		// ae
		case 0x00E6:
			rUniChar  = 0x0061;
			rNextChar = 0x0065;
			break;

		// IJ
		case 0x0132:
			rUniChar  = 0x0049;
			rNextChar = 0x004A;
			break;

		// ij
		case 0x0133:
			rUniChar  = 0x0069;
			rNextChar = 0x006A;
			break;

		// OE
		case 0x0152:
			rUniChar  = 0x004F;
			rNextChar = 0x0045;
			break;

		// oe
		case 0x0153:
			rUniChar  = 0x006F;
			rNextChar = 0x0065;
			break;

		// sz
		case 0x00DF:
			rUniChar  = 0x0073;
			rNextChar = 0x0073;
			break;
	}
}

// -----------------------------------------------------------------------

static StringCompare ImplCompare( const UniString& rStr1, const UniString& rStr2,
								  USHORT nFlags,
								  IntnCompareCharProc pCompProc,
								  BOOL bDiaRightToLeft )
{
	const sal_Unicode*	pStr1 = rStr1.GetBuffer();
	const sal_Unicode*	pStr2 = rStr2.GetBuffer();
	USHORT				nUniChar1;
	USHORT				nUniChar2;
	USHORT				nWordSortPos1 = 0;
	USHORT				nWordSortPos2 = 0;
	USHORT				nCtrlSortPos1 = 0;
	USHORT				nCtrlSortPos2 = 0;
	USHORT				nPrevChar1		= 0;
	USHORT				nPrevChar2		= 0;
	USHORT				nNextChar1		= 0;
	USHORT				nNextChar2		= 0;
	USHORT				nOrgUniChar1 = 0;
	USHORT				nOrgUniChar2 = 0;
	BYTE				nType1;
	BYTE				nType2;
	BYTE				nBaseType1 = 0;
	BYTE				nBaseType2 = 0;
	BYTE				nSubType1;
	BYTE				nSubType2;
	BYTE				nTempBaseType;
	IntnCharInfo*		pCharInfo;
	StringCompare		eDiaSort		= COMPARE_EQUAL;
	StringCompare		eLigaSort		= COMPARE_EQUAL;
	StringCompare		eCaseSort		= COMPARE_EQUAL;
	StringCompare		eWordSort		= COMPARE_EQUAL;
	StringCompare		eCtrlSort		= COMPARE_EQUAL;

	do
	{
		if ( eWordSort == COMPARE_EQUAL )
		{
			nWordSortPos1 = 0;
			nWordSortPos2 = 0;
		}
		if ( eCtrlSort == COMPARE_EQUAL )
		{
			nCtrlSortPos1 = 0;
			nCtrlSortPos2 = 0;
		}

		if ( nNextChar1 )
		{
			nUniChar1 = nNextChar1;
			nOrgUniChar1 = nUniChar1;
			nBaseType1 = ImplGetCharInfo( nUniChar1 )->nBaseType;
			nNextChar1 = 0;
		}
		else
		{
			while ( *pStr1 )
			{
				nOrgUniChar1 = *pStr1;
				nUniChar1 = nOrgUniChar1;
				pCharInfo = ImplGetCharInfo( nOrgUniChar1 );
				if ( pCharInfo->nLowerChar == I_SYM_UNICHAR )
					nUniChar1 = I_SYM_UNICHAR;
				if ( nFlags & INTN_COMPARE_IGNORECASE )
					nUniChar1 = pCharInfo->nLowerChar;
				nBaseType1 = pCharInfo->nBaseType;
				nTempBaseType = ImplIntnTestIgnoreChar( nBaseType1 );
				if ( !nTempBaseType )
					break;
				if ( nTempBaseType == I_BT_CONTROL )
				{
					if ( eCtrlSort == COMPARE_EQUAL )
						nCtrlSortPos1++;
				}
				else
				{
					if ( eWordSort == COMPARE_EQUAL )
						nWordSortPos1++;
					nPrevChar1 = nUniChar1;
				}
				pStr1++;
			}
		}

		if ( nNextChar2 )
		{
			nUniChar2 = nNextChar2;
			nOrgUniChar2 = nUniChar2;
			nBaseType2 = ImplGetCharInfo( nUniChar2 )->nBaseType;
			nNextChar2 = 0;
		}
		else
		{
			while ( *pStr2 )
			{
				nOrgUniChar2 = *pStr2;
				nUniChar2 = nOrgUniChar2;
				pCharInfo = ImplGetCharInfo( nOrgUniChar2 );
				if ( pCharInfo->nLowerChar == I_SYM_UNICHAR )
					nUniChar2 = I_SYM_UNICHAR;
				if ( nFlags & INTN_COMPARE_IGNORECASE )
					nUniChar2 = pCharInfo->nLowerChar;
				nBaseType2 = pCharInfo->nBaseType;
				nTempBaseType = ImplIntnTestIgnoreChar( nBaseType2 );
				if ( !nTempBaseType )
					break;
				if ( nTempBaseType == I_BT_CONTROL )
				{
					if ( eCtrlSort == COMPARE_EQUAL )
						nCtrlSortPos2++;
				}
				else
				{
					if ( eWordSort == COMPARE_EQUAL )
						nWordSortPos2++;
					nPrevChar2 = nUniChar2;
				}
				pStr2++;
			}
		}

		if ( eWordSort == COMPARE_EQUAL )
		{
			if ( nWordSortPos1 != nWordSortPos2 )
			{
				if ( nWordSortPos1 < nWordSortPos2 )
					eWordSort = COMPARE_LESS;
				else
					eWordSort = COMPARE_GREATER;
			}
		}
		if ( eCtrlSort == COMPARE_EQUAL )
		{
			if ( nCtrlSortPos1 != nCtrlSortPos2 )
			{
				if ( nCtrlSortPos1 < nCtrlSortPos2 )
					eCtrlSort = COMPARE_LESS;
				else
					eCtrlSort = COMPARE_GREATER;
			}
		}

		if ( !*pStr1 || !*pStr2 )
			break;

		// Wenn sich die Zeichen unterscheiden, muessen wir aufwendiger
		// vergleichen
		if ( nOrgUniChar1 != nOrgUniChar2 )
		{
			// Wenn es sich bei einem der beiden Zeichen um keinen
			// Buchstaben handelt, koennen wir den Vergleich abbrechen
			if ( (nBaseType1 < I_BT_A) || (nBaseType2 < I_BT_A) )
			{
				if ( nBaseType1 < nBaseType2 )
					return COMPARE_LESS;
				else if ( nBaseType1 > nBaseType2 )
					return COMPARE_GREATER;
				else if ( nOrgUniChar1 < nOrgUniChar2 )
					return COMPARE_LESS;
				else
					return COMPARE_GREATER;
			}

			// Jetzt hantieren wir nur noch mit Buchstaben und muessen
			// diese relativ aufwendig vergleichen
			nSubType1 = ImplGetCharInfo( nUniChar1 )->nSubType;
			nSubType2 = ImplGetCharInfo( nUniChar2 )->nSubType;

			if ( nSubType1 != nSubType2 )
			{
				if ( (nSubType1 == I_ST_LIGATURE) || (nSubType2 == I_ST_LIGATURE) )
				{
					if ( nSubType1 == I_ST_LIGATURE )
					{
						if ( eLigaSort == COMPARE_EQUAL )
						{
							// sz ist per Definition kleiner (wie im deutschen)
							if ( nUniChar1 == 0x00DF )
								eLigaSort = COMPARE_LESS;
							else
								eLigaSort = COMPARE_GREATER;
						}
						if ( nSubType2 != I_ST_NORMAL )
						{
							if ( bDiaRightToLeft || (eDiaSort == COMPARE_EQUAL) )
								eDiaSort = COMPARE_LESS;
						}
						ImplIntnExpandLigature( nUniChar1, nNextChar1 );
					}
					else
					{
						if ( eLigaSort == COMPARE_EQUAL )
						{
							// sz ist per Definition kleiner (wie im deutschen)
							if ( nUniChar2 == 0x00DF )
								eLigaSort = COMPARE_GREATER;
							else
								eLigaSort = COMPARE_LESS;
						}
						if ( nSubType1 != I_ST_NORMAL )
						{
							if ( bDiaRightToLeft || (eDiaSort == COMPARE_EQUAL) )
								eDiaSort = COMPARE_GREATER;
						}
						ImplIntnExpandLigature( nUniChar2, nNextChar2 );
					}
				}
				else
				{
					if ( bDiaRightToLeft || (eDiaSort == COMPARE_EQUAL) )
					{
						if ( nSubType1 < nSubType2 )
							eDiaSort = COMPARE_LESS;
						else
							eDiaSort = COMPARE_GREATER;
					}
				}
			}

			// Jetzt evt. noch Sprachabhaengig sortieren
			if ( pCompProc )
			{
				StringCompare eSort = pCompProc( nPrevChar1, nPrevChar2,
												 nUniChar1, nUniChar2,
												 nNextChar1, nNextChar2,
												 eLigaSort );
				if ( eSort != COMPARE_EQUAL )
					return eSort;
			}

			// Wenn sich die Basistypen unterscheiden, dann
			// koennen wir abbrechen
			// Wir duerfen dies erst hier vergleichen, da im Spanischen
			// zum Beispiel vorher anders in der Compare-Proc verglichen
			// werden kann
			if ( nBaseType1 != nBaseType2 )
			{
				if ( nBaseType1 < nBaseType2 )
					return COMPARE_LESS;
				else
					return COMPARE_GREATER;
			}

			if ( eCaseSort == COMPARE_EQUAL )
			{
				nType1 = ImplGetCharInfo( nUniChar1 )->nType;
				nType2 = ImplGetCharInfo( nUniChar2 )->nType;
				if ( nType1 != nType2 )
				{
					if ( nType1 & INTN_CHAR_LOWER )
						eCaseSort = COMPARE_LESS;
					else
						eCaseSort = COMPARE_GREATER;
				}
			}
		}

		nPrevChar1 = nUniChar1;
		nPrevChar2 = nUniChar2;
		if ( !nNextChar1 )
			pStr1++;
		if ( !nNextChar2 )
			pStr2++;
	}
	while ( *pStr1 && *pStr2 );

	// Falls wir hier ankommen, sind beide Strings gleich gewesen
	// Dann ist die Laenge das entscheidende Kriterium
	if ( !*pStr1 && !*pStr2 )
	{
		// Wenn beide Strings gleich lang sind, dann entscheiden
		// Umlaute, Ligaturen, Sonderzeichen, ...

		// Umlaute
		if ( eDiaSort != COMPARE_EQUAL )
			return eDiaSort;

		// Ligaturen
		if ( eLigaSort != COMPARE_EQUAL )
			return eLigaSort;

		// Klein-/Grossschreibung
		if ( eCaseSort != COMPARE_EQUAL )
			return eCaseSort;

		// Sonderzeichen
		if ( eWordSort != COMPARE_EQUAL )
			return eWordSort;

		// Controlzeichen
		if ( eCtrlSort != COMPARE_EQUAL )
			return eCtrlSort;

		return COMPARE_EQUAL;
	}
	else if ( *pStr1 )
		return COMPARE_GREATER;
	else
		return COMPARE_LESS;
}

// -----------------------------------------------------------------------

StringCompare ImplStdLanguageCompare( const UniString& rStr1, const UniString& rStr2,
									  USHORT nFlags, LanguageType )
{
	return ImplCompare( rStr1, rStr2, nFlags, NULL, FALSE );
}

// -----------------------------------------------------------------------

StringCompare ImplGermanLanguageCompare( const UniString& rStr1, const UniString& rStr2,
										 USHORT nFlags, LanguageType )
{
	return ImplCompare( rStr1, rStr2, nFlags, NULL, FALSE );
}

// -----------------------------------------------------------------------

StringCompare ImplFrenchLanguageCompare( const UniString& rStr1, const UniString& rStr2,
										 USHORT nFlags, LanguageType )
{
	return ImplCompare( rStr1, rStr2, nFlags, NULL, TRUE );
}

// -----------------------------------------------------------------------

static StringCompare ImplSpanishOldCharCompare( USHORT nPrevChar1, USHORT nPrevChar2,
												USHORT& rUniChar1, USHORT& rUniChar2,
												USHORT&, USHORT&,
												StringCompare& )
{
	// ch und CH
	if ( (((rUniChar1  == 0x0068) || (rUniChar1  == 0x0048)) &&
		  ((nPrevChar1 == 0x0063) || (nPrevChar1 == 0x0043))) ||
		 (((rUniChar2  == 0x0068) || (rUniChar2  == 0x0048)) &&
		  ((nPrevChar2 == 0x0063) || (nPrevChar2 == 0x0043))) )
	{
		if ( (((rUniChar1  == 0x0068) || (rUniChar1  == 0x0048)) &&
			  ((nPrevChar1 == 0x0063) || (nPrevChar1 == 0x0043))) )
			return COMPARE_GREATER;
		else
			return COMPARE_LESS;
	}
	// ll und LL
	if ( (((rUniChar1  == 0x006C) || (rUniChar1  == 0x004C)) &&
		  ((nPrevChar1 == 0x006C) || (nPrevChar1 == 0x004C))) ||
		 (((rUniChar2  == 0x006C) || (rUniChar2  == 0x004C)) &&
		  ((nPrevChar2 == 0x006C) || (nPrevChar2 == 0x004C))) )
	{
		if ( (((rUniChar1  == 0x006C) || (rUniChar1  == 0x004C)) &&
			  ((nPrevChar1 == 0x006C) || (nPrevChar1 == 0x004C))) )
			return COMPARE_GREATER;
		else
			return COMPARE_LESS;
	}
	// ~n und ~N
	if ( (rUniChar1 == 0x00F1) || (rUniChar1 == 0x00D1) ||
		 (rUniChar2 == 0x00F1) || (rUniChar2 == 0x00D1) )
	{
		// Nur wenn BaseTypen gleich sind, wie ~n hinter n einsortiert
		if ( ImplGetCharInfo( rUniChar1 )->nBaseType ==
			 ImplGetCharInfo( rUniChar2 )->nBaseType )
		{
			if ( (rUniChar1 == 0x00F1) || (rUniChar1 == 0x00D1) )
				return COMPARE_GREATER;
			else
				return COMPARE_LESS;
		}
	}

	return COMPARE_EQUAL;
}

// -----------------------------------------------------------------------

static StringCompare ImplSpanishCharCompare( USHORT nPrevChar1, USHORT nPrevChar2,
											 USHORT& rUniChar1, USHORT& rUniChar2,
											 USHORT&, USHORT&,
											 StringCompare& )
{
	// ~n und ~N
	if ( (rUniChar1 == 0x00F1) || (rUniChar1 == 0x00D1) ||
		 (rUniChar2 == 0x00F1) || (rUniChar2 == 0x00D1) )
	{
		// Nur wenn BaseTypen gleich sind, wie ~n hinter n einsortiert
		if ( ImplGetCharInfo( rUniChar1 )->nBaseType ==
			 ImplGetCharInfo( rUniChar2 )->nBaseType )
		{
			if ( (rUniChar1 == 0x00F1) || (rUniChar1 == 0x00D1) )
				return COMPARE_GREATER;
			else
				return COMPARE_LESS;
		}
	}

	return COMPARE_EQUAL;
}

// -----------------------------------------------------------------------

StringCompare ImplSpanishLanguageCompare( const UniString& rStr1, const UniString& rStr2,
										  USHORT nFlags, LanguageType eLang )
{
	if ( (eLang == LANGUAGE_SPANISH) || (eLang == LANGUAGE_SPANISH_MEXICAN) )
		return ImplCompare( rStr1, rStr2, nFlags, ImplSpanishOldCharCompare, FALSE );
	else
		return ImplCompare( rStr1, rStr2, nFlags, ImplSpanishCharCompare, FALSE );
}

// -----------------------------------------------------------------------

sal_Unicode International::Lower( sal_Unicode c ) const
{
	DBG_CHKTHIS( International, NULL );

	LanguageUpLowProc pProc = pData->pLanguage->GetLowerProc();
	if ( pProc )
		return pProc( c, pData->pLanguage->eLanguage );
	else
	{
		sal_Unicode c2 = ImplGetCharInfo( c )->nLowerChar;
		if ( c2 != I_SYM_UNICHAR )
			c = c2;
	}

	return c;
}

// -----------------------------------------------------------------------

sal_Unicode International::Upper( sal_Unicode c ) const
{
	DBG_CHKTHIS( International, NULL );

	LanguageUpLowProc pProc = pData->pLanguage->GetUpperProc();
	if ( pProc )
		return pProc( c, pData->pLanguage->eLanguage );
	else
	{
		sal_Unicode c2 = ImplGetCharInfo( c )->nUpperChar;
		if ( c2 != I_SYM_UNICHAR )
			c = c2;
	}

	return c;
}

// -----------------------------------------------------------------------

void International::ToLower( UniString& rStr ) const
{
	DBG_CHKTHIS( International, NULL );

	xub_StrLen			nIndex = 0;
	xub_StrLen			nLen = rStr.Len();
	const xub_Unicode*	pStr = rStr.GetBuffer();
	LanguageUpLowProc	pProc = pData->pLanguage->GetLowerProc();
	if ( pProc )
	{
		while ( nIndex < nLen )
		{
			xub_Unicode c = pProc( *pStr, pData->pLanguage->eLanguage );
			if ( c != *pStr )
			{
				rStr.SetChar( nIndex, c );
				pStr = rStr.GetBuffer();
				pStr += nIndex;
			}

			pStr++;
			nIndex++;
		}
	}
	else
	{
		while ( nIndex < nLen )
		{
			sal_Unicode c = ImplGetCharInfo( *pStr )->nLowerChar;
			if ( (c != *pStr) && (c != I_SYM_UNICHAR) )
			{
				rStr.SetChar( nIndex, c );
				pStr = rStr.GetBuffer();
				pStr += nIndex;
			}

			pStr++;
			nIndex++;
		}
	}
}

// -----------------------------------------------------------------------

void International::ToUpper( UniString& rStr ) const
{
	DBG_CHKTHIS( International, NULL );

	xub_StrLen			nIndex = 0;
	xub_StrLen			nLen = rStr.Len();
	const xub_Unicode*	pStr = rStr.GetBuffer();
	LanguageUpLowProc	pProc = pData->pLanguage->GetUpperProc();
	if ( pProc )
	{
		while ( nIndex < nLen )
		{
			xub_Unicode c = pProc( *pStr, pData->pLanguage->eLanguage );
			if ( c != *pStr )
			{
				rStr.SetChar( nIndex, c );
				pStr = rStr.GetBuffer();
				pStr += nIndex;
			}

			pStr++;
			nIndex++;
		}
	}
	else
	{
		while ( nIndex < nLen )
		{
			sal_Unicode c = ImplGetCharInfo( *pStr )->nUpperChar;
			if ( (c != *pStr) && (c != I_SYM_UNICHAR) )
			{
				rStr.SetChar( nIndex, c );
				pStr = rStr.GetBuffer();
				pStr += nIndex;
			}

			pStr++;
			nIndex++;
		}
	}
}

// -----------------------------------------------------------------------

UniString International::Lower( const UniString& rStr ) const
{
	UniString aStr = rStr;
	ToLower( aStr );
	return aStr;
}

// -----------------------------------------------------------------------

UniString International::Upper( const UniString& rStr ) const
{
	UniString aStr = rStr;
	ToUpper( aStr );
	return aStr;
}

// -----------------------------------------------------------------------

BYTE International::GetCharType( sal_Unicode c ) const
{
	DBG_CHKTHIS( International, NULL );

	LanguageTypeProc pProc = pData->pLanguage->GetTypeProc();
	if ( pProc )
		return pProc( c, pData->pLanguage->eLanguage );
	else
	{
		IntnCharInfo* pInfo = ImplGetCharInfo( c );
		if ( pInfo->nLowerChar != I_SYM_UNICHAR )
			return pInfo->nType;
		else
			return INTN_CHAR_NOTALPHANUMERIC;
	}
}

// -----------------------------------------------------------------------

BOOL International::IsStringType( const UniString& rStr, BYTE nType ) const
{
	DBG_CHKTHIS( International, NULL );

	xub_StrLen			nIndex = 0;
	xub_StrLen			nLen = rStr.Len();
	const xub_Unicode*	pStr = rStr.GetBuffer();
	LanguageUpLowProc	pProc = pData->pLanguage->GetUpperProc();
	if ( pProc )
	{
		while ( nIndex < nLen )
		{
			if ( !(nType & pProc( *pStr, pData->pLanguage->eLanguage )) )
				return FALSE;

			pStr++;
			nIndex++;
		}
	}
	else
	{
		while ( nIndex < nLen )
		{
			BYTE nCharType;
			sal_Unicode c = *pStr;
			IntnCharInfo* pInfo = ImplGetCharInfo( c );
			if ( pInfo->nLowerChar != I_SYM_UNICHAR )
				nCharType = pInfo->nType;
			else
				nCharType = INTN_CHAR_NOTALPHANUMERIC;
			if ( !(nType & nCharType) )
				return FALSE;

			pStr++;
			nIndex++;
		}
	}

	return TRUE;
}

// -----------------------------------------------------------------------

StringCompare International::Compare( const UniString& rStr1, const UniString& rStr2,
									  USHORT nFlags ) const
{
	DBG_CHKTHIS( International, NULL );

	LanguageCompareProc pProc = pData->pLanguage->GetCompareProc();
	if ( pProc )
		return pProc( rStr1, rStr2, nFlags, pData->pLanguage->eLanguage );
	else
		return ImplStdLanguageCompare( rStr1, rStr2, nFlags, pData->pLanguage->eLanguage );
}

// -----------------------------------------------------------------------

BOOL International::CompareEqual( const UniString& rStr1, const UniString& rStr2,
								  USHORT nFlags ) const
{
	DBG_CHKTHIS( International, NULL );

	if ( !nFlags )
		return (rStr2 == rStr1);

	if ( rStr1.Len() == rStr2.Len() )
	{
		const sal_Unicode* pStr1 = rStr1.GetBuffer();
		const sal_Unicode* pStr2 = rStr2.GetBuffer();
		while ( *pStr1 && *pStr2 )
		{
			// Wir haben als Flag derzeit nur IGRNOECASE !!!
			sal_Unicode c1 = Lower( *pStr1 );
			sal_Unicode c2 = Lower( *pStr2 );
			if ( c1 != c2 )
				return FALSE;

			pStr1++;
			pStr2++;
		}

		return TRUE;
	}
	else
		return FALSE;
}

// -----------------------------------------------------------------------

sal_Unicode International::GetIndexChar( const UniString& rStr, USHORT nFlags ) const
{
	DBG_CHKTHIS( International, NULL );

	if ( rStr.Len() )
	{
		LanguageIndexProc pProc = pData->pLanguage->GetIndexProc();
		if ( pProc )
			return pProc( rStr, nFlags, pData->pLanguage->eLanguage );
		else
		{
			const sal_Unicode* pStr = rStr.GetBuffer();
			do
			{
				if ( *pStr <= I_MAX_UNICHAR )
				{
					BYTE nBaseType = aImplCharInfoTab[*pStr].nBaseType;
					if ( !ImplIntnTestIgnoreChar( nBaseType ) )
					{
						if ( (nBaseType >= I_BT_A) && (nBaseType <= I_BT_Z) )
							return ('A'+(nBaseType-I_BT_A));
						break;
					}
				}
				else
					break;
				pStr++;
			}
			while ( *pStr );

			return INTN_INDEX_SYMBOL;
		}
	}
	else
		return INTN_INDEX_DONTKNOW;
}

// -----------------------------------------------------------------------

sal_Char International::GetQuotationMarkStartChar( rtl_TextEncoding eEncoding,
												   rtl_TextEncoding eOptionalEncoding,
												   BOOL* pOptionalUsed ) const
{
	sal_Unicode cStartUni;
	sal_Unicode cEndUni;
	sal_Char	cStart;
	sal_Char	cEnd;

	if ( pOptionalUsed )
		*pOptionalUsed = FALSE;

	cStartUni = (sal_Unicode)GetQuotationMarkStart();
	cEndUni = (sal_Unicode)GetQuotationMarkEnd();
	if ( (eEncoding != RTL_TEXTENCODING_SYMBOL) && (eEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eEncoding, FALSE );
		if ( cStart && cEnd )
			return cStart;
	}
	if ( (eOptionalEncoding != RTL_TEXTENCODING_SYMBOL) && (eOptionalEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eOptionalEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eOptionalEncoding, FALSE );
		if ( cStart && cEnd )
		{
			if ( pOptionalUsed )
				*pOptionalUsed = TRUE;
			return cStart;
		}
	}

	cStartUni = (sal_Unicode)GetQuotationMarkStart2();
	cEndUni = (sal_Unicode)GetQuotationMarkEnd2();
	if ( (eEncoding != RTL_TEXTENCODING_SYMBOL) && (eEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eEncoding, FALSE );
		if ( cStart && cEnd )
			return cStart;
	}
	if ( (eOptionalEncoding != RTL_TEXTENCODING_SYMBOL) && (eOptionalEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eOptionalEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eOptionalEncoding, FALSE );
		if ( cStart && cEnd )
		{
			if ( pOptionalUsed )
				*pOptionalUsed = TRUE;
			return cStart;
		}
	}

	return 0x27;
}

// -----------------------------------------------------------------------

sal_Char International::GetQuotationMarkEndChar( rtl_TextEncoding eEncoding,
												 rtl_TextEncoding eOptionalEncoding,
												 BOOL* pOptionalUsed ) const
{
	sal_Unicode cStartUni;
	sal_Unicode cEndUni;
	sal_Char	cStart;
	sal_Char	cEnd;

	if ( pOptionalUsed )
		*pOptionalUsed = FALSE;

	cStartUni = (sal_Unicode)GetQuotationMarkStart();
	cEndUni = (sal_Unicode)GetQuotationMarkEnd();
	if ( (eEncoding != RTL_TEXTENCODING_SYMBOL) && (eEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eEncoding, FALSE );
		if ( cStart && cEnd )
			return cEnd;
	}
	if ( (eOptionalEncoding != RTL_TEXTENCODING_SYMBOL) && (eOptionalEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eOptionalEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eOptionalEncoding, FALSE );
		if ( cStart && cEnd )
		{
			if ( pOptionalUsed )
				*pOptionalUsed = TRUE;
			return cEnd;
		}
	}

	cStartUni = (sal_Unicode)GetQuotationMarkStart2();
	cEndUni = (sal_Unicode)GetQuotationMarkEnd2();
	if ( (eEncoding != RTL_TEXTENCODING_SYMBOL) && (eEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eEncoding, FALSE );
		if ( cStart && cEnd )
			return cEnd;
	}
	if ( (eOptionalEncoding != RTL_TEXTENCODING_SYMBOL) && (eOptionalEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eOptionalEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eOptionalEncoding, FALSE );
		if ( cStart && cEnd )
		{
			if ( pOptionalUsed )
				*pOptionalUsed = TRUE;
			return cEnd;
		}
	}

	return 0x27;
}

// -----------------------------------------------------------------------

sal_Char International::GetDoubleQuotationMarkStartChar( rtl_TextEncoding eEncoding,
														 rtl_TextEncoding eOptionalEncoding,
														 BOOL* pOptionalUsed ) const
{
	sal_Unicode cStartUni;
	sal_Unicode cEndUni;
	sal_Char	cStart;
	sal_Char	cEnd;

	if ( pOptionalUsed )
		*pOptionalUsed = FALSE;

	cStartUni = (sal_Unicode)GetDoubleQuotationMarkStart();
	cEndUni = (sal_Unicode)GetDoubleQuotationMarkEnd();
	if ( (eEncoding != RTL_TEXTENCODING_SYMBOL) && (eEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eEncoding, FALSE );
		if ( cStart && cEnd )
			return cStart;
	}
	if ( (eOptionalEncoding != RTL_TEXTENCODING_SYMBOL) && (eOptionalEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eOptionalEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eOptionalEncoding, FALSE );
		if ( cStart && cEnd )
		{
			if ( pOptionalUsed )
				*pOptionalUsed = TRUE;
			return cStart;
		}
	}

	cStartUni = (sal_Unicode)GetDoubleQuotationMarkStart2();
	cEndUni = (sal_Unicode)GetDoubleQuotationMarkEnd2();
	if ( (eEncoding != RTL_TEXTENCODING_SYMBOL) && (eEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eEncoding, FALSE );
		if ( cStart && cEnd )
			return cStart;
	}
	if ( (eOptionalEncoding != RTL_TEXTENCODING_SYMBOL) && (eOptionalEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eOptionalEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eOptionalEncoding, FALSE );
		if ( cStart && cEnd )
		{
			if ( pOptionalUsed )
				*pOptionalUsed = TRUE;
			return cStart;
		}
	}

	return 0x22;
}

// -----------------------------------------------------------------------

sal_Char International::GetDoubleQuotationMarkEndChar( rtl_TextEncoding eEncoding,
													   rtl_TextEncoding eOptionalEncoding,
													   BOOL* pOptionalUsed ) const
{
	sal_Unicode cStartUni;
	sal_Unicode cEndUni;
	sal_Char	cStart;
	sal_Char	cEnd;

	if ( pOptionalUsed )
		*pOptionalUsed = FALSE;

	cStartUni = (sal_Unicode)GetDoubleQuotationMarkStart();
	cEndUni = (sal_Unicode)GetDoubleQuotationMarkEnd();
	if ( (eEncoding != RTL_TEXTENCODING_SYMBOL) && (eEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eEncoding, FALSE );
		if ( cStart && cEnd )
			return cEnd;
	}
	if ( (eOptionalEncoding != RTL_TEXTENCODING_SYMBOL) && (eOptionalEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eOptionalEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eOptionalEncoding, FALSE );
		if ( cStart && cEnd )
		{
			if ( pOptionalUsed )
				*pOptionalUsed = TRUE;
			return cEnd;
		}
	}

	cStartUni = (sal_Unicode)GetDoubleQuotationMarkStart2();
	cEndUni = (sal_Unicode)GetDoubleQuotationMarkEnd2();
	if ( (eEncoding != RTL_TEXTENCODING_SYMBOL) && (eEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eEncoding, FALSE );
		if ( cStart && cEnd )
			return cEnd;
	}
	if ( (eOptionalEncoding != RTL_TEXTENCODING_SYMBOL) && (eOptionalEncoding != RTL_TEXTENCODING_DONTKNOW) )
	{
		cStart = ByteString::ConvertFromUnicode( cStartUni, eOptionalEncoding, FALSE );
		cEnd = ByteString::ConvertFromUnicode( cEndUni, eOptionalEncoding, FALSE );
		if ( cStart && cEnd )
		{
			if ( pOptionalUsed )
				*pOptionalUsed = TRUE;
			return cEnd;
		}
	}

	return 0x22;
}
