/*************************************************************************
 *
 *  $RCSfile: intntab.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kz $ $Date: 2004/02/26 13:20:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define private public

#ifndef _INTNTAB_HXX
#include <intntab.hxx>
#endif

// =======================================================================

// Zeichenbeschreibung
// CE = CEDILLA
// GR = GRAVE
// AC = ACUTE
// CI = CIRCUMFLEX
// TI = TILDE
// DI = DIARESIS
// SL = SLASH
// RI = RING
// AE = AE
// TH = THORN
// C  = CAPITEL
// SZ = SHARP S
// PT = .
// _  = -

#define CCE 			"\xE7"
#define AAC 			"\xE1"
#define ACAC			"\xC1"
#define ADI 			"\xE4"
#define ACDI			"\xC4"
#define ARI 			"\xE5"
#define ATI 			"\xE3"
#define EAC 			"\xE9"
#define ECAC			"\xC9"
#define ODI 			"\xF6"
#define OSL 			"\xF8"
#define UCI 			"\xFB"
#define AE				"\xE6"
#define SZ				"\xDF"

// =======================================================================

// ---------
// - Texte -
// ---------

// Montag

static char const aMonday[] 		  = "Monday";
static char const aMontag[] 		  = "Montag";
static char const amandag[] 		  = "mandag";
static char const amaRIndag[]		  = "m" ARI "ndag";
static char const amaandag[]		  = "maandag";
static char const amaanantai[]		  = "maanantai";
static char const alundi[]			  = "lundi";
static char const alunes[]			  = "lunes";
static char const alunedi[] 		  = "lunedi";
static char const asegunda_feira[]	  = "segunda-feira";
static char const aMon[]			  = "Mon";
static char const aMo[] 			  = "Mo";
static char const amaa[]			  = "maa";
static char const ama[] 			  = "ma";
static char const amaRI[]			  = "m" ARI;
static char const alu[] 			  = "lu";
static char const alun[]			  = "lun";
static char const asegPT[]			  = "seg.";
static char const aLUN[]			  = "LUN";


// Dienstag

static char const aTuesday[]		  = "Tuesday";
static char const aDienstag[]		  = "Dienstag";
static char const atirsdag[]		  = "tirsdag";
static char const atisdag[] 		  = "tisdag";
static char const atiistai[]		  = "tiistai";
static char const adinsdag[]		  = "dinsdag";
static char const amardi[]			  = "mardi";
static char const amartes[] 		  = "martes";
static char const amartedi[]		  = "martedi";
static char const atercCEa_feira[]	  = "ter" CCE "a-feira";
static char const aTue[]			  = "Tue";
static char const aDi[] 			  = "Di";
static char const adin[]			  = "din";
static char const ati[] 			  = "ti";
static char const amar[]			  = "mar";
static char const aterPT[]			  = "ter.";
static char const aMAR[]			  = "MAR";


// Mittwoch

static char const aWednesday[]		  = "Wednesday";
static char const aMittwoch[]		  = "Mittwoch";
static char const aonsdag[] 		  = "onsdag";
static char const akeskiviikko[]	  = "keskiviikko";
static char const awoensdag[]		  = "woensdag";
static char const amercredi[]		  = "mercredi";
static char const amercoledi[]		  = "mercoledi";
static char const amieACrcoles[]	  = "mi" EAC "rcoles";
static char const aquarta_feira[]	  = "quarta-feira";
static char const aWed[]			  = "Wed";
static char const aMi[] 			  = "Mi";
static char const awoe[]			  = "woe";
static char const aon[] 			  = "on";
static char const ake[] 			  = "ke";
static char const ame[] 			  = "me";
static char const amer[]			  = "mer";
static char const amercrPT[]		  = "mercr.";
static char const aquaPT[]			  = "qua.";
static char const aMER[]			  = "MER";
static char const aMIECAC[] 		  = "MI" ECAC;


// Donnerstag

static char const aThursday[]		  = "Thursday";
static char const aDonnerstag[] 	  = "Donnerstag";
static char const atorsdag[]		  = "torsdag";
static char const atorstai[]		  = "torstai";
static char const adonderdag[]		  = "donderdag";
static char const ajeudi[]			  = "jeudi";
static char const ajueves[] 		  = "jueves";
static char const agiovedi[]		  = "giovedi";
static char const aquinta_feira[]	  = "quinta-feira";
static char const aThu[]			  = "Thu";
static char const aDo[] 			  = "Do";
static char const adon[]			  = "don";
static char const ato[] 			  = "to";
static char const aje[] 			  = "je";
static char const ajeu[]			  = "jeu";
static char const aquiPT[]			  = "qui.";
static char const aGIO[]			  = "GIO";
static char const aJUE[]			  = "JUE";


// Freitag

static char const aFriday[] 		  = "Friday";
static char const aFreitag[]		  = "Freitag";
static char const afredag[] 		  = "fredag";
static char const aperjantai[]		  = "perjantai";
static char const avrijdag[]		  = "vrijdag";
static char const avendredi[]		  = "vendredi";
static char const avenerdi[]		  = "venerdi";
static char const aviernes[]		  = "viernes";
static char const asexta_feira[]	  = "sexta-feira";
static char const aFri[]			  = "Fri";
static char const aFr[] 			  = "Fr";
static char const avri[]			  = "vri";
static char const afr[] 			  = "fr";
static char const ape[] 			  = "pe";
static char const ave[] 			  = "ve";
static char const aven[]			  = "ven";
static char const avendrPT[]		  = "vendr.";
static char const asexPT[]			  = "sex.";
static char const aVEN[]			  = "VEN";
static char const aVIE[]			  = "VIE";


// Samstag

static char const aSaturday[]		  = "Saturday";
static char const aSamstag[]		  = "Samstag";
static char const aloSLrdag[]		  = "l" OSL "rdag";
static char const aloDIrdag[]		  = "l" ODI "rdag";
static char const alauantai[]		  = "lauantai";
static char const azaterdag[]		  = "zaterdag";
static char const asamedi[] 		  = "samedi";
static char const asabato[] 		  = "sabato";
static char const asaACbado[]		  = "s" AAC "bado";
static char const aSat[]			  = "Sat";
static char const aSa[] 			  = "Sa";
static char const azat[]			  = "zat";
static char const aloSL[]			  = "l" OSL;
static char const aloDI[]			  = "l" ODI;
static char const ala[] 			  = "la";
static char const asa[] 			  = "sa";
static char const asam[]			  = "sam";
static char const asamPT[]			  = "sam.";
static char const asaACbPT[]		  = "s" AAC "b.";
static char const aSAB[]			  = "SAB";
static char const aSACACB[] 		  = "S" ACAC "B";


// Sonntag

static char const aSunday[] 		  = "Sunday";
static char const aSonntag[]		  = "Sonntag";
static char const asoSLndag[]		  = "s" OSL "ndag";
static char const asoDIndag[]		  = "s" ODI "ndag";
static char const asunnuntai[]		  = "sunnuntai";
static char const adimanche[]		  = "dimanche";
static char const adomingo[]		  = "domingo";
static char const adomenica[]		  = "domenica";
static char const azondag[] 		  = "zondag";
static char const aSun[]			  = "Sun";
static char const aSo[] 			  = "So";
static char const azon[]			  = "zon";
static char const asoSL[]			  = "s" OSL;
static char const asoDI[]			  = "s" ODI;
static char const asu[] 			  = "su";
static char const adi[] 			  = "di";
static char const adim[]			  = "dim";
static char const adimPT[]			  = "dim.";
static char const adomPT[]			  = "dom.";
static char const aDOM[]			  = "DOM";



// Januar

static char const aJanuary[]		  = "January";
static char const aJanuar[] 		  = "Januar";
static char const ajanuar[] 		  = "januar";
static char const ajanuari[]		  = "januari";
static char const ajanvier[]		  = "janvier";
static char const ajaneiro[]		  = "janeiro";
static char const agennaio[]		  = "gennaio";
static char const aenero[]			  = "enero";
static char const atammikuu[]		  = "tammikuu";
static char const aJan[]			  = "Jan";
static char const ajan[]			  = "jan";
static char const ajanvPT[] 		  = "janv.";
static char const atammi[]			  = "tammi";
static char const aJAN[]			  = "JAN";
static char const aGEN[]			  = "GEN";
static char const aENE[]			  = "ENE";


// Februar

static char const aFebruary[]		  = "February";
static char const aFebruar[]		  = "Februar";
static char const afebruar[]		  = "februar";
static char const afebruari[]		  = "februari";
static char const afeACvrier[]		  = "f" EAC "vrier";
static char const afebbraio[]		  = "febbraio";
static char const afebrero[]		  = "febrero";
static char const afevereiro[]		  = "fevereiro";
static char const ahelmikuu[]		  = "helmikuu";
static char const aFeb[]			  = "Feb";
static char const afeb[]			  = "feb";
static char const ahelmi[]			  = "helmi";
static char const afeACv[]			  = "f" EAC "v";
static char const afeACvrPT[]		  = "f" EAC "vr.";
static char const aFEB[]			  = "FEB";
static char const aFEV[]			  = "FEV";


// Maerz

static char const aMarch[]			  = "March";
static char const aMaDIrz[] 		  = "M" ADI "rz";
static char const amarts[]			  = "marts";
static char const amaart[]			  = "maart";
static char const amars[]			  = "mars";
static char const amarzo[]			  = "marzo";
static char const amarcCEo[]		  = "mar" CCE "o";
static char const amaaliskuu[]		  = "maaliskuu";
static char const aMar[]			  = "Mar";
static char const aMrz[]			  = "Mrz";
static char const amrt[]			  = "mrt";
static char const amaalis[] 		  = "maalis";


// April

static char const aApril[]			  = "April";
static char const aapril[]			  = "april";
static char const aavril[]			  = "avril";
static char const aaprile[] 		  = "aprile";
static char const aabril[]			  = "abril";
static char const ahuhtikuu[]		  = "huhtikuu";
static char const aApr[]			  = "Apr";
static char const aapr[]			  = "apr";
static char const aavr[]			  = "avr";
static char const aavrPT[]			  = "avr.";
static char const aAPR[]			  = "APR";
static char const aABR[]			  = "ABR";
static char const ahuhti[]			  = "huhti";


// Mai

static char const aMay[]			  = "May";
static char const aMai[]			  = "Mai";
static char const amaj[]			  = "maj";
static char const amai[]			  = "mai";
static char const amei[]			  = "mei";
static char const amaio[]			  = "maio";
static char const amayo[]			  = "mayo";
static char const amaggio[] 		  = "maggio";
static char const atoukokuu[]		  = "toukokuu";
static char const aMAG[]			  = "MAG";
static char const aMAI[]			  = "MAI";
static char const aMAY[]			  = "MAY";
static char const atouko[]			  = "touko";


// Juni

static char const aJune[]			  = "June";
static char const aJuni[]			  = "Juni";
static char const ajuni[]			  = "juni";
static char const ajuin[]			  = "juin";
static char const ajunho[]			  = "junho";
static char const ajunio[]			  = "junio";
static char const agiugno[] 		  = "giugno";
static char const akesaDIkuu[]		  = "kes" ADI "kuu";
static char const aJun[]			  = "Jun";
static char const ajun[]			  = "jun";
static char const aGIU[]			  = "GIU";
static char const aJUN[]			  = "JUN";
static char const akesaDI[] 		  = "kes" ADI;


// Juli

static char const aJuly[]			  = "July";
static char const aJuli[]			  = "Juli";
static char const ajuli[]			  = "juli";
static char const ajuillet[]		  = "juillet";
static char const ajulho[]			  = "julho";
static char const ajulio[]			  = "julio";
static char const aluglio[] 		  = "luglio";
static char const aheinaDIkuu[] 	  = "hein" ADI "kuu";
static char const aJul[]			  = "Jul";
static char const ajul[]			  = "jul";
static char const ajuilPT[] 		  = "juil.";
static char const aheinaDI[]		  = "hein" ADI;
static char const aLUG[]			  = "LUG";
static char const aJUL[]			  = "JUL";


// August

static char const aAugust[] 		  = "August";
static char const aaugust[] 		  = "august";
static char const aaugusti[]		  = "augusti";
static char const aaugustus[]		  = "augustus";
static char const aaouCIt[] 		  = "ao" UCI "t";
static char const aagosto[] 		  = "agosto";
static char const aelokuu[] 		  = "elokuu";
static char const aAug[]			  = "Aug";
static char const aaug[]			  = "aug";
static char const aaouCI[]			  = "ao" UCI;
static char const aelo[]			  = "elo";
static char const aAGO[]			  = "AGO";


// September

static char const aSeptember[]		  = "September";
static char const aseptember[]		  = "september";
static char const aseptembre[]		  = "septembre";
static char const asettembre[]		  = "settembre";
static char const asetembro[]		  = "setembro";
static char const aseptiembre[] 	  = "septiembre";
static char const asyyskuu[]		  = "syyskuu";
static char const aSep[]			  = "Sep";
static char const asep[]			  = "sep";
static char const aseptPT[] 		  = "sept.";
static char const asyys[]			  = "syys";
static char const aSET[]			  = "SET";
static char const aSEP[]			  = "SEP";


// Oktober

static char const aOctober[]		  = "October";
static char const aOktober[]		  = "Oktober";
static char const aoktober[]		  = "oktober";
static char const aoctobre[]		  = "octobre";
static char const aoctubre[]		  = "octubre";
static char const aottobre[]		  = "ottobre";
static char const aoutubro[]		  = "outubro";
static char const alokakuu[]		  = "lokakuu";
static char const aOct[]			  = "Oct";
static char const aOkt[]			  = "Okt";
static char const aokt[]			  = "okt";
static char const aoct[]			  = "oct";
static char const aoctPT[]			  = "oct.";
static char const aOTT[]			  = "OTT";
static char const aOUT[]			  = "OUT";
static char const aOCT[]			  = "OCT";
static char const aloka[]			  = "loka";


// November

static char const aNovember[]		  = "November";
static char const anovember[]		  = "november";
static char const anovembre[]		  = "novembre";
static char const anoviembre[]		  = "noviembre";
static char const anovembro[]		  = "novembro";
static char const amarraskuu[]		  = "marraskuu";
static char const aNov[]			  = "Nov";
static char const anov[]			  = "nov";
static char const anovPT[]			  = "nov.";
static char const amarras[] 		  = "marras";
static char const aNOV[]			  = "NOV";


// Dezember

static char const aDecember[]		  = "December";
static char const aDezember[]		  = "Dezember";
static char const adecember[]		  = "december";
static char const adeACcembre[] 	  = "d" EAC "cembre";
static char const adezembro[]		  = "dezembro";
static char const adicembre[]		  = "dicembre";
static char const adiciembre[]		  = "diciembre";
static char const ajoulukuu[]		  = "joulukuu";
static char const aDec[]			  = "Dec";
static char const aDez[]			  = "Dez";
static char const adec[]			  = "dec";
static char const adeACc[]			  = "d" EAC "c";
static char const adeACcPT[]		  = "d" EAC "c.";
static char const ajoulu[]			  = "joulu";
static char const aDIC[]			  = "DIC";
static char const aDEZ[]			  = "DEZ";



// Following
static char const ap[]				  = "p.";
static char const app[] 			  = "pp";
static char const af[]				  = "f.";
static char const aff[] 			  = "ff";
static char const aev[] 			  = "e.v.";
static char const aseg[]			  = "seg.";
static char const asegs[]			  = "segs.";
static char const asegg[]			  = "segg.";
static char const asuivante[]		  = "suivante";
static char const asuivantes[]		  = "suivantes";



// Datum/Uhrzeit

static char const aDateSep[]		  = ", ";
static char const aDateSep2[]		  = ". ";
static char const ade[] 			  = " de ";
static char const aAM[] 			  = " AM";
static char const aPM[] 			  = " PM";

// =======================================================================

static void ImplAssignText( UniString& rStr,
							const sal_Char* pCharBuf,
							rtl_TextEncoding eEncoding )
{
	rStr = UniString( pCharBuf, eEncoding );
}

// =======================================================================

static void ImplUpdateLanguageDanish( LanguageTable* pTable )
{
// !!!	  pTable->pCompareProc				  = ImplStdLanguageCompare;

	ImplAssignText( *(pTable->pFollowingText[ 0]),		af, 			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pFollowingText[ 1]),		aff,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			amandag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			atirsdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			aonsdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			atorsdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			afredag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			aloSLrdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			asoSLndag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		ama,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		ati,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		aon,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		ato,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		afr,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		aloSL,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		asoSL,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			ajanuar,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			afebruar,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			amarts, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			aapril, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			amaj,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			ajuni,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			ajuli,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aaugust,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			aseptember, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			aoktober,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			anovember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			adecember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	ajan,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	afeb,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	amar,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aapr,			RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevMonthText[ 4]) = *(pTable->pMonthText[4]);
	*(pTable->pAbbrevMonthText[ 5]) = *(pTable->pMonthText[5]);
	*(pTable->pAbbrevMonthText[ 6]) = *(pTable->pMonthText[6]);
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aaug,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	asep,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aokt,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	anov,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	adec,			RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkStart2 = QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd2	= QUOTATION_MARK;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageDutch( LanguageTable* pTable )
{
// !!!	  pTable->pCompareProc				  = ImplStdLanguageCompare;

	ImplAssignText( *(pTable->pFollowingText[ 0]),		aev,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pFollowingText[ 1]),		aev,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			amaandag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			adinsdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			awoensdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			adonderdag, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			avrijdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			azaterdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			azondag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		amaa,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		adin,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		awoe,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		adon,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		avri,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		azat,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		azon,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			ajanuari,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			afebruari,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			amaart, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			aapril, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			amei,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			ajuni,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			ajuli,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aaugustus,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			aseptember, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			aoktober,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			anovember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			adecember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	ajan,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	afeb,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	amrt,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aapr,			RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevMonthText[ 4]) = *(pTable->pMonthText[4]);
	ImplAssignText( *(pTable->pAbbrevMonthText[ 5]),	ajun,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	ajul,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aaug,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	asep,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aokt,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	anov,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	adec,			RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= SINGLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= DOUBLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkStart2 = QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd2	= QUOTATION_MARK;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageEnglish( LanguageTable* pTable )
{
// !!!	  pTable->pCompareProc				  = ImplStdLanguageCompare;

	ImplAssignText( *(pTable->pFollowingText[ 0]),		ap, 			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pFollowingText[ 1]),		app,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			aMonday,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			aTuesday,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			aWednesday, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			aThursday,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			aFriday,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			aSaturday,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			aSunday,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		aMon,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		aTue,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		aWed,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		aThu,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		aFri,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		aSat,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		aSun,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			aJanuary,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			aFebruary,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			aMarch, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			aApril, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			aMay,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			aJune,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			aJuly,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aAugust,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			aSeptember, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			aOctober,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			aNovember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			aDecember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	aJan,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	aFeb,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	aMar,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aApr,			RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevMonthText[ 4]) = *(pTable->pMonthText[4]);
	ImplAssignText( *(pTable->pAbbrevMonthText[ 5]),	aJun,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	aJul,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aAug,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	aSep,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aOct,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	aNov,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	aDec,			RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= SINGLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= DOUBLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkStart2 = QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd2	= QUOTATION_MARK;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageFinnish( LanguageTable* pTable )
{
// !!!	  pTable->pCompareProc				  = ImplStdLanguageCompare;

	// !!!
	ImplAssignText( *(pTable->pFollowingText[ 0]),		af, 			RTL_TEXTENCODING_MS_1252 );
	// !!!
	ImplAssignText( *(pTable->pFollowingText[ 1]),		aff,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			amaanantai, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			atiistai,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			akeskiviikko,	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			atorstai,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			aperjantai, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			alauantai,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			asunnuntai, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		ama,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		ati,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		ake,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		ato,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		ape,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		ala,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		asu,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			atammikuu,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			ahelmikuu,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			amaaliskuu, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			ahuhtikuu,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			atoukokuu,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			akesaDIkuu, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			aheinaDIkuu,	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aelokuu,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			asyyskuu,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			alokakuu,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			amarraskuu, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			ajoulukuu,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	atammi, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	ahelmi, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	amaalis,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	ahuhti, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 4]),	atouko, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 5]),	akesaDI,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	aheinaDI,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aelo,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	asyys,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aloka,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	amarras,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	ajoulu, 		RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkStart2 = QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd2	= QUOTATION_MARK;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageFrench( LanguageTable* pTable )
{
	pTable->pCompareProc				= ImplFrenchLanguageCompare;

	ImplAssignText( *(pTable->pFollowingText[ 0]),		asuivante,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pFollowingText[ 1]),		asuivantes, 	RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			alundi, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			amardi, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			amercredi,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			ajeudi, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			avendredi,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			asamedi,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			adimanche,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		alun,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		amar,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		amer,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		ajeu,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		aven,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		asam,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		adim,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			ajanvier,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			afeACvrier, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			amars,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			aavril, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			amai,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			ajuin,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			ajuillet,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aaouCIt,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			aseptembre, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			aoctobre,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			anovembre,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			adeACcembre,	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	ajan,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	afeACv, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	amar,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aavr,			RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevMonthText[ 4]) = *(pTable->pMonthText[4]);
	ImplAssignText( *(pTable->pAbbrevMonthText[ 5]),	ajun,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	ajul,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aaouCI, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	asep,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aoct,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	anov,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	adeACc, 		RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= SINGLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= LEFT_POINTING_GUILLEMET;
	pTable->meDoubleQuotationMarkEnd	= RIGHT_POINTING_GUILLEMET;
	pTable->meDoubleQuotationMarkStart2 = QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd2	= QUOTATION_MARK;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageFrenchCanadian( LanguageTable* pTable )
{
	// Vieles stimmt mit dem normalen Franzoesisch ueberein
	ImplUpdateLanguageFrench( pTable );

	*(pTable->pAbbrevDayText[0]) = *(pTable->pDayText[0]);
	*(pTable->pAbbrevDayText[1]) = *(pTable->pDayText[1]);
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		amercrPT,		RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevDayText[3]) = *(pTable->pDayText[3]);
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		avendrPT,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		asamPT, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		adimPT, 		RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	ajanvPT,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	afeACvrPT,		RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevMonthText[ 2]) = *(pTable->pMonthText[2]);
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aavrPT, 		RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevMonthText[ 4]) = *(pTable->pMonthText[4]);
	*(pTable->pAbbrevMonthText[ 5]) = *(pTable->pMonthText[5]);
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	ajuilPT,		RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevMonthText[ 7]) = *(pTable->pMonthText[7]);
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	aseptPT,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aoctPT, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	anovPT, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	adeACcPT,		RTL_TEXTENCODING_MS_1252 );
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageFrenchSwiss( LanguageTable* pTable )
{
	// Vieles stimmt mit dem normalen Franzoesisch ueberein
	ImplUpdateLanguageFrenchCanadian( pTable );

	ImplAssignText( *(pTable->pAbbrevDayText[0]),		alu,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		ama,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		ame,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		aje,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		ave,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		asa,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		adi,			RTL_TEXTENCODING_MS_1252 );
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageGerman( LanguageTable* pTable )
{
	pTable->pCompareProc				= ImplGermanLanguageCompare;

	*(pTable->pFollowingText[ 0]) = (xub_Unicode)'f';
	ImplAssignText( *(pTable->pFollowingText[ 1]),		aff,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			aMontag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			aDienstag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			aMittwoch,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			aDonnerstag,	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			aFreitag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			aSamstag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			aSonntag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		aMo,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		aDi,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		aMi,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		aDo,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		aFr,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		aSa,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		aSo,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			aJanuar,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			aFebruar,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			aMaDIrz,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			aApril, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			aMai,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			aJuni,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			aJuli,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aAugust,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			aSeptember, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			aOktober,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			aNovember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			aDezember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	aJan,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	aFeb,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	aMrz,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aApr,			RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevMonthText[ 4]) = *(pTable->pMonthText[4]);
	ImplAssignText( *(pTable->pAbbrevMonthText[ 5]),	aJun,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	aJul,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aAug,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	aSep,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aOkt,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	aNov,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	aDez,			RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= LOW_SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= LOW_DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd	= DOUBLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkStart2 = RIGHT_POINTING_GUILLEMET;
	pTable->meDoubleQuotationMarkEnd2	= LEFT_POINTING_GUILLEMET;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageItalian( LanguageTable* pTable )
{
// !!!	  pTable->pCompareProc				  = ImplStdLanguageCompare;

	ImplAssignText( *(pTable->pFollowingText[ 0]),		aseg,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pFollowingText[ 1]),		asegg,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			alunedi,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			amartedi,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			amercoledi, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			agiovedi,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			avenerdi,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			asabato,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			adomenica,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		aLUN,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		aMAR,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		aMER,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		aGIO,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		aVEN,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		aSAB,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		aDOM,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			agennaio,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			afebbraio,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			amarzo, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			aaprile,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			amaggio,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			agiugno,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			aluglio,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aagosto,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			asettembre, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			aottobre,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			anovembre,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			adicembre,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	aGEN,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	aFEB,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	aMAR,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aAPR,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 4]),	aMAG,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 5]),	aGIU,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	aLUG,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aAGO,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	aSET,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aOTT,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	aNOV,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	aDIC,			RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= SINGLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= DOUBLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkStart2 = QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd2	= QUOTATION_MARK;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageNorwegian( LanguageTable* pTable )
{
	// Monats und Tagesnamen stimmen mit dem daenischen ueberein
	ImplUpdateLanguageDanish( pTable );

// !!!	  pTable->pCompareProc				  = ImplStdLanguageCompare;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguagePortuguese( LanguageTable* pTable )
{
// !!!	  pTable->pCompareProc				  = ImplStdLanguageCompare;

	ImplAssignText( *(pTable->pFollowingText[ 0]),		aseg,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pFollowingText[ 1]),		asegs,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			asegunda_feira, RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			atercCEa_feira, RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			aquarta_feira,	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			aquinta_feira,	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			asexta_feira,	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			asaACbado,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			adomingo,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		asegPT, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		aterPT, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		aquaPT, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		aquiPT, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		asexPT, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		asaACbPT,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		adomPT, 		RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			ajaneiro,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			afevereiro, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			amarcCEo,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			aabril, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			amaio,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			ajunho, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			ajulho, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aagosto,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			asetembro,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			aoutubro,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			anovembro,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			adezembro,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	aJAN,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	aFEV,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	aMAR,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aABR,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 4]),	aMAI,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 5]),	aJUN,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	aJUL,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aAGO,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	aSET,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aOUT,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	aNOV,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	aDEZ,			RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= SINGLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= DOUBLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkStart2 = QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd2	= QUOTATION_MARK;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageSpanish( LanguageTable* pTable )
{
	pTable->pCompareProc				= ImplSpanishLanguageCompare;

	ImplAssignText( *(pTable->pFollowingText[ 0]),		aseg,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pFollowingText[ 1]),		asegs,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			alunes, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			amartes,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			amieACrcoles,	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			ajueves,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			aviernes,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			asaACbado,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			adomingo,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		aLUN,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		aMAR,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		aMIECAC,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		aJUE,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		aVIE,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		aSACACB,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		aDOM,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			aenero, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			afebrero,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			amarzo, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			aabril, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			amayo,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			ajunio, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			ajulio, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aagosto,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			aseptiembre,	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			aoctubre,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			anoviembre, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			adiciembre, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	aENE,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	aFEB,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	aMAR,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aABR,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 4]),	aMAY,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 5]),	aJUN,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	aJUL,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aAGO,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	aSEP,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aOCT,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	aNOV,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	aDIC,			RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= SINGLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= DOUBLE_TURNED_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkStart2 = QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd2	= QUOTATION_MARK;
}

// -----------------------------------------------------------------------

static void ImplUpdateLanguageSwedish( LanguageTable* pTable )
{
// !!!	  pTable->pCompareProc				  = ImplStdLanguageCompare;

	ImplAssignText( *(pTable->pFollowingText[ 0]),		af, 			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pFollowingText[ 1]),		aff,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pDayText[0]), 			amaRIndag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[1]), 			atisdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[2]), 			aonsdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[3]), 			atorsdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[4]), 			afredag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[5]), 			aloDIrdag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pDayText[6]), 			asoDIndag,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[0]),		amaRI,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[1]),		ati,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[2]),		aon,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[3]),		ato,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[4]),		afr,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[5]),		aloDI,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevDayText[6]),		asoDI,			RTL_TEXTENCODING_MS_1252 );

	ImplAssignText( *(pTable->pMonthText[ 0]),			ajanuari,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 1]),			afebruari,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 2]),			amars,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 3]),			aapril, 		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 4]),			amaj,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 5]),			ajuni,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 6]),			ajuli,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 7]),			aaugusti,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 8]),			aseptember, 	RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[ 9]),			aoktober,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[10]),			anovember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pMonthText[11]),			adecember,		RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 0]),	ajan,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 1]),	afeb,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 2]),	amar,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 3]),	aapr,			RTL_TEXTENCODING_MS_1252 );
	*(pTable->pAbbrevMonthText[ 4]) = *(pTable->pMonthText[4]);
	ImplAssignText( *(pTable->pAbbrevMonthText[ 5]),	ajun,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 6]),	ajul,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 7]),	aaug,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 8]),	asep,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[ 9]),	aokt,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[10]),	anov,			RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( *(pTable->pAbbrevMonthText[11]),	adec,			RTL_TEXTENCODING_MS_1252 );

	pTable->meQuotationMarkStart		= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkEnd			= SINGLE_COMMA_QUOTATION_MARK;
	pTable->meQuotationMarkStart2		= APOSTOPHE_QUOTE;
	pTable->meQuotationMarkEnd2 		= APOSTOPHE_QUOTE;
	pTable->meDoubleQuotationMarkStart	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd	= DOUBLE_COMMA_QUOTATION_MARK;
	pTable->meDoubleQuotationMarkStart2 = QUOTATION_MARK;
	pTable->meDoubleQuotationMarkEnd2	= QUOTATION_MARK;
}

// -----------------------------------------------------------------------

void ImplUpdateStandardLanguage( LanguageType eLanguage, LanguageTable* pTable )
{
	switch ( eLanguage )
	{
		case LANGUAGE_DANISH:
			ImplUpdateLanguageDanish( pTable );
			break;

		case LANGUAGE_DUTCH:
		case LANGUAGE_DUTCH_BELGIAN:
			ImplUpdateLanguageDutch( pTable );
			break;

		case LANGUAGE_ENGLISH:
		case LANGUAGE_ENGLISH_US:
		case LANGUAGE_ENGLISH_UK:
		case LANGUAGE_ENGLISH_AUS:
		case LANGUAGE_ENGLISH_CAN:
		case LANGUAGE_ENGLISH_NZ:
		case LANGUAGE_ENGLISH_EIRE:
		case LANGUAGE_ENGLISH_BELIZE:
		case LANGUAGE_ENGLISH_TRINIDAD:
		case LANGUAGE_ENGLISH_ZIMBABWE:
		case LANGUAGE_ENGLISH_PHILIPPINES:
			ImplUpdateLanguageEnglish( pTable );
			break;

		case LANGUAGE_FINNISH:
			ImplUpdateLanguageFinnish( pTable );
			break;

		case LANGUAGE_FRENCH:
		case LANGUAGE_FRENCH_BELGIAN:
		case LANGUAGE_FRENCH_MONACO:
			ImplUpdateLanguageFrench( pTable );
			break;

		case LANGUAGE_FRENCH_CANADIAN:
			ImplUpdateLanguageFrenchCanadian( pTable );
			break;

		case LANGUAGE_FRENCH_SWISS:
			ImplUpdateLanguageFrenchSwiss( pTable );
			break;

		case LANGUAGE_GERMAN:
		case LANGUAGE_GERMAN_SWISS:
		case LANGUAGE_GERMAN_AUSTRIAN:
			ImplUpdateLanguageGerman( pTable );
			break;

		case LANGUAGE_ITALIAN:
		case LANGUAGE_ITALIAN_SWISS:
			ImplUpdateLanguageItalian( pTable );
			break;

		case LANGUAGE_NORWEGIAN:
		case LANGUAGE_NORWEGIAN_BOKMAL:
			ImplUpdateLanguageNorwegian( pTable );
			break;

		case LANGUAGE_PORTUGUESE:
		case LANGUAGE_PORTUGUESE_BRAZILIAN:
			ImplUpdateLanguagePortuguese( pTable );
			break;

		case LANGUAGE_SPANISH:
		case LANGUAGE_SPANISH_MODERN:
			ImplUpdateLanguageSpanish( pTable );
			break;

		case LANGUAGE_SWEDISH:
			ImplUpdateLanguageSwedish( pTable );
			break;
	}
}

// =======================================================================

/*
static void ImplUpdateFormat( FormatTable* pTable )
{
	pTable->eWeekStart					= MONDAY;
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRSTDAY;
	pTable->eDateFormat 				= DMY;
	pTable->cDateSep					= '/';
	pTable->bDateDayLeadingZero 		= TRUE;
	pTable->bDateMonthLeadingZero		= TRUE;
	pTable->bDateCentury				= FALSE;
	pTable->eLongDateFormat 			= DMY;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_NONE;
	pTable->aLongDateDayOfWeekSep		= ' ';
	pTable->bLongDateDayLeadingZero 	= TRUE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_NORMAL;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bLongDateCentury			= TRUE;
	pTable->aLongDateYearSep			= ' ';
	pTable->eTimeFormat 				= HOUR_24;
	pTable->cTimeSep					= ':';
	pTable->cTime100SecSep				= '.';
	pTable->bTimeLeadingZero			= FALSE;
	pTable->aTimeAM 					= "";
	pTable->aTimePM 					= "";
	pTable->cNumThousandSep 			= ',';
	pTable->bNumThousandSep 			= TRUE;
	pTable->cNumDecimalSep				= '.';
	pTable->bNumLeadingZero 			= TRUE;
	pTable->nNumDigits					= 2;
	pTable->bNumTrailingZeros			= TRUE;
	pTable->nCurrPositiveFormat 		= 0;
	pTable->nCurrNegativeFormat 		= 1;
	pTable->nCurrDigits 				= 2;
	pTable->aCurrSymbol 				= '';
	pTable->aCurrBankSymbol 			= "";
	pTable->cListSep					= ';';
}
*/

// =======================================================================

static void ImplUpdateFormatLatinAmerica( FormatTable* pTable )
{
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ' ';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	ImplAssignText( pTable->aLongDateDaySep, ade, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	ImplAssignText( pTable->aLongDateMonthSep, ade, RTL_TEXTENCODING_MS_1252 );
	pTable->eTimeFormat 				= HOUR_12;
	ImplAssignText( pTable->aTimeAM,aAM, RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( pTable->aTimePM, aPM, RTL_TEXTENCODING_MS_1252 );
	pTable->nCurrNegativeFormat 		= 0;
	pTable->cListSep					= ',';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatSouthAfrica( FormatTable* pTable )
{
	pTable->eWeekStart					= SUNDAY;
	pTable->eDateFormat 				= YMD;
	pTable->cDateSep					= '/';
	pTable->eLongDateFormat 			= DMY;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_NONE;
	pTable->bLongDateDayLeadingZero 	= TRUE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->eTimeFormat 				= HOUR_12;
	pTable->bTimeLeadingZero			= TRUE;
	pTable->aTimePM.AssignAscii( "nm" );
	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 2;
	pTable->aCurrSymbol 				= 'R';
	pTable->aCurrBankSymbol.AssignAscii( "ZAR" );
	pTable->cListSep					= ';';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatArgentina( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->eWeekStart					= SUNDAY;
	pTable->eTimeFormat 				= HOUR_24;
	pTable->aCurrSymbol 				= '$';
	pTable->aCurrBankSymbol.AssignAscii( "ARS" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatEnglishAUS( FormatTable* pTable )
{
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	ImplAssignText( pTable->aLongDateDayOfWeekSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bNumLeadingZero 			= FALSE;
	pTable->aCurrSymbol 				= '$';
	pTable->aCurrBankSymbol.AssignAscii( "AUD" );
	pTable->cListSep					= ',';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatGermanAustrian( FormatTable* pTable )
{
	pTable->cDateSep					= '.';
	pTable->bDateCentury				= TRUE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	ImplAssignText( pTable->aLongDateDayOfWeekSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( pTable->aLongDateDaySep, aDateSep2, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 9;
	pTable->aCurrSymbol 				= 'S';
	pTable->aCurrBankSymbol.AssignAscii( "ATS" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatDutchBelgian( FormatTable* pTable )
{
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ' ';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol.AssignAscii( "BF" );
	pTable->aCurrBankSymbol.AssignAscii( "BEF" );
}

// -----------------------------------------------------------------------

inline void ImplUpdateFormatFrenchBelgian( FormatTable* pTable )
{
	ImplUpdateFormatDutchBelgian( pTable );
	pTable->aCurrSymbol.AssignAscii( "FB" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatPortugueseBrazilian( FormatTable* pTable )
{
	pTable->eWeekStart					= SUNDAY;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	ImplAssignText( pTable->aLongDateDayOfWeekSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->bLongDateDayLeadingZero 	= FALSE;
	ImplAssignText( pTable->aLongDateDaySep, ade, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	ImplAssignText( pTable->aLongDateMonthSep, ade, RTL_TEXTENCODING_MS_1252 );
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 9;
	pTable->aCurrSymbol.AssignAscii( "R$" );
	pTable->aCurrBankSymbol.AssignAscii( "BRC" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatEnglishCAN( FormatTable* pTable )
{
	pTable->eWeekStart					= SUNDAY;
	pTable->eLongDateFormat 			= MDY;
	pTable->bLongDateDayLeadingZero 	= FALSE;
	ImplAssignText( pTable->aLongDateDaySep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->eTimeFormat 				= HOUR_12;
	pTable->bTimeLeadingZero			= TRUE;
	ImplAssignText( pTable->aTimeAM, aAM, RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( pTable->aTimePM, aPM, RTL_TEXTENCODING_MS_1252 );
	pTable->aCurrSymbol 				= '$';
	pTable->aCurrBankSymbol.AssignAscii( "CAD" );
	pTable->cListSep					= ',';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatFrenchCanadian( FormatTable* pTable )
{
	pTable->eWeekStart					= SUNDAY;
	pTable->eDateFormat 				= YMD;
	pTable->cDateSep					= '-';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	ImplAssignText( pTable->aLongDateMonthSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= ' ';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol 				= '$';
	pTable->aCurrBankSymbol.AssignAscii( "CAD" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatCatalan( FormatTable* pTable )
{
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ',';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep.AssignAscii( " / " );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep.AssignAscii( " / " );
	pTable->bLongDateCentury			= TRUE;
	pTable->eTimeFormat 				= HOUR_24;
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->bNumTrailingZeros			= TRUE;
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->nCurrDigits 				= 0;
	pTable->aCurrSymbol.AssignAscii( "PTA" );
	pTable->aCurrBankSymbol.AssignAscii( "ESP" );
	pTable->cListSep					= ';';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatChile( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->eWeekStart					= SUNDAY;
	pTable->nCurrNegativeFormat 		= 11;
	pTable->aCurrSymbol.AssignAscii( "Ch$" );
	pTable->aCurrBankSymbol.AssignAscii( "CLP" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatColombia( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->eWeekStart					= SUNDAY;
	pTable->aCurrSymbol.AssignAscii( "C$" );
	pTable->aCurrBankSymbol.AssignAscii( "COP" );
}

// -----------------------------------------------------------------------
/*
static void ImplUpdateFormatCzech( FormatTable* pTable )
{
	pTable->cDateSep					= '.';
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->bDateMonthLeadingZero		= FALSE;
	pTable->bDateCentury				= TRUE;
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= '.';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	ImplAssignText( pTable->aLongDateMonthSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->bTimeLeadingZero			= TRUE;
	pTable->aTimeAM.AssignAscii( "dop." );
	pTable->aTimePM.AssignAscii( "odp." );
	pTable->cNumThousandSep 			= ' ';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol 				= aChech; // need UniCode
	pTable->aCurrBankSymbol.AssignAscii( "CZK" );
}
*/
// -----------------------------------------------------------------------

static void ImplUpdateFormatDanish( FormatTable* pTable )
{
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->cDateSep					= '-';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	ImplAssignText( pTable->aLongDateDaySep, aDateSep2, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 11;
	pTable->aCurrSymbol.AssignAscii( "kr" );
	pTable->aCurrBankSymbol.AssignAscii( "DKK" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatDutch( FormatTable* pTable )
{
	pTable->cDateSep					= '-';
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ' ';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 12;
	pTable->aCurrSymbol 				= 'F';
	pTable->aCurrBankSymbol.AssignAscii( "NLG" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatEnglishEIRE( FormatTable* pTable )
{
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->aCurrSymbol 				= static_cast< sal_Unicode >(0xA3);
	pTable->aCurrBankSymbol.AssignAscii( "IEP" );
	pTable->cListSep					= ',';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatEcuador( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->eWeekStart					= SUNDAY;
	pTable->nCurrNegativeFormat 		= 2;
	pTable->aCurrSymbol.AssignAscii( "S/" );
	pTable->aCurrBankSymbol.AssignAscii( "ECS" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatFinnish( FormatTable* pTable )
{
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->cDateSep					= '.';
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->bDateMonthLeadingZero		= FALSE;
	pTable->bDateCentury				= TRUE;
	pTable->bLongDateDayLeadingZero 	= FALSE;
	ImplAssignText( pTable->aLongDateDaySep, aDateSep2, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep.AssignAscii( "ta " );
	pTable->cNumThousandSep 			= ' ';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol.AssignAscii( "mk" );
	pTable->aCurrBankSymbol.AssignAscii( "FIM" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatFrench( FormatTable* pTable )
{
	pTable->bDateCentury				= TRUE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ' ';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= ' ';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol 				= 'F';
	pTable->aCurrBankSymbol.AssignAscii( "FRF" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatGerman( FormatTable* pTable )
{
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->cDateSep					= '.';
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	ImplAssignText( pTable->aLongDateDayOfWeekSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->bLongDateDayLeadingZero 	= FALSE;
	ImplAssignText( pTable->aLongDateDaySep, aDateSep2, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol.AssignAscii( "DM" );
	pTable->aCurrBankSymbol.AssignAscii( "DEM" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatGreece( FormatTable* pTable )
{
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->bDateMonthLeadingZero		= FALSE;
	pTable->bDateCentury				= TRUE;
	pTable->eLongDateFormat 			= DMY;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ',';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bLongDateCentury			= TRUE;
	pTable->eTimeFormat 				= HOUR_24;
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->bNumLeadingZero 			= FALSE;
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol.AssignAscii( "Drs" );
	pTable->aCurrBankSymbol.AssignAscii( "GRD" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatGuatemala( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->eWeekStart					= SUNDAY;
	pTable->aCurrSymbol 				= 'Q';
	pTable->aCurrBankSymbol.AssignAscii( "GTQ" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatHungary( FormatTable* pTable )
{
	pTable->eDateFormat 				= YMD;
	pTable->cDateSep					= '.';
	pTable->bDateCentury				= TRUE;
	pTable->eLongDateFormat 			= YMD;
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= '.';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bLongDateCentury			= TRUE;
	pTable->aLongDateYearSep			= '.';
	pTable->bTimeLeadingZero			= FALSE;
	pTable->aTimeAM.AssignAscii( " DE" );
	pTable->aTimePM.AssignAscii( " DU" );
	pTable->cNumThousandSep 			= ' ';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol.AssignAscii( "FT" );
	pTable->aCurrBankSymbol.AssignAscii( "HUF" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatIcelandic( FormatTable* pTable )
{
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->cDateSep					= '.';
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->bDateCentury				= TRUE;
	pTable->bLongDateDayLeadingZero 	= FALSE;
	ImplAssignText( pTable->aLongDateDaySep, aDateSep2, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	ImplAssignText( pTable->aLongDateMonthSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->bNumLeadingZero 			= FALSE;
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol.AssignAscii( "kr" );
	pTable->aCurrBankSymbol.AssignAscii( "ISK" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatIndonesian( FormatTable* pTable )
{
	pTable->bLongDateDayLeadingZero 	= TRUE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrNegativeFormat 		= 0;
	pTable->nCurrDigits 				= 0;
	pTable->aCurrSymbol.AssignAscii( "Rp" );
	pTable->aCurrBankSymbol.AssignAscii( "IDR" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatItalian( FormatTable* pTable )
{
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ' ';
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->cTimeSep					= '.';
	pTable->cTime100SecSep				= ':';
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 9;
	pTable->aCurrSymbol.AssignAscii( "L." );
	pTable->aCurrBankSymbol.AssignAscii( "ITL" );
	pTable->nCurrDigits 				= 0;
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatFrenchLuxembourg( FormatTable* pTable )
{
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ' ';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= ' ';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol 				= 'F';
	pTable->aCurrBankSymbol.AssignAscii( "LUF" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatGermanLuxembourg( FormatTable* pTable )
{
	ImplUpdateFormatFrenchLuxembourg( pTable );

	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->cDateSep					= '.';
	pTable->aLongDateDayOfWeekSep		= ',';
	pTable->aLongDateDaySep 			= '.';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatLiechtenstein( FormatTable* pTable )
{
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->cDateSep					= '.';
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ',';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= '.';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= ',';
	pTable->bNumThousandSep 			= FALSE;
	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 2;
	pTable->nCurrDigits 				= 2;
	pTable->aCurrSymbol.AssignAscii( "CHF" );
	pTable->aCurrBankSymbol.AssignAscii( "CHF" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatJamaica( FormatTable* pTable )
{
	pTable->eWeekStart					= SUNDAY;
	pTable->bDateCentury				= TRUE;
	pTable->eLongDateFormat 			= MDY;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ',';
	pTable->aLongDateDaySep 			= ',';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->eTimeFormat 				= HOUR_12;
	pTable->bTimeLeadingZero			= TRUE;
	ImplAssignText( pTable->aTimeAM, aAM, RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( pTable->aTimePM, aPM, RTL_TEXTENCODING_MS_1252 );
	pTable->aCurrSymbol.AssignAscii( "J$" );
	pTable->aCurrBankSymbol.AssignAscii( "JMD" );
	pTable->cListSep					= ',';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatJapan( FormatTable* pTable )
{
	pTable->eDateFormat 				= YMD;
	pTable->cDateSep					= '-';
	pTable->eLongDateFormat 			= YMD;
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bLongDateCentury			= TRUE;
	pTable->aLongDateYearSep			= ' ';
	pTable->cNumThousandSep 			= ',';
	pTable->cNumDecimalSep				= '.';
	pTable->nCurrDigits 				= 0;
	pTable->aCurrSymbol 				= static_cast< sal_Unicode >(0xA5);
	pTable->aCurrBankSymbol.AssignAscii( "JPY" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatMexico( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->eWeekStart					= SUNDAY;
	pTable->aCurrSymbol.AssignAscii( "N$" );
	pTable->aCurrBankSymbol.AssignAscii( "MXN" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatNorwegian( FormatTable* pTable )
{
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->cDateSep					= '.';
	ImplAssignText( pTable->aLongDateDaySep, aDateSep2, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 0;
	pTable->nCurrNegativeFormat 		= 3;
	pTable->aCurrSymbol.AssignAscii( "kr" );
	pTable->aCurrBankSymbol.AssignAscii( "NOK" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatEnglishNZ( FormatTable* pTable )
{
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	ImplAssignText( pTable->aLongDateDayOfWeekSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->aCurrSymbol 				= '$';
	pTable->aCurrBankSymbol.AssignAscii( "NZD" );
	pTable->cListSep					= ',';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatPanama( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->eWeekStart					= SUNDAY;
	pTable->aCurrSymbol 				= 'B';
	pTable->aCurrBankSymbol.AssignAscii( "PAB" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatParaguay( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->aCurrSymbol 				= 'G';
	pTable->aCurrBankSymbol.AssignAscii( "PYG" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatPeru( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->eWeekStart					= SUNDAY;
	pTable->nCurrNegativeFormat 		= 2;
	pTable->aCurrSymbol.AssignAscii( "S/" );
	pTable->aCurrBankSymbol.AssignAscii( "PES" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatPortuguese( FormatTable* pTable )
{
	pTable->cDateSep					= '-';
	pTable->bDateCentury				= TRUE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	ImplAssignText( pTable->aLongDateDayOfWeekSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->bLongDateDayLeadingZero 	= FALSE;
	ImplAssignText( pTable->aLongDateDaySep, ade, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	ImplAssignText( pTable->aLongDateMonthSep, ade, RTL_TEXTENCODING_MS_1252 );
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol.AssignAscii( "Esc." );
	pTable->aCurrBankSymbol.AssignAscii( "PTE" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatSpanish( FormatTable* pTable )
{
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	pTable->aLongDateDayOfWeekSep		= ' ';
	pTable->bLongDateDayLeadingZero 	= FALSE;
	ImplAssignText( pTable->aLongDateDaySep, ade, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	ImplAssignText( pTable->aLongDateMonthSep, ade, RTL_TEXTENCODING_MS_1252 );
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->bNumLeadingZero 			= FALSE;
	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 9;
	pTable->aCurrSymbol.AssignAscii( "Pts" );
	pTable->aCurrBankSymbol.AssignAscii( "ESP" );
	pTable->nCurrDigits 				= 0;
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatSwedish( FormatTable* pTable )
{
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->eDateFormat 				= YMD;
	pTable->cDateSep					= '-';
	pTable->bDateCentury				= TRUE;
	pTable->aLongDateDayOfWeekSep.AssignAscii( "den " );
	pTable->bLongDateDayLeadingZero 	= FALSE;
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->cTimeSep					= '.';
	pTable->cTime100SecSep				= ':';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= ' ';
	pTable->cNumDecimalSep				= ',';
	pTable->nCurrPositiveFormat 		= 3;
	pTable->nCurrNegativeFormat 		= 8;
	pTable->aCurrSymbol.AssignAscii( "kr" );
	pTable->aCurrBankSymbol.AssignAscii( "SEK" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatSwiss( FormatTable* pTable )
{
	pTable->eWeekCountStart 			= WEEKCOUNT_FIRST4DAYWEEK;
	pTable->cDateSep					= '.';
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	ImplAssignText( pTable->aLongDateDayOfWeekSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( pTable->aLongDateDaySep, aDateSep2, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->cNumThousandSep 			= '\'';
	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 11;
	pTable->aCurrSymbol.AssignAscii( "Fr." );
	pTable->aCurrBankSymbol.AssignAscii( "CHF" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatTurkey( FormatTable* pTable )
{
	pTable->eLongDateFormat 			= DMY;
	pTable->bLongDateDayLeadingZero 	= TRUE;
	pTable->aLongDateDaySep 			= '.';
	pTable->eLongDateMonthFormat		= MONTH_ZERO;
	pTable->aLongDateMonthSep			= '.';
	pTable->bLongDateCentury			= FALSE;
	pTable->cNumThousandSep 			= '.';
	pTable->cNumDecimalSep				= ',';
	pTable->aCurrSymbol.AssignAscii( "TL" );
	pTable->aCurrBankSymbol.AssignAscii( "TRL" );
	pTable->cListSep					= ';';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatEnglishUK( FormatTable* pTable )
{
	pTable->aLongDateDaySep 			= ' ';
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->bTimeLeadingZero			= TRUE;
	pTable->aCurrSymbol 				= static_cast< sal_Unicode >(0xA3);
	pTable->aCurrBankSymbol.AssignAscii( "GBP" );
	pTable->cListSep					= ',';
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatEnglishUS( FormatTable* pTable )
{
	pTable->eWeekStart					= SUNDAY;
	pTable->eDateFormat 				= MDY;
	pTable->bDateDayLeadingZero 		= FALSE;
	pTable->bDateMonthLeadingZero		= FALSE;
	pTable->eLongDateFormat 			= MDY;
	pTable->eLongDateDayOfWeekFormat	= DAYOFWEEK_LONG;
	ImplAssignText( pTable->aLongDateDayOfWeekSep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( pTable->aLongDateDaySep, aDateSep, RTL_TEXTENCODING_MS_1252 );
	pTable->eLongDateMonthFormat		= MONTH_LONG;
	pTable->aLongDateMonthSep			= ' ';
	pTable->eTimeFormat 				= HOUR_12;
	ImplAssignText( pTable->aTimeAM, aAM, RTL_TEXTENCODING_MS_1252 );
	ImplAssignText( pTable->aTimePM, aPM, RTL_TEXTENCODING_MS_1252 );
	pTable->bNumLeadingZero 			= FALSE;
	pTable->aCurrSymbol 				= '$';
	pTable->aCurrBankSymbol.AssignAscii( "USD" );
	pTable->cListSep					= ',';
	pTable->eMeasurementSystem			= MEASURE_US;
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatUruguay( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->nCurrPositiveFormat 		= 2;
	pTable->nCurrNegativeFormat 		= 0;
	pTable->aCurrSymbol.AssignAscii( "NU$" );
	pTable->aCurrBankSymbol.AssignAscii( "UYU" );
}

// -----------------------------------------------------------------------

static void ImplUpdateFormatVenezuela( FormatTable* pTable )
{
	ImplUpdateFormatLatinAmerica( pTable );

	pTable->eWeekStart					= SUNDAY;
	pTable->nCurrNegativeFormat 		= 11;
	pTable->aCurrSymbol.AssignAscii( "Bs" );
	pTable->aCurrBankSymbol.AssignAscii( "VEB" );
}

// -----------------------------------------------------------------------

void ImplUpdateStandardFormat( LanguageType eLanguage, FormatTable* pTable )
{
	switch ( eLanguage )
	{
		case LANGUAGE_AFRIKAANS:
			ImplUpdateFormatSouthAfrica( pTable );
			break;

		case LANGUAGE_SPANISH_ARGENTINA:
			ImplUpdateFormatArgentina( pTable );
			break;

		case LANGUAGE_ENGLISH_AUS:
			ImplUpdateFormatEnglishAUS( pTable );
			break;

		case LANGUAGE_GERMAN_AUSTRIAN:
			ImplUpdateFormatGermanAustrian( pTable );
			break;

		case LANGUAGE_DUTCH_BELGIAN:
			ImplUpdateFormatDutchBelgian( pTable );
			break;

		case LANGUAGE_FRENCH_BELGIAN:
			ImplUpdateFormatFrenchBelgian( pTable );
			break;

		case LANGUAGE_PORTUGUESE_BRAZILIAN:
			ImplUpdateFormatPortugueseBrazilian( pTable );
			break;

		case LANGUAGE_ENGLISH_CAN:
			ImplUpdateFormatEnglishCAN( pTable );
			break;

		case LANGUAGE_FRENCH_CANADIAN:
			ImplUpdateFormatFrenchCanadian( pTable );
			break;

		case LANGUAGE_SPANISH_CHILE:
			ImplUpdateFormatChile( pTable );
			break;

		case LANGUAGE_SPANISH_COLOMBIA:
			ImplUpdateFormatColombia( pTable );
			break;
/*
		case LANGUAGE_CZECH:
			ImplUpdateFormatCzech( pTable );
			break;
*/
		case LANGUAGE_DANISH:
			ImplUpdateFormatDanish( pTable );
			break;

		case LANGUAGE_DUTCH:
			ImplUpdateFormatDutch( pTable );
			break;

		case LANGUAGE_ENGLISH_EIRE:
			ImplUpdateFormatEnglishEIRE( pTable );
			break;

		case LANGUAGE_SPANISH_ECUADOR:
			ImplUpdateFormatEcuador( pTable );
			break;

		case LANGUAGE_FINNISH:
			ImplUpdateFormatFinnish( pTable );
			break;

		case LANGUAGE_FRENCH:
			ImplUpdateFormatFrench( pTable );
			break;

		case LANGUAGE_GERMAN:
			ImplUpdateFormatGerman( pTable );
			break;

		case LANGUAGE_GREEK:
			ImplUpdateFormatGreece( pTable );
			break;

		case LANGUAGE_SPANISH_GUATEMALA:
			ImplUpdateFormatGuatemala( pTable );
			break;

		case LANGUAGE_HUNGARIAN:
			ImplUpdateFormatHungary( pTable );
			break;

		case LANGUAGE_ICELANDIC:
			ImplUpdateFormatIcelandic( pTable );
			break;

		case LANGUAGE_INDONESIAN:
			ImplUpdateFormatIndonesian( pTable );
			break;

		case LANGUAGE_ITALIAN:
			ImplUpdateFormatItalian( pTable );
			break;

		case LANGUAGE_FRENCH_LUXEMBOURG:
			ImplUpdateFormatFrenchLuxembourg( pTable );
			break;
		case LANGUAGE_GERMAN_LUXEMBOURG:
			ImplUpdateFormatGermanLuxembourg( pTable );
			break;

		case LANGUAGE_GERMAN_LIECHTENSTEIN:
			ImplUpdateFormatLiechtenstein( pTable );
			break;

		case LANGUAGE_ENGLISH_JAMAICA:
			ImplUpdateFormatJamaica( pTable );
			break;

		case LANGUAGE_JAPANESE:
			ImplUpdateFormatJapan( pTable );
			break;

		case LANGUAGE_SPANISH_MEXICAN:
			ImplUpdateFormatMexico( pTable );
			break;

		case LANGUAGE_NORWEGIAN:
		case LANGUAGE_NORWEGIAN_BOKMAL:
		case LANGUAGE_NORWEGIAN_NYNORSK:
			ImplUpdateFormatNorwegian( pTable );
			break;

		case LANGUAGE_ENGLISH_NZ:
			ImplUpdateFormatEnglishNZ( pTable );
			break;

		case LANGUAGE_SPANISH_PANAMA:
			ImplUpdateFormatPanama( pTable );
			break;

		case LANGUAGE_SPANISH_PARAGUAY:
			ImplUpdateFormatParaguay( pTable );
			break;

		case LANGUAGE_SPANISH_PERU:
			ImplUpdateFormatPeru( pTable );
			break;

		case LANGUAGE_PORTUGUESE:
			ImplUpdateFormatPortuguese( pTable );
			break;

		case LANGUAGE_SPANISH:
		case LANGUAGE_SPANISH_MODERN:
			ImplUpdateFormatSpanish( pTable );
			break;
		case LANGUAGE_CATALAN:
			ImplUpdateFormatCatalan( pTable );
			break;

		case LANGUAGE_SWEDISH:
			ImplUpdateFormatSwedish( pTable );
			break;

		case LANGUAGE_FRENCH_SWISS:
		case LANGUAGE_GERMAN_SWISS:
		case LANGUAGE_ITALIAN_SWISS:
			ImplUpdateFormatSwiss( pTable );
			break;

		case LANGUAGE_TURKISH:
			ImplUpdateFormatTurkey( pTable );
			break;

		case LANGUAGE_ENGLISH_UK:
			ImplUpdateFormatEnglishUK( pTable );
			break;

		case LANGUAGE_ENGLISH_US:
			ImplUpdateFormatEnglishUS( pTable );
			break;

		case LANGUAGE_SPANISH_URUGUAY:
			ImplUpdateFormatUruguay( pTable );
			break;

		case LANGUAGE_SPANISH_VENEZUELA:
			ImplUpdateFormatVenezuela( pTable );
			break;
	}
}
