/*************************************************************************
 *
 *  $RCSfile: VCLWindow.h,v $
 *
 *  $Revision: 1.25 $
 *
 *  last change: $Author: pluby $ $Date: 2000/12/22 21:27:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *	 - GNU Lesser General Public License Version 2.1
 *	 - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_VCLWINDOW_H
#define _SV_VCLWINDOW_H

typedef void *VCLWINDOW;

#ifndef _SV_SALFRAME_HXX
#include <salframe.hxx>
#endif

#ifndef _SV_VCLVIEW_H
#include <VCLView.h>
#endif

#ifndef __cplusplus

#include <premac.h>
#import <AppKit/AppKit.h>
#include <postmac.h>

// -------------
// - VCLWindow -
// -------------

@interface VCLWindow : NSWindow
{   
@public
	// Important: these data members must be explicitly set before using this
	// class. Otherwise, none of the rest of the methods in this class will
	// work properly.
	SalFrame				*mpSalFrame;
	struct SalFrameData		*mpSalFrameData;
}
- (void)setContentSize: (NSSize)aSize;
- (void)windowDidBecomeKey: (NSNotification *)aNotification;
- (void)windowDidResignKey: (NSNotification *)aNotification;
- (MacOSBOOL)windowShouldClose: (id)sender;
- (NSSize)windowWillResize: (NSWindow *)sender toSize: (NSSize)proposedFrameSize;
@end

#endif // ! __cplusplus

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

// -----------------------
// - C wrapper functions -
// -----------------------

// Instantiate a native VCLWindow.
VCLWINDOW VCLWindow_New( ULONG nSalFrameStyle, VCLWINDOW hParentWindow,
	SalFrame *pFrame, struct SalFrameData *pFrameData );
  
// Get VCLWindow contentView
VCLVIEW VCLWindow_ContentView( VCLWINDOW hWindow );
 
// Display VCLWindow
void VCLWindow_Show( VCLWINDOW hWindow );
 
// Hide VCLWindow
void VCLWindow_Close( VCLWINDOW hWindow );
 
// Release a native VCLWindow
void VCLWindow_Release( VCLWINDOW hWindow );

// Set the title for VCLWindow
void VCLWindow_SetTitle( VCLWINDOW hWindow, const char *pTitle );

// Set the size of a VCLWindow
void VCLWindow_SetSize( VCLWINDOW hWindow, long nWidth, long nHeight );

// Post an NSApplicationDefined event to the event queue
BOOL VCLWindow_PostEvent( VCLWINDOW hWindow, void *pData );

// Sound a beep
void VCLWindow_Beep();

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _SV_VCLWINDOW_H
