/*************************************************************************
 *
 *  $RCSfile: salfontutils.cxx,v $
 *
 *  $Revision: 1.6 $
 *  last change: $Author: rt $ $Date: 2004/03/30 13:41:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2001 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// =======================================================================

// =======================================================================

#ifndef _SV_SALATSUIFONTUTILS_HXX
	#include <salatsuifontutils.hxx>
#endif

#ifndef _SV_SALFONTUTILS_HXX
	#include <salfontutils.hxx>
#endif

// =======================================================================

// =======================================================================

static rtl_Script GetRTLScriptFromFontScriptCode( const FontNameEncodingPtr pFontNameEncoding )
{
	FontScriptCode    nFontScriptCode   = pFontNameEncoding->mnFontScriptCode;
	FontPlatformCode  nFontPlatformCode = pFontNameEncoding->mnFontPlatformCode;
	rtl_Script        nFontRTLScript    = SCRIPT_DONTKNOW;

	if ( nFontPlatformCode == kFontUnicodePlatform )
	{
		nFontRTLScript = SCRIPT_UNICODE;
	} // if
	else
	{
		switch( nFontScriptCode )
		{
			case kFontRomanScript:
				nFontRTLScript = SCRIPT_LATIN;
				break;

			case kFontJapaneseScript:
				nFontRTLScript = SCRIPT_JAPANESE;
				break;

			case kFontTraditionalChineseScript:
				nFontRTLScript = SCRIPT_CHINESE_TRADITIONAL;
				break;

			case kFontKoreanScript:
				nFontRTLScript = SCRIPT_KOREAN;
				break;

			case kFontArabicScript:
				nFontRTLScript = SCRIPT_ARABIC;
				break;

			case kFontHebrewScript:
				nFontRTLScript = SCRIPT_HEBREW;
				break;

			case kFontGreekScript:
				nFontRTLScript = SCRIPT_GREEK;
				break;

			case kFontCyrillicScript:
				nFontRTLScript = SCRIPT_CYRILLIC;
				break;

			case kFontRSymbolScript:
				nFontRTLScript = SCRIPT_SYMBOL;
				break;

			case kFontDevanagariScript:
				nFontRTLScript = SCRIPT_DEVANAGARI;
				break;

			case kFontGurmukhiScript:
				nFontRTLScript = SCRIPT_GURMUKHI;
				break;

			case kFontGujaratiScript:
				nFontRTLScript = SCRIPT_GUJARATI;
				break;

			case kFontOriyaScript:
				nFontRTLScript = SCRIPT_ORIYA;
				break;

			case kFontBengaliScript:
				nFontRTLScript = SCRIPT_BENGALI;
				break;

			case kFontTamilScript:
				nFontRTLScript = SCRIPT_TAMIL;
				break;

			case kFontTeluguScript:
				nFontRTLScript = SCRIPT_TELUGU;
				break;

			case kFontKannadaScript:
				nFontRTLScript = SCRIPT_KANNADA;
				break;

			case kFontMalayalamScript:
				nFontRTLScript = SCRIPT_MALAYALAM;
				break;

			case kFontSinhaleseScript:
				nFontRTLScript = SCRIPT_DONTKNOW;
				break;

			case kFontBurmeseScript:
				nFontRTLScript = SCRIPT_DONTKNOW;
				break;

			case kFontKhmerScript:
				nFontRTLScript = SCRIPT_DONTKNOW;
				break;

			case kFontThaiScript:
				nFontRTLScript = SCRIPT_THAI;
				break;

			case kFontLaotianScript:
				nFontRTLScript = SCRIPT_LAO;
				break;

			case kFontGeorgianScript:
				nFontRTLScript = SCRIPT_GEORGIEN;
				break;

			case kFontArmenianScript:
				nFontRTLScript = SCRIPT_ARMENIAN;
				break;

			case kFontSimpleChineseScript:
				nFontRTLScript = SCRIPT_CHINESE_SIMPLIFIED;
				break;

			case kFontTibetanScript:
				nFontRTLScript = SCRIPT_DONTKNOW;
				break;

			case kFontMongolianScript:
				nFontRTLScript = SCRIPT_DONTKNOW;
				break;

			case kFontGeezScript:
				nFontRTLScript = SCRIPT_DONTKNOW;
				break;

			case kFontEastEuropeanRomanScript:
				nFontRTLScript = SCRIPT_EASTEUROPE;
				break;

			case kFontVietnameseScript:
				nFontRTLScript = SCRIPT_VIETNAMESE;
				break;

			case kFontExtendedArabicScript:
				nFontRTLScript = SCRIPT_DONTKNOW;
				break;

			case kFontUninterpretedScript:
				nFontRTLScript = SCRIPT_DONTKNOW;
				break;

			default:
				nFontRTLScript = SCRIPT_DONTKNOW;
				break;
		} // switch
	} // else

	return  nFontRTLScript;
} // GetRTLScriptFromFontScriptCode

// -----------------------------------------------------------------------

static FontWeight GetFontWeightFromFontNamesRecord( const FontNamesPtr pFontName )
{
	FontWeight  nFontWeight;

	if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightThin1 ) != NULL )
	     || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightThin2 ) != NULL )
	   )
	{
		nFontWeight = WEIGHT_THIN;
	} //if
	else if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightNormal1  ) != NULL )
	          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightNormal2  ) != NULL )
	          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightRoman1   ) != NULL )
	          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightRoman2   ) != NULL )
	          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightRegular1 ) != NULL )
	          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightRegular2 ) != NULL )
	        )
	{
		nFontWeight = WEIGHT_NORMAL;
	} // else if
	else if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightMedium1 ) != NULL )
	          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightMedium2 ) != NULL )
	        )
	{
		nFontWeight = WEIGHT_MEDIUM;
	} // else if
	else if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightBlack1 ) != NULL )
	          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightBlack2 ) != NULL )
	        )
	{
		nFontWeight = WEIGHT_BLACK;
	} // else if
	else if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightLight1 ) != NULL )
	          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightLight2 ) != NULL )
	        )
	{
		if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightUltra1 ) != NULL )
		     || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightUltra2 ) != NULL )
		   )
		{
			nFontWeight = WEIGHT_ULTRALIGHT;
		} // else if
		else if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightSemi1 ) != NULL )
		          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightSemi2 ) != NULL )
		        )
		{
			nFontWeight = WEIGHT_SEMILIGHT;
		} // else if
		else
		{
			nFontWeight = WEIGHT_LIGHT;
		} // else
	} // else if
	else if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightBold1 ) != NULL )
	          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightBold2 ) != NULL )
	        )
	{
		if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightUltra1 ) != NULL )
		     || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightUltra2 ) != NULL )
		   )
		{
			nFontWeight = WEIGHT_ULTRABOLD;
		} // else if
		else if (    ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightSemi1 ) != NULL )
		          || ( strstr( &pFontName->mpFontName[ 0 ], kFontWeightSemi2 ) != NULL )
		        )
		{
			nFontWeight = WEIGHT_SEMIBOLD;
		} // else if
		else
		{
			nFontWeight = WEIGHT_BOLD;
		} // else
	} // else if
	else
	{
		nFontWeight = WEIGHT_DONTKNOW;
	} // else

	return  nFontWeight;
} // GetFontWieghtFromFontNamesRecord

// -----------------------------------------------------------------------

FontList *GetMacFontList()
{
	FontList *pList = NULL;

	pList = new FontList;

	if ( pList != NULL )
	{
		FontNamesMatrix   hFontList       = NULL;
		ItemCount         nFontListLength = 0;

		hFontList = ATSUIGetFontNames( &nFontListLength );

		if ( hFontList != NULL )
		{
			short          nItem      = 1;
			ImplFontData  *pData      = NULL;
			ImplFontData  *pCompare   = NULL;
			ULONG          nInsertPos = 0;
			char           pFontFamilyName[kFontFamilyNameLength];
			char           pFontStyleName[kFontStyleNameLength];

			for ( nItem = 1; 
			      nItem <= nFontListLength; 
			      nItem++ 
			    )
			{
				pData = new ImplFontData;
				
				memset( pFontFamilyName, 0, kFontFamilyNameMemSize );
				memset( pFontStyleName,  0, kFontStyleNameMemSize  );

				// Font name

				strncpy(   pFontFamilyName, 
				          &hFontList[ nItem ]->mpFontName[ 0 ],
				           hFontList[ nItem ]->mnFontStyleByteOffset
				       );
					   
				pData->maName = UniString( pFontFamilyName, 
				                           strlen(pFontFamilyName) 
				                         );
	
				// Font style

				snprintf(  pFontStyleName, kFontStyleNameLength, "%s",
				        &hFontList[ nItem ]->mpFontName[ hFontList[ nItem ]->mnFontStyleByteOffset ] 
				      );

				pData->maStyleName = UniString( pFontStyleName, 
				                                strlen(pFontStyleName) 
				                              );

				// Convert Mac OS font script code to that of RTL script code 

				pData->meScript 
					= GetRTLScriptFromFontScriptCode( &(hFontList[ nItem ]->maFontFamilyNameEncoding) );

				// Convert Mac OS font weight to that of SAL weight

				pData->meWeight
					= GetFontWeightFromFontNamesRecord( hFontList[ nItem ] );

				pData->mpSysData     = NULL;			// System-Data (only GSL)
				pData->mnWidth       = 0;			// Font width in pixels
				pData->mnHeight      = 0;			// Font height in pixels
				pData->meFamily      = FAMILY_DONTKNOW;		// Font family
				pData->meCharSet     = 0;			// Font character set
				pData->mePitch       = PITCH_DONTKNOW;		// Font pitch
				pData->meWidthType   = WIDTH_NORMAL;		// Font weight type
				pData->meWeight      = WEIGHT_NORMAL;		// Font weight
				pData->meItalic      = ITALIC_NONE;		// If font is italic
				pData->meType        = TYPE_DONTKNOW;		// Font type
				pData->mbOrientation = FALSE;			// Fonts orientation
				pData->mbDevice      = TRUE;			// Device font
				pData->mnQuality     = 0;			// Font quality

				nInsertPos = nItem - 1;

				while ( nInsertPos )
				{
					pCompare = pList->GetObject( nInsertPos - 1 );

					if ( pCompare->maName > pData->maName )
					{
						nInsertPos -= 1;
					} // if
					else
					{
						break;
					} // else
				} // while

				pList->Insert( pData, nInsertPos );
			} // for
	
			ATSUIDisposeFontNames( nFontListLength, hFontList );

		} // if
	} // if

	return pList;
} // GetMacFontList

// =======================================================================

// =======================================================================
