/*************************************************************************
 *
 *  $RCSfile: fontcfg.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/13 17:33:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _VCL_FONTCFG_HXX
#define _VCL_FONTCFG_HXX

#ifndef _VCL_DLLAPI_H
#include "dllapi.h"
#endif

#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _VCL_ENUM_HXX
#include <vclenum.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
#include <com/sun/star/lang/Locale.hpp>
#endif

#include <hash_map>
#include <vector>

namespace com {
namespace sun {
namespace star {
namespace lang {

// equality operator needed for hash_map;
// (-> why does this need to be in the namespace of Locale ? g++ fails to compile else)
inline bool operator==( const com::sun::star::lang::Locale& rLeft, const com::sun::star::lang::Locale& rRight )
{
    return
        rLeft.Language.equals( rRight.Language ) &&
        rLeft.Country.equals( rRight.Country )  &&
        rLeft.Variant.equals( rRight.Variant )
        ;
}
}}}}

namespace vcl
{

struct LocaleHash
{
    size_t operator()( const com::sun::star::lang::Locale& rLocale ) const
    {
        return
            (size_t)rLocale.Language.hashCode() ^
            (size_t)rLocale.Country.hashCode()  ^
            (size_t)rLocale.Variant.hashCode();
    }
};

class VCL_DLLPUBLIC DefaultFontConfigItem : public ::utl::ConfigItem
{

    std::hash_map< com::sun::star::lang::Locale , std::hash_map< int, rtl::OUString >, vcl::LocaleHash >		m_aDefaults;

    virtual void Notify( const com::sun::star::uno::Sequence< rtl::OUString >& rPropertyNames );
    virtual void Commit();

    void getValues();
    static int getKeyType( const rtl::OUString& rKey );
    DefaultFontConfigItem();
public:
    virtual ~DefaultFontConfigItem();

    static DefaultFontConfigItem* get();

    const rtl::OUString& getDefaultFont( const com::sun::star::lang::Locale& rLocale, int nType ) const;
    const rtl::OUString& getUserInterfaceFont( const com::sun::star::lang::Locale& rLocale ) const;

    void setDefaultFont( const com::sun::star::lang::Locale& rLocale, int nType, const rtl::OUString& rName );
};


// IMPL_FONT_ATTR_DEFAULT       - Default-Font like Andale Sans UI, Palace Script, Albany, Thorndale, Cumberland, ...
// IMPL_FONT_ATTR_STANDARD      - Standard-Font like Arial, Times, Courier, ...
// IMPL_FONT_ATTR_NORMAL        - normal Font for writing text like Arial, Verdana, Arial Narrow, Trebuchet, Times, Courier, ...
// IMPL_FONT_ATTR_SYMBOL        - Font with symbols
// IMPL_FONT_ATTR_DECORATIVE    - Readable and normally used for drawings
// IMPL_FONT_ATTR_SPECIAL       - very special design
// IMPL_FONT_ATTR_TITLING       - only uppercase characters
// IMPL_FONT_ATTR_FULL          - Font with normally all characters
// IMPL_FONT_ATTR_CAPITALS     - only uppercase characters, but lowercase characters smaller as the uppercase characters
// IMPL_FONT_ATTR_TYPEWRITER    - like a typewriter: Courier, ...
// IMPL_FONT_ATTR_SCRIPT        - Handwriting or Script
// IMPL_FONT_ATTR_HANDWRITING   - More Handwriting with normal letters
// IMPL_FONT_ATTR_CHANCERY      - Like Zapf Chancery
// IMPL_FONT_ATTR_COMIC         - Like Comic Sans MS
// IMPL_FONT_ATTR_BRUSHSCRIPT   - More Script
// IMPL_FONT_ATTR_OTHERSTYLE    - OldStyle, ... so negativ points
#define IMPL_FONT_ATTR_DEFAULT       ((ULONG)0x00000001)
#define IMPL_FONT_ATTR_STANDARD      ((ULONG)0x00000002)
#define IMPL_FONT_ATTR_NORMAL        ((ULONG)0x00000004)
#define IMPL_FONT_ATTR_SYMBOL        ((ULONG)0x00000008)
#define IMPL_FONT_ATTR_FIXED         ((ULONG)0x00000010)
#define IMPL_FONT_ATTR_SANSSERIF     ((ULONG)0x00000020)
#define IMPL_FONT_ATTR_SERIF         ((ULONG)0x00000040)
#define IMPL_FONT_ATTR_DECORATIVE    ((ULONG)0x00000080)
#define IMPL_FONT_ATTR_SPECIAL       ((ULONG)0x00000100)
#define IMPL_FONT_ATTR_ITALIC        ((ULONG)0x00000200)
#define IMPL_FONT_ATTR_TITLING       ((ULONG)0x00000400)
#define IMPL_FONT_ATTR_CAPITALS      ((ULONG)0x00000800)
#define IMPL_FONT_ATTR_CJK           ((ULONG)0x00001000)
#define IMPL_FONT_ATTR_CJK_JP        ((ULONG)0x00002000)
#define IMPL_FONT_ATTR_CJK_SC        ((ULONG)0x00004000)
#define IMPL_FONT_ATTR_CJK_TC        ((ULONG)0x00008000)
#define IMPL_FONT_ATTR_CJK_KR        ((ULONG)0x00010000)
#define IMPL_FONT_ATTR_CTL           ((ULONG)0x00020000)
#define IMPL_FONT_ATTR_NONELATIN     ((ULONG)0x00040000)
#define IMPL_FONT_ATTR_FULL          ((ULONG)0x00080000)
#define IMPL_FONT_ATTR_OUTLINE       ((ULONG)0x00100000)
#define IMPL_FONT_ATTR_SHADOW        ((ULONG)0x00200000)
#define IMPL_FONT_ATTR_ROUNDED       ((ULONG)0x00400000)
#define IMPL_FONT_ATTR_TYPEWRITER    ((ULONG)0x00800000)
#define IMPL_FONT_ATTR_SCRIPT        ((ULONG)0x01000000)
#define IMPL_FONT_ATTR_HANDWRITING   ((ULONG)0x02000000)
#define IMPL_FONT_ATTR_CHANCERY      ((ULONG)0x04000000)
#define IMPL_FONT_ATTR_COMIC         ((ULONG)0x08000000)
#define IMPL_FONT_ATTR_BRUSHSCRIPT   ((ULONG)0x10000000)
#define IMPL_FONT_ATTR_GOTHIC        ((ULONG)0x20000000)
#define IMPL_FONT_ATTR_SCHOOLBOOK    ((ULONG)0x40000000)
#define IMPL_FONT_ATTR_OTHERSTYLE    ((ULONG)0x80000000)

#define IMPL_FONT_ATTR_CJK_ALLLANG   (IMPL_FONT_ATTR_CJK_JP | IMPL_FONT_ATTR_CJK_SC | IMPL_FONT_ATTR_CJK_TC | IMPL_FONT_ATTR_CJK_KR)
#define IMPL_FONT_ATTR_ALLSCRIPT     (IMPL_FONT_ATTR_SCRIPT | IMPL_FONT_ATTR_HANDWRITING | IMPL_FONT_ATTR_CHANCERY | IMPL_FONT_ATTR_COMIC | IMPL_FONT_ATTR_BRUSHSCRIPT)
#define IMPL_FONT_ATTR_ALLSUBSCRIPT  (IMPL_FONT_ATTR_HANDWRITING | IMPL_FONT_ATTR_CHANCERY | IMPL_FONT_ATTR_COMIC | IMPL_FONT_ATTR_BRUSHSCRIPT)
#define IMPL_FONT_ATTR_ALLSERIFSTYLE (IMPL_FONT_ATTR_ALLSCRIPT |\
                                      IMPL_FONT_ATTR_SANSSERIF | IMPL_FONT_ATTR_SERIF |\
                                      IMPL_FONT_ATTR_FIXED | IMPL_FONT_ATTR_ITALIC |\
                                      IMPL_FONT_ATTR_GOTHIC | IMPL_FONT_ATTR_SCHOOLBOOK |\
                                      IMPL_FONT_ATTR_SHADOW | IMPL_FONT_ATTR_OUTLINE)

struct FontNameAttr
{
    String								Name;
    ::std::vector< String >				Substitutions;
    ::std::vector< String >				MSSubstitutions;
    ::std::vector< String >				PSSubstitutions;
    ::std::vector< String >				HTMLSubstitutions;
    FontWeight							Weight;
    FontWidth							Width;
    unsigned long						Type; // bitfield of IMPL_FONT_ATTR_*
};

class VCL_DLLPUBLIC FontSubstConfigItem : public ::utl::ConfigItem
{
private:

    // note: m_aSubstitutions must be sorted alphabetically by Name
    // searches on the substitutes are done with Name as key, where
    // a minimal match is sufficient (that is e.g. "Thorndale" will match
    // "Thorndale BlaBlub"). Also names must be lower case.
    std::hash_map< com::sun::star::lang::Locale, std::vector< FontNameAttr >, vcl::LocaleHash > m_aSubstitutions;

    virtual void Notify( const com::sun::star::uno::Sequence< rtl::OUString >& rPropertyNames );
    virtual void Commit();

    void getValues();
    FontSubstConfigItem();
public:
    virtual ~FontSubstConfigItem();

    static FontSubstConfigItem* get();

    const FontNameAttr* getSubstInfo(
                                     const String& rFontName,
                                     const com::sun::star::lang::Locale& rLocale =
                                     com::sun::star::lang::Locale( rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "en" ) ),
                                                                   rtl::OUString(),
                                                                   rtl::OUString() )
                                     ) const;
    static void getMapName( const String& rOrgName, String& rShortName, String& rFamilyName, FontWeight& rWeight, FontWidth& rWidth, unsigned long& rType );
};

class VCL_DLLPUBLIC SettingsConfigItem : public ::utl::ConfigItem
{

    std::hash_map< rtl::OUString, std::hash_map< rtl::OUString, rtl::OUString, rtl::OUStringHash >, rtl::OUStringHash >
    			m_aSettings;

    virtual void Notify( const com::sun::star::uno::Sequence< rtl::OUString >& rPropertyNames );
    virtual void Commit();

    void getValues();
    SettingsConfigItem();
public:
    virtual ~SettingsConfigItem();

    static SettingsConfigItem* get();

    const rtl::OUString& getValue( const rtl::OUString& rGroup, const rtl::OUString& rKey ) const;
    void setValue( const rtl::OUString& rGroup, const rtl::OUString& rKey, const rtl::OUString& rValue );
};


} // namespace vcl

#endif // _VCL_FONTCFG_HXX
