/*************************************************************************
 *
 *  $RCSfile: image.h,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: kz $ $Date: 2004/06/10 17:38:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_IMAGE_H
#define _SV_IMAGE_H

#ifndef _SV_BITMAPEX_HXX
#include <bitmapex.hxx>
#endif

// ----------------
// - ImplImageBmp -
// ----------------

class ImplImageBmp
{
public:

				ImplImageBmp();
				~ImplImageBmp();

	void		Create( long nItemWidth, long nItemHeight, USHORT nInitSize );
	void		Create( const BitmapEx& rBmpEx, long nItemWidth, long nItemHeight,USHORT nInitSize );

	void		Expand( USHORT nGrowSize );

	void		Replace( USHORT nPos, USHORT nSrcPos );
	void		Replace( USHORT nPos, const ImplImageBmp& rImageBmp, USHORT nSrcPos );
	void		Replace( USHORT nPos, const BitmapEx& rBmpEx );

    void        ReplaceColors( const Color* pSrcColors, const Color* pDstColors, ULONG nColorCount );
	void		ColorTransform( BmpColorMode eColorMode );
	void        	Invert();

	BitmapEx	GetBitmapEx( USHORT nPosCount, USHORT* pPosAry ) const;

	void		Draw( USHORT nPos, OutputDevice* pDev, const Point& rPos, USHORT nStyle, const Size* pSize = NULL );

private:

	BitmapEx	maBmpEx;
	Bitmap		maDisabledBmp;
	BitmapEx*	mpDisplayBmp;
	Size		maSize;
	BYTE*		mpInfoAry;
	USHORT		mnSize;

	void		ImplUpdateDisplayBmp( OutputDevice* pOutDev );
	void		ImplUpdateDisabledBmp( int nPos );
};

// --------------
// - ImageTypes -
// --------------

enum ImageType { IMAGETYPE_BITMAP, IMAGETYPE_IMAGE, IMAGETYPE_IMAGEREF };

// -----------------
// - ImplImageList -
// -----------------

struct ImageAryData
{
	::rtl::OUString	maName;
	USHORT			mnId;					
	USHORT			mnRefCount;
	
					ImageAryData();
					ImageAryData( const ImageAryData& rData );
					~ImageAryData();
					
	ImageAryData&	operator=( const ImageAryData& rData );
};

// ------------------------------------------------------------------------------

struct ImplImageList
{
	ULONG			mnRefCount; 			
	ULONG			mnIRefCount;			
	USHORT			mnCount;				
	USHORT			mnRealCount;			
	USHORT			mnArySize;				
	ImageAryData*	mpAry;					
	Size			maImageSize;			
	ImplImageBmp*	mpImageBitmap;			

					ImplImageList();
					~ImplImageList();
};

// --------------------
// - ImplImageRefData -
// --------------------

struct ImplImageRefData
{
	ImplImageList*	mpImplData;
	USHORT			mnIndex;

					ImplImageRefData() {}	 // Um Warning zu umgehen
					~ImplImageRefData();

	BOOL			IsEqual( const ImplImageRefData& rData );
};

// ----------------
// - ImpImageData -
// ----------------

struct ImplImageData
{
	ImplImageBmp*	mpImageBitmap;			
	BitmapEx		maBmpEx;

					ImplImageData( const BitmapEx& rBmpEx );
					~ImplImageData();

	BOOL			IsEqual( const ImplImageData& rData );
};

// -------------
// - ImplImage -
// -------------

struct ImplImage
{
	ULONG			mnRefCount;
	void*			mpData;
	ImageType		meType;

					ImplImage();
					~ImplImage();
};

#endif // _SV_IMAGE_H
