/*************************************************************************
 *
 *  $RCSfile: impimagetree.hxx,v $
 *
 *  $Revision:
 *
 *  last change: $Author: obo $ $Date: 2004/07/06 13:44:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_IMPIMAGETREE_HXX
#define _SV_IMPIMAGETREE_HXX

#ifndef _COMPHELPER_SINGLETONREF_HXX_
#include <salhelper/singletonref.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

// ----------------
// -ImplImageTree -
// ----------------

class BitmapEx;
namespace com { namespace sun { namespace star { namespace packages { namespace zip { class XZipFileAccess; } } } } };
namespace com { namespace sun { namespace star { namespace container { class XNameAccess; } } } };
namespace com { namespace sun { namespace star { namespace beans { class XPropertySet; } } } };
namespace com { namespace sun { namespace star { namespace ucb { class XSimpleFileAccess; } } } };

class ImplImageTree
{
public:

					ImplImageTree();
					~ImplImageTree();

	bool 			loadImage( const ::rtl::OUString& rName, BitmapEx& rReturn, bool bSearchLanguageDependent = false );
	void			addUserImage( const ::rtl::OUString& rName, const BitmapEx& rReturn );
	
	static void     cleanup();

private:

	::com::sun::star::uno::Reference< ::com::sun::star::packages::zip::XZipFileAccess > mxZipAcc;
	::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess > 		mxNameAcc;
	::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > 			mxPathSettings;
	::com::sun::star::uno::Reference< ::com::sun::star::ucb::XSimpleFileAccess > 		mxFileAccess;
	bool																				mbInit;
			
	bool					implInit();
	const ::rtl::OUString&	implGetZipFileURL() const;
	const ::rtl::OUString&	implGetUserDirURL() const;
	::rtl::OUString 		implGetUserFileURL( const ::rtl::OUString& rName ) const;
	void					implCheckUserCache();
	bool					implLoadFromStream( SvStream& rIStm, const ::rtl::OUString& rFileName, BitmapEx& rReturn );
};

typedef ::salhelper::SingletonRef< ImplImageTree > ImplImageTreeSingletonRef;
 
#endif // _SV_IMPIMAGETREE_HXX
