/*************************************************************************
 *
 *  $RCSfile: metric.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/13 17:40:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_METRIC_HXX
#define _SV_METRIC_HXX

#ifndef _VCL_DLLAPI_H
#include "dllapi.h"
#endif

#ifndef _SV_FONT_HXX
#include <font.hxx>
#endif

class ImplFontMetric;
class ImplFontCharMap;

// ------------
// - FontInfo -
// ------------

class VCL_DLLPUBLIC FontInfo : public Font
{
	friend class OutputDevice;

protected:
	ImplFontMetric* 	mpImplMetric;	 // Implementation

public:
						FontInfo();
						FontInfo( const FontInfo& );
						~FontInfo();

	FontType			GetType() const;
	BOOL				IsDeviceFont() const;
	BOOL				SupportsLatin() const;
	BOOL				SupportsCJK() const;
	BOOL				SupportsCTL() const;

	FontInfo&			operator=( const FontInfo& );
	BOOL				operator==( const FontInfo& ) const;
	BOOL				operator!=( const FontInfo& rInfo ) const
							{ return !operator==( rInfo ); }
};

// --------------
// - FontMetric -
// --------------

class VCL_DLLPUBLIC FontMetric : public FontInfo
{
public:
						FontMetric() {}
						FontMetric( const FontMetric& );
						~FontMetric() {}

	long				GetAscent() const;
	long				GetDescent() const;
	long				GetIntLeading() const;
	long				GetExtLeading() const;
	long				GetLineHeight() const;
	long				GetSlant() const;

	FontMetric& 		operator=( const FontMetric& rMetric );
	BOOL				operator==( const FontMetric& rMetric ) const;
	BOOL				operator!=( const FontMetric& rMetric ) const
							{ return !operator==( rMetric ); }
};

// ---------------
// - FontCharMap -
// ---------------

class VCL_DLLPUBLIC FontCharMap
{
private:
    ImplFontCharMap*    mpImpl;

public:
                        FontCharMap();
                        ~FontCharMap();

    BOOL                IsDefaultMap() const;
    BOOL                HasChar( sal_uInt32 ) const;
    int                 CountCharsInRange( sal_uInt32 cMin, sal_uInt32 cMax ) const;
    int                 GetCharCount() const;

    sal_uInt32          GetFirstChar() const;
    sal_uInt32          GetLastChar() const;

    sal_uInt32          GetNextChar( sal_uInt32 ) const;
    sal_uInt32          GetPrevChar( sal_uInt32 ) const;

    int                 GetIndexFromChar( sal_uInt32 ) const;
    sal_uInt32          GetCharFromIndex( int ) const;


private:
    friend class OutputDevice;
    void                Reset( ImplFontCharMap* pNewMap = NULL );

    // prevent assignment and copy construction
                        FontCharMap( const FontCharMap& );
    void                operator=( const FontCharMap& );
};

// ----------------
// - TextRectInfo -
// ----------------

class VCL_DLLPUBLIC TextRectInfo
{
	friend class OutputDevice;

private:
	long			mnMaxWidth;
	USHORT			mnLineCount;
	BOOL			mbEllipsis;

public:
					TextRectInfo();

	USHORT			GetLineCount() const { return mnLineCount; }
	long			GetMaxLineWidth() const { return mnMaxWidth; }
	BOOL			IsEllipses() const { return mbEllipsis; }

	BOOL			operator ==( const TextRectInfo& rInfo ) const
						{ return ((mnMaxWidth	== rInfo.mnMaxWidth)	&&
								  (mnLineCount	== rInfo.mnLineCount)	&&
								  (mbEllipsis	== rInfo.mbEllipsis)); }
	BOOL			operator !=( const TextRectInfo& rInfo ) const
						{ return !(TextRectInfo::operator==( rInfo )); }
};

inline TextRectInfo::TextRectInfo()
{
	mnMaxWidth		= 0;
	mnLineCount 	= 0;
	mbEllipsis		= FALSE;
}

#endif // _SV_METRIC_HXX
