/*************************************************************************
 *
 *  $RCSfile: region.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/13 17:44:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_REGION_HXX
#define _SV_REGION_HXX

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif

#ifndef _VCL_DLLAPI_H
#include "dllapi.h"
#endif

class ImplRegion;
class ImplRegionBand;
class Polygon;
class PolyPolygon;
struct ImplRegionInfo;

// --------------
// - RegionType -
// --------------

enum RegionType { REGION_NULL, REGION_EMPTY, REGION_RECTANGLE, REGION_COMPLEX };
enum RegionOverlapType { REGION_INSIDE, REGION_OVER, REGION_OUTSIDE };

typedef long RegionHandle;

// ----------
// - Region -
// ----------

class VCL_DLLPUBLIC Region
{
	friend class OutputDevice;
	friend class Window;
	friend class Bitmap;

private:
	ImplRegion* 		mpImplRegion;

	SAL_DLLPRIVATE void				ImplCopyData();
	SAL_DLLPRIVATE void				ImplCreateRectRegion( const Rectangle& rRect );
	SAL_DLLPRIVATE void				ImplCreatePolyPolyRegion( const PolyPolygon& rPolyPoly );
	SAL_DLLPRIVATE void				ImplPolyPolyRegionToBandRegionFunc();
	SAL_DLLPRIVATE inline void 		ImplPolyPolyRegionToBandRegion();
	SAL_DLLPRIVATE const ImplRegion*	ImplGetImplRegion() const { return mpImplRegion; }
	SAL_DLLPRIVATE ImplRegion* 		ImplGetImplRegion() { return mpImplRegion; }
	SAL_DLLPRIVATE BOOL				ImplGetFirstRect( ImplRegionInfo& rImplRegionInfo,
										  long& nX, long& nY, long& nWidth, long& nHeight ) const;
	SAL_DLLPRIVATE BOOL				ImplGetNextRect( ImplRegionInfo& rImplRegionInfo,
										 long& nX, long& nY, long& nWidth, long& nHeight ) const;
	SAL_DLLPRIVATE void				ImplBeginAddRect( );
	SAL_DLLPRIVATE BOOL				ImplAddRect( const Rectangle& rRect );
	SAL_DLLPRIVATE void				ImplEndAddRect( );

#ifdef DBG_UTIL
	friend const char*	ImplDbgTestRegion( const void* pObj );
#endif

public:
					Region();
					Region( RegionType eType );
					Region( const Rectangle& rRect );
					Region( const Polygon& rPolygon );
					Region( const PolyPolygon& rPolyPoly );
					Region( const Region& rRegion );
					~Region();

	void			Move( long nHorzMove, long nVertMove );
	void			Scale( double fScaleX, double fScaleY );
	BOOL			Union( const Rectangle& rRegion );
	BOOL			Intersect( const Rectangle& rRegion );
	BOOL			Exclude( const Rectangle& rRegion );
	BOOL			XOr( const Rectangle& rRegion );
	BOOL			Union( const Region& rRegion );
	BOOL			Intersect( const Region& rRegion );
	BOOL			Exclude( const Region& rRegion );
	BOOL			XOr( const Region& rRegion );

	RegionType		GetType() const;
	BOOL			IsEmpty() const { return GetType() == REGION_EMPTY; };
	BOOL			IsNull() const { return GetType() == REGION_NULL; };

	void			SetEmpty();
	void			SetNull();

	Rectangle		GetBoundRect() const;
    
    BOOL            HasPolyPolygon() const;
    PolyPolygon     GetPolyPolygon() const;

	ULONG			GetRectCount() const;
	RegionHandle	BeginEnumRects();
	BOOL			GetEnumRects( RegionHandle hRegionHandle, Rectangle& rRect );
	BOOL			GetNextEnumRect( RegionHandle hRegionHandle, Rectangle& rRect )
						{ return GetEnumRects( hRegionHandle, rRect ); }
	void			EndEnumRects( RegionHandle hRegionHandle );

	BOOL			IsInside( const Point& rPoint ) const;
	BOOL			IsInside( const Rectangle& rRect ) const;
	BOOL			IsOver( const Rectangle& rRect ) const;

	Region& 		operator=( const Region& rRegion );
	Region& 		operator=( const Rectangle& rRect );

	BOOL			operator==( const Region& rRegion ) const;
	BOOL			operator!=( const Region& rRegion ) const
						{ return !(Region::operator==( rRegion )); }

	friend VCL_DLLPUBLIC SvStream& operator>>( SvStream& rIStm, Region& rRegion );
	friend VCL_DLLPUBLIC SvStream& operator<<( SvStream& rOStm, const Region& rRegion );
};

#endif	// _SV_REGION_HXX
