/*************************************************************************
 *
 *  $RCSfile: virdev.hxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/13 17:55:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_VIRDEV_HXX
#define _SV_VIRDEV_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _VCL_DLLAPI_H
#include "dllapi.h"
#endif

#ifndef _SV_OUTDEV_HXX
#include <outdev.hxx>
#endif

// -----------------
// - VirtualDevice -
// -----------------

class SalVirtualDevice;
class RmVirtualDevice;
struct SystemGraphicsData;

class VCL_DLLPUBLIC VirtualDevice : public OutputDevice
{
	friend class Application;
	friend class OutputDevice;

private:
	SalVirtualDevice*	mpVirDev;
	VirtualDevice*		mpPrev;
	VirtualDevice*		mpNext;
	USHORT				mnBitCount;
	BOOL				mbScreenComp;
	sal_Int8			mnAlphaDepth;
	BYTE				meRefDevMode;

	SAL_DLLPRIVATE void	ImplInitVirDev( const OutputDevice* pOutDev, long nDX, long nDY, USHORT nBitCount, const SystemGraphicsData *pData = NULL );
	SAL_DLLPRIVATE BOOL	ImplSetOutputSizePixel( const Size& rNewSize, BOOL bErase );

	// Copy assignment is forbidden and not implemented.
	VirtualDevice (const VirtualDevice &);
	VirtualDevice & operator= (const VirtualDevice &);

    /** Used for alpha VDev, to set areas to opaque 
        
    	@since #i32109#
     */
    SAL_DLLPRIVATE void	ImplFillOpaqueRectangle( const Rectangle& rRect );

public:
						VirtualDevice( USHORT nBitCount = 0 );
						VirtualDevice( const OutputDevice& rCompDev,
									   USHORT nBitCount = 0 );
    /** Create a virtual device with alpha channel
        
    	@param rCompDev
        The generated vdev will be compatible to this device. By
        default, Application::GetDefaultDevice() is used here.

        @param nBitCount
        Bit depth of the generated virtual device. Use 0 here, to
        indicate: take default screen depth. Currently, only 0 and 1
        are allowed here, with 1 denoting binary mask.

        @param nAlphaBitCount
        Bit depth of the generated virtual device. Use 0 here, to
        indicate: take default screen depth. Currently, only 0 and 1
        are allowed here, with 1 denoting binary mask.
     */
						VirtualDevice( const OutputDevice& rCompDev,
									   USHORT nBitCount, USHORT nAlphaBitCount );

    /** Create a virtual device using an existing system dependent device or graphics context
        Any rendering will happen directly on the context and not on any intermediate bitmap.
        Note: This might not be suported on all platforms !
    */
						VirtualDevice( const SystemGraphicsData *pData, USHORT nBitCount );

	virtual 			~VirtualDevice();

	BOOL				SetOutputSizePixel( const Size& rNewSize, BOOL bErase = TRUE );
	BOOL				SetOutputSize( const Size& rNewSize, BOOL bErase = TRUE )
							{ return SetOutputSizePixel( LogicToPixel( rNewSize ), bErase ); }

    // reference device modes for different compatibility levels
    enum RefDevMode { REFDEV_NONE=0, REFDEV_MODE06, REFDEV_MODE48, REFDEV_MODE_MSO1 };
    void                SetReferenceDevice( RefDevMode );
};

#endif // _SV_VIRDEV_HXX
