/*
 * StepModel.java
 *
 * Created on 17. M?rz 2003, 11:35
 */
package com.sun.star.wizards.tutorial.creator.frame;

import java.util.Vector;

/**
 * Steps a model.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class StepModel {
	private Vector m_steps;

	/**
	 * Creates a new StepModel object.
	 */
	public StepModel() {
		m_steps = new Vector();
	}

	/**
	 * Get a step for the given index.
	 *
	 * @param stepIndex
	 *
	 * @return vector with step
	 */
	public Vector getStep(int stepIndex) {
		Vector step = null;

		if ((stepIndex > -1) && (stepIndex < m_steps.size())) {
			step = (Vector) m_steps.get(stepIndex);
		}

		return step;
	}

	/**
	 * Gets the step size
	 *
	 * @return step size
	 */
	public int getStepsSize() {
		return m_steps.size();
	}

	/**
	 * Checks whether the step is empty.
	 *
	 * @return true = empty, false = non-empty
	 */
	public boolean isStepsEmpty() {
		return m_steps.isEmpty();
	}

	/**
	 * Swaps the content of both given indexes.
	 *
	 * @param upIndex
	 * @param downIndex
	 */
	public void changeStepsIndexes(int upIndex, int downIndex) {
		if ((upIndex > -1) && (downIndex < m_steps.size())) {
			Vector upStep = (Vector) ((Vector) m_steps.get(upIndex)).clone();
			Vector downtep = (Vector) ((Vector) m_steps.get(downIndex)).clone();
			m_steps.setElementAt(downtep, upIndex);
			m_steps.setElementAt(upStep, downIndex);
		}
	}

	/**
	 * Clears all steps of the model.
	 */
	public void clearDataVector() {
		m_steps.clear();
	}

	/**
	 * Get all steps.
	 *
	 * @return all steps as vector
	 */
	public Vector getDataVector() {
		return m_steps;
	}

	/**
	 * Sets steps.
	 *
	 * @param data vector
	 */
	public void setDataVector(Vector data) {
		m_steps = data;
	}

	/**
	 * Remove a single step.
	 *
	 * @param stepIndex
	 */
	public void removeStep(int stepIndex) {
		m_steps.remove(stepIndex);
	}

	/**
	 * Adds a single step into the steps vector.
	 *
	 * @param stepIndex
	 * @param stepData
	 */
	public void addStep(int stepIndex, Vector stepData) {
		m_steps.add(stepIndex, stepData);
	}

	/**
	 * Adds an empty step into the new vector.
	 *
	 * @param stepIndex
	 */
	public void addNewStep(int stepIndex) {
		Vector step = new Vector();
		step.add(0, "new desc");
		step.add(1, "new step");
		step.add(2, new Vector());
		m_steps.add(stepIndex, step);
	}
}
