/*
 * Main.java
 *
 * Created on 22. August 2002, 16:19
 */
package com.sun.star.wizards.tutorial.executer;

import java.lang.reflect.Method;

import java.util.Enumeration;
import java.util.Hashtable;

import com.sun.star.accessibility.AccessibleRole;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import com.sun.star.wizards.tutorial.executer.officeHelper.*;
import com.sun.star.wizards.tutorial.executer.util.*;

/**
 * A test class for the tutorial executor. There is no description for every test method.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class Main {
	public DesktopMenu m_deskMenu;
	public TextDocument m_doc;
	public Spreadsheet m_Spreadsheet;
	public DesktopDialog m_deskDialog;
	public Presentation_Drawing m_pd;
	public Helper m_helper;

	/**
	 * Creates a new Main object.
	 */
	public Main() {
		try {
			String connect = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";
			m_helper = new Helper(connect);
		} catch (java.lang.Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			//String  plaf = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
			//    UIManager.setLookAndFeel( plaf );
			Main main = new Main();
			Helper.log("Start :" + new java.sql.Time(System.currentTimeMillis()).toString());

			String param = "text";

			if (param.equals("text")) {
				main.text();
			} else if (param.equals("sheet")) {
				main.sheet();
			} else if (param.equals("pres")) {
				main.presDraw();
			} else if (param.equals("dialog")) {
				main.dialog();
			} else if (param.equals("menu")) {
				main.menu();
			} else if (param.equals("examples")) {
				main.examples();
			} else if (param.equals("test")) {
				main.tests();
			}

			Helper.log("\nStart :" + new java.sql.Time(System.currentTimeMillis()).toString());
		} catch (java.lang.Exception e) {
			e.printStackTrace();
		}

		System.exit(0);
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @throws java.lang.Exception
	 */
	public void presDraw() throws java.lang.Exception {
		m_pd = new Presentation_Drawing(m_helper);
		Helper.log("PES DRAW");

		//m_pd.printAllProperties("Tree");
		//m_pd.printAllProperties("Line");
		//m_pd.writeAllProperties("user.home", "Tree");
		//m_pd.writeAllProperties("user.home", "Line");
		//System.exit(0);
		String[] path = new String[] {

			/*"AccessibleRole.LAYEREDPANE#", "AccessibleRole.SCROLLPANE#",
			"AccessibleRole.DOCUMENT#Drawing View", "AccessibleRole.SHAPE#Text Frame1",
			"AccessibleRole.PARAGRAPH#Paragraph:2"};*/
			/*"AccessibleRole.LAYEREDPANE#", "AccessibleRole.TOOLBAR#Function Bar",
			"AccessibleRole.TOGGLEBUTTON#Navigator On/Off"};*/
			/*"AccessibleRole.LAYEREDPANE#", "AccessibleRole.TOOLBAR#Draw toolbar/Graphics",
			"AccessibleRole.PUSHBUTTON#Connector"};*/
			"FRAME#Untitled1 - StarOffice 6.1 Beta 1", "ROOT_PANE#Untitled1 - StarOffice 6.1 Beta 1", "MENU_BAR#", "MENU#Tools" };

		/*"AccessibleRole.LAYEREDPANE#", "AccessibleRole.TOOLBAR#Draw object bar/Graphics",
		"AccessibleRole.PANEL#Area Style / Filling"};*/
		m_pd.moveMousetoObject_Click(path);

		path = new String[] { "FRAME#Untitled1 - StarOffice 6.1 Beta 1", "ROOT_PANE#Untitled1 - StarOffice 6.1 Beta 1", "MENU_BAR#", "MENU#Tools", "MENU_ITEM#Options..." };

		m_pd.moveMousetoObject_Click(path);
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @throws java.lang.Exception
	 */
	public void dialog() throws java.lang.Exception {
		m_deskDialog = new DesktopDialog(m_helper);

		String[] path = null;
		path = new String[] { "DIALOG#Properties of Untitled1", "PAGE_TAB_LIST#" };

		m_deskDialog.setTab(path, 0, 300);
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @throws java.lang.Exception
	 */
	public void menu() throws java.lang.Exception {
		m_deskMenu = new DesktopMenu(m_helper);

		//m_deskMenu.printAllProperties();
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @throws java.lang.Exception
	 */
	public void text() throws java.lang.Exception {
		//m_doc = new TextDocument(m_helper);
		//Helper.setLogState(true);
		Object o = Desktop.createDocumentInstance("TextDocument", m_helper);
		m_doc = (TextDocument) o;

		Hashtable names = m_doc.getInterfaces();

		for (Enumeration e0 = names.elements(); e0.hasMoreElements();) {
			Hashtable elem0 = (Hashtable) (e0.nextElement());

			for (Enumeration e1 = elem0.keys(); e1.hasMoreElements();) {
				String key = (String) (e1.nextElement());
				System.out.println("KEY :" + key);
			}
		}

		//m_doc.setHelper(m_helper);

		/*XExtendedToolkit tool = m_helper.getXExtendedToolkit();
		TopWindowHandler      m_handler   = new TopWindowHandler();
		tool.addTopWindowListener(m_handler);
		
		try{
		    Thread.sleep(2000);
		}catch(Exception ex){ex.printStackTrace();}
		EscWindow escw = new EscWindow(m_helper.getActiveTopWindow(),null);
		//escw.show();
		try{
		    Thread.sleep(20000);
		}catch(Exception ex){ex.printStackTrace();}
		tool.removeTopWindowListener(m_handler);*/

		//escw.removeListener();*/
		//System.exit(0);
		//String url = "macro:///Tutorials.Test.Main()";
		//dispatchTutorialDialog("macro:///Tutorials.Functions.SetVisibleFalse()");
		//    dispatchTutorialDialog("macro:///Tutorials.ShowInfoDialog.ShowON()");  
		//String url = "macro:///Tutorials.ShowInfoDialog.ShowON()";
		//String url = "macro:///Tutorials.ShowInfoDialog.ShowOFF()";
		//String url = "macro:///Tutorials.Functions.SetVisibleFalse()";

		/*String url = "macro:///Tutorials.Functions.SetVisibleTrue()";
		Helper.log("Dispatch  path :" + url);
		
		try {
		    URLDispatcher.dispatch_Thread(m_helper.getXFrame(), url, "_self", 0, null);
		} catch(com.sun.star.uno.Exception ex) {
		    ex.printStackTrace();
		}*/
		/*Properties prop = System.getProperties();
		for (Enumeration e = prop.keys() ; e.hasMoreElements() ;) {
		 String key = (String)e.nextElement();
		 System.out.println(key + " : " + prop.getProperty(key));
		
		}
		
		System.exit(0);*/
		/*
		m_doc.mouseClick();
		m_doc.mouseClick("Right");
		
		XWindow[] xWindows = m_helper.getTopWindows();
		
		if(xWindows != null) {
		    Debug.printXWindows(xWindows);
		
		    for(int i = 0; i < xWindows.length; i++) {
		        XWindow xWindow = xWindows[i];
		
		        //xWindow.setPosSize(0, 0, 1600,1600,(short)0);
		        XAccessibleContext ac =
		            AccessibilityTools.getAccessibleObject(xWindow).getAccessibleContext();
		
		        while(ac.getAccessibleIndexInParent() > -1)
		            ac = ac.getAccessibleParent().getAccessibleContext();
		
		        Helper.log(ac.getAccessibleRole() + "  **1** " + ac.getAccessibleName());
		    }
		}
		
		com.sun.star.awt.XWindow office = xWindows[6];
		
		Toolkit                  kit        = Toolkit.getDefaultToolkit();
		Dimension                screenSize = kit.getScreenSize();
		JFrame                   frame      = new JFrame();
		Rectangle                dim        = frame.getRootPane().getVisibleRect();
		GraphicsConfiguration    config     = frame.getGraphicsConfiguration();
		Insets                   insets     = kit.getScreenInsets(config);
		screenSize.width -= (insets.left + insets.right);
		screenSize.height -= (insets.top + insets.bottom);
		
		Helper.log("left =" + insets.left);
		Helper.log("right =" + insets.right);
		Helper.log("top =" + insets.top);
		Helper.log("bottom =" + insets.bottom);
		Helper.log("*************************");
		Helper.log("with =" + screenSize.width);
		Helper.log("height =" + screenSize.height);
		
		office.setPosSize(insets.left, insets.right, screenSize.width - 10,
		                  screenSize.height - 30, PosSize.POSSIZE);
		System.exit(0);
		
		XFrame xFrame = m_helper.getXFrame();
		Debug.printInterfaces(xFrame);
		
		XServiceInfo xseer =
		    (XServiceInfo) UnoRuntime.queryInterface(XServiceInfo.class, xFrame);
		XSetup       xset = (XSetup) UnoRuntime.queryInterface(XSetup.class, xseer);
		xseer = (XServiceInfo) UnoRuntime.queryInterface(XServiceInfo.class, xset);
		
		XPropertySet xps =
		    (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, xseer);
		Debug.printPropertiesNames(xps);
		
		/*Helper.log(xps.getPropertyValue("Title"));
		Helper.log("Frame NAME :_ " + xFrame.getName());
		Helper.log(xFrame);*/

		//System.exit(0);

		/* String[] macros = MacroReader.getDocumentMacroNames(m_helper.getXModel(), "Standard");
		 Debug.printArray(macros);
		 String macro = MacroReader.readDocumentMacro(m_helper.getXModel(), "Standard", macros[0]);
		 String temp= "properties(2).Value = " + '"';
		 if( macro.indexOf(temp) > -1){
		     int index = macro.indexOf(temp) + temp.length();
		     String part1 = macro.substring(0, index);
		     String part3 = macro.substring(index);
		     String part2 = part3.substring(0, part3.indexOf('"'));
		     part3        = part3.substring(part3.indexOf('"'));
		     //Helper.log("part1 = " + part1);
		     Helper.log("part2 = " + part2);
		     //Helper.log("part3 = " + part3);
		     if(part2.equalsIgnoreCase("False")){
		         macro = part1 + "True" + part3;
		     }
		 }
		
		 Helper.log("macro : " + macro);
		
		 System.exit(0);
		 //String url = "macro://./Standard.nee.Mainnee()";
		 String url = "macro://./Standard.temp.Maintemp()";
		 Helper.log("Dispatch  path :" + url);
		 try{
		     URLDispatcher.dispatch_Thread(m_helper.getXFrame(), url, "_self", 0, null);
		 } catch (com.sun.star.uno.Exception ex){ex.printStackTrace();}
		   */

		//Debug.printXWindows(m_helper.getTopWindows());
		//Debug.printArray(MacroReader.getMacroNames(m_helper.getxMSF(), "Standard"));
		//String content = MacroReader.readDocumentMacro(m_helper.getXModel(), "Standard", "Module1");
		//System.out.print(content);
		//System.out.print(MacroCreator.createDocumentMacro(m_helper.getXModel(), "Standard", "test", "Sub Main End Sub\n Sub Macro1 End Sub"));
		//System.exit(0);
		//m_doc.printAllProperties(AccessibleRole.FRAME, "Animation Effects", "Tree");
		//m_doc.printAllProperties(AccessibleRole.DIALOG,
		//                       "Tutorial", "Tree");
		//m_doc.printAllProperties(AccessibleRole.DIALOG, "Properties of Untitled1", "Tree");
		//m_doc.printWindowsNames();
		//m_doc.printAllProperties(AccessibleRole.DIALOG, "Vorlagenkatalog", "Tree");
		//m_doc.printAllProperties(AccessibleRole.DIALOG, "Absatzvorlage: Standard", "Tree");
		//m_doc.printAllProperties(AccessibleRole.DIALOG, "Suchen & Ersetzen", "Tree");
		//m_doc.printAllProperties(AccessibleRole.DIALOG, "?ffnen", "Tree");

		/*m_doc.printAllProperties(AccessibleRole.FRAME, "TutorialVorlage.sxw - StarOffice 7 ", "Tree");
		
		System.exit(0);
		*/

		//Control.m_moveMouseStep = 0;
		String[] path = null;
		path = new String[] {

			/*"DIALOG#Suchen & Ersetzen",
			"COMBO_BOX#",
			"LIST#Suchen nach"*/
			/*"FRAME#Unbenannt1 - StarOffice 7 #5",
			"ROOT_PANE#Unbenannt1 - StarOffice 7 #0",
			"PANEL##1",
			"TOOL_BAR#Werkzeugleiste#4",
			"TOGGLE_BUTTON#Suchen ein/aus#18"*/
			/*"FRAME#Unbenannt1 - StarOffice 8 PreAlpha#5",
			"ROOT_PANE#Unbenannt1 - StarOffice 8 PreAlpha#0",
			"MENU_BAR##0",
			"MENU#Format#4"  */
			/*"FRAME#Animation Effects#0", "PANEL#Animation Effects#0", "LIST#ValueSet#0",
			  "LIST_ITEM#Fade From Center#7"*/
			/*"DIALOG#Vorlagenkatalog#2",
			"COMBO_BOX##1"*/
			"{D}FRAME#Unbenannt1 - StarOffice 8 PreAlpha#4", "ROOT_PANE#Unbenannt1 - StarOffice 8 PreAlpha#0", "MENU_BAR##0", "MENU#Einf?gen#3" };
		m_doc.moveMousetoObject_Click_Time(path, 1000);

		/* path =
		     new String[]{
		       "{D}FRAME#Unbenannt1 - StarOffice 8 PreAlpha#4",
		       "ROOT_PANE#Unbenannt1 - StarOffice 8 PreAlpha#0",
		       "MENU_BAR##0",
		       "MENU#Einf?gen#3",
		       "MENU#Verzeichnisse#15"
		     };
		 m_doc.moveMousetoObject_Click_Time(path,1000);
		
		 path =
		     new String[]{
		       "{D}FRAME#Unbenannt1 - StarOffice 8 PreAlpha#4",
		       "ROOT_PANE#Unbenannt1 - StarOffice 8 PreAlpha#0",
		       "MENU_BAR##0",
		       "MENU#Einf?gen#3",
		       "MENU#Verzeichnisse#15",
		       "MENU_ITEM#Eintrag...#0"
		     };
		 m_doc.moveMousetoObject(path);*/

		//m_doc.selectItem_Index(path, 0 );
		//m_doc.selectItem_Name(path,"Marginalie" );
		//AccessibilityTools.setSearchForm(AccessibilityTools.SERCH_FORM_INDEX);
		//m_doc.printWindowsNames();
		//m_doc.moveMousetoObject(path);
		//m_doc.selectItem_Index(path, 1);
		//m_doc.selectItem_Name(path, "Albany");
		//m_doc.selectItem_Name(path, "Tahoma");
		//m_doc.selectItem_Name(path, "Hierarchisch");
		//m_doc.selectItem_Name(path, "SimSun");
		//    System.exit(0);
		//m_doc.printWindowsNames();
		//m_doc.insertText(path,0,"hallo2");
		//m_doc.moveMousetoObject_insertText(path,0,"hallo2");    
		//m_doc.selectItem_Name(path, "Fett");
		//m_doc.selectItem_Name(path, "Listenvorlagen");
		//  m_doc.selectItem_Name(path, "Zeichenvorlagen");
		//m_doc.selectItem_Index(path, 4);
		//m_doc.moveMousetoObject_Click_Time(path,1000);
		//m_doc.moveMousetoObject_insertText(path, 0, "hallo");
		//m_doc.insertText(path,0,"hallo2");
		//m_doc.selectItem_Name(path, "Hierarchical");
		//m_doc.selectItem_Name(path, "Rot");
		//m_doc.selectItem_Index(path, 2);
		//m_doc.setTab(path,0, 500);
		//System.exit(0);

		/*path =
		    new String[]{
		        "FRAME#Unbenannt1 - StarOffice 8 PreAlpha#6",
		        "ROOT_PANE#Unbenannt1 - StarOffice 8 PreAlpha#0", "MENU_BAR##0",
		        "MENU#Format#4", "MENU#Vorlagen#14"
		    };
		m_doc.moveMousetoObject(path);
		m_doc.printWindowsNames();
		System.exit(0);*/

		//"DIALOG#Find & Replace","PUSH_BUTTON#Close"};

		/*"DIALOG#Find & Replace", "COM_BOBOX#",
		"TEXT#Search for"};*/
		/*"FRAME#Untitled1 - StarOffice 6.1 Beta 1", "ROOT_PANE#Untitled1 - StarOffice 6.1 Beta 1",
		"LAYERED_PANE#", "TOOL_BAR#Text Object Bar",
		"COM_BOBOX#12", "TEXT#"};*/
		/*"FRAME#Untitled1 - StarOffice 6.1 Beta 1", "ROOT_PANE#Untitled1 - StarOffice 6.1 Beta 1",
		"LAYERED_PANE#" , "SCROLL_PANE#", "DOCUMENT#Document view" ,"PARAGRAPH#Paragraph:0"};
		m_doc.moveMousetoObject_insertText(path, 0, "Hallo");*/
		/*"FRAME#Untitled1 - StarOffice 6.1 Beta 1", "ROOT_PANE#Untitled1 - StarOffice 6.1 Beta 1",
		"LAYERED_PANE#", "SCROLL_PANE#",
		"DOCUMENT#Document view", "PARAGRAPH#Paragraph:0"};
		m_doc.moveMousetoObject_insertText(path, 0, "Das ist ein Test");  //moveMousetoObject(path);*/

		//m_doc.moveMousetoObject_Click_Time(path, 1000);
		//System.exit(0);

		/*JOptionPane.showMessageDialog(null,
		    "Cannot connect to StarOffice",
		    "Connect Error",
		    JOptionPane.ERROR_MESSAGE );*/
		/*  path =
		      new String[]{
		          "FRAME#Unbenannt1 - StarOffice 6.1 Beta 2",
		          "ROOT_PANE#Unbenannt1 - StarOffice 6.1 Beta 2", "MENU_BAR#", "MENU#Extras",
		          "MENU_ITEM#Optionen..."
		      };*/

		//m_doc.moveMousetoObject_Click(path);
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @throws java.lang.Exception
	 */
	public void sheet() throws java.lang.Exception {
		m_Spreadsheet = new Spreadsheet(m_helper);

		String[] path = new String[] { "FRAME#Untitled2 - StarOffice 6.1 Beta 1", "ROOT_PANE#Untitled2 - StarOffice 6.1 Beta 1", "LAYERED_PANE#", "SCROLL_PANE#", "PANEL#", "PAGE_TAB_LIST#" };

		m_Spreadsheet.setTab(path, 2, 300);

		/*"FRAME#Untitled2 - StarOffice 6.1 Beta 1", "ROOT_PANE#Untitled2 - StarOffice 6.1 Beta 1",
		"LAYERED_PANE#", "SCROLL_PANE#", "DOCUMENT#Document view3", "TABLE#Sheet Sheet1",
		"TABLE_CELL#Cell C2"};
		
		 m_Spreadsheet.moveMousetoCell_insertText(path, 0, "Das ist ein Test");*/
		/*path = new String[]{
		"FRAME#Untitled2 - StarOffice 6.1 Beta 1", "ROOT_PANE#Untitled2 - StarOffice 6.1 Beta 1",
		"LAYERED_PANE#", "TOOL_BAR#Main Toolbar", "TOGGLE_BUTTON#Find On/Off"};
		
		m_Spreadsheet.moveMousetoObject(path);*/

		//   m_Spreadsheet.printAllProperties("Line");
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @throws java.lang.Exception
	 */
	public void examples() throws java.lang.Exception {
	}

	// a URL for a slot would e.g. be:  "slot:" + Integer.toString(SlotID)
	public static void dispatchURL(XMultiServiceFactory xMSF, String sURL, XFrame xFrame) {
		try {
			PropertyValue[] oArg = new PropertyValue[0];
			com.sun.star.util.URL[] oUrl = new com.sun.star.util.URL[1];
			oUrl[0] = new com.sun.star.util.URL();
			oUrl[0].Complete = sURL;

			Object oTransformer = xMSF.createInstance("com.sun.star.util.URLTransformer");
			XURLTransformer xTransformer = (XURLTransformer) UnoRuntime.queryInterface(XURLTransformer.class, oTransformer);
			xTransformer.parseStrict(oUrl);

			XDispatchProvider xDispatchProvider = (XDispatchProvider) UnoRuntime.queryInterface(XDispatchProvider.class, xFrame);
			XDispatch xDispatch = xDispatchProvider.queryDispatch(oUrl[0], "", 0); // "_self"
			xDispatch.dispatch(oUrl[0], oArg);
		} catch (Exception exception) {
			exception.printStackTrace(System.out);
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @throws java.lang.Exception
	 */
	public void tests() throws java.lang.Exception {
		m_doc = new TextDocument(m_helper);

		//Helper.log(m_doc.getHelper().getXFrame());
		//System.exit(0);
		PropertyValue[] aArgs = new PropertyValue[0];
		String url = "";

		//String url = "macro:///Tutorials.demo.Maindemo()";
		//String url = "macro:///Tutorials.Functions.Init()";        
		//URLDispatcher.dispatch(m_doc.getHelper().getXFrame(), url, "_self", 0, null);        
		url = "macro:///Tutorials.mouve.Mainmouve()";
		url = "macro:///Tutorials.tempop.Step_0_Action()";

		//     "macro:///Tutorials.tempop.Step_0_Action()"
		//dispatchURL(m_doc.getHelper().getxMSF(), url, m_doc.getHelper().getXFrame());
		URLDispatcher.dispatch_Thread(m_doc.getHelper().getXFrame(), url, "", 0, aArgs);

		//Control.sleep(4000);
		/*String[] pathh =
		    new String[] {
		                     "DIALOG#Tutorial",
		                     "PUSH_BUTTON#show" };
		m_doc.moveMousetoObject_Click(pathh);*/
		//url = "macro:///Tutorials.mouve.Step_0_Action()";                
		//URLDispatcher.dispatch(m_doc.getHelper().getXFrame(), url, "", 0, aArgs);
		/*XURLTransformer tran = new URLTransformer();
		try {
		    tran =
		        (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class,
		                                               frame);
		} catch (Exception e) {
		    e.printStackTrace();
		}*/
		//tran. .parsestrict(aURL);
		/*String[] names = MacroReader.getMacroNames(m_doc.getHelper().getxMSF(), "Tutorials");
		for(int i=0; i < names.length; i++){
		    Helper.log(names[i]);
		}
		String name = MacroReader.readMacro(m_doc.getHelper().getxMSF(), "Tutorials", "demo");
		Helper.log(name);*/
		Helper.log("exit");
		System.exit(0);
		m_doc.moveMouse_Click(300, 300);
		m_doc.mouseClick("right");

		XAccessible[] xAcess = null;
		Control.sleep(2000);

		try {
			XWindow[] xWindows = m_helper.getTopWindows();
			int count = xWindows.length;

			if (count > 0) {
				xAcess = new XAccessible[count];

				for (int i = 0; i < count; i++) {
					XWindow xWindow = xWindows[i];
					XAccessible xRootTemp = AccessibilityTools.getAccessibleObject(xWindow);

					if (xRootTemp != null) {
						XAccessibleContext ac = xRootTemp.getAccessibleContext();
						Helper.log(" role name :" + ac.getAccessibleRole() + ac.getAccessibleName());

						while (ac.getAccessibleIndexInParent() > -1) {
							xRootTemp = ac.getAccessibleParent();
							ac = xRootTemp.getAccessibleContext();
						}

						m_doc.printAllProperties(ac.getAccessibleRole(), ac.getAccessibleName().trim(), "Tree");
						Helper.log("***********************************************************");
					}
				}
			}
		} catch (com.sun.star.uno.Exception ex) {
		}

		m_doc.mouseClick("left");
	}
}
