/*************************************************************************
 *
 *  $RCSfile: HelpURLStreamHandlerFactory.java,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: obo $ $Date: 2005/01/25 15:29:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

package com.sun.star.help;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public final class HelpURLStreamHandlerFactory
	implements URLStreamHandlerFactory {

	public interface Notify {
		void notify(URL requestedURL);
	}

	protected static byte[] _doc = null;
	private String _HelpURLHandler;
	private Notify interest;

	public HelpURLStreamHandlerFactory(String HelpURLHandler) {
		_HelpURLHandler = HelpURLHandler;
		_doc = null;
	}

	public HelpURLStreamHandlerFactory(
		String HelpURLHandler,
		Notify interest) {
		this(HelpURLHandler);
		this.interest = interest;
	}

	protected static byte[] getData() {
		return _doc;
	}

	protected static void setMode(byte[] doc) {
		_doc = doc;
	}

	public URLStreamHandler createURLStreamHandler(String protocol) {
		try {
			if ("vnd.sun.star.help".equals(protocol)) {
				if ("with-jars".equals(_HelpURLHandler))
					return new HelpURLStreamHandlerWithJars();
				else if ("with-files".equals(_HelpURLHandler))
					return new HelpURLStreamHandler();
				else
					return null;
			} else if ("file".equals(protocol)) {
				Constructor c = null;
				try 
				{
					c = Class.forName("com.sun.star.help.FileURLStreamHandlerWithNotify").getDeclaredConstructor(new Class[] { HelpURLStreamHandlerFactory.Notify.class } );
				}
				catch (Exception e)
				{
					c = Class.forName("com.sun.star.help.GCJFileURLStreamHandlerWithNotify").getDeclaredConstructor(new Class[] { HelpURLStreamHandlerFactory.Notify.class } );
				}
				return (URLStreamHandler)c.newInstance(new Object[] { interest } );
			} else {
				try {
						Class handlerClass =
							Class.forName(
								"sun.net.www.protocol." + protocol + ".Handler");
						return (URLStreamHandler) handlerClass.newInstance();
				} catch (java.lang.ClassNotFoundException ec) {
						Class handlerClass =
							Class.forName(
								"gnu.java.net.protocol." + protocol + ".Handler");
						return (URLStreamHandler) handlerClass.newInstance();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

    protected void setNotify(Notify interest) {
        this.interest = interest;
    }

}
