/*************************************************************************
 *
 *	$RCSfile: baseencoding.cxx,v $
 *
 *	$Revision: 1.2 $
 *
 *	last change: $Author: mt $ $Date: 2004/07/23 07:44:30 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "xmlsecurity/baseencoding.hxx"

#include <xmlsec/xmlsec.h>
#include <xmlsec/base64.h>
#include <com/sun/star/uno/Sequence.hxx>

using namespace ::com::sun::star::uno ;
using ::rtl::OUString ;

//We only implment the base64 encoding at present.
::rtl::OUString SAL_CALL baseEncode( const ::com::sun::star::uno::Sequence< sal_Int8 >& rawdata, BaseType base ) {
	if( base == BASE64 ) {
		xmlChar* chData ;

		chData = xmlSecBase64Encode( ( const unsigned char* )&rawdata[0], rawdata.getLength(), 0 ) ;
		if( chData != NULL ) {
			OUString ouStr = OUString::createFromAscii( ( const sal_Char* )chData );
			xmlFree( chData ) ;

			return ouStr ;
		}
	} else {
		return OUString() ;
	}

	return OUString() ;
}

//We only implment the base64 encoding at present.
::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL baseDecode( const ::rtl::OUString& oustr, BaseType base ) {
	if( base == BASE64 ) {
		xmlChar* chData ;
		xmlSecSize chSize ;

		rtl::OString ostr = rtl::OUStringToOString( oustr , RTL_TEXTENCODING_ASCII_US ) ;

		chData = xmlStrndup( ( const xmlChar* )ostr.getStr(), ( int )ostr.getLength() ) ;

		chSize = xmlSecBase64Decode( chData, ( xmlSecByte* )chData, xmlStrlen( chData ) ) ;

		Sequence< sal_Int8 > rawData( chSize ) ;
		for( unsigned int i = 0 ; i < chSize ; i ++ )
			rawData[i] = *( chData + i ) ;

		xmlFree( chData ) ;

		return rawData ;
	}

	return ::com::sun::star::uno::Sequence< sal_Int8 >() ;
}

