/*************************************************************************
 *
 *	$RCSfile: controller.cxx,v $
 *
 *	$Revision: 1.1.1.1 $
 *
 *	last change: $Author: mt $ $Date: 2004/07/12 13:15:30 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "xsectester.hxx"

#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Can not build under solaris
 * Deleted by AF
#include <memory.h>
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <osl/time.h>

#include <com/sun/star/lang/XInitialization.hpp>
#include <com/sun/star/xml/crypto/sax/XKeyCollector.hpp>
#include <com/sun/star/xml/crypto/sax/ElementMarkPriority.hpp>
#include <com/sun/star/xml/crypto/sax/XReferenceResolvedBroadcaster.hpp>
#include <com/sun/star/xml/crypto/sax/XMissionTaker.hpp>
#include <com/sun/star/xml/crypto/sax/XBlockerMonitor.hpp>
#include <com/sun/star/xml/crypto/sax/XSignatureCreationResultBroadcaster.hpp>
#include <com/sun/star/xml/crypto/sax/XSignatureVerifyResultBroadcaster.hpp>
#include <com/sun/star/xml/crypto/sax/XReferenceCollector.hpp>
#include <com/sun/star/xml/crypto/sax/XSAXEventKeeperStatusChangeBroadcaster.hpp>
#include <com/sun/star/xml/wrapper/XXMLDocumentWrapper.hpp>

#include <xmloff/attrlist.hxx>

namespace cssu = com::sun::star::uno;
namespace cssl = com::sun::star::lang;
namespace cssi = com::sun::star::io;
namespace cssxs = com::sun::star::xml::sax;
namespace cssxc = com::sun::star::xml::crypto;
namespace cssxw = com::sun::star::xml::wrapper;
namespace cssxcsax = com::sun::star::xml::csax;

#define RTL_ASCII_USTRINGPARAM( asciiStr ) asciiStr, strlen( asciiStr ), RTL_TEXTENCODING_ASCII_US

int SecurityEntity::m_nNextSecurityId = 1;

SecurityEntity::SecurityEntity(
	const cssu::Reference<cssxc::sax::XSecuritySAXEventKeeper>& xSAXEventKeeper,
	const cssu::Reference<cssxc::XXMLSecurityContext>& xXMLSecurityContext,
	const cssu::Reference<cssxc::XXMLSignature>& xXMLSignature,
	const cssu::Reference< cssl::XMultiServiceFactory > &rsMSF)
	:m_xSAXEventKeeper(xSAXEventKeeper),
	 m_xXMLSecurityContext(xXMLSecurityContext),
	 m_xXMLSignature(xXMLSignature),
	 mxMSF(rsMSF),
	 m_ouKeyURI(RTL_ASCII_USTRINGPARAM(""))
{
	m_nSecurityId = getNextSecurityId();
}
	
int SecurityEntity::getNextSecurityId() const
{
	int nId = m_nNextSecurityId++;
	return nId;
}

void SecurityEntity::setKeyId(int nId)
{
	cssu::Reference<cssxc::sax::XKeyCollector> keyCollector (m_xReferenceListener, cssu::UNO_QUERY);
	keyCollector->setKeyId(nId);
}


void SecurityEntity::setKeyURI(const rtl::OUString& ouUri)
{
	m_ouKeyURI = ouUri;
}

cssu::Reference<cssxc::sax::XReferenceResolvedListener> SecurityEntity::getReferenceListener() const
{
	return m_xReferenceListener;
}

int SecurityEntity::getSecurityId() const
{
	return m_nSecurityId;
}

bool SecurityEntity::setKey(const rtl::OUString& ouUri, bool bIsExporting)
{
	bool rc = false;
	
 	if (m_ouKeyURI != rtl::OUString(RTL_ASCII_USTRINGPARAM("")) &&
 		m_ouKeyURI == ouUri)
	{
		int nKeeperId = m_xSAXEventKeeper->addSecurityElementCollector(
			bIsExporting ?
			(cssxc::sax::ElementMarkPriority_PRI_BEFOREMODIFY):
			(cssxc::sax::ElementMarkPriority_PRI_AFTERMODIFY), 
			true);
			
		setKeyId(nKeeperId);
		m_xSAXEventKeeper->setSecurityId(nKeeperId, m_nSecurityId);

		cssu::Reference<cssxc::sax::XReferenceResolvedBroadcaster> xReferenceResolvedBroadcaster
			(m_xSAXEventKeeper, cssu::UNO_QUERY);
		xReferenceResolvedBroadcaster->addReferenceResolvedListener(nKeeperId,
			m_xReferenceListener);
			
		rc = true;
	}
	
	return rc;
}

bool SecurityEntity::endMission()
{
	cssu::Reference<cssxc::sax::XMissionTaker> xMissionTaker 
		(m_xReferenceListener, cssu::UNO_QUERY);
		
	return xMissionTaker->endMission();
}

SignatureEntity::SignatureEntity(
	const cssu::Reference<cssxc::sax::XSecuritySAXEventKeeper>& xSAXEventKeeper,
	bool bIsExporting, 
	XSecTester* pListener,
	const cssu::Reference<cssxc::XXMLSecurityContext>& xXMLSecurityContext,
	const cssu::Reference<cssxc::XXMLSignature>& xXMLSignature,
	const cssu::Reference< cssl::XMultiServiceFactory >& rsMSF)
	:SecurityEntity(xSAXEventKeeper,
			xXMLSecurityContext,
			xXMLSignature,
			rsMSF)
{
	if (bIsExporting) 
	{
		m_nSignatureElementCollectorId = 
			m_xSAXEventKeeper->addSecurityElementCollector(
				cssxc::sax::ElementMarkPriority_PRI_AFTERMODIFY,
				true);

		m_xSAXEventKeeper->setSecurityId(m_nSignatureElementCollectorId, m_nSecurityId);

		m_xReferenceListener = cssu::Reference< cssxc::sax::XReferenceResolvedListener >(
			mxMSF->createInstance( rtl::OUString::createFromAscii( SIGNATURECREATOR_COMPONENT )),
			cssu::UNO_QUERY);

		cssu::Reference<cssl::XInitialization> xInitialization(m_xReferenceListener, cssu::UNO_QUERY);
		
		cssu::Sequence<cssu::Any> args(5);
		char buf[16];
		
		sprintf(buf, "%d", m_nSecurityId);
		args[0] = cssu::makeAny(rtl::OUString(RTL_ASCII_USTRINGPARAM(buf)));
		args[1] = cssu::makeAny(m_xSAXEventKeeper);
		
		sprintf(buf, "%d", m_nSignatureElementCollectorId);
		args[2] = cssu::makeAny(rtl::OUString(RTL_ASCII_USTRINGPARAM(buf)));
		args[3] = cssu::makeAny(m_xXMLSecurityContext);
		args[4] = cssu::makeAny(m_xXMLSignature);
		
		xInitialization->initialize(args);
		
		int nBlockerId = m_xSAXEventKeeper->addBlocker();
		m_xSAXEventKeeper->setSecurityId(nBlockerId, m_nSecurityId);
	
		cssu::Reference<cssxc::sax::XBlockerMonitor> xBlockerMonitor(m_xReferenceListener, cssu::UNO_QUERY);
		xBlockerMonitor->setBlockerId(nBlockerId);
		
		cssu::Reference< cssxc::sax::XSignatureCreationResultBroadcaster > xSignatureCreationResultBroadcaster
			(m_xReferenceListener, cssu::UNO_QUERY);
		xSignatureCreationResultBroadcaster->addSignatureCreationResultListener(pListener);
	}
	else 
	{
		m_nSignatureElementCollectorId = 
			m_xSAXEventKeeper->addSecurityElementCollector(
				cssxc::sax::ElementMarkPriority_PRI_BEFOREMODIFY,
				false);
			
		m_xSAXEventKeeper->setSecurityId(m_nSignatureElementCollectorId, m_nSecurityId);

		m_xReferenceListener = cssu::Reference< cssxc::sax::XReferenceResolvedListener >(
			mxMSF->createInstance( rtl::OUString::createFromAscii( SIGNATUREVERIFIER_COMPONENT )),
			cssu::UNO_QUERY);	
		
		cssu::Reference<cssl::XInitialization> xInitialization(m_xReferenceListener, cssu::UNO_QUERY);
		
		cssu::Sequence<cssu::Any> args(5);
		char buf[16];
		
		sprintf(buf, "%d", m_nSecurityId);
		args[0] = cssu::makeAny(rtl::OUString(RTL_ASCII_USTRINGPARAM(buf)));
		args[1] = cssu::makeAny(m_xSAXEventKeeper);
		
		sprintf(buf, "%d", m_nSignatureElementCollectorId);
		args[2] = cssu::makeAny(rtl::OUString(RTL_ASCII_USTRINGPARAM(buf)));
		args[3] = cssu::makeAny(m_xXMLSecurityContext);
		args[4] = cssu::makeAny(m_xXMLSignature);
		xInitialization->initialize(args);
		
		cssu::Reference< cssxc::sax::XSignatureVerifyResultBroadcaster > xSignatureVerifyResultBroadcaster
			(m_xReferenceListener, cssu::UNO_QUERY);
		xSignatureVerifyResultBroadcaster->addSignatureVerifyResultListener(pListener);
	}

	cssu::Reference<cssxc::sax::XReferenceResolvedBroadcaster> xReferenceResolvedBroadcaster
		(m_xSAXEventKeeper, cssu::UNO_QUERY);
	xReferenceResolvedBroadcaster->addReferenceResolvedListener(
		m_nSignatureElementCollectorId, m_xReferenceListener);
}

void SignatureEntity::addReferenceURI(const rtl::OUString& ouUri)
{
	m_vReferenceIds.push_back(ouUri);
}
	
void SignatureEntity::setReferenceNumber() const
{
	cssu::Reference<cssxc::sax::XReferenceCollector> xReferenceCollector
		(m_xReferenceListener, cssu::UNO_QUERY);
	xReferenceCollector->setReferenceCount(m_vReferenceIds.size());
}
	
bool SignatureEntity::hasReference(const rtl::OUString& ouUri) const
{
	bool rc = false;
	
	std::vector<const rtl::OUString>::const_iterator ii;
	for (ii = m_vReferenceIds.begin(); ii != m_vReferenceIds.end(); ++ii) 
	{
		if (ouUri == *ii) 
		{
			rc = true;
			break;
		}
	}
		
	return rc;
}
	
bool SignatureEntity::setReference(const rtl::OUString& ouUri, bool bIsExporting) const
{
	bool rc = false;
	
	if (hasReference(ouUri)) 
	{
		int nKeeperId = m_xSAXEventKeeper->addSecurityElementCollector(
				bIsExporting ?
				(cssxc::sax::ElementMarkPriority_PRI_AFTERMODIFY):
				(cssxc::sax::ElementMarkPriority_PRI_BEFOREMODIFY),
				false);
				
		m_xSAXEventKeeper->setSecurityId(nKeeperId, m_nSecurityId);

		cssu::Reference<cssxc::sax::XReferenceResolvedBroadcaster> xReferenceResolvedBroadcaster  
			(m_xSAXEventKeeper, cssu::UNO_QUERY);
		xReferenceResolvedBroadcaster->addReferenceResolvedListener(nKeeperId, m_xReferenceListener);
		
		cssu::Reference<cssxc::sax::XReferenceCollector> xReferenceCollector
			(m_xReferenceListener, cssu::UNO_QUERY);
		xReferenceCollector->setReferenceId(nKeeperId);
				
		rc = true;
	}
	
	return rc;
}

/* XDocumentHandler */
void SAL_CALL XSecTester::startDocument()
	throw (cssu::RuntimeException)
{
}

void SAL_CALL XSecTester::endDocument()
	throw (cssu::RuntimeException)
{
}

void SAL_CALL XSecTester::characters(const class rtl::OUString & chars)
	throw (cssu::RuntimeException)
{
	m_xExportHandler->characters(chars);
}

void SAL_CALL XSecTester::processingInstruction(const rtl::OUString & target, const rtl::OUString &data)
	throw (cssu::RuntimeException)
{
	m_xExportHandler->processingInstruction(target, data);
}

void SAL_CALL XSecTester::ignorableWhitespace(const rtl::OUString &)
	throw (cssu::RuntimeException)
{

}

void SAL_CALL XSecTester::startElement(const rtl::OUString & name, const cssu::Reference<cssxs::XAttributeList> &xAttribs)
	throw (cssu::RuntimeException)
{
	rtl::OUString ouIdAttr = xAttribs->getValueByName(
		rtl::OUString(RTL_ASCII_USTRINGPARAM("id")));
		
	if (ouIdAttr == NULL) 
	{
		ouIdAttr = xAttribs->getValueByName(
			rtl::OUString(RTL_ASCII_USTRINGPARAM("Id")));
	}
			
	bool bHasIdAttr = (ouIdAttr != NULL && ouIdAttr.getLength() > 0 );
	bool needResend = false;
			
	if (bHasIdAttr || name.equalsAscii( SIGNATURE_STR )) 
	{
		if (foundSecurityRelated() && ! m_bIsExporting) 
		{
			needResend = true;
		}
	}
	
	if ( !m_bIsSAXEventKeeperOnTheSAXChain )
	{
		addStartAncestorEvent(name, xAttribs);
	}
	
	bool bSuppressingForwarding = checkSecurityElement(name, xAttribs);
			
	checkReference(name, xAttribs, ouIdAttr);
			
	if (needResend) 
	{
		m_xSAXEventKeeper->setNextHandler(NULL);
				
		cssu::Reference<cssxs::XDocumentHandler> xSAXEventKeeperHandler 
			(m_xSAXEventKeeper, cssu::UNO_QUERY);
			
		xSAXEventKeeperHandler->startElement(name, xAttribs);
		m_xSAXEventKeeper->setNextHandler(this);
	}
	
	if (!bSuppressingForwarding) 
	{
		m_xExportHandler->startElement(name, xAttribs);
	}
}

void SAL_CALL XSecTester::endElement(const rtl::OUString& name)
	throw (cssu::RuntimeException)
{
	if (!m_stCurrentPath.empty()) 
	{
		void* pSignedInfo = m_stCurrentPath.top();
		bool bIsStringType = m_stCurrentPathType.top();
		
		m_stCurrentPath.pop();
		m_stCurrentPathType.pop();
        	
		if (bIsStringType && !strcmp((const char *)pSignedInfo, SIGNEDINFO_STR))
		{
			if (!m_stCurrentPath.empty()) 
			{
				void* pSignature = m_stCurrentPath.top();
				bIsStringType = m_stCurrentPathType.top();
				
				if (!bIsStringType && pSignature != NULL)
				{
					((SignatureEntity *) pSignature)->setReferenceNumber();
				}
			}
		}
	}
	
	if ( !m_bIsSAXEventKeeperOnTheSAXChain )
	{
		addEndAncestorEvent(name);
	}
		
	m_xExportHandler->endElement(name);
}

void SAL_CALL XSecTester::setDocumentLocator( const cssu::Reference<cssxs::XLocator>& )
	throw (cssu::RuntimeException)
{
}

void XSecTester::changeOutput()
{
	if (m_bIsExporting) 
	{
		if (m_bIsSAXEventKeeperOnTheSAXChain) 
		{
			m_xExportHandler = cssu::Reference<cssxs::XDocumentHandler>
				(m_xSAXEventKeeper, cssu::UNO_QUERY);
				
			m_xSAXEventKeeper->setNextHandler(NULL);
			
			flushAncestorEvents(m_xExportHandler);

			m_xSAXEventKeeper->setNextHandler(m_xOutputHandler);
		}
		else 
		{
			m_xExportHandler = m_xOutputHandler;
		}
	}
 	else 
 	{
		if (m_bIsSAXEventKeeperOnTheSAXChain) 
		{
			cssu::Reference<cssxs::XDocumentHandler> xSAXEventKeeperHandler
				(m_xSAXEventKeeper, cssu::UNO_QUERY);
				
			m_xSAXEventKeeper->setNextHandler(NULL);
			
			flushAncestorEvents(xSAXEventKeeperHandler);

			m_xSaxParser->setDocumentHandler(xSAXEventKeeperHandler);
			m_xSAXEventKeeper->setNextHandler(this);
		}
		else 
		{
			m_xSaxParser->setDocumentHandler(this);
		}

	}
}

bool XSecTester::foundSecurityRelated()
{
	if (m_xSAXEventKeeper == NULL) 
	{
		m_bIsBlocking = false;
		m_bIsInsideCollectedElement = false;

		m_xXMLDocumentWrapper = cssu::Reference<cssxw::XXMLDocumentWrapper>
			(mxMSF->createInstance( m_ouXMLDocumentWrapperComponentName ),
			 cssu::UNO_QUERY);

		m_xSAXEventKeeper = cssu::Reference< cssxc::sax::XSecuritySAXEventKeeper >
			(mxMSF->createInstance( rtl::OUString::createFromAscii( SAXEVENTKEEPER_COMPONENT )),
			 cssu::UNO_QUERY);

		cssu::Reference<cssl::XInitialization> xInitialization(m_xSAXEventKeeper,  cssu::UNO_QUERY);

		cssu::Sequence <cssu::Any> arg(1);
		arg[0] = cssu::makeAny(m_xXMLDocumentWrapper);
		xInitialization->initialize(arg);
		
		cssu::Reference<cssxc::sax::XSAXEventKeeperStatusChangeBroadcaster>
			xSAXEventKeeperStatusChangeBroadcaster(m_xSAXEventKeeper, cssu::UNO_QUERY); 
		xSAXEventKeeperStatusChangeBroadcaster->addXSAXEventKeeperStatusChangeListener(this);
	}
		
	bool rc = false;
	
	if (!m_bIsSAXEventKeeperOnTheSAXChain) 
	{
		rc = true;
	}
		
	m_bIsSAXEventKeeperOnTheSAXChain=true;
	changeOutput();

	return rc;
}

void XSecTester::findKeyOrReference(SecurityEntity* pSecurityEntity, const rtl::OUString& ouUri, bool bIsFindingKey)
{
	std::vector<rtl::OUString>::iterator ii_referenceURIs;
	std::vector<int>::iterator ii_referenceKeeperIds;
	std::vector<int>::iterator ii_referenceRefNums;

	for (ii_referenceURIs = m_vUnsolvedReferenceURIs.begin(),
	     ii_referenceKeeperIds = m_vUnsolvedReferenceKeeperIds.begin(),
	     ii_referenceRefNums = m_vUnsolvedReferenceRefNums.begin();
 	     ii_referenceURIs != m_vUnsolvedReferenceURIs.end(); ) 
	{
		rtl::OUString ouReferenceUri = *ii_referenceURIs;
			
		if (ouReferenceUri == ouUri) 
		{
			int nKeeperId = *ii_referenceKeeperIds;
			int nRefNum = *ii_referenceRefNums;
			
			if ( bIsFindingKey )
			{
			 	int nClonedKeeperId = m_xSAXEventKeeper->cloneElementCollector(
			 		nKeeperId,
			 		m_bIsExporting?
			 		(cssxc::sax::ElementMarkPriority_PRI_BEFOREMODIFY):
					(cssxc::sax::ElementMarkPriority_PRI_AFTERMODIFY));
	
			 	pSecurityEntity->setKeyId(nClonedKeeperId);
	
			 	m_xSAXEventKeeper->setSecurityId(nClonedKeeperId, pSecurityEntity->getSecurityId());
	
			 	cssu::Reference<cssxc::sax::XReferenceResolvedBroadcaster>
					xReferenceResolvedBroadcaster(m_xSAXEventKeeper, cssu::UNO_QUERY);
				xReferenceResolvedBroadcaster->addReferenceResolvedListener(
			 		nClonedKeeperId,
			 		pSecurityEntity->getReferenceListener());
			}
			else
			{
				int nClonedKeeperId = m_xSAXEventKeeper->cloneElementCollector(
					nKeeperId, 
					m_bIsExporting?
					(cssxc::sax::ElementMarkPriority_PRI_AFTERMODIFY):
					(cssxc::sax::ElementMarkPriority_PRI_BEFOREMODIFY));
					
				m_xSAXEventKeeper->setSecurityId(nClonedKeeperId, pSecurityEntity->getSecurityId());
				
				cssu::Reference<cssxc::sax::XReferenceResolvedBroadcaster>
					xReferenceResolvedBroadcaster 
					(m_xSAXEventKeeper, cssu::UNO_QUERY);
				xReferenceResolvedBroadcaster->addReferenceResolvedListener(
					nClonedKeeperId,
					pSecurityEntity->getReferenceListener());
					
				cssu::Reference<cssxc::sax::XReferenceCollector> xReferenceCollector 
						(pSecurityEntity->getReferenceListener(), cssu::UNO_QUERY);
				xReferenceCollector->setReferenceId(nClonedKeeperId);
			}

			nRefNum--;
			if (nRefNum == 0) 
			{
				m_xSAXEventKeeper->removeElementCollector(nKeeperId);
				
				ii_referenceURIs = m_vUnsolvedReferenceURIs.erase(ii_referenceURIs);
				ii_referenceKeeperIds = m_vUnsolvedReferenceKeeperIds.erase(ii_referenceKeeperIds);
				ii_referenceRefNums = m_vUnsolvedReferenceRefNums.erase(ii_referenceRefNums);
			}
			else 
			{
				(*ii_referenceRefNums) = nRefNum;

				ii_referenceURIs++;
				ii_referenceKeeperIds++;
				ii_referenceRefNums++;
			}
			
			if (bIsFindingKey)
			{
				break;
			}
		}
		else 
		{
			ii_referenceURIs++;
			ii_referenceKeeperIds++;
			ii_referenceRefNums++;
		}
	}
}

bool XSecTester::checkSecurityElement(
	const rtl::OUString& ouLocalName,
	const cssu::Reference<cssxs::XAttributeList>& xAttribs)
{
	bool rc = false;
		
	if (ouLocalName.equalsAscii(SIGNATURE_STR))
	{
		SignatureEntity* pSignatureEntity = new SignatureEntity(
			m_xSAXEventKeeper,
			m_bIsExporting,
			this,
			m_xXMLSecurityContext,
			m_xXMLSignature,
			mxMSF);
		
		m_vSignatureList.push_back(pSignatureEntity);
		
		m_stCurrentPath.push(pSignatureEntity);
		m_stCurrentPathType.push(false);
	}
	else if (ouLocalName.equalsAscii(REFERENCE_STR))
	{
		if (!m_stCurrentPath.empty()) 
		{
	 		void* pSignedInfo = m_stCurrentPath.top();
	 		bool bIsStringType = m_stCurrentPathType.top();
	 		
			m_stCurrentPath.pop();
			m_stCurrentPathType.pop();
 			
			if (bIsStringType && !m_stCurrentPath.empty()) 
			{
				void* pSignature = m_stCurrentPath.top();
				bool bIsStringType2 = m_stCurrentPathType.top();

				if (!strcmp((const char*)pSignedInfo, SIGNEDINFO_STR) && !bIsStringType2)
				{
					rtl::OUString ouUri = xAttribs->getValueByName
						(rtl::OUString(RTL_ASCII_USTRINGPARAM( URI_ATTR_STR )));
					
					if (ouUri.matchAsciiL("#", 1, 0))
					{
						rtl::OUString uri = ouUri.copy(1);
 						SignatureEntity* pSignatureEntity = (SignatureEntity *)pSignature;
		
						if (uri != NULL && uri.getLength()>0) 
						{
							pSignatureEntity->addReferenceURI(uri);
							findKeyOrReference(pSignatureEntity, uri, true);
						}
					}
				}
			}
			m_stCurrentPath.push(pSignedInfo);
			m_stCurrentPathType.push(bIsStringType);
		}
		m_stCurrentPath.push( (void *)REFERENCE_STR);
		m_stCurrentPathType.push(true);
	}
	else if(ouLocalName.equalsAscii(KEYVALUE_STR) || 
		ouLocalName.equalsAscii(KEYNAME_STR) || 
		ouLocalName.equalsAscii(X509DATA_STR) || 
		ouLocalName.equalsAscii(ENCRYPTEDKEY_STR)) 
	{
		if (!m_stCurrentPath.empty()) 
		{
			void* pKeyInfo = m_stCurrentPath.top();
			bool bIsStringType = m_stCurrentPathType.top();
			
			m_stCurrentPath.pop();
			m_stCurrentPathType.pop();
			
 			if (bIsStringType && !m_stCurrentPath.empty()) 
 			{
				bool bIsStringType2 = m_stCurrentPathType.top();
				
				if (!bIsStringType2)
				{
					SecurityEntity *pSecurityEntity = 
						(SecurityEntity *) (m_stCurrentPath.top());
					pSecurityEntity->setKeyId(0);
				}
 			}
 			
			m_stCurrentPath.push(pKeyInfo);
			m_stCurrentPathType.push(bIsStringType);
		}
		
		m_stCurrentPath.push((void *)KEYVALUE_STR);
		m_stCurrentPathType.push(true);
	}
	else if(ouLocalName.equalsAscii(RETRIEVALMETHOD_STR)) 
	{
		if (!m_stCurrentPath.empty()) 
		{
			void* pKeyInfo = m_stCurrentPath.top();
			bool bIsStringType = m_stCurrentPathType.top();
			
			m_stCurrentPath.pop();
			m_stCurrentPathType.pop();
			
			if (bIsStringType && !m_stCurrentPath.empty()) 
			{
				bool bIsStringType2 = m_stCurrentPathType.top();
				
				if (!bIsStringType2)
				{
					SecurityEntity *pSecurityEntity = 
						(SecurityEntity *) m_stCurrentPath.top();
					rtl::OUString ouUri = xAttribs->getValueByName(
						rtl::OUString(RTL_ASCII_USTRINGPARAM( URI_ATTR_STR )));
					
					if (!strcmp((const char *)pKeyInfo, KEYINFO_STR) && 
						ouUri != NULL && ouUri.getLength()>0) 
					{
						pSecurityEntity->setKeyURI(ouUri);
						findKeyOrReference(pSecurityEntity, ouUri, true);
					}
				}
				
			}
			
			m_stCurrentPath.push(pKeyInfo);
			m_stCurrentPathType.push(bIsStringType);
		}
		
		m_stCurrentPath.push((void *)RETRIEVALMETHOD_STR);
		m_stCurrentPathType.push(true);
	}
	else if(ouLocalName.equalsAscii(KEYINFO_STR)) 
	{
		m_stCurrentPath.push((void *)KEYINFO_STR);
		m_stCurrentPathType.push(true);
	}
	else if(ouLocalName.equalsAscii(SIGNEDINFO_STR)) 
	{
		m_stCurrentPath.push((void *)SIGNEDINFO_STR);
		m_stCurrentPathType.push(true);
	}
	else
	{
		m_stCurrentPath.push((void *)OTHER_ELEMENT_STR);
		m_stCurrentPathType.push(true);
	}
	
	return rc;
}

void XSecTester::checkReference(
	const rtl::OUString& ouLocalName,
	const cssu::Reference<cssxs::XAttributeList>& xAttribs,
	const rtl::OUString& ouId)
{
	rtl::OUString refNumStr = 
		xAttribs->getValueByName(rtl::OUString(RTL_ASCII_USTRINGPARAM(REFNUM_ATTR_STR)));
		
	if (ouId != NULL && ouId.getLength()>0 ) 
	{
		int nRefNum = 999;
		if (refNumStr != NULL && refNumStr.getLength()>0 ) 
		{
			nRefNum = refNumStr.toInt32();
		}
		
		int nLength = m_vSignatureList.size();
		for (int i = 0; i<nLength; ++i) 
		{
			SignatureEntity* pSignatureEntity = m_vSignatureList.at(i);
				
			if (pSignatureEntity->setReference(ouId, m_bIsExporting)) 
			{
				nRefNum--;
			}
				
			if (pSignatureEntity->setKey(ouId, m_bIsExporting)) 
			{
				nRefNum--;
			}
		}
		
		if (nRefNum>0) 
		{
			int nKeeperId;
			
			if (ouLocalName.equalsAscii(ENCRYPTEDKEY_STR)) 
			{
				nKeeperId = m_xSAXEventKeeper->addSecurityElementCollector(
					m_bIsExporting ?
					(cssxc::sax::ElementMarkPriority_PRI_BEFOREMODIFY):
					(cssxc::sax::ElementMarkPriority_PRI_AFTERMODIFY),
					true);
			}
			else 
			{
				nKeeperId = m_xSAXEventKeeper->addSecurityElementCollector(
					m_bIsExporting?
					(cssxc::sax::ElementMarkPriority_PRI_AFTERMODIFY):
					(cssxc::sax::ElementMarkPriority_PRI_BEFOREMODIFY),
					false);
			}
					
			m_vUnsolvedReferenceURIs.push_back(ouId);
			m_vUnsolvedReferenceKeeperIds.push_back(nKeeperId);
			m_vUnsolvedReferenceRefNums.push_back(nRefNum);
		}
	}
}

void XSecTester::endMission()
{
	while (m_vSignatureList.size() > 0)
	{
		if (m_vSignatureList.size()>0) 
		{
			SignatureEntity * pSignatureEntity = m_vSignatureList.at(0);
			m_vSignatureList.erase(m_vSignatureList.begin());
			pSignatureEntity->endMission();
			delete pSignatureEntity;
		}
	}
		
	while (m_vUnsolvedReferenceURIs.size()>0) 
	{
		int nKeeperId = m_vUnsolvedReferenceKeeperIds.at(0);
		m_xSAXEventKeeper->removeElementCollector(nKeeperId);
		m_vUnsolvedReferenceURIs.erase(m_vUnsolvedReferenceURIs.begin());
		m_vUnsolvedReferenceKeeperIds.erase(m_vUnsolvedReferenceKeeperIds.begin());
		m_vUnsolvedReferenceRefNums.erase(m_vUnsolvedReferenceRefNums.begin());
	}
}

void XSecTester::addStartAncestorEvent(
	const rtl::OUString& ouName,
	const cssu::Reference< cssxs::XAttributeList >& xAttribs)
{
	sal_Int32 nLength = xAttribs->getLength();
	AncestorEvent* ancestorEvent = new AncestorEvent( nLength );
	
	ancestorEvent->bIsStartElement = true;
	ancestorEvent->ouName = ouName;
	
	for (int i = 0; i<nLength; ++i) 
	{
		(ancestorEvent->aAttributeList[i]).sName = xAttribs->getNameByIndex((short)i);
		(ancestorEvent->aAttributeList[i]).sValue =xAttribs->getValueByIndex((short)i);
	}
	
	m_vAncestorEvents.push_back(ancestorEvent);
}

void XSecTester::addEndAncestorEvent(const rtl::OUString& ouName)
{
	AncestorEvent* ancestorEvent = new AncestorEvent(0);
	
	ancestorEvent->bIsStartElement = false;
	ancestorEvent->ouName = ouName;
	
	m_vAncestorEvents.push_back(ancestorEvent);
}

void XSecTester::sendAncestorStartElementEvent(
	const rtl::OUString& ouName, 
	const cssu::Sequence< cssxcsax::XMLAttribute >& attrList,
	const cssu::Reference< cssxs::XDocumentHandler >& xDocumentHandler) const
{
	SvXMLAttributeList* pAttributeList = new SvXMLAttributeList();
	cssu::Reference < cssxs::XAttributeList > xAttrList
		= cssu::Reference< cssxs::XAttributeList > (pAttributeList);

	sal_Int32 nLength = attrList.getLength();
	
	for (int i = 0; i<nLength; ++i) 
	{
		pAttributeList->AddAttribute( attrList[i].sName, attrList[i].sValue);
	}
	
	xDocumentHandler->startElement(ouName, xAttrList);
}

void XSecTester::sendAncestorEndElementEvent(
	const rtl::OUString& ouName,
	const cssu::Reference< cssxs::XDocumentHandler >& xDocumentHandler) const
{
	xDocumentHandler->endElement(ouName);
}

std::vector< AncestorEvent* >::const_iterator XSecTester::checkAncestorStartElementEvent( 
	const std::vector< AncestorEvent* >::const_iterator& ii,
	const cssu::Reference< cssxs::XDocumentHandler >& xDocumentHandler) const
{
	std::vector< AncestorEvent* >::const_iterator next = ii+1;
	
	if (next == m_vAncestorEvents.end())
	{
		sendAncestorStartElementEvent(
			(*ii)->ouName, (*ii)->aAttributeList, xDocumentHandler);
	}
	else
	{
		while ((next != m_vAncestorEvents.end()) && ((*next)->bIsStartElement))
		{
			next = checkAncestorStartElementEvent(next, xDocumentHandler);
		}
		
		if (next != m_vAncestorEvents.end())
		{
			next++;
		}
	}
	
	return next;
}
	
void XSecTester::flushAncestorEvents(
	const cssu::Reference< cssxs::XDocumentHandler >& xDocumentHandler)
{
	std::vector< AncestorEvent* >::const_iterator ii;
	
	if (xDocumentHandler != NULL)
	{
		ii = m_vAncestorEvents.begin();
		
		while (ii != m_vAncestorEvents.end())
		{
			AncestorEvent* ancestorEvent = *ii;
			
			if (ancestorEvent->bIsStartElement)
			{
				ii = checkAncestorStartElementEvent(ii, xDocumentHandler);
			}
			else
			{
				sendAncestorEndElementEvent((*ii)->ouName, xDocumentHandler);
				ii++;
			}
		}
	}
	
	/* free the ancestor events list */
	std::vector< AncestorEvent* >::iterator jj;
	
	while (m_vAncestorEvents.size()>0) 
	{
		jj = m_vAncestorEvents.begin();
		delete *jj;
		m_vAncestorEvents.erase(jj);
	}
}

