#
#    Copyright 2015, 2016 Kai Pastor
#    
#    This file is part of OpenOrienteering.
# 
#    OpenOrienteering is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    OpenOrienteering is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with OpenOrienteering.  If not, see <http://www.gnu.org/licenses/>.

TEMPLATE = lib
TARGET   = printsupport
CONFIG  += staticlib c++11
CONFIG  -= debug_and_release
QT      += printsupport printsupport-private gui-private core-private
DEFINES *= QT_USE_QSTRINGBUILDER QT_NO_CAST_FROM_ASCII QT_NO_CAST_TO_ASCII

lessThan(QT_MINOR_VERSION, 3):FORK_VERSION = qt-5.2.1
else:FORK_VERSION = qt-5.5.1

INCLUDEPATH += $$PWD $$PWD/$$FORK_VERSION

#HEADERS = \
#  advanced_printer.h

SOURCES = \
  advanced_pdf_printer.cpp \
  $$FORK_VERSION/printengine_advanced_pdf.cpp \
  $$FORK_VERSION/advanced_pdf.cpp \
  $$FORK_VERSION/qfontsubset.cpp

win32: SOURCES += printer_properties_win.cpp
else:  SOURCES += printer_properties.cpp

PRINTSUPPORT_PRI = \
  "$$LITERAL_HASH Generated by $$_PRO_FILE_" \
  "DEPENDPATH  += $$PWD" \
  "INCLUDEPATH += $$PWD" \
  "LIBS        += \"-L$$OUT_PWD\" -lprintsupport -lz"

write_file($$OUT_PWD/printsupport.pri, PRINTSUPPORT_PRI)
