---
title: User Manual
edited: 21 December 2019
redirect_from:
  - /
  - /Home
---

{% if doxygen %}
**Note:** The [online version](https://www.openorienteering.org/mapper-manual/) of this documentation may contain additions and corrections.
{% endif %}

## Contents

[Installation](installation.md){: .subpage}
Instructions to download and install OpenOrienteering.

[Main window](main_window.md){: .subpage}
Explanation of the main drawing window.

[Reference](reference.md){: .subpage}
Toolbar and menu items, including explanations for [all drawing tools](toolbars.md#drawing-toolbar).

[Starting a new map](new_map.md){: .subpage}
First steps.

[Georeferencing](georeferencing.md){: .subpage}
Defining the relationship between map paper coordinates and real world coordinates.

[Map grid](grid.md){: .subpage}
Showing a helper grid in the map view.

[Templates](templates-index.md){: .subpage}
Working with templates.

[Geospatial data](gdal.md){: .subpage}
Geospatial raster data and vector data support based on GDAL.

[Colors and symbols](colors_symbols.md){: .subpage}
Modifying map colors and symbols.

[Map parts](map_parts.md){: .subpage}
Organizing objects in maps.

[Object tags](object_tags.md){: .subpage}
Attaching arbitrary key-value pairs to objects.

[Find objects](find_objects.md){: .subpage}
Finding objects based on textual properties.

[CRT files](crt_files.md){: .subpage}
Providing rules for assigning symbols.

[CoVe, the Contour Vectorizer](cove.md){: .subpage}
Vectorizing line features in raster graphics templates.

[Settings](settings.md){: .subpage}
Adjusting the program to your preferences.

[Course design](course_design.md){: .subpage}
Using the course design symbol set.

[The Mapper app for Android](android-app.md){: .subpage}
Working with the Android version of Mapper.

[FAQ](faq.md){: .nosubpage}
Frequently asked questions.


## Online resources

[Blog](https://www.openorienteering.org/)
The latest news from OpenOrienteering.

[Issues list](https://github.com/OpenOrienteering/mapper/issues)
Submit feedback, bug reports, feature requests, and contributions.

[Releases](https://github.com/OpenOrienteering/mapper/releases)
Releases, with links to change information and known issues.
