# Copyright (C) 2000-2001 The OpenRPG Project
#
#	openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: orpg_windows.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: orpg_windows.py,v 1.15 2003/02/03 20:26:09 posterboy Exp $
#
# Description: orpg custom windows
#

__version__ = "$Id: orpg_windows.py,v 1.15 2003/02/03 20:26:09 posterboy Exp $"

import os
import systempath


import orpg.dirpath 
#import minidom
import orpg.orpg_xml
import orpg.tools.rgbhex
import re

try:
    from wxPython.wx import *
    from wxPython.html import *
    import wxPython.lib.wxpTag
    from wxPython.grid import *
    from wxPython.lib.filebrowsebutton import  *
except ImportError:
    print "\n\nImporting wxPython Failed! You must install wxPython for OpenRPG to run"
    print "Download the latest version here: http://www.openrpg.com/orpgnuke/modules.php?name=GetORPG"

import string
import urllib
import orpg.tools.rgbhex


class img_helper:
    def __init__(self):
        pass

    def load_url(self,path):
        img_type = self.get_type(path)
        try:
            data = urllib.urlretrieve(path)
            if data:
                img = wxBitmap(data[0], img_type)                
            else:
                raise IOError, "Image refused to load!"
        except IOError, e:		       
            img = None
        return img


    def load_file(self,path):
        img_type = self.get_type(path)
        return wxBitmap(path, img_type)

    def get_type(self,file_name):
        pos = string.rfind(file_name,'.')
        ext = string.lower(file_name[pos+1:])
        img_type = 0
        if ext == "gif":
            img_type = wxBITMAP_TYPE_GIF
        elif (ext == "jpg") | (ext == "jpeg"):
            img_type = wxBITMAP_TYPE_JPEG
        elif ext == "bmp":
            img_type = wxBITMAP_TYPE_BMP
        elif ext == "png":
            img_type = wxBITMAP_TYPE_PNG
        else:
            imf_type = None
        return img_type
            


################################
## Panels
################################

class wxBoxedSizer(wxPanel):
    def __init__(self, parent, txt):
        wxPanel.__init__(self, parent, -1)
        self.sizer = None
        self.outline = wxStaticBox(self,-1,txt)
        self.ctrl = None
        EVT_SIZE(self, self.on_size)
        
    def set_sizer(self,sizer):
        self.sizer = sizer
        self.SetSizer(self.sizer)

    def set_ctrl(self,ctrl):
        self.ctrl = ctrl

    def on_size(self,event):
        s = self.GetClientSizeTuple()   
        if self.sizer:
            self.sizer.SetDimension(20,20,s[0]-40,s[1]-40)
        if self.ctrl:
            self.ctrl.SetDimensions(20,20,s[0]-40,s[1]-40)
        self.outline.SetDimensions(5,5,s[0]-10,s[1]-10)


#####################
## A text editor for openrpg related text
#####################

class html_text_edit(wxPanel):
    """ a text ctrl with html helpers """
    def __init__(self, parent, id, text, callback,home_dir):
        wxPanel.__init__(self, parent,-1)
        self.r_h = orpg.tools.rgbhex.RGBHex()
        self.text = orpgTextCtrl(self, id, text, wxDefaultPosition,
                             wxDefaultSize,
                             wxTE_MULTILINE )
        EVT_SIZE(self, self.OnSize)
        EVT_TEXT(self, id, callback)
        self.callback = callback
        self.BOLD = wxNewId()
        self.ITALIC = wxNewId()
        self.UNDER = wxNewId()
        self.COLOR = wxNewId()
        self.DIE100 = wxNewId()
        self.DIE20 = wxNewId()
        self.DIE10 = wxNewId()
        self.DIE8 = wxNewId()
        self.DIE6 = wxNewId()
        self.DIE4 = wxNewId()
        self.DIE2 = wxNewId()
        self.DIE = wxNewId()

        self.sizer = wxBoxSizer(wxHORIZONTAL)
        gif = wxImage(orpg.dirpath.dir_struct["icon"]+"bold.gif", wxBITMAP_TYPE_GIF)
        self.sizer.Add(wxBitmapButton(self, self.BOLD, gif.ConvertToBitmap()), 0, wxEXPAND)
        gif = wxImage(orpg.dirpath.dir_struct["icon"]+"italic.gif", wxBITMAP_TYPE_GIF)
        self.sizer.Add(wxBitmapButton(self, self.ITALIC, gif.ConvertToBitmap()), 0, wxEXPAND)
        gif = wxImage(orpg.dirpath.dir_struct["icon"]+"underlined.gif", wxBITMAP_TYPE_GIF)
        self.sizer.Add(wxBitmapButton(self, self.UNDER, gif.ConvertToBitmap()), 0, wxEXPAND)
        self.color_button = wxButton(self, self.COLOR, "C",wxPoint(0,0),wxSize(22,0))
        self.color_button.SetBackgroundColour(wxBLACK)
        self.color_button.SetForegroundColour(wxWHITE)
        self.sizer.Add(self.color_button, 0, wxEXPAND)

        EVT_BUTTON(self, self.BOLD, self.on_text_format)
        EVT_BUTTON(self, self.ITALIC, self.on_text_format)
        EVT_BUTTON(self, self.UNDER, self.on_text_format)
        EVT_BUTTON(self, self.COLOR, self.on_text_format)

    def on_text_format(self,event):
        id = event.GetId()
        if wxPlatform == '__WXMSW__':
            txt = self.text.GetLabel()
        else:
            txt = self.text.GetValue()
        (beg,end) = self.text.GetSelection()
        if beg != end:
            sel_txt = txt[beg:end]
        else:
            return
        print txt
        if id == self.BOLD:
            sel_txt = "<b>" + sel_txt + "</b>"
        elif id == self.ITALIC:
            sel_txt = "<i>" + sel_txt + "</i>"
        elif id == self.UNDER:
            sel_txt = "<u>" + sel_txt + "</u>"
        elif id == self.COLOR:
            hexcolor = self.r_h.do_hex_color_dlg(self)
            if hexcolor:
                sel_txt = "<font color='"+hexcolor+"'>"+sel_txt+"</font>"
                self.color_button.SetBackgroundColour(hexcolor)

        txt = txt[:beg] + sel_txt + txt[end:]
       # print txt
        if wxPlatform == '__WXMSW__':
            txt = self.text.SetLabel(txt)
        else:
            txt = self.text.SetValue(txt)
        self.text.SetInsertionPoint(beg)
        self.text.SetFocus()
        self.callback(wxEvent(self.text.GetId()))
        
    def set_text(self,txt):
        self.text.SetValue(txt)  
    
    def get_text(self):
        return self.text.GetValue()
        
    def OnSize(self,event):
        (w,h) = self.GetClientSizeTuple()
        self.text.SetDimensions(0,0,w,h-25)
        self.sizer.SetDimension(0,h-25,w,25)
       

################################
## controls
################################

TEXT_CUT = wxNewId()
TEXT_PASTE = wxNewId()
TEXT_COPY = wxNewId()
TEXT_SELECT_ALL = wxNewId()
TEXT_UNDO = wxNewId()
TEXT_REDO = wxNewId()
# Heroman
TEXT_DISPLAY_HTML = wxNewId()
TEXT_HTML_BOLD = wxNewId()
TEXT_HTML_ITAL = wxNewId()
TEXT_HTML_UNDER = wxNewId()
TEXT_HTML_COLOR = wxNewId()
TEXT_HTML_OTHER=wxNewId()
TEXT_HTML_BORDER = wxNewId()
TEXT_HTML_RULE = wxNewId()
TEXT_HTML_URL = wxNewId()
TEXT_HTML_IMG = wxNewId()

class orpgTextCtrl(wxTextCtrl):
    def __init__(self, parent, id, value="",pos=wxDefaultPosition, size=wxDefaultSize, style=0, validator=None, name=""):
        if validator:
            wxTextCtrl.__init__(self, parent, id, value,pos, size, style, validator, name)
        else:
            wxTextCtrl.__init__(self, parent, id, value,pos, size, style)
        self.r_h = orpg.tools.rgbhex.RGBHex()
        self.edit_menu = wxMenu()
        self.edit_menu.Append(TEXT_CUT,"Cu&t")
        self.edit_menu.Append(TEXT_COPY,"&Copy")
        self.edit_menu.Append(TEXT_PASTE,"&Paste")
        self.edit_menu.AppendSeparator()
        self.edit_menu.Append(TEXT_SELECT_ALL,"Select &All")
        self.edit_menu.AppendSeparator()
        self.edit_menu.Append(TEXT_DISPLAY_HTML,"HTML Preview")
        self.edit_menu.AppendSeparator()
        self.edit_menu.Append(TEXT_HTML_BOLD,"Bold")
        self.edit_menu.Append(TEXT_HTML_ITAL,"Italics")
        self.edit_menu.Append(TEXT_HTML_UNDER,"Underline")
        self.edit_menu.Append(TEXT_HTML_COLOR,"Color")
        self.edit_menu_other=wxMenu()
        self.edit_menu_other.Append(TEXT_HTML_BORDER,"Border")
        self.edit_menu_other.Append(TEXT_HTML_RULE,"Horizantal Rule")
        self.edit_menu_other.Append(TEXT_HTML_IMG,"Image Tag")
        self.edit_menu_other.Append(TEXT_HTML_URL,"URL Tag","Adds empty tag or uses selection as a URL")

        self.edit_menu.AppendMenu(TEXT_HTML_OTHER,"Other",self.edit_menu_other,"Other HTML tags...");

        EVT_RIGHT_DOWN(self, self.on_rclick)
        EVT_MENU(self, TEXT_COPY, self.on_menu)
        EVT_MENU(self, TEXT_CUT, self.on_menu)
        EVT_MENU(self, TEXT_PASTE, self.on_menu)
        EVT_MENU(self, TEXT_SELECT_ALL, self.on_menu)
        EVT_MENU(self, TEXT_DISPLAY_HTML,self.on_menu)
        EVT_MENU(self, TEXT_HTML_BOLD,self.on_menu)
        EVT_MENU(self, TEXT_HTML_ITAL,self.on_menu)
        EVT_MENU(self, TEXT_HTML_UNDER,self.on_menu)
        EVT_MENU(self, TEXT_HTML_COLOR,self.on_menu)
        EVT_MENU(self, TEXT_HTML_BORDER,self.on_menu)
        EVT_MENU(self, TEXT_HTML_RULE,self.on_menu)
        EVT_MENU(self, TEXT_HTML_IMG,self.on_menu)
        EVT_MENU(self, TEXT_HTML_URL,self.on_menu)

        
    def on_rclick(self,evt):
        pt = evt.GetPosition()
        self.PopupMenu(self.edit_menu,pt)
        
    def on_menu(self,evt):
        id = evt.GetId()
        if id == TEXT_COPY:
            self.Copy()
        elif id == TEXT_CUT:
            self.Cut()
        elif id == TEXT_PASTE:
            self.Paste()       
        elif id == TEXT_SELECT_ALL:
            self.SetFocus()
            self.SetSelection(0,self.GetLastPosition())
        elif id == TEXT_HTML_BOLD:
            sel=self.GetStringSelection();
            self.Cut()
            self.WriteText("<b>"+sel+"</b>")
        elif id == TEXT_HTML_ITAL:
            sel=self.GetStringSelection();
            self.Cut()
            self.WriteText("<i>"+sel+"</i>")
        elif id == TEXT_HTML_IMG:
            sel=self.GetStringSelection();
            self.Cut()
            self.WriteText("<img src=\""+sel+"\">")
        elif id == TEXT_HTML_URL:
            sel=self.GetStringSelection();
            self.Cut()
            if sel == "":
                self.WriteText("<a href=\"INSERT_URL_HERE\">INSERT_TEXT_HERE</a>")
            else:
                self.WriteText("<a href=\""+sel+"\">"+sel+"</a>")
        elif id == TEXT_HTML_UNDER:
            sel=self.GetStringSelection();
            self.Cut()
            self.WriteText("<u>"+sel+"</u>")
        elif id == TEXT_HTML_RULE:
            sel=self.GetStringSelection();
            self.Cut()
            self.WriteText("<hr>")
        elif id == TEXT_HTML_COLOR:
            sel=self.GetStringSelection(); 
            self.Cut()
            data = wxColourData()
            data.SetChooseFull(true)
            dlg = wxColourDialog(self, data)
            if dlg.ShowModal() == wxID_OK:
                data = dlg.GetColourData()
                (red,green,blue) = data.GetColour().Get()
                hexcolor = self.r_h.hexstring(red, green, blue)
                self.WriteText("<font color=\""+hexcolor+"\">"+sel+"</font>")
            dlg.Destroy()
        elif id == TEXT_HTML_BORDER:
            sel=self.GetStringSelection();
            self.Cut()
            self.WriteText("<table border=1><tr><td>"+sel+"</td></tr></table>")            
        elif id == TEXT_DISPLAY_HTML:
            dlg=HTMLDialog(self,"HTML Preview",self.GetValue());
            dlg.Show()
            #dlg.Destroy()
            #about = MyAboutBox(self,obj.about())
            

            


################################
### MISC WINDOWS AND FRAMES
################################
class HTMLDialog(wxDialog):
    page = """
<html>
<body bgcolor="%s">
%s
<p><wxp class="wxButton">
    <param name="label" value="Okay">
    <param name="id"    value="wxID_OK">
</wxp></p>
</body>
</html>
"""
    def __init__(self, parent, title, text, bgcolor="#FFFFFF"):
        wxDialog.__init__(self, parent, -1, title,pos=(-1,-1),size=(400,400),style=wxRESIZE_BORDER|wxDEFAULT_DIALOG_STYLE)
        html = http_html_window(self,-1)
        #html = wxHtmlWindow(self, -1, size=(600, 400))        
        html.SetPage(self.page % (bgcolor, text))
        ir = html.GetInternalRepresentation()
        html.SetSize( (ir.GetWidth()+5, ir.GetHeight()+5) )
        self.SetClientSize(html.GetSize())
        self.SetSize(size=(600,400))
        self.CentreOnParent(wxBOTH)
    #def OnOK(self,event):
        
        
class MyAboutBox(wxDialog):
    page = """
<html>
<body bgcolor="%s"><center>
%s
<p><wxp class="wxButton">
    <param name="label" value="Okay">
    <param name="id"    value="wxID_OK">
</wxp></p>
</center>
</body>
</html>
"""
    def __init__(self, parent, text, bgcolor="#FFFFFF"):
        wxDialog.__init__(self, parent, -1, 'About',)
        html = wxHtmlWindow(self, -1, size=(420, -1))        
        html.SetPage(self.page % (bgcolor, text))
        ir = html.GetInternalRepresentation()
        html.SetSize( (ir.GetWidth()+5, ir.GetHeight()+5) )
        self.SetClientSize(html.GetSize())
        self.CentreOnParent(wxBOTH)
        
###########################
## HTML related clasees
###########################
        
class http_html_window(wxHtmlWindow):
    """ a wxHTMLwindow that will load links  """
    def __init__(self, parent, id):
        wxHtmlWindow.__init__(self, parent, id, wxDefaultPosition,wxDefaultSize,wxSUNKEN_BORDER | wxHW_SCROLLBAR_AUTO)
        self.path = ""
        self.local = 0
        #self.title = title

    def OnLinkClicked(self, linkinfo):
        address = linkinfo.GetHref()        
        if address[:4] == "http":
            self.load_url(address)
            self.local = 0
        elif address[0] == "#" or self.local:
            self.base_OnLinkClicked(linkinfo)
        else:            
            self.load_url(self.path+address)
                
    def load_url(self,path):
        print path
        dlg = wxProgressDialog("HTML Document","Loading...",3,self)
        dlg.Update(1)
        try:
            data = urllib.urlretrieve(path)
            file = open(data[0])
            dlg.Update(2)
            self.SetPage(file.read())
            i = string.rfind(path,"/")
            self.path = path[:i+1]
        except:
            wxMessageBox("Invalid URL","Browser Error",wxOK)
            #self.SetPage("<h3>Invalid URL</h3>")
        dlg.Update(3)
        dlg.Destroy()

    def load_file(self,path):
        self.LoadPage(path)
        self.local = 1
  

WEB_CLOSE = wxNewId()
WEB_BACK = wxNewId()
WEB_FORWARD = wxNewId()
WEB_PRINT = wxNewId()
WEB_SAVE = wxNewId()
class wxHTMLpanel(wxPanel):
    """ A user friednly panel for the http_html_window """
    def __init__(self, parent, id,):
        wxPanel.__init__(self, parent, id)
        self.html_wnd = http_html_window(self,-1)
        self.parent = parent
        self.sizer = wxBoxSizer(wxHORIZONTAL)
        self.sizer.Add(wxButton(self, WEB_CLOSE, "Close"), 1, wxEXPAND)
        self.sizer.Add(wxButton(self, WEB_BACK, "Back"), 1, wxEXPAND)
        self.sizer.Add(wxButton(self, WEB_FORWARD, "Forward"), 1, wxEXPAND)
        self.sizer.Add(wxButton(self, WEB_SAVE, "Save"), 1, wxEXPAND)
        self.sizer.Add(wxButton(self, WEB_PRINT, "Print"), 1, wxEXPAND)
        EVT_BUTTON(self, WEB_CLOSE, self.on_button) 
        EVT_BUTTON(self, WEB_BACK, self.on_button) 
        EVT_BUTTON(self, WEB_FORWARD, self.on_button)
        EVT_BUTTON(self, WEB_PRINT, self.on_button)
        EVT_BUTTON(self, WEB_SAVE, self.on_button)
        EVT_SIZE(self, self.on_size)
        EVT_CLOSE( self, self.OnClose )
        self.printer = wxHtmlEasyPrinting()

    def on_button(self,evt):
        id = evt.GetId()
        if id == WEB_CLOSE:
            self.OnClose( evt )
        elif id == WEB_FORWARD:
            if not self.html_wnd.HistoryForward():
                wxMessageBox("No more items in history!")
        elif id==WEB_BACK:
            if not self.html_wnd.HistoryBack():
                wxMessageBox("No more items in history!")
        elif id==WEB_PRINT:
            file = self.html_wnd.GetOpenedPage()
            if file == "":
                self.save_page("print.htm")
                file = "print.htm"
            self.printer.PreviewFile(file)
        elif id==WEB_SAVE:
            f =wxFileDialog(self,"Select a file",orpg.dirpath.dir_struct["user"],"","HTML (*.html)|*.html",wxSAVE)
            if f.ShowModal() == wxID_OK:
                self.save_page(f.GetPath())
            f.Destroy()

    def save_page(self,path):
        data = self.html_wnd.GetParser().GetSource()
        file = open(path,"w")
        file.write(data)
        file.close()

    def load_file(self,path):
        self.html_wnd.load_file(path)

    def load_url(self,path):
        self.html_wnd.load_url(path)

    def on_size(self,event):
        (w,h) = self.GetClientSizeTuple()
        self.html_wnd.SetDimensions(0,0,w,h-25)
        self.sizer.SetDimension(0,h-25,w,25)

    def load_text(self,txt):
        self.html_wnd.SetPage(txt)

    def OnClose( self, evt ):
        self.parent.Close( true )



class wxPFrame(wxFrame):
    """ a framed window that holds a single panel """
    def __init__(self, parent, caption, icon_file=orpg.dirpath.dir_struct["icon"]+'d20.ico',
                 only_hide=0, pos = None, size = None, style=wxDEFAULT_FRAME_STYLE):
        if not pos:
            pos = wxDefaultPosition
        if not size:
            size = wxSize(500,300)
        wxFrame.__init__(self, parent, -1, caption, pos, size, style )
        if wxPlatform == '__WXMSW__':
            icon = wxIcon(icon_file, wxBITMAP_TYPE_ICO)
            self.SetIcon(icon)
        self.panel = None        
        self.only_hide = only_hide
        self.parent = parent
        self.destroyed = 0
        EVT_SIZE(self, self.OnSize)
        EVT_CLOSE(self, self.OnCloseWindow)


    def OnCloseWindow(self, event):
        if self.only_hide:
            self.Show( false )
            self.Raise()
        else:            
            self.destroyed = 1            
            self.Destroy()
        #print "window destroyed!"


    def OnSize(self,event):
        (w,h) = self.GetClientSizeTuple()
        if self.panel:
            self.panel.SetDimensions(0,0,w,h)
        


class wxHTMLFrame(wxFrame):
    """ a framed http_html_window """
    def __init__(self, parent, caption, pos = None, size = None, style = wxDEFAULT_FRAME_STYLE):
        if not pos:
            pos = wxDefaultPosition
        if not size:
            size = wxSize(500,300)
        wxFrame.__init__(self, parent, -1, caption, pos, size,style)
        self.html_wnd = http_html_window(self,-1)
        self.ok = wxButton(self, wxID_OK, "OK")
        EVT_BUTTON(self, wxID_OK, self.OnCloseMe)
        EVT_SIZE(self, self.OnSize)

    def load_file(self,path):
        self.html_wnd.load_file(path)
        
    def load_url(self,path):    
        self.html_wnd.load_url(path)

    def set_page(self,data):
        self.html_wnd.SetPage(data)

    def load_img(self,path):    
        self.html_wnd.load_img(path)
        
    def OnCloseMe(self, event):
        self.Close(true)

    def OnCloseWindow(self, event):
        self.Destroy()

    def OnSize(self,event):
        (w,h) = self.GetClientSizeTuple()
        self.html_wnd.SetDimensions(0,0,w,h-25)
        self.ok.SetDimensions(0,h-25,w,25)

###########################
## Some misc dialogs
###########################

class wxMultiCheckBoxDlg(wxDialog):
    """ notes """
    def __init__(self,parent,opts,text,caption,selected=[],pos=wxDefaultPosition):
        wxDialog.__init__(self,parent,-1,caption,pos,wxDefaultSize)
        sizers = { 'ctrls' : wxBoxSizer(wxVERTICAL),
                    'buttons' : wxBoxSizer(wxHORIZONTAL) }

        sid = wxNewId()
        self.opts = opts
        self.list = wxCheckListBox(self, sid, wxDefaultPosition, wxDefaultSize,opts)
        for s in selected:
            self.list.Check(s,1)
                   
        sizers['ctrls'].Add(wxStaticText(self, -1, text), 0, 0) 
        sizers['ctrls'].Add(10,10)
        sizers['ctrls'].Add(self.list, 1, wxEXPAND)
        
        sizers['buttons'].Add(wxButton(self, wxID_OK, "OK"), 1, wxEXPAND) 
        sizers['buttons'].Add(10,10)
        sizers['buttons'].Add(wxButton(self, wxID_CANCEL, "Cancel"), 1, wxEXPAND)

        width = 200
        height = 200
        self.SetClientSizeWH(width,height)
        sizers['ctrls'].SetDimension(10,5,width-20,160)
        sizers['buttons'].SetDimension(10,170,width-20,25)
        EVT_BUTTON(self, wxID_OK, self.on_ok)
        
   
    def on_ok(self,evt):
        checked = []
        for i in range(len(self.opts)):
            if self.list.IsChecked(i):
                checked.append(i)
        self.checked = checked
        self.EndModal(wxID_OK)
        
    def get_selections(self):
        return self.checked

    
class wxMultiChoiceDlg(wxDialog):
    """ test """
    def __init__(self,parent,opts,text,caption,pos=wxDefaultPosition):
        wxDialog.__init__(self,parent,-1,caption,pos,wxDefaultSize)
        sizers = { 'ctrls' : wxBoxSizer(wxVERTICAL),
                    'buttons' : wxBoxSizer(wxHORIZONTAL) }

        self.list = wxListBox(self, -1, wxDefaultPosition, wxDefaultSize,
                       opts, wxLB_EXTENDED)
            
        sizers['ctrls'].Add(wxStaticText(self, -1, text), 0, 0) 
        sizers['ctrls'].Add(10,10)
        sizers['ctrls'].Add(self.list, 1, wxEXPAND)
        
        sizers['buttons'].Add(wxButton(self, wxID_OK, "OK"), 1, wxEXPAND) 
        sizers['buttons'].Add(10,10)
        sizers['buttons'].Add(wxButton(self, wxID_CANCEL, "Cancel"), 1, wxEXPAND)

        width = 200
        height = 200
        self.SetClientSizeWH(width,height)
        sizers['ctrls'].SetDimension(10,5,width-20,160)
        sizers['buttons'].SetDimension(10,170,width-20,25)
        EVT_BUTTON(self, wxID_OK, self.on_ok)

    def on_ok(self,evt):
        self.EndModal(wxID_OK)
        
    def get_selections(self):
        pass    

        
class wxMultiTextEntry(wxDialog):
    """ a dialog that takes two lists (labels and values) and creates a
        'label: value' style text edit control for each node in the dic"""
    def __init__(self,parent,tlist,vlist,caption,pos=wxDefaultPosition):
        wxDialog.__init__(self,parent,-1,caption,pos,wxDefaultSize)
        
        num = len(tlist)
        sizers = { 'ctrls' : wxFlexGridSizer(num,2,5,0),
                    'buttons' : wxBoxSizer(wxHORIZONTAL) }
        #keys = mlist.keys()
        self.tlist = tlist
        self.vlist = vlist
        add_list = []
        ctrls = []
        for i in range(len(tlist)):
            add_list.append((wxStaticText(self, -1, tlist[i]+": "),0,wxALIGN_CENTER_VERTICAL ))
            ctrls.append(orpgTextCtrl(self, 10, vlist[i]))
            add_list.append((ctrls[i],1,wxEXPAND))
        self.ctrls = ctrls
        sizers['ctrls'].AddMany(add_list)
        sizers['ctrls'].AddGrowableCol(1)        
        
        sizers['buttons'].Add(wxButton(self, wxID_OK, "OK"), 1, wxEXPAND) 
        sizers['buttons'].Add(10,10)
        sizers['buttons'].Add(wxButton(self, wxID_CANCEL, "Cancel"), 1, wxEXPAND)

        width = 300
        (w,h) = ctrls[0].GetSizeTuple()
        h = h + 5
        height = ((num)*h)+35
        self.SetClientSizeWH(width,height)
        sizers['ctrls'].SetDimension(10,5,width-20,num*30)
        sizers['buttons'].SetDimension(10,(num*h)+5,width-20,25)
        EVT_BUTTON(self, wxID_OK, self.on_ok)

    def on_ok(self,evt):
        for i in range(len(self.ctrls)):
            self.vlist[i] = self.ctrls[i].GetValue()
        self.EndModal(wxID_OK)
        
    def get_values(self):
        return self.vlist


class wxScrolledMessageFrame(wxFrame):
    def __init__(self, parent, msg, caption, callback, pos = None, size = None):
        if not pos:
            pos = wxDefaultPosition
        if not size:
            size = wxSize(300,300)
        wxFrame.__init__(self, parent, -1, caption, pos, size)
        self.text = orpgTextCtrl(self, -1, msg, wxDefaultPosition,
                             wxDefaultSize,
                             wxTE_MULTILINE )
        self.sizer = wxBoxSizer(wxHORIZONTAL)
        self.ok = wxButton(self, wxID_OK, "OK")
        EVT_BUTTON(self, wxID_OK, self.OnCloseMe)
        self.cancel = wxButton(self, wxID_CANCEL, "Cancel")
        EVT_BUTTON(self, wxID_CANCEL, self.OnCloseMe)
        self.sizer.Add(self.ok, 1, wxEXPAND)
        self.sizer.Add(self.cancel, 1, wxEXPAND)
        self.SetSizer(self.sizer)       
        
        self.onchange = callback
        EVT_SIZE(self, self.OnSize)

    def OnCloseMe(self, event):
        if wxID_OK == event.GetId():
            txt = self.text.GetValue()                  
            if(self.onchange):
                self.onchange(txt)
        self.Close(true)

    def OnCloseWindow(self, event):           
        self.Destroy()
        
    def OnSize(self,event):
        (w,h) = self.GetClientSizeTuple()
        self.text.SetDimensions(0,0,w,h-25)
        self.sizer.SetDimension(0,h-25,w,25)


class wxScrolledMessageFrameEditor(wxFrame):
    "class to implement wxScrolledMessageFrame with Find feature for the text of chatbuffer in a popup"
    def __init__(self, parent, msg, caption, pos = None, size = None):
        wxID_ORPGTEXTCTRL = wxNewId()
        wxID_MATCHINSTRUCTION = wxNewId()
        wxID_MATCHINPUT = wxNewId()
        wxID_MATCHBUTTON = wxNewId()
        wxID_MATCHCASEINSTRUCTION = wxNewId()
        wxID_MATCHCASECHECKBOX = wxNewId()
        wxID_DEHTML = wxNewId()
        if not pos:
            pos = wxDefaultPosition
        if not size:
            size = wxSize(300,300)
        wxFrame.__init__(self, parent, -1, caption, pos, size)

        self.text = orpgTextCtrl(self, wxID_ORPGTEXTCTRL, msg, wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE )
        self.sizer = wxBoxSizer(wxHORIZONTAL)

        self.matchInstruction = wxStaticText(self, wxID_MATCHINSTRUCTION, "Text to search for: ")
        self.sizer.Add(self.matchInstruction, 0, wxALIGN_CENTER_VERTICAL)

        self.matchInput = wxTextCtrl(self, wxID_MATCHINPUT, "")
        self.sizer.Add(self.matchInput, 1, wxEXPAND)

        self.matchCaseInstruction = wxStaticText(self, wxID_MATCHCASEINSTRUCTION, "Match case:")
        self.sizer.Add(self.matchCaseInstruction, 0, wxALIGN_CENTER_VERTICAL)

        self.matchCaseCheckBox = wxCheckBox(self, wxID_MATCHCASECHECKBOX, "")
        self.sizer.Add(self.matchCaseCheckBox, 0, wxALIGN_CENTER_VERTICAL)

        self.matchButton = wxButton(self, wxID_MATCHBUTTON, "Find")
        EVT_BUTTON(self, wxID_MATCHBUTTON, self.OnMatchMe)
        self.sizer.Add(self.matchButton, 1, wxEXPAND)

        self.dehtmlButton = wxButton(self, wxID_DEHTML, "Remove HTML")
        EVT_BUTTON(self, wxID_DEHTML, self.OnDeHTML)
        self.sizer.Add(self.dehtmlButton, 1, wxEXPAND)

        self.cancel = wxButton(self, wxID_CANCEL, "Cancel")
        EVT_BUTTON(self, wxID_CANCEL, self.OnCloseMe)
        self.sizer.Add(self.cancel, 1, wxEXPAND)

        self.SetSizer(self.sizer)       
        EVT_SIZE(self, self.OnSize)

        # current position
        self.matchPosition = 0
        # former position
        self.matchPositionOld = 0

    def OnDeHTML(self, event):
        text = re.sub( "\<[^<]*?\>", "", self.text.GetValue() )
        self.text.SetValue(text)
        
    def OnMatchMe(self, event):
        # match case sensitive
        if self.matchCaseCheckBox.GetValue() == 1:
            textValue = self.text.GetValue()
            matchValue = self.matchInput.GetValue()
        # match case insensitive
        else:
            textValue = string.upper(self.text.GetValue())
            matchValue = string.upper(self.matchInput.GetValue())

        # continue search from insertion point instead of top
        self.matchPosition = self.matchPositionOld = self.text.GetInsertionPoint()

        # find search string in chatbuffer
        self.matchPosition = string.find(textValue[self.matchPositionOld:], matchValue)
        # cumulate position for substring matching in continuing search
        self.matchPositionOld = self.matchPositionOld + self.matchPosition
        
        # if match was found
	if self.matchPosition >= 0:
            # highlight(select) match
            self.text.SetSelection(self.matchPositionOld, self.matchPositionOld + len(matchValue))
            # continue search from end of match
            self.text.SetInsertionPoint(self.matchPositionOld + len(matchValue))
        # if match was not found, but match exists somewhere in buffer, start from top
        elif string.find(textValue, matchValue) >= 0:
            self.text.SetInsertionPoint(0)
            self.OnMatchMe(self)            
            
    def OnCloseMe(self, event):
        self.Close(true)

    def OnCloseWindow(self, event):           
        self.Destroy()
        
    def OnSize(self,event):
        (w,h) = self.GetClientSizeTuple()
        self.text.SetDimensions(0,0,w,h-25)
        self.sizer.SetDimension(0,h-25,w,25)


class scrolled_img_panel(wxPanel):
    """a scrolled panel that contains a static image"""
    def __init__(self, parent, id):
        wxPanel.__init__(self, parent, id)
        self.img_wnd = wxScrolledWindow(self, -1, style=wxHSCROLL | wxVSCROLL | wxSUNKEN_BORDER)
        self.img_wnd.SetBackgroundColour(wxWHITE)
        EVT_SIZE(self, self.on_size)      

    def on_size(self,event):
        s = self.GetClientSizeTuple()
        self.img_wnd.SetDimensions(0,0,s[0],s[1])

    def load_url(self,path):
        pos = string.rfind(path,'.')
        ext = path[pos+1:]
        img_type = 0
        if ext == "gif":
            img_type = wxBITMAP_TYPE_GIF 
        elif ext == "jpg":
            img_type = wxBITMAP_TYPE_JPEG  
        elif ext == "bmp":
            img_type = wxBITMAP_TYPE_BMP

        if img_type:
            dlg = wxProgressDialog("HTML Document","Loading...",3,self)
            dlg.Update(1)
            data = urllib.urlretrieve(path)
            dlg.Update(2)
            gif = wxImage(data[0], img_type)
            bmp = gif.ConvertToBitmap()
            wxStaticBitmap(self.img_wnd, -1, bmp, wxPoint(0, 0),
                            wxSize(bmp.GetWidth(), bmp.GetHeight()))
            self.img_wnd.SetScrollbars(20, 20, bmp.GetWidth()/20,  bmp.GetHeight()/20)
            dlg.Update(3)
            dlg.Destroy()
            
    
class wxScrolledImgFrame(wxFrame):
    def __init__(self, parent, caption, pos = None, size = None):
        if not pos:
            pos = wxDefaultPosition
        if not size:
            size = wxSize(300,300)
        wxFrame.__init__(self, parent, -1, caption, pos, size)
        self.img_wnd = wxScrolledWindow(self, -1)
        self.ok = wxButton(self, wxID_OK, "OK")        
        EVT_BUTTON(self, wxID_OK, self.OnCloseMe)
        EVT_SIZE(self, self.OnSize)
        

    def load_url(self,path):
        pos = string.rfind(path,'.')
        ext = path[pos+1:]
        img_type = 0
        if ext == "gif":
            img_type = wxBITMAP_TYPE_GIF 
        elif ext == "jpg":
            img_type = wxBITMAP_TYPE_JPEG  
        elif ext == "bmp":
            img_type = wxBITMAP_TYPE_BMP

        if img_type:
            dlg = wxProgressDialog("HTML Document","Loading...",3,self)
            dlg.Update(1)
            data = urllib.urlretrieve(path)
            dlg.Update(2)
            gif = wxImage(data[0], img_type)
            bmp = gif.ConvertToBitmap()
            wxStaticBitmap(self.img_wnd, -1, bmp, wxPoint(0, 0),
                            wxSize(bmp.GetWidth(), bmp.GetHeight()))
            self.img_wnd.SetScrollbars(20, 20, bmp.GetWidth()/20,  bmp.GetHeight()/20)
            dlg.Update(3)
            dlg.Destroy()
            w = gif.GetWidth()
            h = gif.GetHeight()
            self.SetClientSizeWH(w,h+25)

    def OnCloseMe(self, event):
        self.Close(true)

    def OnCloseWindow(self, event):
        self.Destroy()
        
    def OnSize(self,event):
        (w,h) = self.GetClientSizeTuple()
        self.img_wnd.SetDimensions(0,0,w,h-25)
        self.ok.SetDimensions(0,h-25,w,25)


class orpgProgressDlg(wxDialog):
    def __init__(self, parent,  title="", text="", range=10 ):           
        wxDialog.__init__(self, parent, -1, title, size=wxSize(200,75))
        self.sizer = wxBoxSizer(wxVERTICAL)
        self.text = wxStaticText( self, -1, text)
        self.gauge = wxGauge(self,-1,range)        
        self.sizer.Add(self.text,1,wxALIGN_CENTER | wxEXPAND)
        self.sizer.Add(self.gauge,1,wxALIGN_CENTER | wxEXPAND)
        (w,h) = self.GetClientSizeTuple()
        self.sizer.SetDimension(10,10,w-20,h-20)
        
    def Update(self,pos,text=None):        
        self.gauge.SetValue(pos)
        if text:
            self.text.SetLabel(text)



#####################
## Some misc utilties for the GUI
#####################

def do_progress_dlg(parent,title,text,range):
    " Returns a new progress dialog"
    if wxPlatform == '__WXMSW__':
        dlg = orpgProgressDlg(parent,title,text,range)
        dlg.Centre()
        dlg.Show(1)
        dlg.Raise()
    else:
        dlg = wxProgressDialog(title,text,range,parent)
    return dlg

def parseXml_with_dlg(parent,s,ownerDocument=None):
    "Parse xml with progress dialog"
    dlg = do_progress_dlg(parent,"XML Parser","Reading Configuration Files...",2)
    #dlg.Update(1)
    doc = orpg.orpg_xml.parseXml(s)
    dlg.Update(1,"Done.")
    dlg.Destroy()
    return doc


def createMaskedButton( parent, image, tooltip, id, mask_color=wxWHITE, image_type=wxBITMAP_TYPE_GIF ):
    gif = wxImage( image, image_type, ).ConvertToBitmap()
    mask = wxMaskColour( gif, mask_color )
    gif.SetMask( mask )
    btn = wxBitmapButton( parent, id, gif )
    btn.SetToolTip( wxToolTip( tooltip ) )
    return btn

