name="Blank Plugin"
author="Woody, mDuo13"
help="""This blank plugin should be
used as a template for other ones.
This one does nothing."""
#These give the patch some information about your plugin.
#'name' should contain your plugin's long name.
#       Make sure it's not the same as another plugin's name.
#'author' is the author of the plugin. It will be listed in the plugin info.
#'help' is the help text that will be displayed when the user clicks the
#       'Plugin Info' button.
#--------------------------------------
import os
#imports go here. Things you might want to import:
#import re                  #regular expressions module
#import random              #random value generator
#from wxPython.wx import *  #wxPython suite

chat=None
#an instance of the chat_panel class in orpg/chat/chatwnd.py
#chat.Post("Message") will output a message to the user's screen.
#chat.Post("Message",1,1) will send the message to everyone else, too.
session=None
#the session variable contains all sorts of information about
#OpenRPG's current status, like session.name contains the current
#username, and session.players has the player list.
tree=None
#the OpenRPG tree. Few plugins so far use this.
openrpg=None
#this is an instance of the orpgFrame class from main.py. Pretty much
#everything is subordinate to this class somehow.
plugindb=None
#This is the plugin database. You can store settings in it, and
#it will keep things in a single XML file for all plugins, instead of having to
#create and read text files for each plugin.
#Experiment with the following functions, or look at examples from other
#plugins, to see how to use them:
#These must be called from within one of the functions.
#plugindb.SetString(plugin_filename, variable_name, variable_value)
#plugindb.GetString(plugin_filename, variable_name, default_value)
#plugindb.SetList(plugin_filename, variable_name, list_value)
#plugindb.GetList(plugin_filename, variable_name, default_list)
#plugindb.SetDict(plugin_filename, variable_name, dictionary_value)
#plugindb.GetDict(plugin_filename, variable_name, default_dictionary)

##Now we have the functions. These are called from within OpenRPG at various
##times. You can reference and change the variables, and do other things too.
##The more you know about python and OpenRPG, the more you can do. The
##possibilities are larger than you'd think.
##Note that when I say "formatted" I mean that it has HTML tags like font colors
##and names already added.

def load(self):
    #this gets run when the plugin gets imported, but after the real contents
    #of the openrpg, chat, session, tree, and (most importantly) plugindb
    #variables have been passed to the plugin. If you need to use the plugindb
    #to set a global variable on startup, do it from this function.
    pass

def message(self, text):
    #This is called whenever the user types something and hits enter.
    #It covers all messages, before they are formatted.
    return text

def send_msg(self, text, send):
    #This is called when a message is about to be sent out.
    #It covers all messages sent by the user, before they have been formatted.
    #If send is set to 0, the message will not be sent out to other
    #users, but it will still be posted to the user's chat normally.
    #Otherwise, send defaults to 1. (The message is sent as normal)
    return text, send

def receive_msg(self, text, type, name, player, posted=0):
    #This is called whenever a message from someone else is received, no matter
    #what type of message it is.
    #The text variable is the text of the message. If the type is a regular
    #message, it is already formatted. Otherwise, it's not.
    #The type variable is an integer which tells you the type: 1=chat, 2=whisper
    #3=emote, 4=info, and 5=system.
    #The name variable is the name of the player who sent you the message.
    #The player variable contains lots of info about the player sending the
    #message, including name, ID#, and currently-set role.
    #Uncomment the following line to see the player variable:
    #print player
    #If posted is set to 1 then the chat module will stop processing
    #the incoming message. Use this if you post the incoming message elsewhere,
    #for example in a special tab or window.
    return text, type, name, posted

def post_msg(self, text, myself):
    #This is called whenever a message from anyone is about to be posted
    #to chat; it doesn't affect the copy of the message that gets sent to others
    #Be careful; system and info messages trigger this too.
    #The variable 'myself' evaluates to true if the message is a text message
    #that originates from the local user.
    return text

def docmd(self, text, cmdlist):
    #This is called when the user enters a / command that OpenRPG doesn't
    #recognize. Thus, you can create new / commands. The text variable
    #is the text that the user inputted. If it is your custom command,
    #return 1. If it is not, return 0.
    #try cmddata = text.split(' ',1) to divide the text into the first word
    #of the command and the rest of the command.
    #Then you can do things like:
    #if cmddata[0] == '/mycommand':
    #   chat.Post(cmddata[1])
    return 0

def refresh_counter(self):
    #This is called once per second. That's all you need to know.
    pass

def close_module(self):
    #This is called when OpenRPG shuts down
    pass
