#!/usr/bin/env python
import pyver
import sys
pyver.checkPyVersion()
import time
import gc
import getopt
import orpg.networking.mplay_server
import orpg.networking.meta_server_lib
import traceback

# Simple usuage text for request via help or command line errors
def usage( retValue ):
    print sys.argv[0] + " " + \
    "[-n Server Name]\n" + \
    "[-p]\n" + \
    "[-l Lobby Boot Password]\n" + \
    "[-r Run From???]\n" + \
    "[-h --help]\n\n" + \
    "Where -p is used to request meta registration.  If -p is given, the boot\n" + \
    "password and server name MUST be provided.  If no options are given, user\n" + \
    "will be prompted for information.\n\n"
    sys.exit( retValue )

if __name__ == '__main__':
    lobby_boot_pwd = ""
    name = ""
    post = "N"
    opt="N"
    gc.set_debug(gc.DEBUG_UNCOLLECTABLE)
    gc.enable()

    # See if we have command line arguments in need of processing
    try:
        (opts, args) = getopt.getopt( sys.argv[1:], "n:pl:h", "help" )
        for o in opts:
            # Server Name
            if o[0] in ( "-n", ):
                name = o[1]
            # Post server to meta
            if o[0] in ( "-p", ):
                post = 'Y'
            # Lobby Password
            if o[0] in ( "-l", ):
                lobby_boot_pwd = o[1]
            # Help
            if o[0] in ( "-h", "--help" ):
                usage( 0 )
    except:
        usage( 1 )

    # Now, validate that if we had options passed in, they make sense!  If
    # no options were passed in, follow the normal prompt for information
    # start up path.  If -p is passed in, make sure name and password is
    # also provided.
    if len(opts):
        if (post == 'Y') and ((len(name) == 0) or (len(lobby_boot_pwd) == 0)):
            usage( 1 )
    if (len(lobby_boot_pwd) == 0):
        lobby_boot_pwd = raw_input("Enter boot password for the Lobby:  ")
    # Only ask if we didn't pass in options and post isn't 'Y'
    if ( (post == 'N') and (opt == 'N') ):
        opt = raw_input("Do you want to post your server to the OpenRPG Meta Server list? (y,n)")
        if opt[0] == 'y' or opt[0] == 'Y':
            post = 'Y'
            
    # If we are going to post make sure we have a server name, if not, ask for it
    if ( post == 'Y' ) and (len(name) == 0 ):
        name = raw_input("Server Name?")
    # start server!
    orpg_server = orpg.networking.mplay_server.mplay_server()
    orpg_server.force_check = 1
    for index in range(len(sys.argv)-1):
        if (sys.argv[index] == "-v"):
            orpg_server.force_check=0

    if ( post == 'Y' ) and (len(name)):
        # Start the registration thread
        #  register servers
        orpg_server.register( name )
    print "-----------------------------------------------------"
    print "Type 'help' or '?' or 'h' for server console commands"
    print "-----------------------------------------------------"
    #orpg_server.print_help()
    orpg_server.groups['0'].boot_pwd = lobby_boot_pwd
    
    opt = "None"
    try:
        while (opt != "kill") and ( opt != "quit"):
            opt = raw_input("action?:")
            words = opt.split()
            if opt == "broadcast":
                msg = raw_input("Message:")
                orpg_server.broadcast(msg)
            elif opt == "dump":
                orpg_server.player_dump()
            elif opt == "dump groups":
                orpg_server.groups_list()
            elif opt == "get lobby boot password":
                print "Lobby boot password is:  " + orpg_server.groups['0'].boot_pwd
                print
            elif opt == "register":
                msg = raw_input("Enter server name:  ")
                orpg_server.register(msg)
            elif opt == "unregister":
                orpg_server.unregister()
            elif opt == "set lobby boot password":
                lobby_boot_pwd = raw_input("Enter boot password for the Lobby:  ")
                orpg_server.groups['0'].boot_pwd = lobby_boot_pwd
            elif len(words) == 2 and words[0] == "group":
                orpg_server.group_dump(words[1])
            elif opt == "help" or opt == "?" or opt == "h":
                orpg_server.print_help()
            elif opt == "search":
                msg = raw_input("Pattern:")
                orpg_server.search(msg)
            elif opt == "remove room":
                print "Removing a room will kick everyone in that room off your server."
                print "You might consider going to that room and letting them know what you are about to do."
                groupnumber = raw_input("Room group number:")
                orpg_server.remove_room(groupnumber)
            elif opt == "uptime": 
                orpg_server.uptime()
            elif opt == "roompasswords": 
                print orpg_server.RoomPasswords()
            elif opt == "list":
                orpg_server.player_list()
            elif opt == "log":
                orpg_server.console_log()
            elif opt == "log meta":
                orpg_server.toggleMetaLogging()
            elif len(words) > 0 and words[0] == "logfile":
                if len(words) > 1:
                    if words[1] == "off":
                        orpg_server.NetworkLogging(0)
                    elif words[1] == "on":
                        orpg_server.NetworkLogging(1)
                    elif words[1] == "split":
                        orpg_server.NetworkLogging(2)
                    else:
                        print "<command useage> logfile [off|on|split]" 
                else:
                    print orpg_server.NetworkLoggingStatus()
            elif (len(words) > 0 and words[0]) == "monitor":
                if len(words) >1:
                    print "Attempting to monitor client \""+str(words[1])+"\""
                    orpg_server.monitor(words[1])
                else: print "<command useage> monitor (player id #)"
            elif opt == "purge clients":
                try:
                    orpg_server.kick_all_clients()
                except Exception, e:
                    traceback.print_exc()
            elif len(words)>0 and words[0] == "zombie":
                if len(words) > 1:
                    if words[1] == "set":
                        if len(words) > 2:
                            try:
                                t = int(words[2])
                                orpg_server.zombie_time = t
                                print ("--> Zombie auto-kick time set to "+str(t)+" minutes");
                            except Exception, e:
                                print "Invalid zombie time!"
                                traceback.print_exc()
                        else:
                            orpg_server.zombie_time = 480
                            print "--> Zombie auto-kick time set to default (480 mins)";
                    else:
                        print "<command useage> zombie [set [mins]]"
                else:
                    timeout = int(orpg_server.zombie_time)
                    print ("--> Zombie auto-kick time set to "+str(timeout)+" minutes.  Use \"zombie set [min]\" to change.");
            elif opt == "kick":
                kick_id = raw_input("Kick Player #  ")
                kick_msg = raw_input("Reason(optional):  ")
                orpg_server.admin_kick(kick_id,kick_msg)
            else:
                if (opt == "kill") or (opt == "quit"):
                    print ("Closing down OpenRPG server. Please wait...") 
                else:
                    print ("[UNKNOWN COMMAND: \""+opt+"\" ]")
                
    except Exception, e:
        print "EXCEPTION: "+str(e)
        traceback.print_exc()
        raw_input("press <enter> key to terminate program")

    orpg_server.kill_server()

