Name:		opensaml
Summary:	Open source Security Assertion Markup Language implementation.
Version:	1.1.1
Release:	2
Group:		System Environment/Libraries
Vendor:		Internet2
License:	Apache 2.0
URL:		http://www.opensaml.org/
Source0:	%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-root

BuildRequires:	openssl-devel, curl-devel >= 7.10.6
BuildRequires:	xerces%{?xercesver}-c-devel >= 2.8.0, xml-security-c-devel >= 1.3.0
BuildRequires:	zlib-devel 
%{?_with_log4cpp:BuildRequires: log4cpp-devel >= 1.0}
%{!?_with_log4cpp:BuildRequires: log4shib-devel}

%description
OpenSAML is an open source implementation of the Security Assertion
Markup Language Specification of the OASIS group.  It contains a set
of open source C++ libraries that support the SAML 1.0 and 1.1
specifications.  

This package contains the opensaml runtime library.

%package devel
Summary: OpenSAML development Headers
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
OpenSAML is an open source implementation of the Security Assertion
Markup Language Specification of the OASIS group.  It contains a set
of open source C++ libraries that support the SAML 1.0 and 1.1
specifications.  

This package contains the headers and other necessary files to build
applications that use the opensaml library.

%prep
%setup -q

%build
%configure %{?saml_options}
%{__make}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT
%{__make} install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT/%{_bindir} -type f |
  %{__sed} -e "s|$RPM_BUILD_ROOT||" | sort > rpm.binlist

%check || :
%{__make} check

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT

%ifnos solaris2.8 solaris2.9 solaris2.10 
%post -p /sbin/ldconfig
%endif

%ifnos solaris2.8 solaris2.9 solaris2.10 
%postun -p /sbin/ldconfig
%endif

%files -f rpm.binlist
%defattr(-,root,root,-)
%{_libdir}/libsaml.so.*
%dir %{_datadir}/xml/opensaml
%{_datadir}/xml/opensaml
%docdir %{_datadir}/doc/opensaml
%{_datadir}/doc/opensaml

%files devel
%defattr(-,root,root,-)
%{_includedir}
%{_libdir}/libsaml.so

%changelog
* Mon Dec 17 2007  Scott Cantor  <cantor.2@osu.edu>  - 1.1.1-2
- First official release

* Sat Sep 15 2007  Scott Cantor  <cantor.2@osu.edu>  - 1.1.1-1
- Minor revision for Shibboleth 1.3.1
- Update dependencies

* Thu Mar 23 2006  Scott Cantor  <cantor.2@osu.edu>  - 1.1-6
- Warning and gcc4.1 error fixes
- Add cxxtest to build dependencies

* Thu Aug 11 2005  Scott Cantor  <cantor.2@osu.edu>  - 1.1-5
- Reduce wasteful memory use in DOM

* Sun Apr 24 2005  Scott Cantor  <cantor.2@osu.edu>  - 1.1-1
- Updated test programs and location of schemas.

* Tue Oct 19 2004  Derek Atkins  <derek@ihtfp.com>  - 1.0-1
- Create SPEC file based on various versions in existence.
