#include <osg/Shape>
#include <osgDB/ObjectWrapper>
#include <osgDB/InputStream>
#include <osgDB/OutputStream>

static bool checkChildren( const osg::CompositeShape& shape )
{
    return shape.getNumChildren()>0;
}

static bool readChildren( osgDB::InputStream& is, osg::CompositeShape& shape )
{
    unsigned int size = 0; is >> size >> osgDB::BEGIN_BRACKET;
    for ( unsigned int i=0; i<size; ++i )
    {
        osg::Shape* child = dynamic_cast<osg::Shape*>( is.readObject() );
        if ( child ) shape.addChild( child );
    }
    is >> osgDB::END_BRACKET;
    return true;
}

static bool writeChildren( osgDB::OutputStream& os, const osg::CompositeShape& shape )
{
    unsigned int size = shape.getNumChildren();
    os << size << osgDB::BEGIN_BRACKET << std::endl;
    for ( unsigned int i=0; i<size; ++i )
    {
        os << shape.getChild(i);
    }
    os << osgDB::END_BRACKET << std::endl;
    return true;
}

REGISTER_OBJECT_WRAPPER( CompositeShape,
                         new osg::CompositeShape,
                         osg::CompositeShape,
                         "osg::Object osg::Shape osg::CompositeShape" )
{
    ADD_OBJECT_SERIALIZER( Shape, osg::Shape, NULL );  // _shape
    ADD_USER_SERIALIZER( Children );  //_children
}
