// -*- C++ -*- 
/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef TIMEBLOCK_H
#define TIMEBLOCK_H

#include <string>
#include <vector>
using namespace std;

class TASK;
class RESOURCE;

class TimeBlock
{
public:

    enum Type
    {
	MANUAL_SCHEDULE,
	AUTO_SCHEDULE,
	WORK_DONE,
	INVALID
    };

    TimeBlock(int start, int finish, Type type);
    virtual ~TimeBlock() = 0;
    int start() const { return mStart; };
    int finish() const { return mFinish; };
    Type type() const { return mType; };

    bool overlap(int start, int finish) const;

private:
    int mStart;
    int mFinish;
    Type mType;
};


class TaskTimeBlock : public TimeBlock
{
public:
    TaskTimeBlock(RESOURCE *r, int start, int finish, Type type);
    ~TaskTimeBlock() {};
    RESOURCE * resource() const { return mResource; };

private:
    RESOURCE *mResource;
};

typedef vector<TaskTimeBlock> TaskTimeBlockList;
typedef TaskTimeBlockList::const_iterator TaskTimeBlockIterator;


class ResourceTimeBlock : public TimeBlock
{
public:
    ResourceTimeBlock(TASK *r, int start, int finish, Type type);
    ~ResourceTimeBlock() {};
    TASK * task() const { return mTask; };

private:
    TASK *mTask;
};

typedef vector<ResourceTimeBlock> ResourceTimeBlockList;
typedef ResourceTimeBlockList::const_iterator ResourceTimeBlockIterator;


#endif
