/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of openserxs.xs. Do not edit this file, edit openserxs.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "openserxs.xs"
/*
 * $Id: openserxs.xs 1827 2007-03-12 15:22:53Z bogdan_iancu $
 *
 * Perl module for OpenSER
 *
 * Copyright (C) 2006 Collax GmbH
 *                    (Bastian Friedrich <bastian.friedrich@collax.com>)
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#include <unistd.h>
#undef load_module
#include "../../sr_module.h"
#include "../../parser/msg_parser.h"
#include "../../parser/parse_uri.h"
#include "../../usr_avp.h"
#include "../../action.h"
#include "../../flags.h"
#include "../../items.h"
#include "../../mem/mem.h"
#include "../../route_struct.h"
#include "../../serialize.h"
#include "../../qvalue.h"

extern int unsafemodfnc;

enum uri_members {
	user = 0,
	passwd,
	host,
	port,
	params,
	headers,
	transport,
	ttl,
	user_param,
	maddr,
	method,
	lr,
	r2,
	transport_val,
	ttl_val,
	user_param_val,
	maddr_val,
	method_val,
	lr_val,
	r2_val
	
	/* These members are no strings:
		unsigned short port_no;
	unsigned short proto; / * from transport * /
	uri_type type; / * uri scheme */
};

/*
 * Return the sip_msg struct referred to by perl reference sv
 */
struct sip_msg * sv2msg(SV *sv) {
	struct sip_msg* m;
	if (SvROK(sv)) {
		sv = SvRV(sv);
		if (SvIOK(sv)) {
			m = INT2PTR(struct sip_msg*, SvIV(sv));
			return m;
		}
	}
	return NULL; /* In case of error above... */
}

struct sip_uri * sv2uri(SV *sv) {
	struct sip_uri* u;
	if (SvROK(sv)) {
		sv = SvRV(sv);
		if (SvIOK(sv)) {
			u = INT2PTR(struct sip_uri*, SvIV(sv));
			return u;
		}
	}
	return NULL; /* In case of error above... */
}

struct action * sv2action(SV *sv) {
	struct action* a;
	if (SvROK(sv)) {
		sv = SvRV(sv);
		if (SvIOK(sv)) {
			a = INT2PTR(struct action*, SvIV(sv));
			return a;
		}
	}
	return NULL; /* In case of error above... */
}

/*
 * We have a private function for two reasons:
 * a) Return SIP_INVALID even if type was sth different
 * b) easy access
 */

inline static int getType(struct sip_msg *msg) {
	int t = SIP_INVALID;

	if (!msg) return SIP_INVALID;

	switch ((msg->first_line).type) {
		case SIP_REQUEST:	t = SIP_REQUEST; break;
		case SIP_REPLY:		t = SIP_REPLY; break;
	}
	return t;
}
		

SV *getStringFromURI(SV *self, enum uri_members what) {
	struct sip_uri *myuri = sv2uri(self);
	str *ret = NULL;

	if (!myuri) {
		LOG(L_ERR, "perl: Invalid URI reference\n");
		ret = NULL;
	} else {
		
		switch (what) {
			case user:		ret = &(myuri->user);
						break;
			case host:		ret = &(myuri->host);
						break;
			case passwd:		ret = &(myuri->passwd);
						break;
			case port:		ret = &(myuri->port);
						break;
			case params:		ret = &(myuri->params);
						break;
			case headers:		ret = &(myuri->headers);
						break;
			case transport:		ret = &(myuri->transport);
						break;
			case ttl:		ret = &(myuri->ttl);
						break;
			case user_param:	ret = &(myuri->user_param);
						break;
			case maddr:		ret = &(myuri->maddr);
						break;
			case method:		ret = &(myuri->method);
						break;
			case lr:		ret = &(myuri->lr);
						break;
			case r2:		ret = &(myuri->r2);
						break;
			case transport_val:	ret = &(myuri->transport_val);
						break;
			case ttl_val:		ret = &(myuri->ttl_val);
						break;
			case user_param_val:	ret = &(myuri->user_param_val);
						break;
			case maddr_val:		ret = &(myuri->maddr_val);
						break;
			case method_val:	ret = &(myuri->method_val);
						break;
			case lr_val:		ret = &(myuri->lr_val);
						break;
			case r2_val:		ret = &(myuri->r2_val);
						break;

			default:	LOG(L_INFO, "Unknown URI element"
						" requested: %d\n", what);
					break;
		}
	}

	if ((ret) && (ret->len)) {
		return sv_2mortal(newSVpv(ret->s, ret->len));
	} else {
		return &PL_sv_undef;
	}
}



/*
 * Calls an exported function. Parameters are copied and fixup'd.
 *
 * Return codes:
 *   -1 - Function not available (or other error).
 *    1 - Function was called. Its return value is returned via the retval
 *        parameter.
 */

int moduleFunc(struct sip_msg *m, char *func,
	       char *param1, char *param2,
	       int *retval) {

	cmd_export_t *exp_func_struct;
	struct action *act;
	char *argv[2];
	int argc = 0;
	action_elem_t elems[MAX_ACTION_ELEMS];

	if (!func) {
		LOG(L_ERR, "moduleFunc called with null function name. Error.");
		return -1;
	}

	if ((!param1) && param2) {
		LOG(L_ERR, "moduleFunc called with parameter 1 UNSET and"
			   " parameter 2 SET. Error.");
		return -1;
	}


	if (param1) {
		argv[0] = (char *)pkg_malloc(strlen(param1)+1);
		strcpy(argv[0], param1);
		argc++;
	} else {
		argv[0] = NULL;
	}

	if (param2) {
		argv[1] = (char *)pkg_malloc(strlen(param2)+1);
		strcpy(argv[1], param2);
		argc++;
	} else {
		argv[1] = NULL;
	}

	exp_func_struct = find_cmd_export_t(func, argc, 0);
	if (!exp_func_struct) {
		LOG(L_ERR, "function '%s' called, but not available.", func);
		*retval = -1;
		if (argv[0]) pkg_free(argv[0]);
		if (argv[1]) pkg_free(argv[1]);
		return -1;
	}

	elems[0].type = CMD_ST;
	elems[0].u.data = exp_func_struct;
	elems[1].type = STRING_ST;
	elems[1].u.data = argv[0];
	elems[2].type = STRING_ST;
	elems[2].u.data = argv[1];
	act = mk_action(	MODULE_T,
				3,
				elems,
				0);


	if (!act) {
		LOG(L_ERR, "action structure could not be created. Error.");
		if (argv[0]) pkg_free(argv[0]);
		if (argv[1]) pkg_free(argv[1]);
		return -1;
	}


	if (exp_func_struct->fixup) {
		if (!unsafemodfnc) {
			LOG(L_ERR, "perl: Module function '%s' is unsafe. Call is refused.\n", func);
			if (argv[0]) pkg_free(argv[0]);
			if (argv[1]) pkg_free(argv[1]);
			*retval = -1;
			return -1;
		}

		if (argc>=2) {
			*retval = exp_func_struct->fixup(&(act->elem[2].u.data), 2);
			if (*retval < 0) {
				LOG(L_ERR, "Error in fixup (2)\n");
				return -1;
			}
			act->elem[2].type = MODFIXUP_ST;
		}
		if (argc>=1) {
			*retval = exp_func_struct->fixup(&(act->elem[1].u.data), 1);
			if (*retval < 0) {
				LOG(L_ERR, "Error in fixup (1)\n");
				return -1;
			}
			act->elem[1].type = MODFIXUP_ST;
		}
		if (argc==0) {
			*retval = exp_func_struct->fixup(&(act->elem[0].u.data), 0);
			if (*retval < 0) {
				LOG(L_ERR, "Error in fixup (0)\n");
				return -1;
			}
		}
	}

	*retval = do_action(act, m);

	if ((act->elem[2].type == MODFIXUP_ST) && (act->elem[2].u.data)) {
		/* pkg_free(act->elem[2].u.data); */
		LOG(L_WARN, "perl:moduleFunction: A fixup function was called. "
				"This currently creates a memory leak.\n");
	}

	if ((act->elem[1].type == MODFIXUP_ST) && (act->elem[1].u.data)) {
		/* pkg_free(act->elem[1].u.data); */
		LOG(L_WARN, "perl:moduleFunction: A fixup function was called. "
				"This currently creates a memory leak.\n");
	}

	if (argv[0]) pkg_free(argv[0]);
	if (argv[1]) pkg_free(argv[1]);

	pkg_free(act);
	
	return 1;
}


/**
 * Rewrite Request-URI
 */
static inline int rewrite_ruri(struct sip_msg* _m, char* _s)
{
	struct action act;

	act.type = SET_URI_T;
	act.elem[0].type = STRING_ST;
	act.elem[0].u.string = _s;
	act.next = 0;
	
	if (do_action(&act, _m) < 0)
	{
		LOG(L_ERR, "perl:rewrite_ruri: Error in do_action\n");
		return -1;
	}
	return 0;
}


/**
 * Compile a string with pseudo variables substituted by their values.
 * A string buffer is allocated. Deallocate afterwards!
 */
char *xl_sprintf(struct sip_msg *m, char *fmt) {
	int buf_size = 4096;
	xl_elem_t *model;

	char *out = (char *)pkg_malloc(buf_size);
	char *ret = NULL;

	if (!out) {
		LOG(L_ERR, "perl:xl_sprintf: Memory exhausted!\n");
		return NULL;
	}

	if(xl_parse_format(fmt, &model, XL_DISABLE_NONE) < 0) {
		LOG(L_ERR, "perl:xl_sprintf: ERROR: wrong format[%s]!\n",
			fmt);
		return NULL;
	}

	if(xl_printf(m, model, out, &buf_size) < 0) {
		ret = NULL;
	} else {
		ret = strdup(out);
	}

	xl_elem_free_all(model);
	pkg_free(out);

	return ret;
}

/**
 * Convert an SV to an int_str struct. Needed in AVP package.
 * - val: SV to convert.
 * - is: pointer to resulting int_str
 * - flags: pointer to flags to set
 * - strflag: flag mask to be or-applied for string match
 */

inline int sv2int_str(SV *val, int_str *is,
		      unsigned short *flags, unsigned short strflag) {
	char *s;
	STRLEN len;

	if (!SvOK(val)) {
		LOG(L_ERR, "perl:AVP:sv2int_str: Invalid value "
			"(not a scalar).\n");
		return 0;
	}
	
	if (SvIOK(val)) { /* numerical name */
		is->n = SvIV(val);
		*flags = 0;
		return 1;
	} else if (SvPOK(val)) {
		s = SvPV(val, len);
		is->s.len = len;
		is->s.s = pkg_malloc(len+1);
		strcpy(is->s.s, s);
		(*flags) |= strflag;
		return 1;
	} else {
		LOG(L_ERR, "perl:AVP:sv2int_str: Invalid value "
			"(neither string nor integer).\n");
		return 0;
	}
}

/* ************************************************************************ */
/* Object methods begin here */

#if 0
  "Skipped embedded POD."
#endif
#line 433 "openserxs.xs"

#line 441 "openserxs.c"

XS(XS_OpenSER_log); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER_log)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OpenSER::log(level, log)");
    {
	int	level = (int)SvIV(ST(0));
	char *	log = (char *)SvPV_nolen(ST(1));
#line 463 "openserxs.xs"
#line 453 "openserxs.c"
#line 464 "openserxs.xs"
#line 455 "openserxs.c"
#line 465 "openserxs.xs"
	LOG(level, "%s", log);
#line 458 "openserxs.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_OpenSER__Message_getType); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getType)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getType(self)");
    {
	SV *	self = ST(0);
#line 493 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
#line 474 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 495 "openserxs.xs"
#line 478 "openserxs.c"
#line 496 "openserxs.xs"
  	RETVAL = getType(msg);
#line 481 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getStatus); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getStatus)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getStatus(self)");
    {
	SV *	self = ST(0);
#line 513 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 499 "openserxs.c"
	SV *	RETVAL;
#line 516 "openserxs.xs"
#line 502 "openserxs.c"
#line 517 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) != SIP_REPLY) {
			LOG(L_ERR, "perl:getStatus: Status not available in"
				" non-reply messages.");
			ST(0) = &PL_sv_undef;
		} else {
			ret = &((msg->first_line).u.reply.status);
			ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
		}
	}
#line 517 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getReason); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getReason)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getReason(self)");
    {
	SV *	self = ST(0);
#line 543 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 534 "openserxs.c"
	SV *	RETVAL;
#line 546 "openserxs.xs"
#line 537 "openserxs.c"
#line 547 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) != SIP_REPLY) {
			LOG(L_ERR, "perl:getReason: Reason not available in"
				" non-reply messages.");
			ST(0) = &PL_sv_undef;
		} else {
			ret = &((msg->first_line).u.reply.reason);
			ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
		}
	}
#line 552 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getVersion); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getVersion)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getVersion(self)");
    {
	SV *	self = ST(0);
#line 572 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 569 "openserxs.c"
	SV *	RETVAL;
#line 575 "openserxs.xs"
#line 572 "openserxs.c"
#line 576 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) == SIP_REQUEST) {
			ret = &((msg->first_line).u.request.version);
		} else { /* SIP_REPLY */
			ret = &((msg->first_line).u.reply.version);
		}
		ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
	}
#line 585 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getRURI); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getRURI)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getRURI(self)");
    {
	SV *	self = ST(0);
#line 606 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 602 "openserxs.c"
	SV *	RETVAL;
#line 609 "openserxs.xs"
#line 605 "openserxs.c"
#line 610 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) != SIP_REQUEST) {
			LOG(L_ERR, "perl: Not a request message - "
				"no RURI available.\n");
			ST(0) = &PL_sv_undef;
		} else {
			ret = &((msg->first_line).u.request.uri);
			ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
		}
	}
#line 620 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getMethod); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getMethod)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getMethod(self)");
    {
	SV *	self = ST(0);
#line 639 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 637 "openserxs.c"
	char *	RETVAL;
	dXSTARG;
#line 642 "openserxs.xs"
#line 641 "openserxs.c"
#line 643 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) != SIP_REQUEST) {
			LOG(L_ERR, "perl: Not a request message - "
				"no method available.\n");
			ST(0) = &PL_sv_undef;
		} else {
			ret = &((msg->first_line).u.request.method);
			ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
		}
	}
#line 656 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getFullHeader); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getFullHeader)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getFullHeader(self)");
    {
	SV *	self = ST(0);
#line 672 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    char *firsttoken;
    long headerlen;
#line 674 "openserxs.c"
	SV *	RETVAL;
#line 676 "openserxs.xs"
#line 677 "openserxs.c"
#line 677 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) == SIP_INVALID) {
			LOG(L_ERR, "perl:getFullHeader: Invalid message type.\n");
			ST(0)  = &PL_sv_undef;
		} else {
			parse_headers(msg, ~0, 0);
			if (getType(msg) == SIP_REQUEST) {
				firsttoken = (msg->first_line).u.request.method.s;
			} else { /* SIP_REPLY */
				firsttoken = (msg->first_line).u.reply.version.s;
			}

			if (msg->eoh == NULL)
				headerlen = 0;
			else
				headerlen = ((long)(msg->eoh))
						-((long)(firsttoken));

			if (headerlen > 0) {
				ST(0) = 
				    sv_2mortal(newSVpv(firsttoken, headerlen));
			} else {
				ST(0) = &PL_sv_undef;
			}
		}
	}
#line 708 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getBody); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getBody)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getBody(self)");
    {
	SV *	self = ST(0);
#line 718 "openserxs.xs"
#line 723 "openserxs.c"
#line 719 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
#line 726 "openserxs.c"
	SV *	RETVAL;
#line 721 "openserxs.xs"
#line 729 "openserxs.c"
#line 722 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		parse_headers(msg, ~0, 0);
		ST(0) = sv_2mortal(newSVpv(get_body(msg), 0));
	}
#line 738 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getMessage); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getMessage)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getMessage(self)");
    {
	SV *	self = ST(0);
#line 741 "openserxs.xs"
#line 753 "openserxs.c"
#line 742 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
#line 756 "openserxs.c"
	SV *	RETVAL;
#line 744 "openserxs.xs"
#line 759 "openserxs.c"
#line 745 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		ST(0) = sv_2mortal(newSVpv(msg->buf, 0));
	}
#line 767 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getHeader); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getHeader)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getHeader(self, name)");
    SP -= items;
    {
	SV *	self = ST(0);
	char *	name = (char *)SvPV_nolen(ST(1));
#line 768 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *body = NULL;
    struct hdr_field *hf;
    int found = 0;
    int namelen = strlen(name);
#line 789 "openserxs.c"
	SV *	RETVAL;
#line 774 "openserxs.xs"
#line 792 "openserxs.c"
#line 775 "openserxs.xs"
	DBG("getHeader: searching '%s'\n", name);

	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
	} else {
		parse_headers(msg, ~0, 0);
		for (hf = msg->headers; hf; hf = hf->next) {
			if (namelen == hf->name.len) {
				if (strncmp(name, hf->name.s, namelen) == 0) {
					/* Found the right header. */
					found = 1;
					body = &(hf->body);
					XPUSHs(sv_2mortal(newSVpv(body->s,
								  body->len)));
				}
			}
		}
	}
	if (!found) {
		XPUSHs(&PL_sv_undef);
	}
#line 815 "openserxs.c"
	PUTBACK;
	return;
    }
}


XS(XS_OpenSER__Message_getHeaderNames); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getHeaderNames)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getHeaderNames(self)");
    SP -= items;
    {
	SV *	self = ST(0);
#line 809 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    struct hdr_field *hf = NULL;
    int found = 0;
#line 835 "openserxs.c"
	AV *	RETVAL;
#line 814 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
	} else {
		parse_headers(msg, ~0, 0);
		for (hf = msg->headers; hf; hf = hf->next) {
			found = 1;
			XPUSHs(sv_2mortal(newSVpv(hf->name.s, hf->name.len)));
		}
	}
	if (!found) {
		XPUSHs(&PL_sv_undef);
	}
#line 850 "openserxs.c"
	PUTBACK;
	return;
    }
}


XS(XS_OpenSER__Message_moduleFunction); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_moduleFunction)
{
    dXSARGS;
    if (items < 2 || items > 4)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::moduleFunction(self, func, string1 = NULL, string2 = NULL)");
    {
	SV *	self = ST(0);
	char *	func = (char *)SvPV_nolen(ST(1));
	char *	string1;
	char *	string2;
#line 960 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    int retval; /* Return value of called function */
    int ret;    /* Return value of moduleFunc - < 0 for "non existing function" and other errors */
#line 872 "openserxs.c"
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    string1 = NULL;
	else {
	    string1 = (char *)SvPV_nolen(ST(2));
	}

	if (items < 4)
	    string2 = NULL;
	else {
	    string2 = (char *)SvPV_nolen(ST(3));
	}
#line 964 "openserxs.xs"
#line 888 "openserxs.c"
#line 965 "openserxs.xs"
	LOG(L_DBG, "perl: Calling exported func '%s', Param1 is '%s',"
		" Param2 is '%s'\n", func, string1, string2);

	ret = moduleFunc(msg, func, string1, string2, &retval);
	if (ret < 0) {
		LOG(L_ERR, "perl: calling module function '%s' failed."
			" Missing loadmodule?\n", func);
		retval = -1;
	}
	RETVAL = retval;
#line 900 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_log); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_log)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::log(self, level, log)");
    {
	SV *	self = ST(0);
	int	level = (int)SvIV(ST(1));
	char *	log = (char *)SvPV_nolen(ST(2));
#line 1004 "openserxs.xs"
#line 918 "openserxs.c"
#line 1005 "openserxs.xs"
#line 920 "openserxs.c"
#line 1006 "openserxs.xs"
	LOG(level, "%s", log);
#line 923 "openserxs.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_OpenSER__Message_rewrite_ruri); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_rewrite_ruri)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::rewrite_ruri(self, newruri)");
    {
	SV *	self = ST(0);
	char *	newruri = (char *)SvPV_nolen(ST(1));
#line 1026 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
#line 940 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1028 "openserxs.xs"
#line 944 "openserxs.c"
#line 1029 "openserxs.xs"
  	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		RETVAL = -1;
	} else {
		if (getType(msg) != SIP_REQUEST) {
			LOG(L_ERR, "perl:rewrite_ruri: Not a Request. "
				"RURI rewrite unavailable.\n");
			RETVAL = -1;
		} else {
			DBG("perl:rewrite_ruri: New R-URI is [%s]\n", newruri);
			RETVAL = rewrite_ruri(msg, newruri);
		}
	}
#line 959 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_setFlag); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_setFlag)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::setFlag(self, flag)");
    {
	SV *	self = ST(0);
	unsigned int	flag = (unsigned int)SvUV(ST(1));
#line 1059 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
#line 977 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1061 "openserxs.xs"
#line 981 "openserxs.c"
#line 1062 "openserxs.xs"
  	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		RETVAL = -1;
	} else {
		RETVAL = setflag(msg, flag);
	}
#line 989 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_resetFlag); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_resetFlag)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::resetFlag(self, flag)");
    {
	SV *	self = ST(0);
	unsigned int	flag = (unsigned int)SvUV(ST(1));
#line 1083 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
#line 1007 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1085 "openserxs.xs"
#line 1011 "openserxs.c"
#line 1086 "openserxs.xs"
  	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		RETVAL = -1;
	} else {
		RETVAL = resetflag(msg, flag);
	}
#line 1019 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_isFlagSet); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_isFlagSet)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::isFlagSet(self, flag)");
    {
	SV *	self = ST(0);
	unsigned int	flag = (unsigned int)SvUV(ST(1));
#line 1106 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
#line 1037 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1108 "openserxs.xs"
#line 1041 "openserxs.c"
#line 1109 "openserxs.xs"
  	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		RETVAL = -1;
	} else {
		RETVAL = isflagset(msg, flag) == 1 ? 1 : 0;
	}
#line 1049 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_pseudoVar); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_pseudoVar)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::pseudoVar(self, varstring)");
    {
	SV *	self = ST(0);
	char *	varstring = (char *)SvPV_nolen(ST(1));
#line 1133 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
	char *ret;
#line 1068 "openserxs.c"
	SV *	RETVAL;
#line 1136 "openserxs.xs"
  	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		ret = xl_sprintf(msg, varstring);
		if (ret) {
			ST(0) = sv_2mortal(newSVpv(ret, strlen(ret)));
			free(ret);
		} else {
			ST(0) = &PL_sv_undef;
		}
	}
#line 1083 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_append_branch); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_append_branch)
{
    dXSARGS;
    if (items < 1 || items > 3)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::append_branch(self, branch = NULL, qval = NULL)");
    {
	SV *	self = ST(0);
	char *	branch;
	char *	qval;
#line 1163 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
	action_elem_t elems[MAX_ACTION_ELEMS];
	qvalue_t q;
	int err = 0;
	struct action *act = NULL;
#line 1105 "openserxs.c"
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    branch = NULL;
	else {
	    branch = (char *)SvPV_nolen(ST(1));
	}

	if (items < 3)
	    qval = NULL;
	else {
	    qval = (char *)SvPV_nolen(ST(2));
	}
#line 1169 "openserxs.xs"
#line 1121 "openserxs.c"
#line 1170 "openserxs.xs"
  	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		RETVAL = -1;
	} else {
		if (qval) {
			if (str2q(&q, qval, strlen(qval)) < 0) {
				LOG(L_ERR, "perl:append_branch: Bad q value.");
			} else { /* branch and qval set */
				elems[0].type = STRING_ST;
				elems[0].u.data = branch;
				elems[1].type = NUMBER_ST;
				elems[1].u.data = (void *)(long)q;
				act = mk_action(APPEND_BRANCH_T,
						2,
						elems,
						0);
			}
		} else {
			if (branch) { /* branch set, qval unset */
				elems[0].type = STRING_ST;
				elems[0].u.data = branch;
				elems[1].type = NUMBER_ST;
				elems[1].u.data = (void *)Q_UNSPECIFIED;
				act = mk_action(APPEND_BRANCH_T,
						2,
						elems,
						0);
			} else { /* neither branch nor qval set */
				elems[0].type = STRING_ST;
				elems[0].u.data = NULL;
				elems[1].type = NUMBER_ST;
				elems[1].u.data = (void *)Q_UNSPECIFIED;
				act = mk_action(APPEND_BRANCH_T,
						2,
						elems,
						0);
			}
		}

		if (act) {
			RETVAL = do_action(act, msg);
		} else {
			RETVAL = -1;
		}
	}
#line 1168 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_serialize_branches); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_serialize_branches)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::serialize_branches(self, clean_before)");
    {
	SV *	self = ST(0);
	int	clean_before = (int)SvIV(ST(1));
#line 1230 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
#line 1186 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1232 "openserxs.xs"
  	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		RETVAL = -1;
	} else {
		RETVAL = serialize_branches(msg, clean_before);
	}
#line 1196 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_next_branches); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_next_branches)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::next_branches(self)");
    {
	SV *	self = ST(0);
#line 1253 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
#line 1213 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1255 "openserxs.xs"
  	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		RETVAL = -1;
	} else {
		RETVAL = next_branches(msg);
	}
#line 1223 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getParsedRURI); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getParsedRURI)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::Message::getParsedRURI(self)");
    {
	SV *	self = ST(0);
#line 1277 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    struct sip_uri *uri;
    SV *ret;
#line 1242 "openserxs.c"
	SV *	RETVAL;
#line 1281 "openserxs.xs"
#line 1245 "openserxs.c"
#line 1282 "openserxs.xs"
	if (!msg) {
		LOG(L_ERR, "perl: Invalid message reference\n");
		ST(0) = NULL;
	} else {
		parse_sip_msg_uri(msg);
		parse_headers(msg, ~0, 0);

		uri = &(msg->parsed_uri);
		ret = sv_newmortal();
		sv_setref_pv(ret, "OpenSER::URI", (void *)uri);
		SvREADONLY_on(SvRV(ret));

		ST(0) = ret;
	}
#line 1261 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_user); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_user)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::user(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1320 "openserxs.xs"
	ST(0) = getStringFromURI(self, user);
#line 1278 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_host); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_host)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::host(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1333 "openserxs.xs"
	ST(0) = getStringFromURI(self, host);
#line 1295 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_passwd); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_passwd)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::passwd(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1346 "openserxs.xs"
	ST(0) = getStringFromURI(self, passwd);
#line 1312 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_port); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_port)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::port(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1359 "openserxs.xs"
	ST(0) = getStringFromURI(self, port);
#line 1329 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_params); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_params)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::params(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1372 "openserxs.xs"
	ST(0) = getStringFromURI(self, params);
#line 1346 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_headers); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_headers)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::headers(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1385 "openserxs.xs"
	ST(0) = getStringFromURI(self, headers);
#line 1363 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_transport); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_transport)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::transport(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1398 "openserxs.xs"
	ST(0) = getStringFromURI(self, transport);
#line 1380 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_ttl); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_ttl)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::ttl(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1411 "openserxs.xs"
	ST(0) = getStringFromURI(self, ttl);
#line 1397 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_user_param); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_user_param)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::user_param(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1424 "openserxs.xs"
	ST(0) = getStringFromURI(self, user_param);
#line 1414 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_maddr); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_maddr)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::maddr(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1438 "openserxs.xs"
	ST(0) = getStringFromURI(self, maddr);
#line 1431 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_method); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_method)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::method(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1450 "openserxs.xs"
	ST(0) = getStringFromURI(self, method);
#line 1448 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_lr); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_lr)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::lr(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1463 "openserxs.xs"
	ST(0) = getStringFromURI(self, lr);
#line 1465 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_r2); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_r2)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::r2(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1476 "openserxs.xs"
	ST(0) = getStringFromURI(self, r2);
#line 1482 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_transport_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_transport_val)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::transport_val(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1489 "openserxs.xs"
	ST(0) = getStringFromURI(self, transport_val);
#line 1499 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_ttl_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_ttl_val)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::ttl_val(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1502 "openserxs.xs"
	ST(0) = getStringFromURI(self, ttl_val);
#line 1516 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_user_param_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_user_param_val)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::user_param_val(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1515 "openserxs.xs"
	ST(0) = getStringFromURI(self, user_param_val);
#line 1533 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_maddr_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_maddr_val)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::maddr_val(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1528 "openserxs.xs"
	ST(0) = getStringFromURI(self, maddr_val);
#line 1550 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_method_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_method_val)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::method_val(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1541 "openserxs.xs"
	ST(0) = getStringFromURI(self, method_val);
#line 1567 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_lr_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_lr_val)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::lr_val(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1554 "openserxs.xs"
	ST(0) = getStringFromURI(self, lr_val);
#line 1584 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_r2_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_r2_val)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::URI::r2_val(self)");
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1567 "openserxs.xs"
	ST(0) = getStringFromURI(self, r2_val);
#line 1601 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__AVP_add); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__AVP_add)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OpenSER::AVP::add(p_name, p_val)");
    {
	SV *	p_name = ST(0);
	SV *	p_val = ST(1);
#line 1611 "openserxs.xs"
	int_str name;
	int_str val;
	unsigned short flags = 0;
	char *s;
	STRLEN len;
#line 1622 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1617 "openserxs.xs"
  	RETVAL = 0;
	if (SvOK(p_name) && SvOK(p_val)) {
		if (!sv2int_str(p_name, &name, &flags, AVP_NAME_STR)) {
			RETVAL = -1;
		} else if (!sv2int_str(p_val, &val, &flags, AVP_VAL_STR)) {
			RETVAL = -1;
		}

		if (RETVAL == 0) {
			RETVAL = add_avp(flags, name, val);
		}
	}
#line 1638 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__AVP_get); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__AVP_get)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::AVP::get(p_name)");
    {
	SV *	p_name = ST(0);
#line 1648 "openserxs.xs"
	struct usr_avp *first_avp;
	int_str name;
	int_str val;
	unsigned short flags = 0;
	SV *ret = &PL_sv_undef;
	int err = 0;
	char *s;
	STRLEN len;
#line 1662 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1657 "openserxs.xs"
	if (SvOK(p_name)) {
		if (!sv2int_str(p_name, &name, &flags, AVP_NAME_STR)) {
			LOG(L_ERR, "perl:AVP:get: Invalid name.");
			err = 1;
		}
	} else {
		LOG(L_ERR, "perl:AVP:get: Invalid name.");
		err = 1;
	}

	if (err == 0) {
		first_avp = search_first_avp(flags, name, &val, NULL);

		if (first_avp != NULL) { /* found correct AVP */
			if (is_avp_str_val(first_avp)) {
				ret = sv_2mortal(newSVpv(val.s.s, val.s.len));
			} else {
				ret = sv_2mortal(newSViv(val.n));
			}
		} else {
			/* Empty AVP requested. */
		}
	}

	ST(0) = ret;
#line 1691 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__AVP_destroy); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__AVP_destroy)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OpenSER::AVP::destroy(p_name)");
    {
	SV *	p_name = ST(0);
#line 1699 "openserxs.xs"
	struct usr_avp *first_avp;
	int_str name;
	int_str val;
	unsigned short flags = 0;
	SV *ret = &PL_sv_undef;
	char *s;
	STRLEN len;
#line 1713 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1707 "openserxs.xs"
	RETVAL = 1;
	if (SvOK(p_name)) {
		if (!sv2int_str(p_name, &name, &flags, AVP_NAME_STR)) {
			RETVAL = 0;
			LOG(L_ERR, "perl:AVP:destroy: Invalid name.");
		}
	} else {
		RETVAL = 0;
		LOG(L_ERR, "perl:AVP:destroy: Invalid name.");
	}

	if (RETVAL == 1) {
		first_avp = search_first_avp(flags, name, &val, NULL);

		if (first_avp != NULL) { /* found correct AVP */
			destroy_avp(first_avp);
		} else {
			RETVAL = 0;
			/* Empty AVP requested. */
		}
	}
#line 1738 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_OpenSER); /* prototype to pass -Wmissing-prototypes */
XS(boot_OpenSER)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("OpenSER::log", XS_OpenSER_log, file);
        newXSproto("OpenSER::Message::getType", XS_OpenSER__Message_getType, file, "$");
        newXSproto("OpenSER::Message::getStatus", XS_OpenSER__Message_getStatus, file, "$");
        newXSproto("OpenSER::Message::getReason", XS_OpenSER__Message_getReason, file, "$");
        newXSproto("OpenSER::Message::getVersion", XS_OpenSER__Message_getVersion, file, "$");
        newXSproto("OpenSER::Message::getRURI", XS_OpenSER__Message_getRURI, file, "$");
        newXSproto("OpenSER::Message::getMethod", XS_OpenSER__Message_getMethod, file, "$");
        newXSproto("OpenSER::Message::getFullHeader", XS_OpenSER__Message_getFullHeader, file, "$");
        newXSproto("OpenSER::Message::getBody", XS_OpenSER__Message_getBody, file, "$");
        newXSproto("OpenSER::Message::getMessage", XS_OpenSER__Message_getMessage, file, "$");
        newXSproto("OpenSER::Message::getHeader", XS_OpenSER__Message_getHeader, file, "$$");
        newXSproto("OpenSER::Message::getHeaderNames", XS_OpenSER__Message_getHeaderNames, file, "$");
        newXSproto("OpenSER::Message::moduleFunction", XS_OpenSER__Message_moduleFunction, file, "$$;$$");
        newXSproto("OpenSER::Message::log", XS_OpenSER__Message_log, file, "$$$");
        newXSproto("OpenSER::Message::rewrite_ruri", XS_OpenSER__Message_rewrite_ruri, file, "$$");
        newXSproto("OpenSER::Message::setFlag", XS_OpenSER__Message_setFlag, file, "$$");
        newXSproto("OpenSER::Message::resetFlag", XS_OpenSER__Message_resetFlag, file, "$$");
        newXSproto("OpenSER::Message::isFlagSet", XS_OpenSER__Message_isFlagSet, file, "$$");
        newXSproto("OpenSER::Message::pseudoVar", XS_OpenSER__Message_pseudoVar, file, "$$");
        newXSproto("OpenSER::Message::append_branch", XS_OpenSER__Message_append_branch, file, "$;$$");
        newXSproto("OpenSER::Message::serialize_branches", XS_OpenSER__Message_serialize_branches, file, "$$");
        newXSproto("OpenSER::Message::next_branches", XS_OpenSER__Message_next_branches, file, "$");
        newXSproto("OpenSER::Message::getParsedRURI", XS_OpenSER__Message_getParsedRURI, file, "$");
        newXSproto("OpenSER::URI::user", XS_OpenSER__URI_user, file, "$");
        newXSproto("OpenSER::URI::host", XS_OpenSER__URI_host, file, "$");
        newXSproto("OpenSER::URI::passwd", XS_OpenSER__URI_passwd, file, "$");
        newXSproto("OpenSER::URI::port", XS_OpenSER__URI_port, file, "$");
        newXSproto("OpenSER::URI::params", XS_OpenSER__URI_params, file, "$");
        newXSproto("OpenSER::URI::headers", XS_OpenSER__URI_headers, file, "$");
        newXSproto("OpenSER::URI::transport", XS_OpenSER__URI_transport, file, "$");
        newXSproto("OpenSER::URI::ttl", XS_OpenSER__URI_ttl, file, "$");
        newXSproto("OpenSER::URI::user_param", XS_OpenSER__URI_user_param, file, "$");
        newXSproto("OpenSER::URI::maddr", XS_OpenSER__URI_maddr, file, "$");
        newXSproto("OpenSER::URI::method", XS_OpenSER__URI_method, file, "$");
        newXSproto("OpenSER::URI::lr", XS_OpenSER__URI_lr, file, "$");
        newXSproto("OpenSER::URI::r2", XS_OpenSER__URI_r2, file, "$");
        newXSproto("OpenSER::URI::transport_val", XS_OpenSER__URI_transport_val, file, "$");
        newXSproto("OpenSER::URI::ttl_val", XS_OpenSER__URI_ttl_val, file, "$");
        newXSproto("OpenSER::URI::user_param_val", XS_OpenSER__URI_user_param_val, file, "$");
        newXSproto("OpenSER::URI::maddr_val", XS_OpenSER__URI_maddr_val, file, "$");
        newXSproto("OpenSER::URI::method_val", XS_OpenSER__URI_method_val, file, "$");
        newXSproto("OpenSER::URI::lr_val", XS_OpenSER__URI_lr_val, file, "$");
        newXSproto("OpenSER::URI::r2_val", XS_OpenSER__URI_r2_val, file, "$");
        newXSproto("OpenSER::AVP::add", XS_OpenSER__AVP_add, file, "$$");
        newXSproto("OpenSER::AVP::get", XS_OpenSER__AVP_get, file, "$");
        newXSproto("OpenSER::AVP::destroy", XS_OpenSER__AVP_destroy, file, "$");
    XSRETURN_YES;
}

