/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class NewFieldContainerLib!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILENEWFIELDCONTAINERLIBINST

#include <stdlib.h>
#include <stdio.h>

#include <OpenSG/OSGConfig.h>

#include "OSGNewFieldContainerLibBase.h"
#include "OSGNewFieldContainerLib.h"


OSG_USING_NAMESPACE

const OSG::BitVector  NewFieldContainerLibBase::FooFieldMask = 
    (TypeTraits<BitVector>::One << NewFieldContainerLibBase::FooFieldId);

const OSG::BitVector  NewFieldContainerLibBase::BarFieldMask = 
    (TypeTraits<BitVector>::One << NewFieldContainerLibBase::BarFieldId);

const OSG::BitVector NewFieldContainerLibBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var UInt32          NewFieldContainerLibBase::_mfFoo
    The foos.
*/
/*! \var TripleInt       NewFieldContainerLibBase::_sfBar
    A Field containing the new TripleInt type.
*/

//! NewFieldContainerLib description

FieldDescription *NewFieldContainerLibBase::_desc[] = 
{
    new FieldDescription(MFUInt32::getClassType(), 
                     "foo", 
                     FooFieldId, FooFieldMask,
                     false,
                     (FieldAccessMethod) &NewFieldContainerLibBase::getMFFoo),
    new FieldDescription(SFTripleInt::getClassType(), 
                     "bar", 
                     BarFieldId, BarFieldMask,
                     false,
                     (FieldAccessMethod) &NewFieldContainerLibBase::getSFBar)
};


FieldContainerType NewFieldContainerLibBase::_type(
    "NewFieldContainerLib",
    "FieldContainer",
    NULL,
    (PrototypeCreateF) &NewFieldContainerLibBase::createEmpty,
    NewFieldContainerLib::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(NewFieldContainerLibBase, NewFieldContainerLibPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &NewFieldContainerLibBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &NewFieldContainerLibBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr NewFieldContainerLibBase::shallowCopy(void) const 
{ 
    NewFieldContainerLibPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const NewFieldContainerLib *>(this)); 

    return returnValue; 
}

UInt32 NewFieldContainerLibBase::getContainerSize(void) const 
{ 
    return sizeof(NewFieldContainerLib); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void NewFieldContainerLibBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((NewFieldContainerLibBase *) &other, whichField);
}
#else
void NewFieldContainerLibBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((NewFieldContainerLibBase *) &other, whichField, sInfo);
}
void NewFieldContainerLibBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void NewFieldContainerLibBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfFoo.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

NewFieldContainerLibBase::NewFieldContainerLibBase(void) :
    _mfFoo                    (), 
    _sfBar                    (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

NewFieldContainerLibBase::NewFieldContainerLibBase(const NewFieldContainerLibBase &source) :
    _mfFoo                    (source._mfFoo                    ), 
    _sfBar                    (source._sfBar                    ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

NewFieldContainerLibBase::~NewFieldContainerLibBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 NewFieldContainerLibBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (FooFieldMask & whichField))
    {
        returnValue += _mfFoo.getBinSize();
    }

    if(FieldBits::NoField != (BarFieldMask & whichField))
    {
        returnValue += _sfBar.getBinSize();
    }


    return returnValue;
}

void NewFieldContainerLibBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (FooFieldMask & whichField))
    {
        _mfFoo.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BarFieldMask & whichField))
    {
        _sfBar.copyToBin(pMem);
    }


}

void NewFieldContainerLibBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (FooFieldMask & whichField))
    {
        _mfFoo.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BarFieldMask & whichField))
    {
        _sfBar.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void NewFieldContainerLibBase::executeSyncImpl(      NewFieldContainerLibBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (FooFieldMask & whichField))
        _mfFoo.syncWith(pOther->_mfFoo);

    if(FieldBits::NoField != (BarFieldMask & whichField))
        _sfBar.syncWith(pOther->_sfBar);


}
#else
void NewFieldContainerLibBase::executeSyncImpl(      NewFieldContainerLibBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (BarFieldMask & whichField))
        _sfBar.syncWith(pOther->_sfBar);


    if(FieldBits::NoField != (FooFieldMask & whichField))
        _mfFoo.syncWith(pOther->_mfFoo, sInfo);


}

void NewFieldContainerLibBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (FooFieldMask & whichField))
        _mfFoo.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OpenSG/OSGSFieldTypeDef.inl>
#include <OpenSG/OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<NewFieldContainerLibPtr>::_type("NewFieldContainerLibPtr", "FieldContainerPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(NewFieldContainerLibPtr, OSG_MYLIBRARYLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(NewFieldContainerLibPtr, OSG_MYLIBRARYLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGNEWFIELDCONTAINERLIBBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGNEWFIELDCONTAINERLIBBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGNEWFIELDCONTAINERLIBFIELDS_HEADER_CVSID;
}

