/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CGFXAnnotation!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &CGFXAnnotationBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 CGFXAnnotationBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
CGFXAnnotationPtr CGFXAnnotationBase::create(void) 
{
    CGFXAnnotationPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = CGFXAnnotationPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
CGFXAnnotationPtr CGFXAnnotationBase::createEmpty(void) 
{ 
    CGFXAnnotationPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the CGFXAnnotation::_mfParameters field.
inline
MFShaderParameterPtr *CGFXAnnotationBase::getMFParameters(void)
{
    return &_mfParameters;
}



//! Get the value of the \a index element the CGFXAnnotation::_mfParameters field.
inline
ShaderParameterPtr &CGFXAnnotationBase::getParameters(const UInt32 index)
{
    return _mfParameters[index];
}

//! Get the CGFXAnnotation::_mfParameters field.
inline
MFShaderParameterPtr &CGFXAnnotationBase::getParameters(void)
{
    return _mfParameters;
}

//! Get the CGFXAnnotation::_mfParameters field.
inline
const MFShaderParameterPtr &CGFXAnnotationBase::getParameters(void) const
{
    return _mfParameters;
}

OSG_END_NAMESPACE

#define OSGCGFXANNOTATIONBASE_INLINE_CVSID "@(#)$Id: OSGCGFXAnnotationBase.inl,v 1.1 2006/04/05 16:10:24 a-m-z Exp $"

