/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DrawFunctorCore!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEDRAWFUNCTORCOREINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGDrawFunctorCoreBase.h"
#include "OSGDrawFunctorCore.h"


OSG_USING_NAMESPACE

const OSG::BitVector  DrawFunctorCoreBase::VolumeUpdateFieldMask = 
    (TypeTraits<BitVector>::One << DrawFunctorCoreBase::VolumeUpdateFieldId);

const OSG::BitVector  DrawFunctorCoreBase::DrawFieldMask = 
    (TypeTraits<BitVector>::One << DrawFunctorCoreBase::DrawFieldId);

const OSG::BitVector DrawFunctorCoreBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var VolumeFunctor   DrawFunctorCoreBase::_sfVolumeUpdate
    The Functor called for updating the volume
*/
/*! \var DrawFunctor     DrawFunctorCoreBase::_sfDraw
    The Functor called for drawing
*/

//! DrawFunctorCore description

FieldDescription *DrawFunctorCoreBase::_desc[] = 
{
    new FieldDescription(SFVolumeFunctor::getClassType(), 
                     "volumeUpdate", 
                     VolumeUpdateFieldId, VolumeUpdateFieldMask,
                     false,
                     (FieldAccessMethod) &DrawFunctorCoreBase::getSFVolumeUpdate),
    new FieldDescription(SFDrawFunctor::getClassType(), 
                     "draw", 
                     DrawFieldId, DrawFieldMask,
                     false,
                     (FieldAccessMethod) &DrawFunctorCoreBase::getSFDraw)
};


FieldContainerType DrawFunctorCoreBase::_type(
    "DrawFunctorCore",
    "MaterialDrawable",
    NULL,
    (PrototypeCreateF) &DrawFunctorCoreBase::createEmpty,
    DrawFunctorCore::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(DrawFunctorCoreBase, DrawFunctorCorePtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &DrawFunctorCoreBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &DrawFunctorCoreBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr DrawFunctorCoreBase::shallowCopy(void) const 
{ 
    DrawFunctorCorePtr returnValue; 

    newPtr(returnValue, dynamic_cast<const DrawFunctorCore *>(this)); 

    return returnValue; 
}

UInt32 DrawFunctorCoreBase::getContainerSize(void) const 
{ 
    return sizeof(DrawFunctorCore); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void DrawFunctorCoreBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((DrawFunctorCoreBase *) &other, whichField);
}
#else
void DrawFunctorCoreBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((DrawFunctorCoreBase *) &other, whichField, sInfo);
}
void DrawFunctorCoreBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void DrawFunctorCoreBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

DrawFunctorCoreBase::DrawFunctorCoreBase(void) :
    _sfVolumeUpdate           (), 
    _sfDraw                   (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

DrawFunctorCoreBase::DrawFunctorCoreBase(const DrawFunctorCoreBase &source) :
    _sfVolumeUpdate           (source._sfVolumeUpdate           ), 
    _sfDraw                   (source._sfDraw                   ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

DrawFunctorCoreBase::~DrawFunctorCoreBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 DrawFunctorCoreBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (VolumeUpdateFieldMask & whichField))
    {
        returnValue += _sfVolumeUpdate.getBinSize();
    }

    if(FieldBits::NoField != (DrawFieldMask & whichField))
    {
        returnValue += _sfDraw.getBinSize();
    }


    return returnValue;
}

void DrawFunctorCoreBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (VolumeUpdateFieldMask & whichField))
    {
        _sfVolumeUpdate.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DrawFieldMask & whichField))
    {
        _sfDraw.copyToBin(pMem);
    }


}

void DrawFunctorCoreBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (VolumeUpdateFieldMask & whichField))
    {
        _sfVolumeUpdate.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DrawFieldMask & whichField))
    {
        _sfDraw.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void DrawFunctorCoreBase::executeSyncImpl(      DrawFunctorCoreBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (VolumeUpdateFieldMask & whichField))
        _sfVolumeUpdate.syncWith(pOther->_sfVolumeUpdate);

    if(FieldBits::NoField != (DrawFieldMask & whichField))
        _sfDraw.syncWith(pOther->_sfDraw);


}
#else
void DrawFunctorCoreBase::executeSyncImpl(      DrawFunctorCoreBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (VolumeUpdateFieldMask & whichField))
        _sfVolumeUpdate.syncWith(pOther->_sfVolumeUpdate);

    if(FieldBits::NoField != (DrawFieldMask & whichField))
        _sfDraw.syncWith(pOther->_sfDraw);



}

void DrawFunctorCoreBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<DrawFunctorCorePtr>::_type("DrawFunctorCorePtr", "MaterialDrawablePtr");
#endif


OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGDRAWFUNCTORCOREBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGDRAWFUNCTORCOREBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGDRAWFUNCTORCOREFIELDS_HEADER_CVSID;
}

