/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class SkinDeformer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &SkinDeformerBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 SkinDeformerBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
SkinDeformerPtr SkinDeformerBase::create(void) 
{
    SkinDeformerPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = SkinDeformerPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
SkinDeformerPtr SkinDeformerBase::createEmpty(void) 
{ 
    SkinDeformerPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the SkinDeformer::_mfInfluences field.
inline
MFNodePtr *SkinDeformerBase::getMFInfluences(void)
{
    return &_mfInfluences;
}

//! Get the SkinDeformer::_mfBaseMatrices field.
inline
MFMatrix *SkinDeformerBase::getMFBaseMatrices(void)
{
    return &_mfBaseMatrices;
}

//! Get the SkinDeformer::_mfVertexIndices field.
inline
MFUInt32 *SkinDeformerBase::getMFVertexIndices(void)
{
    return &_mfVertexIndices;
}

//! Get the SkinDeformer::_mfInfluenceIndices field.
inline
MFUInt16 *SkinDeformerBase::getMFInfluenceIndices(void)
{
    return &_mfInfluenceIndices;
}

//! Get the SkinDeformer::_mfInfluenceWeights field.
inline
MFReal32 *SkinDeformerBase::getMFInfluenceWeights(void)
{
    return &_mfInfluenceWeights;
}

//! Get the SkinDeformer::_mfNormalIndices field.
inline
MFUInt32 *SkinDeformerBase::getMFNormalIndices(void)
{
    return &_mfNormalIndices;
}

//! Get the SkinDeformer::_mfNormalInfluenceIndices field.
inline
MFUInt16 *SkinDeformerBase::getMFNormalInfluenceIndices(void)
{
    return &_mfNormalInfluenceIndices;
}

//! Get the SkinDeformer::_mfNormalInfluenceWeights field.
inline
MFReal32 *SkinDeformerBase::getMFNormalInfluenceWeights(void)
{
    return &_mfNormalInfluenceWeights;
}



//! Get the value of the \a index element the SkinDeformer::_mfInfluences field.
inline
NodePtr &SkinDeformerBase::getInfluences(const UInt32 index)
{
    return _mfInfluences[index];
}

//! Get the SkinDeformer::_mfInfluences field.
inline
MFNodePtr &SkinDeformerBase::getInfluences(void)
{
    return _mfInfluences;
}

//! Get the SkinDeformer::_mfInfluences field.
inline
const MFNodePtr &SkinDeformerBase::getInfluences(void) const
{
    return _mfInfluences;
}

//! Get the value of the \a index element the SkinDeformer::_mfBaseMatrices field.
inline
Matrix &SkinDeformerBase::getBaseMatrices(const UInt32 index)
{
    return _mfBaseMatrices[index];
}

//! Get the SkinDeformer::_mfBaseMatrices field.
inline
MFMatrix &SkinDeformerBase::getBaseMatrices(void)
{
    return _mfBaseMatrices;
}

//! Get the SkinDeformer::_mfBaseMatrices field.
inline
const MFMatrix &SkinDeformerBase::getBaseMatrices(void) const
{
    return _mfBaseMatrices;
}

//! Get the value of the \a index element the SkinDeformer::_mfVertexIndices field.
inline
UInt32 &SkinDeformerBase::getVertexIndices(const UInt32 index)
{
    return _mfVertexIndices[index];
}

//! Get the SkinDeformer::_mfVertexIndices field.
inline
MFUInt32 &SkinDeformerBase::getVertexIndices(void)
{
    return _mfVertexIndices;
}

//! Get the SkinDeformer::_mfVertexIndices field.
inline
const MFUInt32 &SkinDeformerBase::getVertexIndices(void) const
{
    return _mfVertexIndices;
}

//! Get the value of the \a index element the SkinDeformer::_mfInfluenceIndices field.
inline
UInt16 &SkinDeformerBase::getInfluenceIndices(const UInt32 index)
{
    return _mfInfluenceIndices[index];
}

//! Get the SkinDeformer::_mfInfluenceIndices field.
inline
MFUInt16 &SkinDeformerBase::getInfluenceIndices(void)
{
    return _mfInfluenceIndices;
}

//! Get the SkinDeformer::_mfInfluenceIndices field.
inline
const MFUInt16 &SkinDeformerBase::getInfluenceIndices(void) const
{
    return _mfInfluenceIndices;
}

//! Get the value of the \a index element the SkinDeformer::_mfInfluenceWeights field.
inline
Real32 &SkinDeformerBase::getInfluenceWeights(const UInt32 index)
{
    return _mfInfluenceWeights[index];
}

//! Get the SkinDeformer::_mfInfluenceWeights field.
inline
MFReal32 &SkinDeformerBase::getInfluenceWeights(void)
{
    return _mfInfluenceWeights;
}

//! Get the SkinDeformer::_mfInfluenceWeights field.
inline
const MFReal32 &SkinDeformerBase::getInfluenceWeights(void) const
{
    return _mfInfluenceWeights;
}

//! Get the value of the \a index element the SkinDeformer::_mfNormalIndices field.
inline
UInt32 &SkinDeformerBase::getNormalIndices(const UInt32 index)
{
    return _mfNormalIndices[index];
}

//! Get the SkinDeformer::_mfNormalIndices field.
inline
MFUInt32 &SkinDeformerBase::getNormalIndices(void)
{
    return _mfNormalIndices;
}

//! Get the SkinDeformer::_mfNormalIndices field.
inline
const MFUInt32 &SkinDeformerBase::getNormalIndices(void) const
{
    return _mfNormalIndices;
}

//! Get the value of the \a index element the SkinDeformer::_mfNormalInfluenceIndices field.
inline
UInt16 &SkinDeformerBase::getNormalInfluenceIndices(const UInt32 index)
{
    return _mfNormalInfluenceIndices[index];
}

//! Get the SkinDeformer::_mfNormalInfluenceIndices field.
inline
MFUInt16 &SkinDeformerBase::getNormalInfluenceIndices(void)
{
    return _mfNormalInfluenceIndices;
}

//! Get the SkinDeformer::_mfNormalInfluenceIndices field.
inline
const MFUInt16 &SkinDeformerBase::getNormalInfluenceIndices(void) const
{
    return _mfNormalInfluenceIndices;
}

//! Get the value of the \a index element the SkinDeformer::_mfNormalInfluenceWeights field.
inline
Real32 &SkinDeformerBase::getNormalInfluenceWeights(const UInt32 index)
{
    return _mfNormalInfluenceWeights[index];
}

//! Get the SkinDeformer::_mfNormalInfluenceWeights field.
inline
MFReal32 &SkinDeformerBase::getNormalInfluenceWeights(void)
{
    return _mfNormalInfluenceWeights;
}

//! Get the SkinDeformer::_mfNormalInfluenceWeights field.
inline
const MFReal32 &SkinDeformerBase::getNormalInfluenceWeights(void) const
{
    return _mfNormalInfluenceWeights;
}

OSG_END_NAMESPACE

#define OSGSKINDEFORMERBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

