/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsBody!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEPHYSICSBODYINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGPhysicsBodyBase.h"
#include "OSGPhysicsBody.h"


OSG_USING_NAMESPACE

const OSG::BitVector  PhysicsBodyBase::PositionFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::PositionFieldId);

const OSG::BitVector  PhysicsBodyBase::RotationFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::RotationFieldId);

const OSG::BitVector  PhysicsBodyBase::QuaternionFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::QuaternionFieldId);

const OSG::BitVector  PhysicsBodyBase::LinearVelFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::LinearVelFieldId);

const OSG::BitVector  PhysicsBodyBase::AngularVelFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::AngularVelFieldId);

const OSG::BitVector  PhysicsBodyBase::ForceFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::ForceFieldId);

const OSG::BitVector  PhysicsBodyBase::TorqueFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::TorqueFieldId);

const OSG::BitVector  PhysicsBodyBase::EnableFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::EnableFieldId);

const OSG::BitVector  PhysicsBodyBase::AutoDisableFlagFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::AutoDisableFlagFieldId);

const OSG::BitVector  PhysicsBodyBase::AutoDisableLinearThresholFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::AutoDisableLinearThresholFieldId);

const OSG::BitVector  PhysicsBodyBase::AutoDisableAngularThresholFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::AutoDisableAngularThresholFieldId);

const OSG::BitVector  PhysicsBodyBase::AutoDisableStepsFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::AutoDisableStepsFieldId);

const OSG::BitVector  PhysicsBodyBase::AutoDisableTimeFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::AutoDisableTimeFieldId);

const OSG::BitVector  PhysicsBodyBase::FiniteRotationModeFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::FiniteRotationModeFieldId);

const OSG::BitVector  PhysicsBodyBase::FiniteRotationAxisFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::FiniteRotationAxisFieldId);

const OSG::BitVector  PhysicsBodyBase::GravityModeFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::GravityModeFieldId);

const OSG::BitVector  PhysicsBodyBase::WorldFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsBodyBase::WorldFieldId);

const OSG::BitVector PhysicsBodyBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Vec3f           PhysicsBodyBase::_sfPosition
    
*/
/*! \var Matrix          PhysicsBodyBase::_sfRotation
    
*/
/*! \var Quaternion      PhysicsBodyBase::_sfQuaternion
    
*/
/*! \var Vec3f           PhysicsBodyBase::_sfLinearVel
    
*/
/*! \var Vec3f           PhysicsBodyBase::_sfAngularVel
    
*/
/*! \var Vec3f           PhysicsBodyBase::_sfForce
    
*/
/*! \var Vec3f           PhysicsBodyBase::_sfTorque
    
*/
/*! \var bool            PhysicsBodyBase::_sfEnable
    
*/
/*! \var Int32           PhysicsBodyBase::_sfAutoDisableFlag
    
*/
/*! \var Real32          PhysicsBodyBase::_sfAutoDisableLinearThreshol
    
*/
/*! \var Real32          PhysicsBodyBase::_sfAutoDisableAngularThreshol
    
*/
/*! \var Int32           PhysicsBodyBase::_sfAutoDisableSteps
    
*/
/*! \var Real32          PhysicsBodyBase::_sfAutoDisableTime
    
*/
/*! \var Int32           PhysicsBodyBase::_sfFiniteRotationMode
    
*/
/*! \var Vec3f           PhysicsBodyBase::_sfFiniteRotationAxis
    
*/
/*! \var bool            PhysicsBodyBase::_sfGravityMode
    
*/
/*! \var PhysicsWorldPtr PhysicsBodyBase::_sfWorld
    
*/

//! PhysicsBody description

FieldDescription *PhysicsBodyBase::_desc[] = 
{
    new FieldDescription(SFVec3f::getClassType(), 
                     "position", 
                     PositionFieldId, PositionFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFPosition),
    new FieldDescription(SFMatrix::getClassType(), 
                     "rotation", 
                     RotationFieldId, RotationFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFRotation),
    new FieldDescription(SFQuaternion::getClassType(), 
                     "quaternion", 
                     QuaternionFieldId, QuaternionFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFQuaternion),
    new FieldDescription(SFVec3f::getClassType(), 
                     "linearVel", 
                     LinearVelFieldId, LinearVelFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFLinearVel),
    new FieldDescription(SFVec3f::getClassType(), 
                     "angularVel", 
                     AngularVelFieldId, AngularVelFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFAngularVel),
    new FieldDescription(SFVec3f::getClassType(), 
                     "force", 
                     ForceFieldId, ForceFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFForce),
    new FieldDescription(SFVec3f::getClassType(), 
                     "torque", 
                     TorqueFieldId, TorqueFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFTorque),
    new FieldDescription(SFBool::getClassType(), 
                     "enable", 
                     EnableFieldId, EnableFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFEnable),
    new FieldDescription(SFInt32::getClassType(), 
                     "autoDisableFlag", 
                     AutoDisableFlagFieldId, AutoDisableFlagFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFAutoDisableFlag),
    new FieldDescription(SFReal32::getClassType(), 
                     "autoDisableLinearThreshol", 
                     AutoDisableLinearThresholFieldId, AutoDisableLinearThresholFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFAutoDisableLinearThreshol),
    new FieldDescription(SFReal32::getClassType(), 
                     "autoDisableAngularThreshol", 
                     AutoDisableAngularThresholFieldId, AutoDisableAngularThresholFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFAutoDisableAngularThreshol),
    new FieldDescription(SFInt32::getClassType(), 
                     "autoDisableSteps", 
                     AutoDisableStepsFieldId, AutoDisableStepsFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFAutoDisableSteps),
    new FieldDescription(SFReal32::getClassType(), 
                     "autoDisableTime", 
                     AutoDisableTimeFieldId, AutoDisableTimeFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFAutoDisableTime),
    new FieldDescription(SFInt32::getClassType(), 
                     "finiteRotationMode", 
                     FiniteRotationModeFieldId, FiniteRotationModeFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFFiniteRotationMode),
    new FieldDescription(SFVec3f::getClassType(), 
                     "finiteRotationAxis", 
                     FiniteRotationAxisFieldId, FiniteRotationAxisFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFFiniteRotationAxis),
    new FieldDescription(SFBool::getClassType(), 
                     "gravityMode", 
                     GravityModeFieldId, GravityModeFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFGravityMode),
    new FieldDescription(SFPhysicsWorldPtr::getClassType(), 
                     "world", 
                     WorldFieldId, WorldFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsBodyBase::getSFWorld)
};


FieldContainerType PhysicsBodyBase::_type(
    "PhysicsBody",
    "Attachment",
    NULL,
    (PrototypeCreateF) &PhysicsBodyBase::createEmpty,
    PhysicsBody::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(PhysicsBodyBase, PhysicsBodyPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &PhysicsBodyBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &PhysicsBodyBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr PhysicsBodyBase::shallowCopy(void) const 
{ 
    PhysicsBodyPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const PhysicsBody *>(this)); 

    return returnValue; 
}

UInt32 PhysicsBodyBase::getContainerSize(void) const 
{ 
    return sizeof(PhysicsBody); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsBodyBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((PhysicsBodyBase *) &other, whichField);
}
#else
void PhysicsBodyBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((PhysicsBodyBase *) &other, whichField, sInfo);
}
void PhysicsBodyBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void PhysicsBodyBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

PhysicsBodyBase::PhysicsBodyBase(void) :
    _sfPosition               (), 
    _sfRotation               (), 
    _sfQuaternion             (), 
    _sfLinearVel              (), 
    _sfAngularVel             (), 
    _sfForce                  (), 
    _sfTorque                 (), 
    _sfEnable                 (bool(true)), 
    _sfAutoDisableFlag        (), 
    _sfAutoDisableLinearThreshol(), 
    _sfAutoDisableAngularThreshol(), 
    _sfAutoDisableSteps       (), 
    _sfAutoDisableTime        (), 
    _sfFiniteRotationMode     (), 
    _sfFiniteRotationAxis     (), 
    _sfGravityMode            (bool(true)), 
    _sfWorld                  (PhysicsWorldPtr(NullFC)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

PhysicsBodyBase::PhysicsBodyBase(const PhysicsBodyBase &source) :
    _sfPosition               (source._sfPosition               ), 
    _sfRotation               (source._sfRotation               ), 
    _sfQuaternion             (source._sfQuaternion             ), 
    _sfLinearVel              (source._sfLinearVel              ), 
    _sfAngularVel             (source._sfAngularVel             ), 
    _sfForce                  (source._sfForce                  ), 
    _sfTorque                 (source._sfTorque                 ), 
    _sfEnable                 (source._sfEnable                 ), 
    _sfAutoDisableFlag        (source._sfAutoDisableFlag        ), 
    _sfAutoDisableLinearThreshol(source._sfAutoDisableLinearThreshol), 
    _sfAutoDisableAngularThreshol(source._sfAutoDisableAngularThreshol), 
    _sfAutoDisableSteps       (source._sfAutoDisableSteps       ), 
    _sfAutoDisableTime        (source._sfAutoDisableTime        ), 
    _sfFiniteRotationMode     (source._sfFiniteRotationMode     ), 
    _sfFiniteRotationAxis     (source._sfFiniteRotationAxis     ), 
    _sfGravityMode            (source._sfGravityMode            ), 
    _sfWorld                  (source._sfWorld                  ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

PhysicsBodyBase::~PhysicsBodyBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 PhysicsBodyBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        returnValue += _sfPosition.getBinSize();
    }

    if(FieldBits::NoField != (RotationFieldMask & whichField))
    {
        returnValue += _sfRotation.getBinSize();
    }

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
    {
        returnValue += _sfQuaternion.getBinSize();
    }

    if(FieldBits::NoField != (LinearVelFieldMask & whichField))
    {
        returnValue += _sfLinearVel.getBinSize();
    }

    if(FieldBits::NoField != (AngularVelFieldMask & whichField))
    {
        returnValue += _sfAngularVel.getBinSize();
    }

    if(FieldBits::NoField != (ForceFieldMask & whichField))
    {
        returnValue += _sfForce.getBinSize();
    }

    if(FieldBits::NoField != (TorqueFieldMask & whichField))
    {
        returnValue += _sfTorque.getBinSize();
    }

    if(FieldBits::NoField != (EnableFieldMask & whichField))
    {
        returnValue += _sfEnable.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
    {
        returnValue += _sfAutoDisableFlag.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableLinearThresholFieldMask & whichField))
    {
        returnValue += _sfAutoDisableLinearThreshol.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableAngularThresholFieldMask & whichField))
    {
        returnValue += _sfAutoDisableAngularThreshol.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
    {
        returnValue += _sfAutoDisableSteps.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
    {
        returnValue += _sfAutoDisableTime.getBinSize();
    }

    if(FieldBits::NoField != (FiniteRotationModeFieldMask & whichField))
    {
        returnValue += _sfFiniteRotationMode.getBinSize();
    }

    if(FieldBits::NoField != (FiniteRotationAxisFieldMask & whichField))
    {
        returnValue += _sfFiniteRotationAxis.getBinSize();
    }

    if(FieldBits::NoField != (GravityModeFieldMask & whichField))
    {
        returnValue += _sfGravityMode.getBinSize();
    }

    if(FieldBits::NoField != (WorldFieldMask & whichField))
    {
        returnValue += _sfWorld.getBinSize();
    }


    return returnValue;
}

void PhysicsBodyBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _sfPosition.copyToBin(pMem);
    }

    if(FieldBits::NoField != (RotationFieldMask & whichField))
    {
        _sfRotation.copyToBin(pMem);
    }

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
    {
        _sfQuaternion.copyToBin(pMem);
    }

    if(FieldBits::NoField != (LinearVelFieldMask & whichField))
    {
        _sfLinearVel.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AngularVelFieldMask & whichField))
    {
        _sfAngularVel.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ForceFieldMask & whichField))
    {
        _sfForce.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TorqueFieldMask & whichField))
    {
        _sfTorque.copyToBin(pMem);
    }

    if(FieldBits::NoField != (EnableFieldMask & whichField))
    {
        _sfEnable.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
    {
        _sfAutoDisableFlag.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableLinearThresholFieldMask & whichField))
    {
        _sfAutoDisableLinearThreshol.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableAngularThresholFieldMask & whichField))
    {
        _sfAutoDisableAngularThreshol.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
    {
        _sfAutoDisableSteps.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
    {
        _sfAutoDisableTime.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FiniteRotationModeFieldMask & whichField))
    {
        _sfFiniteRotationMode.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FiniteRotationAxisFieldMask & whichField))
    {
        _sfFiniteRotationAxis.copyToBin(pMem);
    }

    if(FieldBits::NoField != (GravityModeFieldMask & whichField))
    {
        _sfGravityMode.copyToBin(pMem);
    }

    if(FieldBits::NoField != (WorldFieldMask & whichField))
    {
        _sfWorld.copyToBin(pMem);
    }


}

void PhysicsBodyBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _sfPosition.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (RotationFieldMask & whichField))
    {
        _sfRotation.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
    {
        _sfQuaternion.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (LinearVelFieldMask & whichField))
    {
        _sfLinearVel.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AngularVelFieldMask & whichField))
    {
        _sfAngularVel.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ForceFieldMask & whichField))
    {
        _sfForce.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TorqueFieldMask & whichField))
    {
        _sfTorque.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (EnableFieldMask & whichField))
    {
        _sfEnable.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
    {
        _sfAutoDisableFlag.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableLinearThresholFieldMask & whichField))
    {
        _sfAutoDisableLinearThreshol.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableAngularThresholFieldMask & whichField))
    {
        _sfAutoDisableAngularThreshol.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
    {
        _sfAutoDisableSteps.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
    {
        _sfAutoDisableTime.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FiniteRotationModeFieldMask & whichField))
    {
        _sfFiniteRotationMode.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FiniteRotationAxisFieldMask & whichField))
    {
        _sfFiniteRotationAxis.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (GravityModeFieldMask & whichField))
    {
        _sfGravityMode.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (WorldFieldMask & whichField))
    {
        _sfWorld.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsBodyBase::executeSyncImpl(      PhysicsBodyBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _sfPosition.syncWith(pOther->_sfPosition);

    if(FieldBits::NoField != (RotationFieldMask & whichField))
        _sfRotation.syncWith(pOther->_sfRotation);

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
        _sfQuaternion.syncWith(pOther->_sfQuaternion);

    if(FieldBits::NoField != (LinearVelFieldMask & whichField))
        _sfLinearVel.syncWith(pOther->_sfLinearVel);

    if(FieldBits::NoField != (AngularVelFieldMask & whichField))
        _sfAngularVel.syncWith(pOther->_sfAngularVel);

    if(FieldBits::NoField != (ForceFieldMask & whichField))
        _sfForce.syncWith(pOther->_sfForce);

    if(FieldBits::NoField != (TorqueFieldMask & whichField))
        _sfTorque.syncWith(pOther->_sfTorque);

    if(FieldBits::NoField != (EnableFieldMask & whichField))
        _sfEnable.syncWith(pOther->_sfEnable);

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
        _sfAutoDisableFlag.syncWith(pOther->_sfAutoDisableFlag);

    if(FieldBits::NoField != (AutoDisableLinearThresholFieldMask & whichField))
        _sfAutoDisableLinearThreshol.syncWith(pOther->_sfAutoDisableLinearThreshol);

    if(FieldBits::NoField != (AutoDisableAngularThresholFieldMask & whichField))
        _sfAutoDisableAngularThreshol.syncWith(pOther->_sfAutoDisableAngularThreshol);

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
        _sfAutoDisableSteps.syncWith(pOther->_sfAutoDisableSteps);

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
        _sfAutoDisableTime.syncWith(pOther->_sfAutoDisableTime);

    if(FieldBits::NoField != (FiniteRotationModeFieldMask & whichField))
        _sfFiniteRotationMode.syncWith(pOther->_sfFiniteRotationMode);

    if(FieldBits::NoField != (FiniteRotationAxisFieldMask & whichField))
        _sfFiniteRotationAxis.syncWith(pOther->_sfFiniteRotationAxis);

    if(FieldBits::NoField != (GravityModeFieldMask & whichField))
        _sfGravityMode.syncWith(pOther->_sfGravityMode);

    if(FieldBits::NoField != (WorldFieldMask & whichField))
        _sfWorld.syncWith(pOther->_sfWorld);


}
#else
void PhysicsBodyBase::executeSyncImpl(      PhysicsBodyBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _sfPosition.syncWith(pOther->_sfPosition);

    if(FieldBits::NoField != (RotationFieldMask & whichField))
        _sfRotation.syncWith(pOther->_sfRotation);

    if(FieldBits::NoField != (QuaternionFieldMask & whichField))
        _sfQuaternion.syncWith(pOther->_sfQuaternion);

    if(FieldBits::NoField != (LinearVelFieldMask & whichField))
        _sfLinearVel.syncWith(pOther->_sfLinearVel);

    if(FieldBits::NoField != (AngularVelFieldMask & whichField))
        _sfAngularVel.syncWith(pOther->_sfAngularVel);

    if(FieldBits::NoField != (ForceFieldMask & whichField))
        _sfForce.syncWith(pOther->_sfForce);

    if(FieldBits::NoField != (TorqueFieldMask & whichField))
        _sfTorque.syncWith(pOther->_sfTorque);

    if(FieldBits::NoField != (EnableFieldMask & whichField))
        _sfEnable.syncWith(pOther->_sfEnable);

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
        _sfAutoDisableFlag.syncWith(pOther->_sfAutoDisableFlag);

    if(FieldBits::NoField != (AutoDisableLinearThresholFieldMask & whichField))
        _sfAutoDisableLinearThreshol.syncWith(pOther->_sfAutoDisableLinearThreshol);

    if(FieldBits::NoField != (AutoDisableAngularThresholFieldMask & whichField))
        _sfAutoDisableAngularThreshol.syncWith(pOther->_sfAutoDisableAngularThreshol);

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
        _sfAutoDisableSteps.syncWith(pOther->_sfAutoDisableSteps);

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
        _sfAutoDisableTime.syncWith(pOther->_sfAutoDisableTime);

    if(FieldBits::NoField != (FiniteRotationModeFieldMask & whichField))
        _sfFiniteRotationMode.syncWith(pOther->_sfFiniteRotationMode);

    if(FieldBits::NoField != (FiniteRotationAxisFieldMask & whichField))
        _sfFiniteRotationAxis.syncWith(pOther->_sfFiniteRotationAxis);

    if(FieldBits::NoField != (GravityModeFieldMask & whichField))
        _sfGravityMode.syncWith(pOther->_sfGravityMode);

    if(FieldBits::NoField != (WorldFieldMask & whichField))
        _sfWorld.syncWith(pOther->_sfWorld);



}

void PhysicsBodyBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<PhysicsBodyPtr>::_type("PhysicsBodyPtr", "AttachmentPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(PhysicsBodyPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(PhysicsBodyPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGPhysicsBodyBase.cpp,v 1.2 2006/02/20 17:04:20 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGPHYSICSBODYBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPHYSICSBODYBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPHYSICSBODYFIELDS_HEADER_CVSID;
}

