/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsHashSpace!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEPHYSICSHASHSPACEINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGPhysicsHashSpaceBase.h"
#include "OSGPhysicsHashSpace.h"


OSG_USING_NAMESPACE

const OSG::BitVector  PhysicsHashSpaceBase::LevelsFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsHashSpaceBase::LevelsFieldId);

const OSG::BitVector PhysicsHashSpaceBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Vec2f           PhysicsHashSpaceBase::_sfLevels
    
*/

//! PhysicsHashSpace description

FieldDescription *PhysicsHashSpaceBase::_desc[] = 
{
    new FieldDescription(SFVec2f::getClassType(), 
                     "levels", 
                     LevelsFieldId, LevelsFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsHashSpaceBase::getSFLevels)
};


FieldContainerType PhysicsHashSpaceBase::_type(
    "PhysicsHashSpace",
    "PhysicsSpace",
    NULL,
    (PrototypeCreateF) &PhysicsHashSpaceBase::createEmpty,
    PhysicsHashSpace::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(PhysicsHashSpaceBase, PhysicsHashSpacePtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &PhysicsHashSpaceBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &PhysicsHashSpaceBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr PhysicsHashSpaceBase::shallowCopy(void) const 
{ 
    PhysicsHashSpacePtr returnValue; 

    newPtr(returnValue, dynamic_cast<const PhysicsHashSpace *>(this)); 

    return returnValue; 
}

UInt32 PhysicsHashSpaceBase::getContainerSize(void) const 
{ 
    return sizeof(PhysicsHashSpace); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsHashSpaceBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((PhysicsHashSpaceBase *) &other, whichField);
}
#else
void PhysicsHashSpaceBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((PhysicsHashSpaceBase *) &other, whichField, sInfo);
}
void PhysicsHashSpaceBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void PhysicsHashSpaceBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

PhysicsHashSpaceBase::PhysicsHashSpaceBase(void) :
    _sfLevels                 (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

PhysicsHashSpaceBase::PhysicsHashSpaceBase(const PhysicsHashSpaceBase &source) :
    _sfLevels                 (source._sfLevels                 ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

PhysicsHashSpaceBase::~PhysicsHashSpaceBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 PhysicsHashSpaceBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (LevelsFieldMask & whichField))
    {
        returnValue += _sfLevels.getBinSize();
    }


    return returnValue;
}

void PhysicsHashSpaceBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (LevelsFieldMask & whichField))
    {
        _sfLevels.copyToBin(pMem);
    }


}

void PhysicsHashSpaceBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (LevelsFieldMask & whichField))
    {
        _sfLevels.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsHashSpaceBase::executeSyncImpl(      PhysicsHashSpaceBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (LevelsFieldMask & whichField))
        _sfLevels.syncWith(pOther->_sfLevels);


}
#else
void PhysicsHashSpaceBase::executeSyncImpl(      PhysicsHashSpaceBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (LevelsFieldMask & whichField))
        _sfLevels.syncWith(pOther->_sfLevels);



}

void PhysicsHashSpaceBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<PhysicsHashSpacePtr>::_type("PhysicsHashSpacePtr", "PhysicsSpacePtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(PhysicsHashSpacePtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(PhysicsHashSpacePtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGPhysicsHashSpaceBase.cpp,v 1.2 2006/02/20 17:04:21 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGPHYSICSHASHSPACEBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPHYSICSHASHSPACEBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPHYSICSHASHSPACEFIELDS_HEADER_CVSID;
}

