/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsWorld!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEPHYSICSWORLDINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGPhysicsWorldBase.h"
#include "OSGPhysicsWorld.h"


OSG_USING_NAMESPACE

const OSG::BitVector  PhysicsWorldBase::ErpFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::ErpFieldId);

const OSG::BitVector  PhysicsWorldBase::GravityFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::GravityFieldId);

const OSG::BitVector  PhysicsWorldBase::CfmFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::CfmFieldId);

const OSG::BitVector  PhysicsWorldBase::AutoDisableFlagFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::AutoDisableFlagFieldId);

const OSG::BitVector  PhysicsWorldBase::AutoDisableLinearThresholdFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::AutoDisableLinearThresholdFieldId);

const OSG::BitVector  PhysicsWorldBase::AutoDisableAngularThresholdFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::AutoDisableAngularThresholdFieldId);

const OSG::BitVector  PhysicsWorldBase::AutoDisableStepsFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::AutoDisableStepsFieldId);

const OSG::BitVector  PhysicsWorldBase::AutoDisableTimeFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::AutoDisableTimeFieldId);

const OSG::BitVector  PhysicsWorldBase::WorldQuickStepNumIterationsFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::WorldQuickStepNumIterationsFieldId);

const OSG::BitVector  PhysicsWorldBase::WorldContactMaxCorrectingVelFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::WorldContactMaxCorrectingVelFieldId);

const OSG::BitVector  PhysicsWorldBase::WorldContactSurfaceLayerFieldMask = 
    (TypeTraits<BitVector>::One << PhysicsWorldBase::WorldContactSurfaceLayerFieldId);

const OSG::BitVector PhysicsWorldBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Real32          PhysicsWorldBase::_sfErp
    the global ERP value, that controls how much error correction is performed in each time step. Typical values are in the range 0.1--0.8. The default is 0.2.
*/
/*! \var Vec3f           PhysicsWorldBase::_sfGravity
    the world's global gravity vector. The units are m/s/s, so Earth's gravity vector would be (0,0,-9.81), assuming that +z is up. The default is no gravity, i.e. (0,0,0).
*/
/*! \var Real32          PhysicsWorldBase::_sfCfm
    the global CFM (constraint force mixing) value. Typical values are in the range 10-9 -- 1. The default is 10-5 if single precision is being used, or 10-10 if double precision is being used.
*/
/*! \var Int32           PhysicsWorldBase::_sfAutoDisableFlag
    Set and get the default auto-disable parameters for newly created bodies. See section 6.5 of ODE userguide for a description of the auto-disable feature. The default parameter AutoDisableFlag = disabled
*/
/*! \var Real32          PhysicsWorldBase::_sfAutoDisableLinearThreshold
    Set and get the default auto-disable parameters for newly created bodies. See section 6.5 of ODE userguide for a description of the auto-disable feature. The default parameter AutoDisableLinearThreshold = 0.01
*/
/*! \var Real32          PhysicsWorldBase::_sfAutoDisableAngularThreshold
    Set and get the default auto-disable parameters for newly created bodies. See section 6.5 of ODE userguide for a description of the auto-disable feature. The default parameter AutoDisableAngularThreshold = 0.01
*/
/*! \var Int32           PhysicsWorldBase::_sfAutoDisableSteps
    Set and get the default auto-disable parameters for newly created bodies. See section 6.5 of ODE userguide for a description of the auto-disable feature. The default parameter AutoDisableSteps = 10
*/
/*! \var Real32          PhysicsWorldBase::_sfAutoDisableTime
    Set and get the default auto-disable parameters for newly created bodies. See section 6.5 of ODE userguide for a description of the auto-disable feature. The default parameter AutoDisableTime = 0
*/
/*! \var Int32           PhysicsWorldBase::_sfWorldQuickStepNumIterations
    Set and get the number of iterations that the QuickStep method performs per step. More iterations will give a more accurate solution, but will take longer to compute. The default is 20 iterations.
*/
/*! \var Real32          PhysicsWorldBase::_sfWorldContactMaxCorrectingVel
    maximum correcting velocity that contacts are allowed to generate. The default value is infinity (i.e. no limit). Reducing this value can help prevent "popping" of deeply embedded objects.
*/
/*! \var Real32          PhysicsWorldBase::_sfWorldContactSurfaceLayer
    the depth of the surface layer around all geometry objects. Contacts are allowed to sink into the surface layer up to the given depth before coming to rest. The default value is zero. Increasing this to some small value (e.g. 0.001) can help prevent jittering problems due to contacts being repeatedly made and broken.
*/

//! PhysicsWorld description

FieldDescription *PhysicsWorldBase::_desc[] = 
{
    new FieldDescription(SFReal32::getClassType(), 
                     "erp", 
                     ErpFieldId, ErpFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFErp),
    new FieldDescription(SFVec3f::getClassType(), 
                     "gravity", 
                     GravityFieldId, GravityFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFGravity),
    new FieldDescription(SFReal32::getClassType(), 
                     "cfm", 
                     CfmFieldId, CfmFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFCfm),
    new FieldDescription(SFInt32::getClassType(), 
                     "autoDisableFlag", 
                     AutoDisableFlagFieldId, AutoDisableFlagFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFAutoDisableFlag),
    new FieldDescription(SFReal32::getClassType(), 
                     "autoDisableLinearThreshold", 
                     AutoDisableLinearThresholdFieldId, AutoDisableLinearThresholdFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFAutoDisableLinearThreshold),
    new FieldDescription(SFReal32::getClassType(), 
                     "autoDisableAngularThreshold", 
                     AutoDisableAngularThresholdFieldId, AutoDisableAngularThresholdFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFAutoDisableAngularThreshold),
    new FieldDescription(SFInt32::getClassType(), 
                     "autoDisableSteps", 
                     AutoDisableStepsFieldId, AutoDisableStepsFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFAutoDisableSteps),
    new FieldDescription(SFReal32::getClassType(), 
                     "autoDisableTime", 
                     AutoDisableTimeFieldId, AutoDisableTimeFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFAutoDisableTime),
    new FieldDescription(SFInt32::getClassType(), 
                     "worldQuickStepNumIterations", 
                     WorldQuickStepNumIterationsFieldId, WorldQuickStepNumIterationsFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFWorldQuickStepNumIterations),
    new FieldDescription(SFReal32::getClassType(), 
                     "worldContactMaxCorrectingVel", 
                     WorldContactMaxCorrectingVelFieldId, WorldContactMaxCorrectingVelFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFWorldContactMaxCorrectingVel),
    new FieldDescription(SFReal32::getClassType(), 
                     "worldContactSurfaceLayer", 
                     WorldContactSurfaceLayerFieldId, WorldContactSurfaceLayerFieldMask,
                     false,
                     (FieldAccessMethod) &PhysicsWorldBase::getSFWorldContactSurfaceLayer)
};


FieldContainerType PhysicsWorldBase::_type(
    "PhysicsWorld",
    "Attachment",
    NULL,
    (PrototypeCreateF) &PhysicsWorldBase::createEmpty,
    PhysicsWorld::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(PhysicsWorldBase, PhysicsWorldPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &PhysicsWorldBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &PhysicsWorldBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr PhysicsWorldBase::shallowCopy(void) const 
{ 
    PhysicsWorldPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const PhysicsWorld *>(this)); 

    return returnValue; 
}

UInt32 PhysicsWorldBase::getContainerSize(void) const 
{ 
    return sizeof(PhysicsWorld); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsWorldBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((PhysicsWorldBase *) &other, whichField);
}
#else
void PhysicsWorldBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((PhysicsWorldBase *) &other, whichField, sInfo);
}
void PhysicsWorldBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void PhysicsWorldBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

PhysicsWorldBase::PhysicsWorldBase(void) :
    _sfErp                    (Real32(0.2)), 
    _sfGravity                (), 
    _sfCfm                    (), 
    _sfAutoDisableFlag        (), 
    _sfAutoDisableLinearThreshold(Real32(0.01)), 
    _sfAutoDisableAngularThreshold(Real32(0.01)), 
    _sfAutoDisableSteps       (Int32(10)), 
    _sfAutoDisableTime        (Real32(0)), 
    _sfWorldQuickStepNumIterations(Int32(20)), 
    _sfWorldContactMaxCorrectingVel(), 
    _sfWorldContactSurfaceLayer(Real32(0)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

PhysicsWorldBase::PhysicsWorldBase(const PhysicsWorldBase &source) :
    _sfErp                    (source._sfErp                    ), 
    _sfGravity                (source._sfGravity                ), 
    _sfCfm                    (source._sfCfm                    ), 
    _sfAutoDisableFlag        (source._sfAutoDisableFlag        ), 
    _sfAutoDisableLinearThreshold(source._sfAutoDisableLinearThreshold), 
    _sfAutoDisableAngularThreshold(source._sfAutoDisableAngularThreshold), 
    _sfAutoDisableSteps       (source._sfAutoDisableSteps       ), 
    _sfAutoDisableTime        (source._sfAutoDisableTime        ), 
    _sfWorldQuickStepNumIterations(source._sfWorldQuickStepNumIterations), 
    _sfWorldContactMaxCorrectingVel(source._sfWorldContactMaxCorrectingVel), 
    _sfWorldContactSurfaceLayer(source._sfWorldContactSurfaceLayer), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

PhysicsWorldBase::~PhysicsWorldBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 PhysicsWorldBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ErpFieldMask & whichField))
    {
        returnValue += _sfErp.getBinSize();
    }

    if(FieldBits::NoField != (GravityFieldMask & whichField))
    {
        returnValue += _sfGravity.getBinSize();
    }

    if(FieldBits::NoField != (CfmFieldMask & whichField))
    {
        returnValue += _sfCfm.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
    {
        returnValue += _sfAutoDisableFlag.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableLinearThresholdFieldMask & whichField))
    {
        returnValue += _sfAutoDisableLinearThreshold.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableAngularThresholdFieldMask & whichField))
    {
        returnValue += _sfAutoDisableAngularThreshold.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
    {
        returnValue += _sfAutoDisableSteps.getBinSize();
    }

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
    {
        returnValue += _sfAutoDisableTime.getBinSize();
    }

    if(FieldBits::NoField != (WorldQuickStepNumIterationsFieldMask & whichField))
    {
        returnValue += _sfWorldQuickStepNumIterations.getBinSize();
    }

    if(FieldBits::NoField != (WorldContactMaxCorrectingVelFieldMask & whichField))
    {
        returnValue += _sfWorldContactMaxCorrectingVel.getBinSize();
    }

    if(FieldBits::NoField != (WorldContactSurfaceLayerFieldMask & whichField))
    {
        returnValue += _sfWorldContactSurfaceLayer.getBinSize();
    }


    return returnValue;
}

void PhysicsWorldBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ErpFieldMask & whichField))
    {
        _sfErp.copyToBin(pMem);
    }

    if(FieldBits::NoField != (GravityFieldMask & whichField))
    {
        _sfGravity.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CfmFieldMask & whichField))
    {
        _sfCfm.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
    {
        _sfAutoDisableFlag.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableLinearThresholdFieldMask & whichField))
    {
        _sfAutoDisableLinearThreshold.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableAngularThresholdFieldMask & whichField))
    {
        _sfAutoDisableAngularThreshold.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
    {
        _sfAutoDisableSteps.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
    {
        _sfAutoDisableTime.copyToBin(pMem);
    }

    if(FieldBits::NoField != (WorldQuickStepNumIterationsFieldMask & whichField))
    {
        _sfWorldQuickStepNumIterations.copyToBin(pMem);
    }

    if(FieldBits::NoField != (WorldContactMaxCorrectingVelFieldMask & whichField))
    {
        _sfWorldContactMaxCorrectingVel.copyToBin(pMem);
    }

    if(FieldBits::NoField != (WorldContactSurfaceLayerFieldMask & whichField))
    {
        _sfWorldContactSurfaceLayer.copyToBin(pMem);
    }


}

void PhysicsWorldBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ErpFieldMask & whichField))
    {
        _sfErp.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (GravityFieldMask & whichField))
    {
        _sfGravity.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CfmFieldMask & whichField))
    {
        _sfCfm.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
    {
        _sfAutoDisableFlag.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableLinearThresholdFieldMask & whichField))
    {
        _sfAutoDisableLinearThreshold.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableAngularThresholdFieldMask & whichField))
    {
        _sfAutoDisableAngularThreshold.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
    {
        _sfAutoDisableSteps.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
    {
        _sfAutoDisableTime.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (WorldQuickStepNumIterationsFieldMask & whichField))
    {
        _sfWorldQuickStepNumIterations.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (WorldContactMaxCorrectingVelFieldMask & whichField))
    {
        _sfWorldContactMaxCorrectingVel.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (WorldContactSurfaceLayerFieldMask & whichField))
    {
        _sfWorldContactSurfaceLayer.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void PhysicsWorldBase::executeSyncImpl(      PhysicsWorldBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ErpFieldMask & whichField))
        _sfErp.syncWith(pOther->_sfErp);

    if(FieldBits::NoField != (GravityFieldMask & whichField))
        _sfGravity.syncWith(pOther->_sfGravity);

    if(FieldBits::NoField != (CfmFieldMask & whichField))
        _sfCfm.syncWith(pOther->_sfCfm);

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
        _sfAutoDisableFlag.syncWith(pOther->_sfAutoDisableFlag);

    if(FieldBits::NoField != (AutoDisableLinearThresholdFieldMask & whichField))
        _sfAutoDisableLinearThreshold.syncWith(pOther->_sfAutoDisableLinearThreshold);

    if(FieldBits::NoField != (AutoDisableAngularThresholdFieldMask & whichField))
        _sfAutoDisableAngularThreshold.syncWith(pOther->_sfAutoDisableAngularThreshold);

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
        _sfAutoDisableSteps.syncWith(pOther->_sfAutoDisableSteps);

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
        _sfAutoDisableTime.syncWith(pOther->_sfAutoDisableTime);

    if(FieldBits::NoField != (WorldQuickStepNumIterationsFieldMask & whichField))
        _sfWorldQuickStepNumIterations.syncWith(pOther->_sfWorldQuickStepNumIterations);

    if(FieldBits::NoField != (WorldContactMaxCorrectingVelFieldMask & whichField))
        _sfWorldContactMaxCorrectingVel.syncWith(pOther->_sfWorldContactMaxCorrectingVel);

    if(FieldBits::NoField != (WorldContactSurfaceLayerFieldMask & whichField))
        _sfWorldContactSurfaceLayer.syncWith(pOther->_sfWorldContactSurfaceLayer);


}
#else
void PhysicsWorldBase::executeSyncImpl(      PhysicsWorldBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ErpFieldMask & whichField))
        _sfErp.syncWith(pOther->_sfErp);

    if(FieldBits::NoField != (GravityFieldMask & whichField))
        _sfGravity.syncWith(pOther->_sfGravity);

    if(FieldBits::NoField != (CfmFieldMask & whichField))
        _sfCfm.syncWith(pOther->_sfCfm);

    if(FieldBits::NoField != (AutoDisableFlagFieldMask & whichField))
        _sfAutoDisableFlag.syncWith(pOther->_sfAutoDisableFlag);

    if(FieldBits::NoField != (AutoDisableLinearThresholdFieldMask & whichField))
        _sfAutoDisableLinearThreshold.syncWith(pOther->_sfAutoDisableLinearThreshold);

    if(FieldBits::NoField != (AutoDisableAngularThresholdFieldMask & whichField))
        _sfAutoDisableAngularThreshold.syncWith(pOther->_sfAutoDisableAngularThreshold);

    if(FieldBits::NoField != (AutoDisableStepsFieldMask & whichField))
        _sfAutoDisableSteps.syncWith(pOther->_sfAutoDisableSteps);

    if(FieldBits::NoField != (AutoDisableTimeFieldMask & whichField))
        _sfAutoDisableTime.syncWith(pOther->_sfAutoDisableTime);

    if(FieldBits::NoField != (WorldQuickStepNumIterationsFieldMask & whichField))
        _sfWorldQuickStepNumIterations.syncWith(pOther->_sfWorldQuickStepNumIterations);

    if(FieldBits::NoField != (WorldContactMaxCorrectingVelFieldMask & whichField))
        _sfWorldContactMaxCorrectingVel.syncWith(pOther->_sfWorldContactMaxCorrectingVel);

    if(FieldBits::NoField != (WorldContactSurfaceLayerFieldMask & whichField))
        _sfWorldContactSurfaceLayer.syncWith(pOther->_sfWorldContactSurfaceLayer);



}

void PhysicsWorldBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<PhysicsWorldPtr>::_type("PhysicsWorldPtr", "AttachmentPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(PhysicsWorldPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(PhysicsWorldPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGPhysicsWorldBase.cpp,v 1.2 2006/02/20 17:04:21 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGPHYSICSWORLDBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPHYSICSWORLDBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPHYSICSWORLDFIELDS_HEADER_CVSID;
}

