/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class PhysicsWorld!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &PhysicsWorldBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 PhysicsWorldBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
PhysicsWorldPtr PhysicsWorldBase::create(void) 
{
    PhysicsWorldPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = PhysicsWorldPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
PhysicsWorldPtr PhysicsWorldBase::createEmpty(void) 
{ 
    PhysicsWorldPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the PhysicsWorld::_sfErp field.
inline
SFReal32 *PhysicsWorldBase::getSFErp(void)
{
    return &_sfErp;
}

//! Get the PhysicsWorld::_sfGravity field.
inline
SFVec3f *PhysicsWorldBase::getSFGravity(void)
{
    return &_sfGravity;
}

//! Get the PhysicsWorld::_sfCfm field.
inline
SFReal32 *PhysicsWorldBase::getSFCfm(void)
{
    return &_sfCfm;
}

//! Get the PhysicsWorld::_sfAutoDisableFlag field.
inline
SFInt32 *PhysicsWorldBase::getSFAutoDisableFlag(void)
{
    return &_sfAutoDisableFlag;
}

//! Get the PhysicsWorld::_sfAutoDisableLinearThreshold field.
inline
SFReal32 *PhysicsWorldBase::getSFAutoDisableLinearThreshold(void)
{
    return &_sfAutoDisableLinearThreshold;
}

//! Get the PhysicsWorld::_sfAutoDisableAngularThreshold field.
inline
SFReal32 *PhysicsWorldBase::getSFAutoDisableAngularThreshold(void)
{
    return &_sfAutoDisableAngularThreshold;
}

//! Get the PhysicsWorld::_sfAutoDisableSteps field.
inline
SFInt32 *PhysicsWorldBase::getSFAutoDisableSteps(void)
{
    return &_sfAutoDisableSteps;
}

//! Get the PhysicsWorld::_sfAutoDisableTime field.
inline
SFReal32 *PhysicsWorldBase::getSFAutoDisableTime(void)
{
    return &_sfAutoDisableTime;
}

//! Get the PhysicsWorld::_sfWorldQuickStepNumIterations field.
inline
SFInt32 *PhysicsWorldBase::getSFWorldQuickStepNumIterations(void)
{
    return &_sfWorldQuickStepNumIterations;
}

//! Get the PhysicsWorld::_sfWorldContactMaxCorrectingVel field.
inline
SFReal32 *PhysicsWorldBase::getSFWorldContactMaxCorrectingVel(void)
{
    return &_sfWorldContactMaxCorrectingVel;
}

//! Get the PhysicsWorld::_sfWorldContactSurfaceLayer field.
inline
SFReal32 *PhysicsWorldBase::getSFWorldContactSurfaceLayer(void)
{
    return &_sfWorldContactSurfaceLayer;
}


//! Get the value of the PhysicsWorld::_sfErp field.
inline
Real32 &PhysicsWorldBase::getErp(void)
{
    return _sfErp.getValue();
}

//! Get the value of the PhysicsWorld::_sfErp field.
inline
const Real32 &PhysicsWorldBase::getErp(void) const
{
    return _sfErp.getValue();
}

//! Set the value of the PhysicsWorld::_sfErp field.
inline
void PhysicsWorldBase::setErp(const Real32 &value)
{
    _sfErp.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfGravity field.
inline
Vec3f &PhysicsWorldBase::getGravity(void)
{
    return _sfGravity.getValue();
}

//! Get the value of the PhysicsWorld::_sfGravity field.
inline
const Vec3f &PhysicsWorldBase::getGravity(void) const
{
    return _sfGravity.getValue();
}

//! Set the value of the PhysicsWorld::_sfGravity field.
inline
void PhysicsWorldBase::setGravity(const Vec3f &value)
{
    _sfGravity.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfCfm field.
inline
Real32 &PhysicsWorldBase::getCfm(void)
{
    return _sfCfm.getValue();
}

//! Get the value of the PhysicsWorld::_sfCfm field.
inline
const Real32 &PhysicsWorldBase::getCfm(void) const
{
    return _sfCfm.getValue();
}

//! Set the value of the PhysicsWorld::_sfCfm field.
inline
void PhysicsWorldBase::setCfm(const Real32 &value)
{
    _sfCfm.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfAutoDisableFlag field.
inline
Int32 &PhysicsWorldBase::getAutoDisableFlag(void)
{
    return _sfAutoDisableFlag.getValue();
}

//! Get the value of the PhysicsWorld::_sfAutoDisableFlag field.
inline
const Int32 &PhysicsWorldBase::getAutoDisableFlag(void) const
{
    return _sfAutoDisableFlag.getValue();
}

//! Set the value of the PhysicsWorld::_sfAutoDisableFlag field.
inline
void PhysicsWorldBase::setAutoDisableFlag(const Int32 &value)
{
    _sfAutoDisableFlag.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfAutoDisableLinearThreshold field.
inline
Real32 &PhysicsWorldBase::getAutoDisableLinearThreshold(void)
{
    return _sfAutoDisableLinearThreshold.getValue();
}

//! Get the value of the PhysicsWorld::_sfAutoDisableLinearThreshold field.
inline
const Real32 &PhysicsWorldBase::getAutoDisableLinearThreshold(void) const
{
    return _sfAutoDisableLinearThreshold.getValue();
}

//! Set the value of the PhysicsWorld::_sfAutoDisableLinearThreshold field.
inline
void PhysicsWorldBase::setAutoDisableLinearThreshold(const Real32 &value)
{
    _sfAutoDisableLinearThreshold.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfAutoDisableAngularThreshold field.
inline
Real32 &PhysicsWorldBase::getAutoDisableAngularThreshold(void)
{
    return _sfAutoDisableAngularThreshold.getValue();
}

//! Get the value of the PhysicsWorld::_sfAutoDisableAngularThreshold field.
inline
const Real32 &PhysicsWorldBase::getAutoDisableAngularThreshold(void) const
{
    return _sfAutoDisableAngularThreshold.getValue();
}

//! Set the value of the PhysicsWorld::_sfAutoDisableAngularThreshold field.
inline
void PhysicsWorldBase::setAutoDisableAngularThreshold(const Real32 &value)
{
    _sfAutoDisableAngularThreshold.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfAutoDisableSteps field.
inline
Int32 &PhysicsWorldBase::getAutoDisableSteps(void)
{
    return _sfAutoDisableSteps.getValue();
}

//! Get the value of the PhysicsWorld::_sfAutoDisableSteps field.
inline
const Int32 &PhysicsWorldBase::getAutoDisableSteps(void) const
{
    return _sfAutoDisableSteps.getValue();
}

//! Set the value of the PhysicsWorld::_sfAutoDisableSteps field.
inline
void PhysicsWorldBase::setAutoDisableSteps(const Int32 &value)
{
    _sfAutoDisableSteps.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfAutoDisableTime field.
inline
Real32 &PhysicsWorldBase::getAutoDisableTime(void)
{
    return _sfAutoDisableTime.getValue();
}

//! Get the value of the PhysicsWorld::_sfAutoDisableTime field.
inline
const Real32 &PhysicsWorldBase::getAutoDisableTime(void) const
{
    return _sfAutoDisableTime.getValue();
}

//! Set the value of the PhysicsWorld::_sfAutoDisableTime field.
inline
void PhysicsWorldBase::setAutoDisableTime(const Real32 &value)
{
    _sfAutoDisableTime.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfWorldQuickStepNumIterations field.
inline
Int32 &PhysicsWorldBase::getWorldQuickStepNumIterations(void)
{
    return _sfWorldQuickStepNumIterations.getValue();
}

//! Get the value of the PhysicsWorld::_sfWorldQuickStepNumIterations field.
inline
const Int32 &PhysicsWorldBase::getWorldQuickStepNumIterations(void) const
{
    return _sfWorldQuickStepNumIterations.getValue();
}

//! Set the value of the PhysicsWorld::_sfWorldQuickStepNumIterations field.
inline
void PhysicsWorldBase::setWorldQuickStepNumIterations(const Int32 &value)
{
    _sfWorldQuickStepNumIterations.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfWorldContactMaxCorrectingVel field.
inline
Real32 &PhysicsWorldBase::getWorldContactMaxCorrectingVel(void)
{
    return _sfWorldContactMaxCorrectingVel.getValue();
}

//! Get the value of the PhysicsWorld::_sfWorldContactMaxCorrectingVel field.
inline
const Real32 &PhysicsWorldBase::getWorldContactMaxCorrectingVel(void) const
{
    return _sfWorldContactMaxCorrectingVel.getValue();
}

//! Set the value of the PhysicsWorld::_sfWorldContactMaxCorrectingVel field.
inline
void PhysicsWorldBase::setWorldContactMaxCorrectingVel(const Real32 &value)
{
    _sfWorldContactMaxCorrectingVel.setValue(value);
}

//! Get the value of the PhysicsWorld::_sfWorldContactSurfaceLayer field.
inline
Real32 &PhysicsWorldBase::getWorldContactSurfaceLayer(void)
{
    return _sfWorldContactSurfaceLayer.getValue();
}

//! Get the value of the PhysicsWorld::_sfWorldContactSurfaceLayer field.
inline
const Real32 &PhysicsWorldBase::getWorldContactSurfaceLayer(void) const
{
    return _sfWorldContactSurfaceLayer.getValue();
}

//! Set the value of the PhysicsWorld::_sfWorldContactSurfaceLayer field.
inline
void PhysicsWorldBase::setWorldContactSurfaceLayer(const Real32 &value)
{
    _sfWorldContactSurfaceLayer.setValue(value);
}


OSG_END_NAMESPACE

#define OSGPHYSICSWORLDBASE_INLINE_CVSID "@(#)$Id: OSGPhysicsWorldBase.inl,v 1.2 2006/02/20 17:04:21 dirk Exp $"

