/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class TiledTerrain
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGTILEDTERRAINBASE_H_
#define _OSGTILEDTERRAINBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGContribDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGMaterialGroup.h> // Parent

#include <OSGImageFields.h> // HeightTiles type
#include <OSGMaterialFields.h> // HeightTextures type
#include <OSGUInt32Fields.h> // SizeX type
#include <OSGUInt32Fields.h> // SizeY type
#include <OSGReal32Fields.h> // HeightScale type
#include <OSGReal32Fields.h> // VertexSpacing type
#include <OSGBoolFields.h> // GeoMorphing type
#include <OSGReal32Fields.h> // Detail type
#include <OSGInt32Fields.h> // CurrentX type
#include <OSGInt32Fields.h> // CurrentY type
#include <OSGInt32Fields.h> // SizeROI type
#include <OSGBoolFields.h> // Update type
#include <OSGBoolFields.h> // UpdateTerrain type
#include <OSGBoolFields.h> // PerPixelLighting type

#include <OSGTiledTerrainFields.h>

OSG_BEGIN_NAMESPACE

class TiledTerrain;
class BinaryDataHandler;

//! \brief TiledTerrain Base Class.

class OSG_CONTRIBLIB_DLLMAPPING TiledTerrainBase : public MaterialGroup
{
  private:

    typedef MaterialGroup    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef TiledTerrainPtr  Ptr;

    enum
    {
        HeightTilesFieldId      = Inherited::NextFieldId,
        HeightTexturesFieldId   = HeightTilesFieldId      + 1,
        SizeXFieldId            = HeightTexturesFieldId   + 1,
        SizeYFieldId            = SizeXFieldId            + 1,
        HeightScaleFieldId      = SizeYFieldId            + 1,
        VertexSpacingFieldId    = HeightScaleFieldId      + 1,
        GeoMorphingFieldId      = VertexSpacingFieldId    + 1,
        DetailFieldId           = GeoMorphingFieldId      + 1,
        CurrentXFieldId         = DetailFieldId           + 1,
        CurrentYFieldId         = CurrentXFieldId         + 1,
        SizeROIFieldId          = CurrentYFieldId         + 1,
        UpdateFieldId           = SizeROIFieldId          + 1,
        UpdateTerrainFieldId    = UpdateFieldId           + 1,
        PerPixelLightingFieldId = UpdateTerrainFieldId    + 1,
        NextFieldId             = PerPixelLightingFieldId + 1
    };

    static const OSG::BitVector HeightTilesFieldMask;
    static const OSG::BitVector HeightTexturesFieldMask;
    static const OSG::BitVector SizeXFieldMask;
    static const OSG::BitVector SizeYFieldMask;
    static const OSG::BitVector HeightScaleFieldMask;
    static const OSG::BitVector VertexSpacingFieldMask;
    static const OSG::BitVector GeoMorphingFieldMask;
    static const OSG::BitVector DetailFieldMask;
    static const OSG::BitVector CurrentXFieldMask;
    static const OSG::BitVector CurrentYFieldMask;
    static const OSG::BitVector SizeROIFieldMask;
    static const OSG::BitVector UpdateFieldMask;
    static const OSG::BitVector UpdateTerrainFieldMask;
    static const OSG::BitVector PerPixelLightingFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           MFImagePtr          *getMFHeightTiles    (void);
           MFMaterialPtr       *getMFHeightTextures (void);
           SFUInt32            *getSFSizeX          (void);
           SFUInt32            *getSFSizeY          (void);
           SFReal32            *getSFHeightScale    (void);
           SFReal32            *getSFVertexSpacing  (void);
           SFBool              *getSFGeoMorphing    (void);
           SFReal32            *getSFDetail         (void);
           SFInt32             *getSFCurrentX       (void);
           SFInt32             *getSFCurrentY       (void);
           SFInt32             *getSFSizeROI        (void);
           SFBool              *getSFUpdate         (void);
           SFBool              *getSFUpdateTerrain  (void);
           SFBool              *getSFPerPixelLighting(void);

           UInt32              &getSizeX          (void);
     const UInt32              &getSizeX          (void) const;
           UInt32              &getSizeY          (void);
     const UInt32              &getSizeY          (void) const;
           Real32              &getHeightScale    (void);
     const Real32              &getHeightScale    (void) const;
           Real32              &getVertexSpacing  (void);
     const Real32              &getVertexSpacing  (void) const;
           bool                &getGeoMorphing    (void);
     const bool                &getGeoMorphing    (void) const;
           Real32              &getDetail         (void);
     const Real32              &getDetail         (void) const;
           Int32               &getCurrentX       (void);
     const Int32               &getCurrentX       (void) const;
           Int32               &getCurrentY       (void);
     const Int32               &getCurrentY       (void) const;
           Int32               &getSizeROI        (void);
     const Int32               &getSizeROI        (void) const;
           bool                &getUpdate         (void);
     const bool                &getUpdate         (void) const;
           bool                &getUpdateTerrain  (void);
     const bool                &getUpdateTerrain  (void) const;
           bool                &getPerPixelLighting(void);
     const bool                &getPerPixelLighting(void) const;
           ImagePtr            &getHeightTiles    (const UInt32 index);
           MFImagePtr          &getHeightTiles    (void);
     const MFImagePtr          &getHeightTiles    (void) const;
           MaterialPtr         &getHeightTextures (const UInt32 index);
           MFMaterialPtr       &getHeightTextures (void);
     const MFMaterialPtr       &getHeightTextures (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setSizeX          ( const UInt32 &value );
     void setSizeY          ( const UInt32 &value );
     void setHeightScale    ( const Real32 &value );
     void setVertexSpacing  ( const Real32 &value );
     void setGeoMorphing    ( const bool &value );
     void setDetail         ( const Real32 &value );
     void setCurrentX       ( const Int32 &value );
     void setCurrentY       ( const Int32 &value );
     void setSizeROI        ( const Int32 &value );
     void setUpdate         ( const bool &value );
     void setUpdateTerrain  ( const bool &value );
     void setPerPixelLighting( const bool &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  TiledTerrainPtr      create          (void); 
    static  TiledTerrainPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    MFImagePtr          _mfHeightTiles;
    MFMaterialPtr       _mfHeightTextures;
    SFUInt32            _sfSizeX;
    SFUInt32            _sfSizeY;
    SFReal32            _sfHeightScale;
    SFReal32            _sfVertexSpacing;
    SFBool              _sfGeoMorphing;
    SFReal32            _sfDetail;
    SFInt32             _sfCurrentX;
    SFInt32             _sfCurrentY;
    SFInt32             _sfSizeROI;
    SFBool              _sfUpdate;
    SFBool              _sfUpdateTerrain;
    SFBool              _sfPerPixelLighting;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    TiledTerrainBase(void);
    TiledTerrainBase(const TiledTerrainBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~TiledTerrainBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      TiledTerrainBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      TiledTerrainBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const TiledTerrainBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef TiledTerrainBase *TiledTerrainBaseP;

typedef osgIF<TiledTerrainBase::isNodeCore,
              CoredNodePtr<TiledTerrain>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet TiledTerrainNodePtr;

typedef RefPtr<TiledTerrainPtr> TiledTerrainRefPtr;

OSG_END_NAMESPACE

#define OSGTILEDTERRAINBASE_HEADER_CVSID "@(#)$Id: OSGTiledTerrainBase.h,v 1.7 2006/02/20 17:04:33 dirk Exp $"

#endif /* _OSGTILEDTERRAINBASE_H_ */
