/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class FOXWindow!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEFOXWINDOWINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGFOXWindowBase.h"
#include "OSGFOXWindow.h"


OSG_USING_NAMESPACE

const OSG::BitVector  FOXWindowBase::GlWidgetFieldMask = 
    (TypeTraits<BitVector>::One << FOXWindowBase::GlWidgetFieldId);

const OSG::BitVector FOXWindowBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var FOXGLWidgetP    FOXWindowBase::_sfGlWidget
    GL canvas used for OpenSG rendering
*/

//! FOXWindow description

FieldDescription *FOXWindowBase::_desc[] = 
{
    new FieldDescription(SFFOXGLWidgetP::getClassType(), 
                     "glWidget", 
                     GlWidgetFieldId, GlWidgetFieldMask,
                     false,
                     (FieldAccessMethod) &FOXWindowBase::getSFGlWidget)
};

//! FOXWindow type

#ifdef WIN32
FieldContainerType FOXWindowBase::_type(
    "FOXWindow",
    "WIN32Window",
    NULL,
    (PrototypeCreateF) &FOXWindowBase::createEmpty,
    FOXWindow::initMethod,
    _desc,
    sizeof(_desc));
#else
FieldContainerType FOXWindowBase::_type(
    "FOXWindow",
    "XWindow",
    NULL,
    (PrototypeCreateF) &FOXWindowBase::createEmpty,
    FOXWindow::initMethod,
    _desc,
    sizeof(_desc));
#endif

//OSG_FIELD_CONTAINER_DEF(FOXWindowBase, FOXWindowPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &FOXWindowBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &FOXWindowBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr FOXWindowBase::shallowCopy(void) const 
{ 
    FOXWindowPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const FOXWindow *>(this)); 

    return returnValue; 
}

UInt32 FOXWindowBase::getContainerSize(void) const 
{ 
    return sizeof(FOXWindow); 
}


void FOXWindowBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((FOXWindowBase *) &other, whichField);
}

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

FOXWindowBase::FOXWindowBase(void) :
    _sfGlWidget               (FOXGLWidgetP(NULL)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

FOXWindowBase::FOXWindowBase(const FOXWindowBase &source) :
    _sfGlWidget               (source._sfGlWidget               ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

FOXWindowBase::~FOXWindowBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 FOXWindowBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (GlWidgetFieldMask & whichField))
    {
        returnValue += _sfGlWidget.getBinSize();
    }


    return returnValue;
}

void FOXWindowBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (GlWidgetFieldMask & whichField))
    {
        _sfGlWidget.copyToBin(pMem);
    }


}

void FOXWindowBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (GlWidgetFieldMask & whichField))
    {
        _sfGlWidget.copyFromBin(pMem);
    }


}

void FOXWindowBase::executeSyncImpl(      FOXWindowBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (GlWidgetFieldMask & whichField))
        _sfGlWidget.syncWith(pOther->_sfGlWidget);


}



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
#ifdef WIN32
DataType FieldDataTraits<FOXWindowPtr>::_type("FOXWindowPtr", "WIN32WindowPtr");
#else
DataType FieldDataTraits<FOXWindowPtr>::_type("FOXWindowPtr", "XWindowPtr");
#endif
#endif

OSG_DLLEXPORT_SFIELD_DEF1(FOXWindowPtr, OSG_WINDOWFOXLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(FOXWindowPtr, OSG_WINDOWFOXLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: $";
    static Char8 cvsid_hpp       [] = OSGFOXWINDOWBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGFOXWINDOWBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGFOXWINDOWFIELDS_HEADER_CVSID;
}

